/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.StringResourceValueReader;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzjm;
import com.google.android.gms.internal.measurement.zzjx;
import com.google.android.gms.internal.measurement.zzke;
import com.google.android.gms.internal.measurement.zzkp;
import com.google.android.gms.internal.measurement.zzlc;
import com.google.android.gms.measurement.internal.zzan;
import com.google.android.gms.measurement.internal.zzao;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgv;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzkh;
import com.google.android.gms.measurement.internal.zzkm;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicReference;

public final class zzhb
extends zzg {
    @VisibleForTesting
    protected zzhw zza;
    private zzgw zzd;
    private final Set<zzgz> zze = new CopyOnWriteArraySet<zzgz>();
    private boolean zzf;
    private final AtomicReference<String> zzg = new AtomicReference();
    final zzp zzb;
    @VisibleForTesting
    protected boolean zzc = true;

    protected zzhb(zzfw zzfw2) {
        super(zzfw2);
        this.zzb = new zzp(zzfw2);
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    public final void zzab() {
        if (((zzgr)this).zzn().getApplicationContext() instanceof Application) {
            zzhw zzhw2 = this.zza;
            ((Application)((zzgr)this).zzn().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzhw2);
        }
    }

    public final Boolean zzac() {
        AtomicReference atomicReference = new AtomicReference();
        return (Boolean)((zzgr)this).zzq().zza(atomicReference, 15000L, "boolean test flag value", new zzhc(this, atomicReference));
    }

    public final String zzad() {
        AtomicReference atomicReference = new AtomicReference();
        return (String)((zzgr)this).zzq().zza(atomicReference, 15000L, "String test flag value", new zzhm(this, atomicReference));
    }

    public final Long zzae() {
        AtomicReference atomicReference = new AtomicReference();
        return (Long)((zzgr)this).zzq().zza(atomicReference, 15000L, "long test flag value", new zzhr(this, atomicReference));
    }

    public final Integer zzaf() {
        AtomicReference atomicReference = new AtomicReference();
        return (Integer)((zzgr)this).zzq().zza(atomicReference, 15000L, "int test flag value", new zzhq(this, atomicReference));
    }

    public final Double zzag() {
        AtomicReference atomicReference = new AtomicReference();
        return (Double)((zzgr)this).zzq().zza(atomicReference, 15000L, "double test flag value", new zzht(this, atomicReference));
    }

    public final void zza(boolean bl) {
        this.zzw();
        ((zzgr)this).zzb();
        ((zzgr)this).zzq().zza(new zzhs(this, bl));
    }

    public final void zzb(boolean bl) {
        this.zzw();
        ((zzgr)this).zzb();
        ((zzgr)this).zzq().zza(new zzhv(this, bl));
    }

    @WorkerThread
    private final void zzd(boolean bl) {
        ((zzgr)this).zzd();
        ((zzgr)this).zzb();
        this.zzw();
        ((zzgr)this).zzr().zzw().zza("Setting app measurement enabled (FE)", bl);
        ((zzgr)this).zzs().zzb(bl);
        this.zzam();
    }

    @WorkerThread
    private final void zzam() {
        Object object = this;
        ((zzgr)object).zzd();
        String string = ((zzgr)object).zzs().zzn.zza();
        if (string != null) {
            if ("unset".equals(string)) {
                ((zzhb)object).zza("app", "_npa", null, ((zzgr)object).zzm().currentTimeMillis());
            } else {
                ((zzhb)object).zza("app", "_npa", (Object)("true".equals(string) ? 1L : 0L), ((zzgr)object).zzm().currentTimeMillis());
            }
        }
        if (this.zzz.zzab() && this.zzc) {
            ((zzgr)this).zzr().zzw().zza("Recording app launch after enabling measurement for the first time (FE)");
            this.zzai();
            if (zzkp.zzb() && ((zzgr)this).zzt().zza(zzaq.zzbw)) {
                ((zzd)this).zzk().zza.zza();
            }
            if (zzke.zzb() && ((zzgr)this).zzt().zza(zzaq.zzcb) && !(this.zzz.zzf().zza.zzc().zzi.zza() > 0L)) {
                object = this.zzz.zzf();
                ((zzfn)object).zza.zzad();
                ((zzfn)object).zza(((zzfn)object).zza.zzn().getPackageName());
            }
            if (((zzgr)this).zzt().zza(zzaq.zzcp)) {
                ((zzgr)this).zzq().zza(new zzhu(this));
            }
            return;
        }
        ((zzgr)this).zzr().zzw().zza("Updating Scion state (FE)");
        ((zzd)this).zzh().zzac();
    }

    public final void zza(long l) {
        ((zzgr)this).zzb();
        ((zzgr)this).zzq().zza(new zzhx(this, l));
    }

    public final void zzb(long l) {
        ((zzgr)this).zzb();
        ((zzgr)this).zzq().zza(new zzhf(this, l));
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl) {
        this.zza(string, string2, bundle, false, true, ((zzgr)this).zzm().currentTimeMillis());
    }

    public final void zza(String string, String string2, Bundle bundle) {
        this.zza(string, string2, bundle, true, true, ((zzgr)this).zzm().currentTimeMillis());
    }

    @WorkerThread
    final void zzb(String string, String string2, Bundle bundle) {
        ((zzgr)this).zzb();
        ((zzgr)this).zzd();
        this.zza(string, string2, ((zzgr)this).zzm().currentTimeMillis(), bundle);
    }

    @WorkerThread
    final void zza(String string, String string2, long l, Bundle bundle) {
        ((zzgr)this).zzb();
        ((zzgr)this).zzd();
        boolean bl = this.zzd == null || zzkm.zze(string2);
        this.zza(string, string2, l, bundle, true, bl, false, null);
    }

    @WorkerThread
    protected final void zza(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2;
        Object object;
        Bundle bundle3;
        int n;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Class<?> clazz;
        zzgr zzgr2;
        Object object6;
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)bundle);
        ((zzgr)this).zzd();
        this.zzw();
        if (!this.zzz.zzab()) {
            ((zzgr)this).zzr().zzw().zza("Event not sent since app measurement is disabled");
            return;
        }
        if (((zzgr)this).zzt().zza(zzaq.zzbc) && (object6 = ((zzd)this).zzg().zzah()) != null && !object6.contains(string2)) {
            ((zzgr)this).zzr().zzw().zza("Dropping non-safelisted event. event name, origin", string2, string);
            return;
        }
        if (!this.zzf) {
            this.zzf = true;
            zzgr2 = this;
            try {
                clazz = !((zzhb)zzgr2).zzz.zzt() ? Class.forName("com.google.android.gms.tagmanager.TagManagerService", true, zzgr2.zzn().getClassLoader()) : Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                Class<?> clazz2 = clazz;
                object5 = zzgr2;
                try {
                    clazz2.getDeclaredMethod("initialize", Context.class).invoke(null, ((zzgr)object5).zzn());
                }
                catch (Exception exception) {
                    ((zzgr)object5).zzr().zzi().zza("Failed to invoke Tag Manager's initialize() method", exception);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                zzgr2.zzr().zzv().zza("Tag Manager is not found and thus will not be used");
            }
        }
        if (((zzgr)this).zzt().zza(zzaq.zzbi) && "_cmp".equals(string2) && bundle.containsKey("gclid")) {
            this.zza("auto", "_lgclid", (Object)bundle.getString("gclid"), ((zzgr)this).zzm().currentTimeMillis());
        }
        if (zzlc.zzb() && ((zzgr)this).zzt().zza(zzaq.zzcn)) {
            object5 = ((zzgr)this).zzu();
            if (bl && zzkm.zzg(string2)) {
                object4 = ((zzgr)this).zzs().zzy.zza();
                clazz = bundle;
                zzgr2 = ((zzgr)this).zzp();
                if (object4 != null) {
                    for (String string4 : object4.keySet()) {
                        if (clazz.containsKey(string4)) continue;
                        zzgr2.zzp().zza((Bundle)clazz, string4, object4.get(string4));
                    }
                }
            }
        }
        if (bl3) {
            object5 = ((zzgr)this).zzu();
            if (!"_iap".equals(string2)) {
                int n2;
                clazz = string2;
                zzgr2 = this.zzz.zzi();
                if ((!((zzkm)zzgr2).zza("event", (String)((Object)clazz)) ? 2 : (!((zzkm)zzgr2).zza("event", zzgv.zza, (String)((Object)clazz)) ? 13 : (n2 = !((zzkm)zzgr2).zza("event", 40, (String)((Object)clazz)) ? 2 : 0))) != 0) {
                    ((zzgr)this).zzr().zzh().zza("Invalid public event name. Event will not be logged (FE)", ((zzgr)this).zzo().zza(string2));
                    this.zzz.zzi();
                    String string5 = zzkm.zza(string2, 40, true);
                    int n3 = string2 != null ? string2.length() : 0;
                    this.zzz.zzi().zza(n2, "_ev", string5, n3);
                    return;
                }
            }
        }
        object5 = ((zzgr)this).zzu();
        zzih zzih2 = ((zzd)this).zzi().zzab();
        if (zzih2 != null && !bundle.containsKey("_sc")) {
            zzih2.zzd = true;
        }
        object6 = zzih2;
        zzig.zza((zzih)object6, bundle, bl && bl3);
        boolean bl4 = "am".equals(string);
        boolean bl5 = zzkm.zze(string2);
        if (bl && this.zzd != null && !bl5 && !bl4) {
            ((zzgr)this).zzr().zzw().zza("Passing event to registered event handler (FE)", ((zzgr)this).zzo().zza(string2), ((zzgr)this).zzo().zza(bundle));
            this.zzd.interceptEvent(string, string2, bundle, l);
            return;
        }
        if (!this.zzz.zzag()) {
            return;
        }
        int n4 = ((zzgr)this).zzp().zzb(string2);
        if (n4 != 0) {
            ((zzgr)this).zzr().zzh().zza("Invalid event name. Event will not be logged (FE)", ((zzgr)this).zzo().zza(string2));
            ((zzgr)this).zzp();
            String string6 = zzkm.zza(string2, 40, true);
            int n5 = string2 != null ? string2.length() : 0;
            this.zzz.zzi().zza(string3, n4, "_ev", string6, n5);
            return;
        }
        List list = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        Bundle bundle4 = ((zzgr)this).zzp().zza(string3, string2, bundle, list, bl3, true);
        zzgr2 = bundle4;
        if (bundle4 == null || !zzgr2.containsKey("_sc") || !zzgr2.containsKey("_si")) {
            object3 = null;
        } else {
            clazz = zzgr2.getString("_sn");
            object4 = zzgr2.getString("_sc");
            Long l2 = zzgr2.getLong("_si");
            object3 = object2 = new zzih((String)((Object)clazz), (String)object4, l2);
        }
        if (object3 == null) {
            object2 = object6;
        }
        if (((zzgr)this).zzt().zza(zzaq.zzat)) {
            long l3;
            object5 = ((zzgr)this).zzu();
            if (((zzd)this).zzi().zzab() != null && "_ae".equals(string2) && (l3 = ((zzd)this).zzk().zzb.zzb()) > 0L) {
                ((zzgr)this).zzp().zza(bundle4, l3);
            }
        }
        if (zzjx.zzb() && ((zzgr)this).zzt().zza(zzaq.zzbv)) {
            if (!"auto".equals(string) && "_ssr".equals(string2)) {
                boolean bl6;
                clazz = bundle4;
                zzgr2 = ((zzgr)this).zzp();
                object4 = clazz.getString("_ffr");
                object4 = Strings.isEmptyOrWhitespace((String)object4) ? null : ((String)object4).trim();
                if (zzkm.zzc((String)object4, zzgr2.zzs().zzv.zza())) {
                    zzgr2.zzr().zzw().zza("Not logging duplicate session_start_with_rollout event");
                    bl6 = false;
                } else {
                    zzgr2.zzs().zzv.zza((String)object4);
                    bl6 = true;
                }
                if (!bl6) {
                    return;
                }
            } else if ("_ae".equals(string2)) {
                clazz = bundle4;
                object4 = ((zzgr)((zzgr)this).zzp()).zzs().zzv.zza();
                if (!TextUtils.isEmpty((CharSequence)object4)) {
                    clazz.putString("_ffr", (String)object4);
                }
            }
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add(bundle4);
        long l4 = ((zzgr)this).zzp().zzh().nextLong();
        if (((zzgr)this).zzs().zzq.zza() > 0L && ((zzgr)this).zzs().zza(l) && ((zzgr)this).zzs().zzs.zza()) {
            ((zzgr)this).zzr().zzx().zza("Current session is expired, remove the session number, ID, and engagement time");
            this.zza("auto", "_sid", null, ((zzgr)this).zzm().currentTimeMillis());
            this.zza("auto", "_sno", null, ((zzgr)this).zzm().currentTimeMillis());
            this.zza("auto", "_se", null, ((zzgr)this).zzm().currentTimeMillis());
        }
        if (bundle4.getLong("extend_session", 0L) == 1L) {
            ((zzgr)this).zzr().zzx().zza("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
            long l5 = l;
            this.zzz.zze().zza.zza(l5, true);
        }
        Object[] objectArray = bundle4.keySet().toArray(new String[bundle4.size()]);
        Arrays.sort(objectArray);
        if (zzjm.zzb() && ((zzgr)this).zzt().zza(zzaq.zzch) && ((zzgr)this).zzt().zza(zzaq.zzcg)) {
            Object[] objectArray2 = objectArray;
            int n6 = objectArray.length;
            for (n = 0; n < n6; ++n) {
                Object object7 = objectArray2[n];
                ((zzgr)this).zzp();
                bundle3 = zzkm.zzb(bundle4.get((String)object7));
                if (bundle3 == null) continue;
                bundle4.putParcelableArray((String)object7, (Parcelable[])bundle3);
            }
        } else {
            int n7 = 0;
            Object[] objectArray3 = objectArray;
            n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                bundle3 = objectArray3[i];
                object = bundle4.get((String)bundle3);
                ((zzgr)this).zzp();
                Bundle[] bundleArray = zzkm.zzb(object);
                if (bundleArray == null) continue;
                bundle4.putInt((String)bundle3, bundleArray.length);
                for (int j = 0; j < bundleArray.length; ++j) {
                    bundle2 = bundleArray[j];
                    zzig.zza((zzih)object2, bundle2, true);
                    Bundle bundle5 = ((zzgr)this).zzp().zza(string3, "_ep", bundle2, list, bl3, false);
                    bundle5.putString("_en", string2);
                    bundle5.putLong("_eid", l4);
                    bundle5.putString("_gn", (String)bundle3);
                    bundle5.putInt("_ll", bundleArray.length);
                    bundle5.putInt("_i", j);
                    arrayList.add(bundle5);
                }
                n7 += bundleArray.length;
            }
            if (n7 != 0) {
                bundle4.putLong("_eid", l4);
                bundle4.putInt("_epc", n7);
            }
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Bundle bundle6 = (Bundle)arrayList.get(i);
            String string7 = i != 0 ? "_ep" : string2;
            bundle6.putString("_o", string);
            bundle3 = bl2 ? ((zzgr)this).zzp().zza(bundle6) : bundle6;
            object = new zzao(string7, new zzan(bundle3), string, l);
            ((zzd)this).zzh().zza((zzao)((Object)object), string3);
            if (bl4) continue;
            for (zzgz zzgz2 : this.zze) {
                bundle2 = new Bundle(bundle3);
                zzgz2.onEvent(string, string2, bundle2, l);
            }
        }
        object5 = ((zzgr)this).zzu();
        if (((zzd)this).zzi().zzab() != null && "_ae".equals(string2)) {
            ((zzd)this).zzk().zza(true, true, ((zzgr)this).zzm().elapsedRealtime());
        }
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        ((zzgr)this).zzb();
        if (string == null) {
            string = "app";
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        boolean bl3 = !bl2 || this.zzd == null || zzkm.zze(string2);
        this.zzb(string, string2, l, bundle, bl2, bl3, !bl, null);
    }

    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2 = zzkm.zzb(bundle);
        ((zzgr)this).zzq().zza(new zzhe(this, string, string2, l, bundle2, bl, bl2, bl3, string3));
    }

    public final void zza(String string, String string2, Object object, boolean bl) {
        this.zza(string, string2, object, bl, ((zzgr)this).zzm().currentTimeMillis());
    }

    public final void zza(String string, String string2, Object object, boolean bl, long l) {
        int n;
        int n2;
        if (string == null) {
            string = "app";
        }
        if (bl) {
            n2 = ((zzgr)this).zzp().zzc(string2);
        } else {
            String string3 = string2;
            zzkm zzkm2 = ((zzgr)this).zzp();
            n2 = !zzkm2.zza("user property", string3) ? 6 : (!zzkm2.zza("user property", zzgx.zza, string3) ? 15 : (n = !zzkm2.zza("user property", 24, string3) ? 6 : 0));
        }
        if (n2 != 0) {
            ((zzgr)this).zzp();
            String string4 = zzkm.zza(string2, 24, true);
            int n3 = string2 != null ? string2.length() : 0;
            this.zzz.zzi().zza(n, "_ev", string4, n3);
            return;
        }
        if (object != null) {
            n = ((zzgr)this).zzp().zzb(string2, object);
            if (n != 0) {
                ((zzgr)this).zzp();
                String string5 = zzkm.zza(string2, 24, true);
                int n4 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n4 = String.valueOf(object).length();
                }
                this.zzz.zzi().zza(n, "_ev", string5, n4);
                return;
            }
            Object object2 = ((zzgr)this).zzp().zzc(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, (Object)null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzgr)this).zzq().zza(new zzhh(this, string, string2, object, l));
    }

    @WorkerThread
    final void zza(String string, String string2, Object object, long l) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ((zzgr)this).zzd();
        ((zzgr)this).zzb();
        this.zzw();
        if ("allow_personalized_ads".equals(string2)) {
            if (object instanceof String && !TextUtils.isEmpty((CharSequence)((String)object))) {
                object = "false".equals(((String)object).toLowerCase(Locale.ENGLISH)) ? 1L : 0L;
                string2 = "_npa";
                ((zzgr)this).zzs().zzn.zza((Long)object == 1L ? "true" : "false");
            } else if (object == null) {
                string2 = "_npa";
                ((zzgr)this).zzs().zzn.zza("unset");
            }
        }
        if (!this.zzz.zzab()) {
            ((zzgr)this).zzr().zzx().zza("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzz.zzag()) {
            return;
        }
        zzkh zzkh2 = new zzkh(string2, l, object, string);
        ((zzd)this).zzh().zza(zzkh2);
    }

    public final List<zzkh> zzc(boolean bl) {
        ((zzgr)this).zzb();
        this.zzw();
        ((zzgr)this).zzr().zzx().zza("Getting user properties (FE)");
        if (((zzgr)this).zzq().zzg()) {
            ((zzgr)this).zzr().zzf().zza("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        if (zzx.zza()) {
            ((zzgr)this).zzr().zzf().zza("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        this.zzz.zzq().zza(atomicReference, 5000L, "get user properties", new zzhg(this, atomicReference, bl));
        List list = (List)atomicReference.get();
        if (list == null) {
            ((zzgr)this).zzr().zzf().zza("Timed out waiting for get user properties, includeInternal", bl);
            return Collections.emptyList();
        }
        return list;
    }

    @Nullable
    public final String zzah() {
        ((zzgr)this).zzb();
        return this.zzg.get();
    }

    @Nullable
    public final String zzc(long l) {
        if (((zzgr)this).zzq().zzg()) {
            ((zzgr)this).zzr().zzf().zza("Cannot retrieve app instance id from analytics worker thread");
            return null;
        }
        if (zzx.zza()) {
            ((zzgr)this).zzr().zzf().zza("Cannot retrieve app instance id from main thread");
            return null;
        }
        long l2 = ((zzgr)this).zzm().elapsedRealtime();
        String string = this.zze(120000L);
        long l3 = ((zzgr)this).zzm().elapsedRealtime() - l2;
        if (string == null && l3 < 120000L) {
            string = this.zze(120000L - l3);
        }
        return string;
    }

    final void zza(@Nullable String string) {
        this.zzg.set(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private final String zze(long l) {
        AtomicReference atomicReference;
        AtomicReference atomicReference2 = atomicReference = new AtomicReference();
        synchronized (atomicReference) {
            ((zzgr)this).zzq().zza(new zzhj(this, atomicReference));
            try {
                atomicReference.wait(l);
            }
            catch (InterruptedException interruptedException) {
                ((zzgr)this).zzr().zzi().zza("Interrupted waiting for app instance id");
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return null;
            }
            return (String)atomicReference.get();
        }
    }

    public final void zzd(long l) {
        this.zza((String)null);
        ((zzgr)this).zzq().zza(new zzhi(this, l));
    }

    @WorkerThread
    public final void zzai() {
        ((zzgr)this).zzd();
        ((zzgr)this).zzb();
        this.zzw();
        if (!this.zzz.zzag()) {
            return;
        }
        if (((zzgr)this).zzt().zza(zzaq.zzbh)) {
            zzy zzy2 = ((zzgr)this).zzt();
            zzx zzx2 = ((zzgr)zzy2).zzu();
            Boolean bl = zzy2.zzd("google_analytics_deferred_deep_link_enabled");
            if (bl != null && bl != false) {
                ((zzgr)this).zzr().zzw().zza("Deferred Deep Link feature enabled.");
                ((zzgr)this).zzq().zza(new zzhd(this));
            }
        }
        ((zzd)this).zzh().zzae();
        this.zzc = false;
        String string = ((zzgr)this).zzs().zzw();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            ((zzgr)this).zzl().zzaa();
            if (!string.equals(Build.VERSION.RELEASE)) {
                Bundle bundle = new Bundle();
                bundle.putString("_po", string);
                this.zza("auto", "_ou", bundle);
            }
        }
    }

    @WorkerThread
    public final void zza(zzgw zzgw2) {
        ((zzgr)this).zzd();
        ((zzgr)this).zzb();
        this.zzw();
        if (zzgw2 != null && zzgw2 != this.zzd) {
            Preconditions.checkState((this.zzd == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzd = zzgw2;
    }

    public final void zza(zzgz zzgz2) {
        ((zzgr)this).zzb();
        this.zzw();
        Preconditions.checkNotNull((Object)zzgz2);
        if (!this.zze.add(zzgz2)) {
            ((zzgr)this).zzr().zzi().zza("OnEventListener already registered");
        }
    }

    public final void zzb(zzgz zzgz2) {
        ((zzgr)this).zzb();
        this.zzw();
        Preconditions.checkNotNull((Object)zzgz2);
        if (!this.zze.remove(zzgz2)) {
            ((zzgr)this).zzr().zzi().zza("OnEventListener had not been registered");
        }
    }

    public final void zza(Bundle bundle) {
        this.zza(bundle, ((zzgr)this).zzm().currentTimeMillis());
    }

    public final void zza(Bundle bundle, long l) {
        Preconditions.checkNotNull((Object)bundle);
        ((zzgr)this).zzb();
        Bundle bundle2 = new Bundle(bundle);
        if (!TextUtils.isEmpty((CharSequence)bundle2.getString("app_id"))) {
            ((zzgr)this).zzr().zzi().zza("Package name should be null when calling setConditionalUserProperty");
        }
        bundle2.remove("app_id");
        this.zzb(bundle2, l);
    }

    public final void zzb(Bundle bundle) {
        Preconditions.checkNotNull((Object)bundle);
        Preconditions.checkNotEmpty((String)bundle.getString("app_id"));
        ((zzgr)this).zza();
        this.zzb(new Bundle(bundle), ((zzgr)this).zzm().currentTimeMillis());
    }

    private final void zzb(Bundle bundle, long l) {
        Preconditions.checkNotNull((Object)bundle);
        Bundle bundle2 = bundle;
        zzgs.zza((Bundle)bundle2, (String)"app_id", String.class, null);
        zzgs.zza((Bundle)bundle2, (String)"origin", String.class, null);
        zzgs.zza((Bundle)bundle2, (String)"name", String.class, null);
        zzgs.zza((Bundle)bundle2, (String)"value", Object.class, null);
        zzgs.zza((Bundle)bundle2, (String)"trigger_event_name", String.class, null);
        zzgs.zza((Bundle)bundle2, (String)"trigger_timeout", Long.class, (Object)0L);
        zzgs.zza((Bundle)bundle2, (String)"timed_out_event_name", String.class, null);
        zzgs.zza((Bundle)bundle2, (String)"timed_out_event_params", Bundle.class, null);
        zzgs.zza((Bundle)bundle2, (String)"triggered_event_name", String.class, null);
        zzgs.zza((Bundle)bundle2, (String)"triggered_event_params", Bundle.class, null);
        zzgs.zza((Bundle)bundle2, (String)"time_to_live", Long.class, (Object)0L);
        zzgs.zza((Bundle)bundle2, (String)"expired_event_name", String.class, null);
        zzgs.zza((Bundle)bundle2, (String)"expired_event_params", Bundle.class, null);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
        Preconditions.checkNotNull((Object)bundle.get("value"));
        bundle.putLong("creation_timestamp", l);
        String string = bundle.getString("name");
        Object object = bundle.get("value");
        if (((zzgr)this).zzp().zzc(string) != 0) {
            ((zzgr)this).zzr().zzf().zza("Invalid conditional user property name", ((zzgr)this).zzo().zzc(string));
            return;
        }
        if (((zzgr)this).zzp().zzb(string, object) != 0) {
            ((zzgr)this).zzr().zzf().zza("Invalid conditional user property value", ((zzgr)this).zzo().zzc(string), object);
            return;
        }
        Object object2 = ((zzgr)this).zzp().zzc(string, object);
        if (object2 == null) {
            ((zzgr)this).zzr().zzf().zza("Unable to normalize conditional user property value", ((zzgr)this).zzo().zzc(string), object);
            return;
        }
        zzgs.zza((Bundle)bundle, (Object)object2);
        long l2 = bundle.getLong("trigger_timeout");
        if (!(TextUtils.isEmpty((CharSequence)bundle.getString("trigger_event_name")) || l2 <= 15552000000L && l2 >= 1L)) {
            ((zzgr)this).zzr().zzf().zza("Invalid conditional user property timeout", ((zzgr)this).zzo().zzc(string), l2);
            return;
        }
        long l3 = bundle.getLong("time_to_live");
        if (l3 > 15552000000L || l3 < 1L) {
            ((zzgr)this).zzr().zzf().zza("Invalid conditional user property time to live", ((zzgr)this).zzo().zzc(string), l3);
            return;
        }
        ((zzgr)this).zzq().zza(new zzhk(this, bundle));
    }

    public final void zzc(String string, String string2, Bundle bundle) {
        ((zzgr)this).zzb();
        this.zzb(null, string, string2, bundle);
    }

    public final void zza(String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotEmpty((String)string);
        ((zzgr)this).zza();
        this.zzb(string, string2, string3, bundle);
    }

    private final void zzb(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzgr)this).zzm().currentTimeMillis();
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle2 = new Bundle();
        if (string != null) {
            bundle2.putString("app_id", string);
        }
        bundle2.putString("name", string2);
        bundle2.putLong("creation_timestamp", l);
        if (string3 != null) {
            bundle2.putString("expired_event_name", string3);
            bundle2.putBundle("expired_event_params", bundle);
        }
        ((zzgr)this).zzq().zza(new zzhn(this, bundle2));
    }

    @WorkerThread
    private final void zzc(Bundle bundle) {
        zzao zzao2;
        zzao zzao3;
        zzao zzao4;
        ((zzgr)this).zzd();
        this.zzw();
        Preconditions.checkNotNull((Object)bundle);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
        Preconditions.checkNotNull((Object)bundle.get("value"));
        if (!this.zzz.zzab()) {
            ((zzgr)this).zzr().zzx().zza("Conditional property not set since app measurement is disabled");
            return;
        }
        zzkh zzkh2 = new zzkh(bundle.getString("name"), bundle.getLong("triggered_timestamp"), bundle.get("value"), bundle.getString("origin"));
        try {
            zzao4 = ((zzgr)this).zzp().zza(bundle.getString("app_id"), bundle.getString("triggered_event_name"), bundle.getBundle("triggered_event_params"), bundle.getString("origin"), 0L, true, false);
            zzao3 = ((zzgr)this).zzp().zza(bundle.getString("app_id"), bundle.getString("timed_out_event_name"), bundle.getBundle("timed_out_event_params"), bundle.getString("origin"), 0L, true, false);
            zzao2 = ((zzgr)this).zzp().zza(bundle.getString("app_id"), bundle.getString("expired_event_name"), bundle.getBundle("expired_event_params"), bundle.getString("origin"), 0L, true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzw zzw2 = new zzw(bundle.getString("app_id"), bundle.getString("origin"), zzkh2, bundle.getLong("creation_timestamp"), false, bundle.getString("trigger_event_name"), zzao3, bundle.getLong("trigger_timeout"), zzao4, bundle.getLong("time_to_live"), zzao2);
        ((zzd)this).zzh().zza(zzw2);
    }

    @WorkerThread
    private final void zzd(Bundle bundle) {
        zzao zzao2;
        ((zzgr)this).zzd();
        this.zzw();
        Preconditions.checkNotNull((Object)bundle);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        if (!this.zzz.zzab()) {
            ((zzgr)this).zzr().zzx().zza("Conditional property not cleared since app measurement is disabled");
            return;
        }
        zzkh zzkh2 = new zzkh(bundle.getString("name"), 0L, null, null);
        try {
            zzao2 = ((zzgr)this).zzp().zza(bundle.getString("app_id"), bundle.getString("expired_event_name"), bundle.getBundle("expired_event_params"), bundle.getString("origin"), bundle.getLong("creation_timestamp"), true, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzw zzw2 = new zzw(bundle.getString("app_id"), bundle.getString("origin"), zzkh2, bundle.getLong("creation_timestamp"), bundle.getBoolean("active"), bundle.getString("trigger_event_name"), null, bundle.getLong("trigger_timeout"), null, bundle.getLong("time_to_live"), zzao2);
        ((zzd)this).zzh().zza(zzw2);
    }

    public final ArrayList<Bundle> zza(String string, String string2) {
        ((zzgr)this).zzb();
        return this.zzb(null, string, string2);
    }

    public final ArrayList<Bundle> zza(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        ((zzgr)this).zza();
        return this.zzb(string, string2, string3);
    }

    @VisibleForTesting
    private final ArrayList<Bundle> zzb(String string, String string2, String string3) {
        if (((zzgr)this).zzq().zzg()) {
            ((zzgr)this).zzr().zzf().zza("Cannot get conditional user properties from analytics worker thread");
            return new ArrayList<Bundle>(0);
        }
        if (zzx.zza()) {
            ((zzgr)this).zzr().zzf().zza("Cannot get conditional user properties from main thread");
            return new ArrayList<Bundle>(0);
        }
        AtomicReference atomicReference = new AtomicReference();
        this.zzz.zzq().zza(atomicReference, 5000L, "get conditional user properties", new zzhp(this, atomicReference, string, string2, string3));
        List list = (List)atomicReference.get();
        if (list == null) {
            ((zzgr)this).zzr().zzf().zza("Timed out waiting for get conditional user properties", string);
            return new ArrayList<Bundle>();
        }
        return zzkm.zzb(list);
    }

    public final Map<String, Object> zza(String string, String string2, boolean bl) {
        ((zzgr)this).zzb();
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> zza(String string, String string2, String string3, boolean bl) {
        Preconditions.checkNotEmpty((String)string);
        ((zzgr)this).zza();
        return this.zzb(string, string2, string3, bl);
    }

    @VisibleForTesting
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzgr)this).zzq().zzg()) {
            ((zzgr)this).zzr().zzf().zza("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        if (zzx.zza()) {
            ((zzgr)this).zzr().zzf().zza("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        this.zzz.zzq().zza(atomicReference, 5000L, "get user properties", new zzho(this, atomicReference, string, string2, string3, bl));
        List list = (List)atomicReference.get();
        if (list == null) {
            ((zzgr)this).zzr().zzf().zza("Timed out waiting for handle get user properties, includeInternal", bl);
            return Collections.emptyMap();
        }
        ArrayMap arrayMap = new ArrayMap(list.size());
        for (zzkh zzkh2 : list) {
            arrayMap.put(zzkh2.zza, zzkh2.zza());
        }
        return arrayMap;
    }

    @Nullable
    public final String zzaj() {
        zzih zzih2 = this.zzz.zzv().zzac();
        if (zzih2 != null) {
            return zzih2.zza;
        }
        return null;
    }

    @Nullable
    public final String zzak() {
        zzih zzih2 = this.zzz.zzv().zzac();
        if (zzih2 != null) {
            return zzih2.zzb;
        }
        return null;
    }

    @Nullable
    public final String zzal() {
        if (this.zzz.zzo() != null) {
            return this.zzz.zzo();
        }
        try {
            String string = "google_app_id";
            Context context = ((zzgr)this).zzn();
            return new StringResourceValueReader(context).getString(string);
        }
        catch (IllegalStateException illegalStateException) {
            this.zzz.zzr().zzf().zza("getGoogleAppId failed with exception", illegalStateException);
            return null;
        }
    }

    static /* synthetic */ void zza(zzhb zzhb2, boolean bl) {
        zzhb2.zzd(bl);
    }

    static /* synthetic */ void zza(zzhb zzhb2) {
        zzhb2.zzam();
    }

    static /* synthetic */ void zza(zzhb zzhb2, Bundle bundle) {
        zzhb2.zzc(bundle);
    }

    static /* synthetic */ void zzb(zzhb zzhb2, Bundle bundle) {
        zzhb2.zzd(bundle);
    }
}

