/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import androidx.annotation.MainThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzv;

public final class zzfp {
    private final zzfs zza;

    public zzfp(zzfs zzfs2) {
        Preconditions.checkNotNull((Object)zzfs2);
        this.zza = zzfs2;
    }

    public static boolean zza(Context context) {
        Preconditions.checkNotNull((Object)context);
        try {
            PackageManager packageManager = context.getPackageManager();
            if (packageManager == null) {
                return false;
            }
            ActivityInfo activityInfo = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (activityInfo != null && activityInfo.enabled) {
                return true;
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        return false;
    }

    @MainThread
    public final void zza(Context context, Intent intent) {
        zzfx zzfx2 = zzfx.zza(context, null, null);
        zzet zzet2 = zzfx2.zzr();
        if (intent == null) {
            zzet2.zzi().zza("Receiver called with null intent");
            return;
        }
        zzv zzv2 = zzfx2.zzu();
        boolean bl = false;
        String string = intent.getAction();
        if (bl) {
            zzet2.zzx().zza("Device receiver got", string);
        } else {
            zzet2.zzx().zza("Local receiver got", string);
        }
        if ("com.google.android.gms.measurement.UPLOAD".equals(string)) {
            Intent intent2 = new Intent().setClassName(context, bl ? "com.google.android.gms.measurement.PackageMeasurementService" : "com.google.android.gms.measurement.AppMeasurementService");
            intent2.setAction("com.google.android.gms.measurement.UPLOAD");
            zzet2.zzx().zza("Starting wakeful intent.");
            this.zza.doStartService(context, intent2);
            return;
        }
        if ("com.android.vending.INSTALL_REFERRER".equals(string)) {
            zzet2.zzi().zza("Install Referrer Broadcasts are deprecated");
        }
    }
}

