/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import com.google.android.gms.internal.measurement.zzcj;
import com.google.android.gms.internal.measurement.zzck;
import com.google.android.gms.internal.measurement.zzcl;
import com.google.android.gms.internal.measurement.zzcm;
import com.google.android.gms.internal.measurement.zzco;
import com.google.android.gms.internal.measurement.zzcv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzch
implements zzcl {
    @GuardedBy(value="ConfigurationContentLoader.class")
    private static final Map<Uri, zzch> zza = new ArrayMap();
    private final ContentResolver zzb;
    private final Uri zzc;
    private final ContentObserver zzd = new zzcj(this, null);
    private final Object zze = new Object();
    private volatile Map<String, String> zzf;
    @GuardedBy(value="this")
    private final List<zzcm> zzg = new ArrayList<zzcm>();
    private static final String[] zzh = new String[]{"key", "value"};

    private zzch(ContentResolver contentResolver, Uri uri) {
        this.zzb = contentResolver;
        this.zzc = uri;
        contentResolver.registerContentObserver(uri, false, this.zzd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzch zza(ContentResolver contentResolver, Uri uri) {
        Class<zzch> clazz = zzch.class;
        synchronized (zzch.class) {
            zzch zzch2 = zza.get(uri);
            if (zzch2 == null) {
                try {
                    zzch2 = new zzch(contentResolver, uri);
                    zza.put(uri, zzch2);
                }
                catch (SecurityException securityException) {}
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return zzch2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Map<String, String> zza() {
        Map<String, String> map = this.zzf;
        if (map == null) {
            Object object = this.zze;
            synchronized (object) {
                map = this.zzf;
                if (map == null) {
                    this.zzf = map = this.zze();
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb() {
        zzch zzch2;
        Object object = this.zze;
        synchronized (object) {
            this.zzf = null;
            zzcv.zza();
        }
        zzch zzch3 = zzch2 = this;
        synchronized (zzch2) {
            Iterator<zzcm> iterator = zzch2.zzg.iterator();
            while (iterator.hasNext()) {
                iterator.next().zza();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private final Map<String, String> zze() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            Map map = (Map)zzco.zza(new zzck(this));
            return map;
        }
        catch (SQLiteException | IllegalStateException | SecurityException throwable) {
            Log.e((String)"ConfigurationContentLoader", (String)"PhenotypeFlag unable to load ContentProvider, using default values");
            return null;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    static synchronized void zzc() {
        for (zzch zzch2 : zza.values()) {
            zzch2.zzb.unregisterContentObserver(zzch2.zzd);
        }
        zza.clear();
    }

    @Override
    public final /* synthetic */ Object zza(String string) {
        String string2 = string;
        return this.zza().get(string2);
    }

    final /* synthetic */ Map zzd() {
        Cursor cursor = this.zzb.query(this.zzc, zzh, null, null, null);
        if (cursor == null) {
            return Collections.emptyMap();
        }
        try {
            Object object;
            int n = cursor.getCount();
            if (n == 0) {
                Map map = Collections.emptyMap();
                return map;
            }
            Object object2 = object = n <= 256 ? new ArrayMap(n) : new HashMap(n, 1.0f);
            while (cursor.moveToNext()) {
                object.put(cursor.getString(0), cursor.getString(1));
            }
            Object object3 = object;
            return object3;
        }
        finally {
            cursor.close();
        }
    }
}

