/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzkt;
import com.google.android.gms.internal.measurement.zzlf;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzil;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zzkr;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class zzii
extends zzg {
    private volatile zzij zzb;
    private zzij zzc;
    @VisibleForTesting
    protected zzij zza;
    private final Map<Activity, zzij> zzd;
    private Activity zze;
    private volatile boolean zzf;
    private volatile zzij zzg;
    private zzij zzh;
    private boolean zzi;
    private final Object zzj = new Object();
    private zzij zzk;
    private String zzl;

    public zzii(zzfy zzfy2) {
        super(zzfy2);
        this.zzd = new ConcurrentHashMap<Activity, zzij>();
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    public final zzij zza(boolean bl) {
        this.zzw();
        ((zzgs)this).zzd();
        if (!((zzgs)this).zzt().zza(zzaq.zzcc) || !bl) {
            return this.zza;
        }
        if (this.zza != null) {
            return this.zza;
        }
        return this.zzh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Bundle bundle) {
        zzij zzij2;
        if (!((zzgs)this).zzt().zza(zzaq.zzcc)) {
            ((zzgs)this).zzr().zzk().zza("Manual screen reporting is disabled.");
            return;
        }
        String string = null;
        String string2 = null;
        Object object = this.zzj;
        synchronized (object) {
            if (!this.zzi) {
                ((zzgs)this).zzr().zzk().zza("Cannot log screen view event when the app is in the background.");
                return;
            }
            if (bundle != null) {
                string = bundle.getString("screen_name");
                if (string != null && (string.length() <= 0 || string.length() > 100)) {
                    ((zzgs)this).zzr().zzk().zza("Invalid screen name length for screen view. Length", string.length());
                    return;
                }
                string2 = bundle.getString("screen_class");
                if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
                    ((zzgs)this).zzr().zzk().zza("Invalid screen class length for screen view. Length", string2.length());
                    return;
                }
            }
            if (string2 == null) {
                String string3 = string2 = this.zze != null ? zzii.zza(this.zze.getClass().getCanonicalName()) : "Activity";
            }
            if (this.zzf && this.zzb != null) {
                this.zzf = false;
                boolean bl = zzkr.zzc(this.zzb.zzb, string2);
                boolean bl2 = zzkr.zzc(this.zzb.zza, string);
                if (bl && bl2) {
                    ((zzgs)this).zzr().zzk().zza("Ignoring call to log screen view event with duplicate parameters.");
                    return;
                }
            }
        }
        ((zzgs)this).zzr().zzx().zza("Logging screen view with name, class", string == null ? "null" : string, string2 == null ? "null" : string2);
        object = this.zzb == null ? this.zzc : this.zzb;
        this.zzb = zzij2 = new zzij(string, string2, ((zzgs)this).zzp().zzg(), true);
        this.zzc = object;
        this.zzg = zzij2;
        long l = ((zzgs)this).zzm().elapsedRealtime();
        ((zzgs)this).zzq().zza(new zzil(this, bundle, zzij2, (zzij)object, l));
    }

    @WorkerThread
    private final void zza(Bundle bundle, @NonNull zzij zzij2, zzij zzij3, long l) {
        if (bundle != null) {
            bundle.remove("screen_name");
            bundle.remove("screen_class");
        }
        Bundle bundle2 = ((zzgs)this).zzp().zza(null, "screen_view", bundle, null, true, true);
        this.zza(zzij2, zzij3, l, true, bundle2);
    }

    @MainThread
    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!((zzgs)this).zzt().zzj().booleanValue()) {
            ((zzgs)this).zzr().zzk().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
            return;
        }
        if (this.zzb == null) {
            ((zzgs)this).zzr().zzk().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzgs)this).zzr().zzk().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzii.zza(activity.getClass().getCanonicalName());
        }
        boolean bl = zzkr.zzc(this.zzb.zzb, string2);
        boolean bl2 = zzkr.zzc(this.zzb.zza, string);
        if (bl && bl2) {
            ((zzgs)this).zzr().zzk().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzgs)this).zzr().zzk().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzgs)this).zzr().zzk().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzgs)this).zzr().zzx().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzij zzij2 = new zzij(string, string2, ((zzgs)this).zzp().zzg());
        this.zzd.put(activity, zzij2);
        this.zza(activity, zzij2, true);
    }

    public final zzij zzab() {
        ((zzgs)this).zzb();
        return this.zzb;
    }

    @MainThread
    private final void zza(Activity activity, zzij zzij2, boolean bl) {
        zzij zzij3;
        zzij zzij4;
        zzij zzij5 = zzij4 = this.zzb == null ? this.zzc : this.zzb;
        if (zzij2.zzb == null) {
            zzij3 = activity != null ? zzii.zza(activity.getClass().getCanonicalName()) : null;
            zzij2 = new zzij(zzij2.zza, (String)((Object)zzij3), zzij2.zzc, zzij2.zze);
        }
        zzij3 = zzij2;
        this.zzc = this.zzb;
        this.zzb = zzij3;
        long l = ((zzgs)this).zzm().elapsedRealtime();
        ((zzgs)this).zzq().zza(new zzik(this, zzij3, zzij4, l, bl));
    }

    @WorkerThread
    private final void zza(zzij zzij2, zzij zzij3, long l, boolean bl, Bundle bundle) {
        ((zzgs)this).zzd();
        boolean bl2 = false;
        if (((zzgs)this).zzt().zza(zzaq.zzat)) {
            bl2 = bl && this.zza != null;
            if (bl2) {
                this.zza(this.zza, true, l);
            }
        } else if (bl && this.zza != null) {
            this.zza(this.zza, true, l);
        }
        if (zzij3 == null || zzij3.zzc != zzij2.zzc || !zzkr.zzc(zzij3.zzb, zzij2.zzb) || !zzkr.zzc(zzij3.zza, zzij2.zza)) {
            long l2;
            Bundle bundle2 = new Bundle();
            if (((zzgs)this).zzt().zza(zzaq.zzcc)) {
                bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            }
            zzii.zza(zzij2, bundle2, true);
            if (zzij3 != null) {
                if (zzij3.zza != null) {
                    bundle2.putString("_pn", zzij3.zza);
                }
                if (zzij3.zzb != null) {
                    bundle2.putString("_pc", zzij3.zzb);
                }
                bundle2.putLong("_pi", zzij3.zzc);
            }
            if (((zzgs)this).zzt().zza(zzaq.zzat) && bl2 && (l2 = zzlf.zzb() && ((zzgs)this).zzt().zza(zzaq.zzav) && zzkt.zzb() && ((zzgs)this).zzt().zza(zzaq.zzbz) ? ((zzd)this).zzk().zza(l) : ((zzd)this).zzk().zzb.zzb()) > 0L) {
                ((zzgs)this).zzp().zza(bundle2, l2);
            }
            String string = "auto";
            if (((zzgs)this).zzt().zza(zzaq.zzcc)) {
                if (!((zzgs)this).zzt().zzj().booleanValue()) {
                    bundle2.putLong("_mt", 1L);
                }
                string = zzij2.zze ? "app" : "auto";
            }
            ((zzd)this).zzf().zzb(string, "_vs", bundle2);
        }
        this.zza = zzij2;
        if (((zzgs)this).zzt().zza(zzaq.zzcc) && zzij2.zze) {
            this.zzh = zzij2;
        }
        ((zzd)this).zzh().zza(zzij2);
    }

    @WorkerThread
    private final void zza(zzij zzij2, boolean bl, long l) {
        boolean bl2;
        ((zzd)this).zze().zza(((zzgs)this).zzm().elapsedRealtime());
        boolean bl3 = bl2 = zzij2 != null && zzij2.zzd;
        if (((zzd)this).zzk().zza(bl2, bl, l) && zzij2 != null) {
            zzij2.zzd = false;
        }
    }

    public static void zza(zzij zzij2, Bundle bundle, boolean bl) {
        if (bundle != null && zzij2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzij2.zza != null) {
                bundle.putString("_sn", zzij2.zza);
            } else {
                bundle.remove("_sn");
            }
            if (zzij2.zzb != null) {
                bundle.putString("_sc", zzij2.zzb);
            } else {
                bundle.remove("_sc");
            }
            bundle.putLong("_si", zzij2.zzc);
            return;
        }
        if (bundle != null && zzij2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzij zzij2) {
        ((zzgs)this).zzd();
        zzii zzii2 = this;
        synchronized (zzii2) {
            if (this.zzl == null || this.zzl.equals(string) || zzij2 != null) {
                this.zzl = string;
                this.zzk = zzij2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zza(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzij zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzij zzij2 = this.zzd.get(activity);
        if (zzij2 == null) {
            String string = zzii.zza(activity.getClass().getCanonicalName());
            zzij2 = new zzij(null, string, ((zzgs)this).zzp().zzg());
            this.zzd.put(activity, zzij2);
        }
        if (!((zzgs)this).zzt().zza(zzaq.zzcc)) {
            return zzij2;
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return zzij2;
    }

    @MainThread
    public final void zza(Activity activity, Bundle bundle) {
        if (!((zzgs)this).zzt().zzj().booleanValue()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzij zzij2 = new zzij(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzij2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(Activity activity) {
        zzd zzd2;
        Object object;
        if (((zzgs)this).zzt().zza(zzaq.zzcc)) {
            object = this.zzj;
            synchronized (object) {
                this.zzi = true;
                if (activity != this.zze) {
                    Activity activity2 = activity;
                    zzd2 = this;
                    Object object2 = ((zzii)zzd2).zzj;
                    synchronized (object2) {
                        ((zzii)zzd2).zze = activity2;
                        ((zzii)zzd2).zzf = false;
                    }
                    if (zzd2.zzt().zza(zzaq.zzcb) && zzd2.zzt().zzj().booleanValue()) {
                        ((zzii)zzd2).zzg = null;
                        zzd2.zzq().zza(new zzio((zzii)zzd2));
                    }
                }
            }
        }
        if (((zzgs)this).zzt().zza(zzaq.zzcb) && !((zzgs)this).zzt().zzj().booleanValue()) {
            this.zzb = this.zzg;
            ((zzgs)this).zzq().zza(new zzin(this));
            return;
        }
        object = this.zzd(activity);
        this.zza(activity, (zzij)object, false);
        zzd2 = ((zzd)this).zze();
        long l = zzd2.zzm().elapsedRealtime();
        zzd2.zzq().zza(new zze((zza)zzd2, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzb(Activity activity) {
        if (((zzgs)this).zzt().zza(zzaq.zzcc)) {
            Object object = this.zzj;
            synchronized (object) {
                this.zzi = false;
                this.zzf = true;
            }
        }
        long l = ((zzgs)this).zzm().elapsedRealtime();
        if (((zzgs)this).zzt().zza(zzaq.zzcb) && !((zzgs)this).zzt().zzj().booleanValue()) {
            this.zzb = null;
            ((zzgs)this).zzq().zza(new zzim(this, l));
            return;
        }
        zzij zzij2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzgs)this).zzq().zza(new zzip(this, zzij2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (!((zzgs)this).zzt().zzj().booleanValue()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzij zzij2 = this.zzd.get(activity);
        if (zzij2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzij2.zzc);
        bundle2.putString("name", zzij2.zza);
        bundle2.putString("referrer_name", zzij2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzc(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            if (activity == this.zze) {
                this.zze = null;
            }
        }
        if (!((zzgs)this).zzt().zzj().booleanValue()) {
            return;
        }
        this.zzd.remove(activity);
    }

    static /* synthetic */ void zza(zzii zzii2, Bundle bundle, zzij zzij2, zzij zzij3, long l) {
        zzii2.zza(bundle, zzij2, zzij3, l);
    }

    static /* synthetic */ void zza(zzii zzii2, zzij zzij2, zzij zzij3, long l, boolean bl, Bundle bundle) {
        zzii2.zza(zzij2, zzij3, l, bl, null);
    }

    static /* synthetic */ zzij zza(zzii zzii2) {
        return zzii2.zzh;
    }

    static /* synthetic */ void zza(zzii zzii2, zzij zzij2, boolean bl, long l) {
        zzii2.zza(zzij2, false, l);
    }

    static /* synthetic */ zzij zza(zzii zzii2, zzij zzij2) {
        zzii2.zzh = null;
        return null;
    }
}

