/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.SharedPreferences;
import android.os.Bundle;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzfj;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class zzfk {
    private final String zza;
    private final Bundle zzb;
    private boolean zzc;
    private Bundle zzd;
    private final /* synthetic */ zzfj zze;

    public zzfk(zzfj zzfj2, String string, Bundle bundle) {
        this.zze = zzfj2;
        Preconditions.checkNotEmpty((String)string);
        this.zza = string;
        this.zzb = new Bundle();
    }

    @WorkerThread
    public final Bundle zza() {
        zzfk zzfk2 = this;
        if (!zzfk2.zzc) {
            zzfk2.zzc = true;
            String string = zzfk2.zze.zzf().getString(zzfk2.zza, null);
            if (string != null) {
                try {
                    Bundle bundle = new Bundle();
                    JSONArray jSONArray = new JSONArray(string);
                    for (int i = 0; i < jSONArray.length(); ++i) {
                        try {
                            String string2;
                            JSONObject jSONObject = jSONArray.getJSONObject(i);
                            String string3 = jSONObject.getString("n");
                            switch (string2 = jSONObject.getString("t")) {
                                case "s": {
                                    String string4 = jSONObject.getString("v");
                                    bundle.putString(string3, string4);
                                    break;
                                }
                                case "d": {
                                    double d = Double.parseDouble(jSONObject.getString("v"));
                                    bundle.putDouble(string3, d);
                                    break;
                                }
                                case "l": {
                                    long l = Long.parseLong(jSONObject.getString("v"));
                                    bundle.putLong(string3, l);
                                    break;
                                }
                                default: {
                                    zzfk2.zze.zzq().zze().zza("Unrecognized persisted bundle type. Type", string2);
                                    break;
                                }
                            }
                            continue;
                        }
                        catch (NumberFormatException | JSONException throwable) {
                            zzfk2.zze.zzq().zze().zza("Error reading value from SharedPreferences. Value dropped");
                        }
                    }
                    zzfk2.zzd = bundle;
                }
                catch (JSONException jSONException) {
                    zzfk2.zze.zzq().zze().zza("Error loading bundle from SharedPreferences. Values will be lost");
                }
            }
            if (zzfk2.zzd == null) {
                zzfk2.zzd = zzfk2.zzb;
            }
        }
        return this.zzd;
    }

    @WorkerThread
    public final void zza(Bundle bundle) {
        if (bundle == null) {
            bundle = new Bundle();
        }
        SharedPreferences.Editor editor = this.zze.zzf().edit();
        if (bundle.size() == 0) {
            editor.remove(this.zza);
        } else {
            editor.putString(this.zza, this.zzb(bundle));
        }
        editor.apply();
        this.zzd = bundle;
    }

    private final String zzb(Bundle bundle) {
        JSONArray jSONArray = new JSONArray();
        for (String string : bundle.keySet()) {
            Object object = bundle.get(string);
            if (object == null) continue;
            try {
                JSONObject jSONObject = new JSONObject();
                jSONObject.put("n", (Object)string);
                jSONObject.put("v", (Object)String.valueOf(object));
                if (object instanceof String) {
                    jSONObject.put("t", (Object)"s");
                } else if (object instanceof Long) {
                    jSONObject.put("t", (Object)"l");
                } else if (object instanceof Double) {
                    jSONObject.put("t", (Object)"d");
                } else {
                    this.zze.zzq().zze().zza("Cannot serialize bundle value to SharedPreferences. Type", object.getClass());
                    continue;
                }
                jSONArray.put((Object)jSONObject);
            }
            catch (JSONException jSONException) {
                this.zze.zzq().zze().zza("Cannot serialize bundle value to SharedPreferences", (Object)jSONException);
            }
        }
        return jSONArray.toString();
    }
}

