/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzlj;
import com.google.android.gms.internal.measurement.zzmb;
import com.google.android.gms.internal.measurement.zzmh;
import com.google.android.gms.internal.measurement.zzmn;
import com.google.android.gms.internal.measurement.zzmt;
import com.google.android.gms.internal.measurement.zzne;
import com.google.android.gms.internal.measurement.zznr;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzik;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzkb;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzkx;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzhe
extends zzg {
    @VisibleForTesting
    protected zzic zza;
    private zzhd zzc;
    private final Set<zzhc> zzd = new CopyOnWriteArraySet<zzhc>();
    private boolean zze;
    private final AtomicReference<String> zzf;
    private final Object zzg = new Object();
    @GuardedBy(value="consentLock")
    private zzad zzh;
    @GuardedBy(value="consentLock")
    private int zzi = 100;
    private final AtomicLong zzj;
    private long zzk = -1L;
    private int zzl = 100;
    final zzp zzb;
    @VisibleForTesting
    private boolean zzm = true;

    protected zzhe(zzgb zzgb2) {
        super(zzgb2);
        this.zzf = new AtomicReference();
        this.zzh = new zzad(null, null);
        this.zzj = new AtomicLong(0L);
        this.zzb = new zzp(zzgb2);
    }

    @Override
    protected final boolean zzy() {
        return false;
    }

    public final void zzaa() {
        if (((zzgu)this).zzm().getApplicationContext() instanceof Application) {
            ((Application)((zzgu)this).zzm().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zza);
        }
    }

    public final Boolean zzab() {
        AtomicReference atomicReference = new AtomicReference();
        return (Boolean)((zzgu)this).zzp().zza(atomicReference, 15000L, "boolean test flag value", new zzhj(this, atomicReference));
    }

    public final String zzac() {
        AtomicReference atomicReference = new AtomicReference();
        return (String)((zzgu)this).zzp().zza(atomicReference, 15000L, "String test flag value", new zzht(this, atomicReference));
    }

    public final Long zzad() {
        AtomicReference atomicReference = new AtomicReference();
        return (Long)((zzgu)this).zzp().zza(atomicReference, 15000L, "long test flag value", new zzhx(this, atomicReference));
    }

    public final Integer zzae() {
        AtomicReference atomicReference = new AtomicReference();
        return (Integer)((zzgu)this).zzp().zza(atomicReference, 15000L, "int test flag value", new zzhw(this, atomicReference));
    }

    public final Double zzaf() {
        AtomicReference atomicReference = new AtomicReference();
        return (Double)((zzgu)this).zzp().zza(atomicReference, 15000L, "double test flag value", new zzhz(this, atomicReference));
    }

    public final void zza(@Nullable Boolean bl) {
        this.zzv();
        ((zzgu)this).zzp().zza(new zzhy(this, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzad zzad2, int n, long l) {
        if (zzmb.zzb() && ((zzgu)this).zzs().zza(zzat.zzco)) {
            this.zzv();
            if (zzad2.zzb() == null && zzad2.zzd() == null) {
                ((zzgu)this).zzq().zzj().zza("Discarding empty consent settings");
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            Object object = this.zzg;
            synchronized (object) {
                if (zzad.zza(n, this.zzi)) {
                    bl = zzad2.zza(this.zzh);
                    bl2 = zzad2.zze() && !this.zzh.zze();
                    this.zzh = zzad2 = zzad2.zzc(this.zzh);
                    bl3 = true;
                }
            }
            if (!bl3) {
                ((zzgu)this).zzq().zzu().zza("Ignoring lower-priority consent settings, proposed settings", zzad2);
                return;
            }
            long l2 = this.zzj.getAndIncrement();
            boolean bl4 = bl2;
            zzad zzad3 = zzad2;
            if (bl) {
                this.zza((String)null);
                ((zzgu)this).zzp().zzb(new zzib(this, zzad3, l, n, l2, bl4));
                return;
            }
            ((zzgu)this).zzp().zza(new zzia(this, zzad3, n, l2, bl4));
        }
    }

    @WorkerThread
    final void zza(zzad zzad2) {
        ((zzgu)this).zzc();
        boolean bl = zzad2.zze() && zzad2.zzc() || ((zzd)this).zzg().zzai();
        if (bl != this.zzy.zzac()) {
            this.zzy.zzb(bl);
            Boolean bl2 = ((zzgu)this).zzr().zzv();
            if (!bl || bl2 == null || bl2.booleanValue()) {
                this.zza(bl, false);
            }
        }
    }

    @WorkerThread
    private final void zza(@Nullable Boolean bl, boolean bl2) {
        ((zzgu)this).zzc();
        this.zzv();
        ((zzgu)this).zzq().zzv().zza("Setting app measurement enabled (FE)", bl);
        ((zzgu)this).zzr().zza(bl);
        if (zzmb.zzb() && ((zzgu)this).zzs().zza(zzat.zzco) && bl2) {
            ((zzgu)this).zzr().zzb(bl);
        }
        if (!zzmb.zzb() || !((zzgu)this).zzs().zza(zzat.zzco) || this.zzy.zzac() || !bl.booleanValue()) {
            this.zzal();
        }
    }

    @WorkerThread
    private final void zza(zzad zzad2, int n, long l, boolean bl, boolean bl2) {
        ((zzgu)this).zzc();
        this.zzv();
        if (l <= this.zzk && zzad.zza(this.zzl, n)) {
            ((zzgu)this).zzq().zzu().zza("Dropped out-of-date consent setting, proposed settings", zzad2);
            return;
        }
        if (((zzgu)this).zzr().zza(zzad2, n)) {
            this.zzk = l;
            this.zzl = n;
            ((zzd)this).zzg().zza(bl);
            if (bl2) {
                ((zzd)this).zzg().zza(new AtomicReference<String>());
                return;
            }
        } else {
            ((zzgu)this).zzq().zzu().zza("Lower precedence consent source ignored, proposed source", n);
        }
    }

    @WorkerThread
    private final void zzal() {
        Object object = this;
        ((zzgu)object).zzc();
        String string = ((zzgu)object).zzr().zzn.zza();
        if (string != null) {
            if ("unset".equals(string)) {
                ((zzhe)object).zza("app", "_npa", null, ((zzgu)object).zzl().currentTimeMillis());
            } else {
                ((zzhe)object).zza("app", "_npa", (Object)("true".equals(string) ? 1L : 0L), ((zzgu)object).zzl().currentTimeMillis());
            }
        }
        if (this.zzy.zzaa() && this.zzm) {
            ((zzgu)this).zzq().zzv().zza("Recording app launch after enabling measurement for the first time (FE)");
            this.zzah();
            if (zzne.zzb() && ((zzgu)this).zzs().zza(zzat.zzbr)) {
                ((zzd)this).zzj().zza.zza();
            }
            if (zzmt.zzb() && ((zzgu)this).zzs().zza(zzat.zzbu) && !(this.zzy.zze().zza.zzb().zzi.zza() > 0L)) {
                object = this.zzy.zze();
                ((zzfo)object).zza(((zzfo)object).zza.zzm().getPackageName());
            }
            if (((zzgu)this).zzs().zza(zzat.zzck)) {
                ((zzgu)this).zzp().zza(new zzhi(this));
            }
            return;
        }
        ((zzgu)this).zzq().zzv().zza("Updating Scion state (FE)");
        ((zzd)this).zzg().zzab();
    }

    public final void zza(String string, String string2, Bundle bundle) {
        this.zza(string, string2, bundle, true, true, ((zzgu)this).zzl().currentTimeMillis());
    }

    @WorkerThread
    final void zzb(String string, String string2, Bundle bundle) {
        ((zzgu)this).zzc();
        this.zza(string, string2, ((zzgu)this).zzl().currentTimeMillis(), bundle);
    }

    @WorkerThread
    final void zza(String string, String string2, long l, Bundle bundle) {
        ((zzgu)this).zzc();
        boolean bl = this.zzc == null || zzkx.zzd(string2);
        this.zza(string, string2, l, bundle, true, bl, false, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    protected final void zza(String var1_1, String var2_2, long var3_3, Bundle var5_4, boolean var6_5, boolean var7_6, boolean var8_7, String var9_8) {
        block39: {
            block41: {
                block42: {
                    block40: {
                        Preconditions.checkNotEmpty((String)var1_1);
                        Preconditions.checkNotNull((Object)var5_4);
                        this.zzc();
                        this.zzv();
                        if (!this.zzy.zzaa()) {
                            this.zzq().zzv().zza("Event not sent since app measurement is disabled");
                            return;
                        }
                        var10_9 = this.zzf().zzag();
                        if (var10_9 != null && !var10_9.contains(var2_2)) {
                            this.zzq().zzv().zza("Dropping non-safelisted event. event name, origin", var2_2, var1_1);
                            return;
                        }
                        if (!this.zze) {
                            this.zze = true;
                            var32_10 = this;
                            try {
                                var33_11 = var32_10.zzy.zzs() == false ? Class.forName("com.google.android.gms.tagmanager.TagManagerService", true, var32_10.zzm().getClassLoader()) : Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                                var37_13 = var33_11;
                                var36_14 = var32_10;
                                try {
                                    var37_13.getDeclaredMethod("initialize", new Class[]{Context.class}).invoke(null, new Object[]{var36_14.zzm()});
                                }
                                catch (Exception var38_15) {
                                    var36_14.zzq().zzh().zza("Failed to invoke Tag Manager's initialize() method", var38_15);
                                }
                            }
                            catch (ClassNotFoundException v0) {
                                var32_10.zzq().zzu().zza("Tag Manager is not found and thus will not be used");
                            }
                        }
                        if (this.zzs().zza(zzat.zzbe) && "_cmp".equals(var2_2) && var5_4.containsKey("gclid")) {
                            this.zza("auto", "_lgclid", (Object)var5_4.getString("gclid"), this.zzl().currentTimeMillis());
                        }
                        if (zznr.zzb() && this.zzs().zza(zzat.zzcg) && var6_5 && zzkx.zzf(var2_2)) {
                            this.zzo().zza(var5_4, this.zzr().zzx.zza());
                        }
                        if (!var8_7 || "_iap".equals(var2_2)) break block39;
                        var34_16 = zzlj.zzb() != false && this.zzs().zza(zzat.zzcr) != false;
                        var33_11 = var2_2;
                        var32_10 = this.zzy.zzh();
                        if (var32_10.zza("event", (String)var33_11)) break block40;
                        v1 = 2;
                        break block41;
                    }
                    if (!var34_16) break block42;
                    if (var32_10.zza("event", zzgy.zza, zzgy.zzb, (String)var33_11)) ** GOTO lbl-1000
                    v1 = 13;
                    break block41;
                }
                if (!var32_10.zza("event", zzgy.zza, (String)var33_11)) {
                    v1 = 13;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = var11_20 = var32_10.zza("event", 40, (String)var33_11) == false ? 2 : 0;
                }
            }
            if (v1 != 0) {
                this.zzq().zzg().zza("Invalid public event name. Event will not be logged (FE)", this.zzn().zza(var2_2));
                this.zzy.zzh();
                var12_22 = zzkx.zza(var2_2, 40, true);
                var13_25 = var2_2 != null ? var2_2.length() : 0;
                this.zzy.zzh().zza(var11_20, "_ev", var12_22, var13_25);
                return;
            }
        }
        if ((var12_23 = this.zzh().zza(false)) != null && !var5_4.containsKey("_sc")) {
            var12_23.zzd = true;
        }
        var11_21 = var12_23;
        zzim.zza(var11_21, var5_4, var6_5 != false && var8_7 != false);
        var12_24 = "am".equals(var1_1);
        var13_26 = zzkx.zzd(var2_2);
        if (var6_5 && this.zzc != null && !var13_26 && !var12_24) {
            this.zzq().zzv().zza("Passing event to registered event handler (FE)", this.zzn().zza(var2_2), this.zzn().zza(var5_4));
            this.zzc.interceptEvent(var1_1, var2_2, var5_4, var3_3);
            return;
        }
        if (!this.zzy.zzaf()) {
            return;
        }
        var14_27 = this.zzo().zza(var2_2, zzlj.zzb() != false && this.zzs().zza(zzat.zzcr) != false);
        if (var14_27 != 0) {
            this.zzq().zzg().zza("Invalid event name. Event will not be logged (FE)", this.zzn().zza(var2_2));
            this.zzo();
            var15_28 = zzkx.zza(var2_2, 40, true);
            var16_30 = var2_2 != null ? var2_2.length() : 0;
            this.zzy.zzh().zza(var9_8, var14_27, "_ev", var15_28, var16_30);
            return;
        }
        var15_29 = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        var16_31 = this.zzo().zza(var9_8, var2_2, var5_4, var15_29, var8_7, true);
        var32_10 = var16_31;
        if (var16_31 == null || !var32_10.containsKey("_sc") || !var32_10.containsKey("_si")) {
            v2 = null;
        } else {
            var33_11 = var32_10.getString("_sn");
            var34_17 = var32_10.getString("_sc");
            var35_32 = var32_10.getLong("_si");
            v2 = var17_33 = new zzin((String)var33_11, var34_17, var35_32);
        }
        if (v2 == null) {
            var17_33 = var11_21;
        }
        if (this.zzs().zza(zzat.zzat) && this.zzh().zza(false) != null && "_ae".equals(var2_2) && (var18_34 = this.zzj().zzb.zzb()) > 0L) {
            this.zzo().zza(var16_31, var18_34);
        }
        if (zzmn.zzb() && this.zzs().zza(zzat.zzbq)) {
            if (!"auto".equals(var1_1) && "_ssr".equals(var2_2)) {
                var33_11 = var16_31;
                var32_10 = this.zzo();
                var34_18 /* !! */  = var33_11.getString("_ffr");
                var34_18 /* !! */  = Strings.isEmptyOrWhitespace((String)var34_18 /* !! */ ) != false ? null : var34_18 /* !! */ .trim();
                if (zzkx.zzc(var34_18 /* !! */ , var32_10.zzr().zzu.zza())) {
                    var32_10.zzq().zzv().zza("Not logging duplicate session_start_with_rollout event");
                    v3 = false;
                } else {
                    var32_10.zzr().zzu.zza(var34_18 /* !! */ );
                    v3 = true;
                }
                if (!v3) {
                    return;
                }
            } else if ("_ae".equals(var2_2)) {
                var33_11 = var16_31;
                var34_19 = this.zzo().zzr().zzu.zza();
                if (!TextUtils.isEmpty((CharSequence)var34_19)) {
                    var33_11.putString("_ffr", var34_19);
                }
            }
        }
        var18_35 = new ArrayList<Bundle>();
        var18_35.add(var16_31);
        var19_36 = this.zzo().zzg().nextLong();
        if (this.zzr().zzp.zza() > 0L && this.zzr().zza(var3_3) && this.zzr().zzr.zza()) {
            this.zzq().zzw().zza("Current session is expired, remove the session number, ID, and engagement time");
            this.zza("auto", "_sid", null, this.zzl().currentTimeMillis());
            this.zza("auto", "_sno", null, this.zzl().currentTimeMillis());
            this.zza("auto", "_se", null, this.zzl().currentTimeMillis());
        }
        if (var16_31.getLong("extend_session", 0L) == 1L) {
            this.zzq().zzw().zza("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
            var33_12 = var3_3;
            this.zzy.zzd().zza.zza(var33_12, true);
        }
        var21_37 = var16_31.keySet().toArray(new String[var16_31.size()]);
        Arrays.sort(var21_37);
        if (zzmh.zzb() && this.zzs().zza(zzat.zzca) && this.zzs().zza(zzat.zzbz)) {
            var22_38 = var21_37;
            var23_41 = var21_37.length;
            for (var24_44 = 0; var24_44 < var23_41; ++var24_44) {
                var25_45 = var22_38[var24_44];
                this.zzo();
                var26_48 = zzkx.zzb(var16_31.get((String)var25_45));
                if (var26_48 == null) continue;
                var16_31.putParcelableArray((String)var25_45, (Parcelable[])var26_48);
            }
        } else {
            var22_39 = 0;
            var23_42 = var21_37;
            var24_44 = var21_37.length;
            for (var25_46 = 0; var25_46 < var24_44; ++var25_46) {
                var26_48 = var23_42[var25_46];
                var27_49 /* !! */  = var16_31.get((String)var26_48);
                this.zzo();
                var28_50 = zzkx.zzb(var27_49 /* !! */ );
                if (var28_50 == null) continue;
                var16_31.putInt((String)var26_48, var28_50.length);
                for (var29_51 = 0; var29_51 < var28_50.length; ++var29_51) {
                    var30_54 = var28_50[var29_51];
                    zzim.zza(var17_33, var30_54, true);
                    var31_55 = this.zzo().zza(var9_8, "_ep", var30_54, var15_29, var8_7, false);
                    var31_55.putString("_en", var2_2);
                    var31_55.putLong("_eid", var19_36);
                    var31_55.putString("_gn", (String)var26_48);
                    var31_55.putInt("_ll", var28_50.length);
                    var31_55.putInt("_i", var29_51);
                    var18_35.add(var31_55);
                }
                var22_39 += var28_50.length;
            }
            if (var22_39 != 0) {
                var16_31.putLong("_eid", var19_36);
                var16_31.putInt("_epc", var22_39);
            }
        }
        for (var22_40 = 0; var22_40 < var18_35.size(); ++var22_40) {
            var23_43 = (Bundle)var18_35.get(var22_40);
            var25_47 = var22_40 != 0 != false ? "_ep" : var2_2;
            var23_43.putString("_o", var1_1);
            var26_48 = var7_6 != false ? this.zzo().zza(var23_43) : var23_43;
            var27_49 /* !! */  = new zzar(var25_47, new zzam(var26_48), var1_1, var3_3);
            this.zzg().zza((zzar)var27_49 /* !! */ , var9_8);
            if (var12_24) continue;
            for (zzhc var29_53 : this.zzd) {
                var30_54 = new Bundle(var26_48);
                var29_53.onEvent(var1_1, var2_2, var30_54, var3_3);
            }
        }
        if (this.zzh().zza(false) != null && "_ae".equals(var2_2)) {
            this.zzj().zza(true, true, this.zzl().elapsedRealtime());
        }
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        if (string == null) {
            string = "app";
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (((zzgu)this).zzs().zza(zzat.zzbw) && zzkx.zzc(string2, "screen_view")) {
            ((zzd)this).zzh().zza(bundle, l);
            return;
        }
        boolean bl3 = !bl2 || this.zzc == null || zzkx.zzd(string2);
        Object var18_8 = null;
        boolean bl4 = !bl;
        boolean bl5 = bl3;
        boolean bl6 = bl2;
        Bundle bundle2 = bundle;
        long l2 = l;
        String string3 = string2;
        String string4 = string;
        zzhe zzhe2 = this;
        Bundle bundle3 = zzkx.zzb(bundle2);
        ((zzgu)zzhe2).zzp().zza(new zzhn(zzhe2, string4, string3, l2, bundle3, bl6, bl5, bl4, null));
    }

    public final void zza(String string, String string2, Object object, boolean bl) {
        this.zza(string, string2, object, true, ((zzgu)this).zzl().currentTimeMillis());
    }

    public final void zza(String string, String string2, Object object, boolean bl, long l) {
        int n;
        int n2;
        if (string == null) {
            string = "app";
        }
        if (bl) {
            n2 = ((zzgu)this).zzo().zzb(string2);
        } else {
            String string3 = string2;
            zzkx zzkx2 = ((zzgu)this).zzo();
            n2 = !zzkx2.zza("user property", string3) ? 6 : (!zzkx2.zza("user property", zzha.zza, string3) ? 15 : (n = !zzkx2.zza("user property", 24, string3) ? 6 : 0));
        }
        if (n2 != 0) {
            ((zzgu)this).zzo();
            String string4 = zzkx.zza(string2, 24, true);
            int n3 = string2 != null ? string2.length() : 0;
            this.zzy.zzh().zza(n, "_ev", string4, n3);
            return;
        }
        if (object != null) {
            n = ((zzgu)this).zzo().zzb(string2, object);
            if (n != 0) {
                ((zzgu)this).zzo();
                String string5 = zzkx.zza(string2, 24, true);
                int n4 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n4 = String.valueOf(object).length();
                }
                this.zzy.zzh().zza(n, "_ev", string5, n4);
                return;
            }
            Object object2 = ((zzgu)this).zzo().zzc(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, (Object)null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzgu)this).zzp().zza(new zzhm(this, string, string2, object, l));
    }

    @WorkerThread
    final void zza(String string, String string2, Object object, long l) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ((zzgu)this).zzc();
        this.zzv();
        if ("allow_personalized_ads".equals(string2)) {
            if (object instanceof String && !TextUtils.isEmpty((CharSequence)((String)object))) {
                object = "false".equals(((String)object).toLowerCase(Locale.ENGLISH)) ? 1L : 0L;
                string2 = "_npa";
                ((zzgu)this).zzr().zzn.zza((Long)object == 1L ? "true" : "false");
            } else if (object == null) {
                string2 = "_npa";
                ((zzgu)this).zzr().zzn.zza("unset");
            }
        }
        if (!this.zzy.zzaa()) {
            ((zzgu)this).zzq().zzw().zza("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzy.zzaf()) {
            return;
        }
        zzkw zzkw2 = new zzkw(string2, l, object, string);
        ((zzd)this).zzg().zza(zzkw2);
    }

    public final List<zzkw> zza(boolean bl) {
        this.zzv();
        ((zzgu)this).zzq().zzw().zza("Getting user properties (FE)");
        if (((zzgu)this).zzp().zzf()) {
            ((zzgu)this).zzq().zze().zza("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        if (zzx.zza()) {
            ((zzgu)this).zzq().zze().zza("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        this.zzy.zzp().zza(atomicReference, 5000L, "get user properties", new zzhp(this, atomicReference, bl));
        List list = (List)atomicReference.get();
        if (list == null) {
            ((zzgu)this).zzq().zze().zza("Timed out waiting for get user properties, includeInternal", bl);
            return Collections.emptyList();
        }
        return list;
    }

    @Nullable
    public final String zzag() {
        return this.zzf.get();
    }

    final void zza(@Nullable String string) {
        this.zzf.set(string);
    }

    final void zza(long l, boolean bl) {
        boolean bl2;
        ((zzgu)this).zzc();
        this.zzv();
        ((zzgu)this).zzq().zzv().zza("Resetting analytics data (FE)");
        zzgu zzgu2 = ((zzd)this).zzj();
        zzgu2.zzc();
        ((zzkb)zzgu2).zzb.zza();
        boolean bl3 = bl2 = this.zzy.zzaa();
        long l2 = l;
        zzgu2 = ((zzgu)this).zzr();
        ((zzfj)zzgu2).zzh.zza(l2);
        if (!TextUtils.isEmpty((CharSequence)zzgu2.zzr().zzu.zza())) {
            ((zzfj)zzgu2).zzu.zza(null);
        }
        if (zzne.zzb() && zzgu2.zzs().zza(zzat.zzbr)) {
            ((zzfj)zzgu2).zzp.zza(0L);
        }
        if (!zzgu2.zzs().zzf()) {
            ((zzfj)zzgu2).zzb(!bl3);
        }
        ((zzfj)zzgu2).zzv.zza(null);
        ((zzfj)zzgu2).zzw.zza(0L);
        ((zzfj)zzgu2).zzx.zza(null);
        if (bl) {
            ((zzd)this).zzg().zzac();
        }
        if (zzne.zzb() && ((zzgu)this).zzs().zza(zzat.zzbr)) {
            ((zzd)this).zzj().zza.zza();
        }
        this.zzm = !bl2;
    }

    @WorkerThread
    public final void zzah() {
        zzy zzy2;
        Boolean bl;
        ((zzgu)this).zzc();
        this.zzv();
        if (!this.zzy.zzaf()) {
            return;
        }
        if (((zzgu)this).zzs().zza(zzat.zzbd) && (bl = (zzy2 = ((zzgu)this).zzs()).zzf("google_analytics_deferred_deep_link_enabled")) != null && bl != false) {
            ((zzgu)this).zzq().zzv().zza("Deferred Deep Link feature enabled.");
            ((zzgu)this).zzp().zza(new zzhg(this));
        }
        ((zzd)this).zzg().zzad();
        this.zzm = false;
        String string = ((zzgu)this).zzr().zzx();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            ((zzgu)this).zzk().zzaa();
            if (!string.equals(Build.VERSION.RELEASE)) {
                Bundle bundle = new Bundle();
                bundle.putString("_po", string);
                this.zza("auto", "_ou", bundle);
            }
        }
    }

    @WorkerThread
    public final void zza(zzhd zzhd2) {
        ((zzgu)this).zzc();
        this.zzv();
        if (zzhd2 != null && zzhd2 != this.zzc) {
            Preconditions.checkState((this.zzc == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzc = zzhd2;
    }

    public final void zza(zzhc zzhc2) {
        this.zzv();
        Preconditions.checkNotNull((Object)zzhc2);
        if (!this.zzd.add(zzhc2)) {
            ((zzgu)this).zzq().zzh().zza("OnEventListener already registered");
        }
    }

    public final void zzb(zzhc zzhc2) {
        this.zzv();
        Preconditions.checkNotNull((Object)zzhc2);
        if (!this.zzd.remove(zzhc2)) {
            ((zzgu)this).zzq().zzh().zza("OnEventListener had not been registered");
        }
    }

    public final void zza(Bundle bundle) {
        this.zza(bundle, ((zzgu)this).zzl().currentTimeMillis());
    }

    public final void zza(Bundle bundle, long l) {
        Preconditions.checkNotNull((Object)bundle);
        Bundle bundle2 = new Bundle(bundle);
        if (!TextUtils.isEmpty((CharSequence)bundle2.getString("app_id"))) {
            ((zzgu)this).zzq().zzh().zza("Package name should be null when calling setConditionalUserProperty");
        }
        bundle2.remove("app_id");
        this.zzb(bundle2, l);
    }

    public final void zzb(Bundle bundle) {
        Preconditions.checkNotNull((Object)bundle);
        Preconditions.checkNotEmpty((String)bundle.getString("app_id"));
        ((zzgu)this).zza();
        this.zzb(new Bundle(bundle), ((zzgu)this).zzl().currentTimeMillis());
    }

    private final void zzb(Bundle bundle, long l) {
        Preconditions.checkNotNull((Object)bundle);
        Bundle bundle2 = bundle;
        zzgz.zza((Bundle)bundle2, (String)"app_id", String.class, null);
        zzgz.zza((Bundle)bundle2, (String)"origin", String.class, null);
        zzgz.zza((Bundle)bundle2, (String)"name", String.class, null);
        zzgz.zza((Bundle)bundle2, (String)"value", Object.class, null);
        zzgz.zza((Bundle)bundle2, (String)"trigger_event_name", String.class, null);
        zzgz.zza((Bundle)bundle2, (String)"trigger_timeout", Long.class, (Object)0L);
        zzgz.zza((Bundle)bundle2, (String)"timed_out_event_name", String.class, null);
        zzgz.zza((Bundle)bundle2, (String)"timed_out_event_params", Bundle.class, null);
        zzgz.zza((Bundle)bundle2, (String)"triggered_event_name", String.class, null);
        zzgz.zza((Bundle)bundle2, (String)"triggered_event_params", Bundle.class, null);
        zzgz.zza((Bundle)bundle2, (String)"time_to_live", Long.class, (Object)0L);
        zzgz.zza((Bundle)bundle2, (String)"expired_event_name", String.class, null);
        zzgz.zza((Bundle)bundle2, (String)"expired_event_params", Bundle.class, null);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
        Preconditions.checkNotNull((Object)bundle.get("value"));
        bundle.putLong("creation_timestamp", l);
        String string = bundle.getString("name");
        Object object = bundle.get("value");
        if (((zzgu)this).zzo().zzb(string) != 0) {
            ((zzgu)this).zzq().zze().zza("Invalid conditional user property name", ((zzgu)this).zzn().zzc(string));
            return;
        }
        if (((zzgu)this).zzo().zzb(string, object) != 0) {
            ((zzgu)this).zzq().zze().zza("Invalid conditional user property value", ((zzgu)this).zzn().zzc(string), object);
            return;
        }
        Object object2 = ((zzgu)this).zzo().zzc(string, object);
        if (object2 == null) {
            ((zzgu)this).zzq().zze().zza("Unable to normalize conditional user property value", ((zzgu)this).zzn().zzc(string), object);
            return;
        }
        zzgz.zza((Bundle)bundle, (Object)object2);
        long l2 = bundle.getLong("trigger_timeout");
        if (!(TextUtils.isEmpty((CharSequence)bundle.getString("trigger_event_name")) || l2 <= 15552000000L && l2 >= 1L)) {
            ((zzgu)this).zzq().zze().zza("Invalid conditional user property timeout", ((zzgu)this).zzn().zzc(string), l2);
            return;
        }
        long l3 = bundle.getLong("time_to_live");
        if (l3 > 15552000000L || l3 < 1L) {
            ((zzgu)this).zzq().zze().zza("Invalid conditional user property time to live", ((zzgu)this).zzn().zzc(string), l3);
            return;
        }
        ((zzgu)this).zzp().zza(new zzhq(this, bundle));
    }

    public final void zzc(String string, String string2, Bundle bundle) {
        this.zzb(null, string, string2, bundle);
    }

    public final void zza(String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotEmpty((String)string);
        ((zzgu)this).zza();
        this.zzb(string, string2, string3, bundle);
    }

    private final void zzb(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzgu)this).zzl().currentTimeMillis();
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle2 = new Bundle();
        if (string != null) {
            bundle2.putString("app_id", string);
        }
        bundle2.putString("name", string2);
        bundle2.putLong("creation_timestamp", l);
        if (string3 != null) {
            bundle2.putString("expired_event_name", string3);
            bundle2.putBundle("expired_event_params", bundle);
        }
        ((zzgu)this).zzp().zza(new zzhs(this, bundle2));
    }

    @WorkerThread
    private final void zzc(Bundle bundle) {
        zzar zzar2;
        zzar zzar3;
        zzar zzar4;
        ((zzgu)this).zzc();
        this.zzv();
        Preconditions.checkNotNull((Object)bundle);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
        Preconditions.checkNotNull((Object)bundle.get("value"));
        if (!this.zzy.zzaa()) {
            ((zzgu)this).zzq().zzw().zza("Conditional property not set since app measurement is disabled");
            return;
        }
        zzkw zzkw2 = new zzkw(bundle.getString("name"), bundle.getLong("triggered_timestamp"), bundle.get("value"), bundle.getString("origin"));
        try {
            zzar4 = ((zzgu)this).zzo().zza(bundle.getString("app_id"), bundle.getString("triggered_event_name"), bundle.getBundle("triggered_event_params"), bundle.getString("origin"), 0L, true, false, zzlj.zzb() && ((zzgu)this).zzs().zza(zzat.zzcr));
            zzar3 = ((zzgu)this).zzo().zza(bundle.getString("app_id"), bundle.getString("timed_out_event_name"), bundle.getBundle("timed_out_event_params"), bundle.getString("origin"), 0L, true, false, zzlj.zzb() && ((zzgu)this).zzs().zza(zzat.zzcr));
            zzar2 = ((zzgu)this).zzo().zza(bundle.getString("app_id"), bundle.getString("expired_event_name"), bundle.getBundle("expired_event_params"), bundle.getString("origin"), 0L, true, false, zzlj.zzb() && ((zzgu)this).zzs().zza(zzat.zzcr));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzw zzw2 = new zzw(bundle.getString("app_id"), bundle.getString("origin"), zzkw2, bundle.getLong("creation_timestamp"), false, bundle.getString("trigger_event_name"), zzar3, bundle.getLong("trigger_timeout"), zzar4, bundle.getLong("time_to_live"), zzar2);
        ((zzd)this).zzg().zza(zzw2);
    }

    @WorkerThread
    private final void zzd(Bundle bundle) {
        zzar zzar2;
        ((zzgu)this).zzc();
        this.zzv();
        Preconditions.checkNotNull((Object)bundle);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        if (!this.zzy.zzaa()) {
            ((zzgu)this).zzq().zzw().zza("Conditional property not cleared since app measurement is disabled");
            return;
        }
        zzkw zzkw2 = new zzkw(bundle.getString("name"), 0L, null, null);
        try {
            zzar2 = ((zzgu)this).zzo().zza(bundle.getString("app_id"), bundle.getString("expired_event_name"), bundle.getBundle("expired_event_params"), bundle.getString("origin"), bundle.getLong("creation_timestamp"), true, false, zzlj.zzb() && ((zzgu)this).zzs().zza(zzat.zzcr));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzw zzw2 = new zzw(bundle.getString("app_id"), bundle.getString("origin"), zzkw2, bundle.getLong("creation_timestamp"), bundle.getBoolean("active"), bundle.getString("trigger_event_name"), null, bundle.getLong("trigger_timeout"), null, bundle.getLong("time_to_live"), zzar2);
        ((zzd)this).zzg().zza(zzw2);
    }

    public final ArrayList<Bundle> zza(String string, String string2) {
        return this.zzb(null, string, string2);
    }

    public final ArrayList<Bundle> zza(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        ((zzgu)this).zza();
        return this.zzb(string, string2, string3);
    }

    @VisibleForTesting
    private final ArrayList<Bundle> zzb(String string, String string2, String string3) {
        if (((zzgu)this).zzp().zzf()) {
            ((zzgu)this).zzq().zze().zza("Cannot get conditional user properties from analytics worker thread");
            return new ArrayList<Bundle>(0);
        }
        if (zzx.zza()) {
            ((zzgu)this).zzq().zze().zza("Cannot get conditional user properties from main thread");
            return new ArrayList<Bundle>(0);
        }
        AtomicReference atomicReference = new AtomicReference();
        this.zzy.zzp().zza(atomicReference, 5000L, "get conditional user properties", new zzhv(this, atomicReference, string, string2, string3));
        List list = (List)atomicReference.get();
        if (list == null) {
            ((zzgu)this).zzq().zze().zza("Timed out waiting for get conditional user properties", string);
            return new ArrayList<Bundle>();
        }
        return zzkx.zzb(list);
    }

    public final Map<String, Object> zza(String string, String string2, boolean bl) {
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> zza(String string, String string2, String string3, boolean bl) {
        Preconditions.checkNotEmpty((String)string);
        ((zzgu)this).zza();
        return this.zzb(string, string2, string3, bl);
    }

    @VisibleForTesting
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzgu)this).zzp().zzf()) {
            ((zzgu)this).zzq().zze().zza("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        if (zzx.zza()) {
            ((zzgu)this).zzq().zze().zza("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        this.zzy.zzp().zza(atomicReference, 5000L, "get user properties", new zzhu(this, atomicReference, string, string2, string3, bl));
        List list = (List)atomicReference.get();
        if (list == null) {
            ((zzgu)this).zzq().zze().zza("Timed out waiting for handle get user properties, includeInternal", bl);
            return Collections.emptyMap();
        }
        ArrayMap arrayMap = new ArrayMap(list.size());
        for (zzkw zzkw2 : list) {
            arrayMap.put(zzkw2.zza, zzkw2.zza());
        }
        return arrayMap;
    }

    @Nullable
    public final String zzai() {
        zzin zzin2 = this.zzy.zzu().zzaa();
        if (zzin2 != null) {
            return zzin2.zza;
        }
        return null;
    }

    @Nullable
    public final String zzaj() {
        zzin zzin2 = this.zzy.zzu().zzaa();
        if (zzin2 != null) {
            return zzin2.zzb;
        }
        return null;
    }

    @Nullable
    public final String zzak() {
        if (this.zzy.zzn() != null) {
            return this.zzy.zzn();
        }
        try {
            return zzik.zza((Context)((zzgu)this).zzm(), (String)"google_app_id");
        }
        catch (IllegalStateException illegalStateException) {
            this.zzy.zzq().zze().zza("getGoogleAppId failed with exception", illegalStateException);
            return null;
        }
    }

    static /* synthetic */ void zza(zzhe zzhe2, Boolean bl, boolean bl2) {
        zzhe2.zza(bl, true);
    }

    static /* synthetic */ void zza(zzhe zzhe2, zzad zzad2, int n, long l, boolean bl, boolean bl2) {
        zzhe2.zza(zzad2, n, l, bl, bl2);
    }

    static /* synthetic */ void zza(zzhe zzhe2) {
        zzhe2.zzal();
    }

    static /* synthetic */ void zza(zzhe zzhe2, Bundle bundle) {
        zzhe2.zzc(bundle);
    }

    static /* synthetic */ void zzb(zzhe zzhe2, Bundle bundle) {
        zzhe2.zzd(bundle);
    }
}

