/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zznf;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zzkx;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class zzim
extends zzg {
    private volatile zzin zzb;
    private zzin zzc;
    @VisibleForTesting
    protected zzin zza;
    private final Map<Activity, zzin> zzd;
    private Activity zze;
    private volatile boolean zzf;
    private volatile zzin zzg;
    private zzin zzh;
    private boolean zzi;
    private final Object zzj = new Object();
    private zzin zzk;
    private String zzl;

    public zzim(zzgb zzgb2) {
        super(zzgb2);
        this.zzd = new ConcurrentHashMap<Activity, zzin>();
    }

    @Override
    protected final boolean zzy() {
        return false;
    }

    @WorkerThread
    public final zzin zza(boolean bl) {
        this.zzv();
        ((zzgu)this).zzc();
        if (!((zzgu)this).zzs().zza(zzat.zzbw) || !bl) {
            return this.zza;
        }
        if (this.zza != null) {
            return this.zza;
        }
        return this.zzh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Bundle bundle, long l) {
        zzin zzin2;
        if (!((zzgu)this).zzs().zza(zzat.zzbw)) {
            ((zzgu)this).zzq().zzj().zza("Manual screen reporting is disabled.");
            return;
        }
        String string = null;
        String string2 = null;
        Object object = this.zzj;
        synchronized (object) {
            if (!this.zzi) {
                ((zzgu)this).zzq().zzj().zza("Cannot log screen view event when the app is in the background.");
                return;
            }
            if (bundle != null) {
                string = bundle.getString("screen_name");
                if (string != null && (string.length() <= 0 || string.length() > 100)) {
                    ((zzgu)this).zzq().zzj().zza("Invalid screen name length for screen view. Length", string.length());
                    return;
                }
                string2 = bundle.getString("screen_class");
                if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
                    ((zzgu)this).zzq().zzj().zza("Invalid screen class length for screen view. Length", string2.length());
                    return;
                }
            }
            if (string2 == null) {
                String string3 = string2 = this.zze != null ? zzim.zza(this.zze.getClass().getCanonicalName()) : "Activity";
            }
            if (this.zzf && this.zzb != null) {
                this.zzf = false;
                boolean bl = zzkx.zzc(this.zzb.zzb, string2);
                boolean bl2 = zzkx.zzc(this.zzb.zza, string);
                if (bl && bl2) {
                    ((zzgu)this).zzq().zzj().zza("Ignoring call to log screen view event with duplicate parameters.");
                    return;
                }
            }
        }
        ((zzgu)this).zzq().zzw().zza("Logging screen view with name, class", string == null ? "null" : string, string2 == null ? "null" : string2);
        object = this.zzb == null ? this.zzc : this.zzb;
        this.zzb = zzin2 = new zzin(string, string2, ((zzgu)this).zzo().zzf(), true, l);
        this.zzc = object;
        this.zzg = zzin2;
        long l2 = ((zzgu)this).zzl().elapsedRealtime();
        ((zzgu)this).zzp().zza(new zzip(this, bundle, zzin2, (zzin)object, l2));
    }

    @WorkerThread
    private final void zza(Bundle bundle, @NonNull zzin zzin2, zzin zzin3, long l) {
        if (bundle != null) {
            bundle.remove("screen_name");
            bundle.remove("screen_class");
        }
        Bundle bundle2 = ((zzgu)this).zzo().zza(null, "screen_view", bundle, null, true, true);
        this.zza(zzin2, zzin3, l, true, bundle2);
    }

    @Deprecated
    @MainThread
    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!((zzgu)this).zzs().zzh().booleanValue()) {
            ((zzgu)this).zzq().zzj().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
            return;
        }
        if (this.zzb == null) {
            ((zzgu)this).zzq().zzj().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzgu)this).zzq().zzj().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = zzim.zza(activity.getClass().getCanonicalName());
        }
        boolean bl = zzkx.zzc(this.zzb.zzb, string2);
        boolean bl2 = zzkx.zzc(this.zzb.zza, string);
        if (bl && bl2) {
            ((zzgu)this).zzq().zzj().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > 100)) {
            ((zzgu)this).zzq().zzj().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > 100)) {
            ((zzgu)this).zzq().zzj().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzgu)this).zzq().zzw().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzin zzin2 = new zzin(string, string2, ((zzgu)this).zzo().zzf());
        this.zzd.put(activity, zzin2);
        this.zza(activity, zzin2, true);
    }

    public final zzin zzaa() {
        return this.zzb;
    }

    @MainThread
    private final void zza(Activity activity, zzin zzin2, boolean bl) {
        zzin zzin3;
        zzin zzin4;
        zzin zzin5 = zzin4 = this.zzb == null ? this.zzc : this.zzb;
        if (zzin2.zzb == null) {
            zzin3 = activity != null ? zzim.zza(activity.getClass().getCanonicalName()) : null;
            zzin2 = new zzin(zzin2.zza, (String)((Object)zzin3), zzin2.zzc, zzin2.zze, zzin2.zzf);
        }
        zzin3 = zzin2;
        this.zzc = this.zzb;
        this.zzb = zzin3;
        long l = ((zzgu)this).zzl().elapsedRealtime();
        ((zzgu)this).zzp().zza(new zzio(this, zzin3, zzin4, l, bl));
    }

    @WorkerThread
    private final void zza(zzin zzin2, zzin zzin3, long l, boolean bl, Bundle bundle) {
        ((zzgu)this).zzc();
        boolean bl2 = false;
        if (((zzgu)this).zzs().zza(zzat.zzat)) {
            bl2 = bl && this.zza != null;
            if (bl2) {
                this.zza(this.zza, true, l);
            }
        } else if (bl && this.zza != null) {
            this.zza(this.zza, true, l);
        }
        if (zzin3 == null || zzin3.zzc != zzin2.zzc || !zzkx.zzc(zzin3.zzb, zzin2.zzb) || !zzkx.zzc(zzin3.zza, zzin2.zza)) {
            long l2;
            Bundle bundle2 = new Bundle();
            if (((zzgu)this).zzs().zza(zzat.zzbw)) {
                bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            }
            zzim.zza(zzin2, bundle2, true);
            if (zzin3 != null) {
                if (zzin3.zza != null) {
                    bundle2.putString("_pn", zzin3.zza);
                }
                if (zzin3.zzb != null) {
                    bundle2.putString("_pc", zzin3.zzb);
                }
                bundle2.putLong("_pi", zzin3.zzc);
            }
            if (((zzgu)this).zzs().zza(zzat.zzat) && bl2 && (l2 = zznf.zzb() && ((zzgu)this).zzs().zza(zzat.zzav) ? ((zzd)this).zzj().zza(l) : ((zzd)this).zzj().zzb.zzb()) > 0L) {
                ((zzgu)this).zzo().zza(bundle2, l2);
            }
            String string = "auto";
            if (((zzgu)this).zzs().zza(zzat.zzbw)) {
                if (!((zzgu)this).zzs().zzh().booleanValue()) {
                    bundle2.putLong("_mst", 1L);
                }
                String string2 = string = zzin2.zze ? "app" : "auto";
            }
            if (((zzgu)this).zzs().zza(zzat.zzbw)) {
                long l3 = ((zzgu)this).zzl().currentTimeMillis();
                if (zzin2.zze && zzin2.zzf != 0L) {
                    l3 = zzin2.zzf;
                }
                ((zzd)this).zze().zza(string, "_vs", l3, bundle2);
            } else {
                ((zzd)this).zze().zzb(string, "_vs", bundle2);
            }
        }
        this.zza = zzin2;
        if (((zzgu)this).zzs().zza(zzat.zzbw) && zzin2.zze) {
            this.zzh = zzin2;
        }
        ((zzd)this).zzg().zza(zzin2);
    }

    @WorkerThread
    private final void zza(zzin zzin2, boolean bl, long l) {
        boolean bl2;
        ((zzd)this).zzd().zza(((zzgu)this).zzl().elapsedRealtime());
        boolean bl3 = bl2 = zzin2 != null && zzin2.zzd;
        if (((zzd)this).zzj().zza(bl2, bl, l) && zzin2 != null) {
            zzin2.zzd = false;
        }
    }

    public static void zza(zzin zzin2, Bundle bundle, boolean bl) {
        if (bundle != null && zzin2 != null && (!bundle.containsKey("_sc") || bl)) {
            if (zzin2.zza != null) {
                bundle.putString("_sn", zzin2.zza);
            } else {
                bundle.remove("_sn");
            }
            if (zzin2.zzb != null) {
                bundle.putString("_sc", zzin2.zzb);
            } else {
                bundle.remove("_sc");
            }
            bundle.putLong("_si", zzin2.zzc);
            return;
        }
        if (bundle != null && zzin2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(String string, zzin zzin2) {
        ((zzgu)this).zzc();
        zzim zzim2 = this;
        synchronized (zzim2) {
            if (this.zzl == null || this.zzl.equals(string) || zzin2 != null) {
                this.zzl = string;
                this.zzk = zzin2;
            }
            return;
        }
    }

    @VisibleForTesting
    private static String zza(String string) {
        String[] stringArray = string.split("\\.");
        String string2 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string2.length() > 100) {
            return string2.substring(0, 100);
        }
        return string2;
    }

    @MainThread
    private final zzin zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzin zzin2 = this.zzd.get(activity);
        if (zzin2 == null) {
            String string = zzim.zza(activity.getClass().getCanonicalName());
            zzin2 = new zzin(null, string, ((zzgu)this).zzo().zzf());
            this.zzd.put(activity, zzin2);
        }
        if (!((zzgu)this).zzs().zza(zzat.zzbw)) {
            return zzin2;
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return zzin2;
    }

    @MainThread
    public final void zza(Activity activity, Bundle bundle) {
        if (!((zzgu)this).zzs().zzh().booleanValue()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzin zzin2 = new zzin(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzin2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(Activity activity) {
        zzd zzd2;
        Object object;
        if (((zzgu)this).zzs().zza(zzat.zzbw)) {
            object = this.zzj;
            synchronized (object) {
                this.zzi = true;
                if (activity != this.zze) {
                    Activity activity2 = activity;
                    zzd2 = this;
                    Object object2 = ((zzim)zzd2).zzj;
                    synchronized (object2) {
                        ((zzim)zzd2).zze = activity2;
                        ((zzim)zzd2).zzf = false;
                    }
                    if (zzd2.zzs().zza(zzat.zzbv) && zzd2.zzs().zzh().booleanValue()) {
                        ((zzim)zzd2).zzg = null;
                        zzd2.zzp().zza(new zzis((zzim)zzd2));
                    }
                }
            }
        }
        if (((zzgu)this).zzs().zza(zzat.zzbv) && !((zzgu)this).zzs().zzh().booleanValue()) {
            this.zzb = this.zzg;
            ((zzgu)this).zzp().zza(new zzir(this));
            return;
        }
        object = this.zzd(activity);
        this.zza(activity, (zzin)object, false);
        zzd2 = ((zzd)this).zzd();
        long l = zzd2.zzl().elapsedRealtime();
        zzd2.zzp().zza(new zze((zza)zzd2, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzb(Activity activity) {
        if (((zzgu)this).zzs().zza(zzat.zzbw)) {
            Object object = this.zzj;
            synchronized (object) {
                this.zzi = false;
                this.zzf = true;
            }
        }
        long l = ((zzgu)this).zzl().elapsedRealtime();
        if (((zzgu)this).zzs().zza(zzat.zzbv) && !((zzgu)this).zzs().zzh().booleanValue()) {
            this.zzb = null;
            ((zzgu)this).zzp().zza(new zziq(this, l));
            return;
        }
        zzin zzin2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzgu)this).zzp().zza(new zzit(this, zzin2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (!((zzgu)this).zzs().zzh().booleanValue()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzin zzin2 = this.zzd.get(activity);
        if (zzin2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzin2.zzc);
        bundle2.putString("name", zzin2.zza);
        bundle2.putString("referrer_name", zzin2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzc(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            if (activity == this.zze) {
                this.zze = null;
            }
        }
        if (!((zzgu)this).zzs().zzh().booleanValue()) {
            return;
        }
        this.zzd.remove(activity);
    }

    static /* synthetic */ void zza(zzim zzim2, Bundle bundle, zzin zzin2, zzin zzin3, long l) {
        zzim2.zza(bundle, zzin2, zzin3, l);
    }

    static /* synthetic */ void zza(zzim zzim2, zzin zzin2, zzin zzin3, long l, boolean bl, Bundle bundle) {
        zzim2.zza(zzin2, zzin3, l, bl, null);
    }

    static /* synthetic */ zzin zza(zzim zzim2) {
        return zzim2.zzh;
    }

    static /* synthetic */ void zza(zzim zzim2, zzin zzin2, boolean bl, long l) {
        zzim2.zza(zzin2, false, l);
    }

    static /* synthetic */ zzin zza(zzim zzim2, zzin zzin2) {
        zzim2.zzh = null;
        return null;
    }
}

