/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzlq;
import com.google.android.gms.internal.measurement.zzmj;
import com.google.android.gms.internal.measurement.zzmu;
import com.google.android.gms.internal.measurement.zzna;
import com.google.android.gms.internal.measurement.zznh;
import com.google.android.gms.internal.measurement.zzny;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzar;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzfd;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzp;
import com.google.android.gms.measurement.internal.zzw;
import com.google.android.gms.measurement.internal.zzx;
import com.google.android.gms.measurement.internal.zzy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzgy
extends zzg {
    @VisibleForTesting
    protected zzhz zza;
    private zzgx zzc;
    private final Set<zzgw> zzd = new CopyOnWriteArraySet<zzgw>();
    private boolean zze;
    private final AtomicReference<String> zzf;
    private final Object zzg = new Object();
    @GuardedBy(value="consentLock")
    private zzad zzh;
    @GuardedBy(value="consentLock")
    private int zzi = 100;
    private final AtomicLong zzj;
    private long zzk = -1L;
    private int zzl = 100;
    final zzp zzb;
    @VisibleForTesting
    private boolean zzm = true;
    private final zzkv zzn = new zzhr(this);

    protected zzgy(zzfv zzfv2) {
        super(zzfv2);
        this.zzf = new AtomicReference();
        this.zzh = new zzad(null, null);
        this.zzj = new AtomicLong(0L);
        this.zzb = new zzp(zzfv2);
    }

    @Override
    protected final boolean zzy() {
        return false;
    }

    public final void zzaa() {
        if (((zzgo)this).zzm().getApplicationContext() instanceof Application) {
            ((Application)((zzgo)this).zzm().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zza);
        }
    }

    public final Boolean zzab() {
        AtomicReference atomicReference = new AtomicReference();
        return (Boolean)((zzgo)this).zzp().zza(atomicReference, 15000L, "boolean test flag value", new zzhd(this, atomicReference));
    }

    public final String zzac() {
        AtomicReference atomicReference = new AtomicReference();
        return (String)((zzgo)this).zzp().zza(atomicReference, 15000L, "String test flag value", new zzhn(this, atomicReference));
    }

    public final Long zzad() {
        AtomicReference atomicReference = new AtomicReference();
        return (Long)((zzgo)this).zzp().zza(atomicReference, 15000L, "long test flag value", new zzhq(this, atomicReference));
    }

    public final Integer zzae() {
        AtomicReference atomicReference = new AtomicReference();
        return (Integer)((zzgo)this).zzp().zza(atomicReference, 15000L, "int test flag value", new zzht(this, atomicReference));
    }

    public final Double zzaf() {
        AtomicReference atomicReference = new AtomicReference();
        return (Double)((zzgo)this).zzp().zza(atomicReference, 15000L, "double test flag value", new zzhs(this, atomicReference));
    }

    public final void zza(@Nullable Boolean bl) {
        this.zzv();
        ((zzgo)this).zzp().zza(new zzhv(this, bl));
    }

    public final void zza(Bundle bundle, int n, long l) {
        if (zzmj.zzb() && ((zzgo)this).zzs().zza(zzat.zzcg)) {
            this.zzv();
            String string = zzad.zza(bundle);
            if (string != null) {
                ((zzgo)this).zzq().zzj().zza("Ignoring invalid consent setting", string);
                ((zzgo)this).zzq().zzj().zza("Valid consent values are 'granted', 'denied'");
            }
            this.zza(zzad.zzb(bundle), n, l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzad zzad2, int n, long l) {
        if (zzmj.zzb() && ((zzgo)this).zzs().zza(zzat.zzcg)) {
            this.zzv();
            if (zzad2.zzb() == null && zzad2.zzd() == null) {
                ((zzgo)this).zzq().zzj().zza("Discarding empty consent settings");
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            Object object = this.zzg;
            synchronized (object) {
                if (zzad.zza(n, this.zzi)) {
                    bl = zzad2.zza(this.zzh);
                    bl2 = zzad2.zze() && !this.zzh.zze();
                    this.zzh = zzad2 = zzad2.zzc(this.zzh);
                    bl3 = true;
                }
            }
            if (!bl3) {
                ((zzgo)this).zzq().zzu().zza("Ignoring lower-priority consent settings, proposed settings", zzad2);
                return;
            }
            long l2 = this.zzj.getAndIncrement();
            boolean bl4 = bl2;
            zzad zzad3 = zzad2;
            if (bl) {
                this.zza((String)null);
                ((zzgo)this).zzp().zzb(new zzhu(this, zzad3, l, n, l2, bl4));
                return;
            }
            ((zzgo)this).zzp().zza(new zzhx(this, zzad3, n, l2, bl4));
        }
    }

    @WorkerThread
    final void zza(zzad zzad2) {
        ((zzgo)this).zzc();
        boolean bl = zzad2.zze() && zzad2.zzc() || ((zzd)this).zzg().zzai();
        if (bl != this.zzy.zzac()) {
            this.zzy.zzb(bl);
            Boolean bl2 = ((zzgo)this).zzr().zzv();
            if (!bl || bl2 == null || bl2.booleanValue()) {
                this.zza(bl, false);
            }
        }
    }

    @WorkerThread
    private final void zza(@Nullable Boolean bl, boolean bl2) {
        ((zzgo)this).zzc();
        this.zzv();
        ((zzgo)this).zzq().zzv().zza("Setting app measurement enabled (FE)", bl);
        ((zzgo)this).zzr().zza(bl);
        if (zzmj.zzb() && ((zzgo)this).zzs().zza(zzat.zzcg) && bl2) {
            ((zzgo)this).zzr().zzb(bl);
        }
        if (!zzmj.zzb() || !((zzgo)this).zzs().zza(zzat.zzcg) || this.zzy.zzac() || !bl.booleanValue()) {
            this.zzal();
        }
    }

    @WorkerThread
    private final void zza(zzad zzad2, int n, long l, boolean bl, boolean bl2) {
        ((zzgo)this).zzc();
        this.zzv();
        if (l <= this.zzk && zzad.zza(this.zzl, n)) {
            ((zzgo)this).zzq().zzu().zza("Dropped out-of-date consent setting, proposed settings", zzad2);
            return;
        }
        if (((zzgo)this).zzr().zza(zzad2, n)) {
            this.zzk = l;
            this.zzl = n;
            ((zzd)this).zzg().zza(bl);
            if (bl2) {
                ((zzd)this).zzg().zza(new AtomicReference<String>());
                return;
            }
        } else {
            ((zzgo)this).zzq().zzu().zza("Lower precedence consent source ignored, proposed source", n);
        }
    }

    @WorkerThread
    private final void zzal() {
        Object object = this;
        ((zzgo)object).zzc();
        String string = ((zzgo)object).zzr().zzn.zza();
        if (string != null) {
            if ("unset".equals(string)) {
                ((zzgy)object).zza("app", "_npa", null, ((zzgo)object).zzl().currentTimeMillis());
            } else {
                ((zzgy)object).zza("app", "_npa", (Object)("true".equals(string) ? 1L : 0L), ((zzgo)object).zzl().currentTimeMillis());
            }
        }
        if (this.zzy.zzaa() && this.zzm) {
            ((zzgo)this).zzq().zzv().zza("Recording app launch after enabling measurement for the first time (FE)");
            this.zzah();
            if (zznh.zzb() && ((zzgo)this).zzs().zza(zzat.zzbp)) {
                ((zzd)this).zzj().zza.zza();
            }
            if (zzna.zzb() && ((zzgo)this).zzs().zza(zzat.zzbs) && !(this.zzy.zze().zza.zzb().zzi.zza() > 0L)) {
                object = this.zzy.zze();
                ((zzfi)object).zza(((zzfi)object).zza.zzm().getPackageName());
            }
            if (((zzgo)this).zzs().zza(zzat.zzcc)) {
                ((zzgo)this).zzp().zza(new zzhc(this));
            }
            return;
        }
        ((zzgo)this).zzq().zzv().zza("Updating Scion state (FE)");
        ((zzd)this).zzg().zzab();
    }

    public final void zza(String string, String string2, Bundle bundle) {
        this.zza(string, string2, bundle, true, true, ((zzgo)this).zzl().currentTimeMillis());
    }

    @WorkerThread
    final void zzb(String string, String string2, Bundle bundle) {
        ((zzgo)this).zzc();
        this.zza(string, string2, ((zzgo)this).zzl().currentTimeMillis(), bundle);
    }

    @WorkerThread
    final void zza(String string, String string2, long l, Bundle bundle) {
        ((zzgo)this).zzc();
        boolean bl = this.zzc == null || zzkw.zzd(string2);
        this.zza(string, string2, l, bundle, true, bl, false, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    protected final void zza(String var1_1, String var2_2, long var3_3, Bundle var5_4, boolean var6_5, boolean var7_6, boolean var8_7, String var9_8) {
        block33: {
            block35: {
                block36: {
                    block34: {
                        Preconditions.checkNotEmpty((String)var1_1);
                        Preconditions.checkNotNull((Object)var5_4);
                        this.zzc();
                        this.zzv();
                        if (!this.zzy.zzaa()) {
                            this.zzq().zzv().zza("Event not sent since app measurement is disabled");
                            return;
                        }
                        var10_9 = this.zzf().zzag();
                        if (var10_9 != null && !var10_9.contains(var2_2)) {
                            this.zzq().zzv().zza("Dropping non-safelisted event. event name, origin", var2_2, var1_1);
                            return;
                        }
                        if (!this.zze) {
                            this.zze = true;
                            var29_10 = this;
                            try {
                                var30_11 = var29_10.zzy.zzs() == false ? Class.forName("com.google.android.gms.tagmanager.TagManagerService", true, var29_10.zzm().getClassLoader()) : Class.forName("com.google.android.gms.tagmanager.TagManagerService");
                                var34_13 = var30_11;
                                var33_14 = var29_10;
                                try {
                                    var34_13.getDeclaredMethod("initialize", new Class[]{Context.class}).invoke(null, new Object[]{var33_14.zzm()});
                                }
                                catch (Exception var35_15) {
                                    var33_14.zzq().zzh().zza("Failed to invoke Tag Manager's initialize() method", var35_15);
                                }
                            }
                            catch (ClassNotFoundException v0) {
                                var29_10.zzq().zzu().zza("Tag Manager is not found and thus will not be used");
                            }
                        }
                        if (this.zzs().zza(zzat.zzbd) && "_cmp".equals(var2_2) && var5_4.containsKey("gclid")) {
                            this.zza("auto", "_lgclid", (Object)var5_4.getString("gclid"), this.zzl().currentTimeMillis());
                        }
                        if (zzny.zzb() && this.zzs().zza(zzat.zzby) && var6_5 && zzkw.zzf(var2_2)) {
                            this.zzo().zza(var5_4, this.zzr().zzx.zza());
                        }
                        if (!var8_7 || "_iap".equals(var2_2)) break block33;
                        var31_16 = zzlq.zzb() != false && this.zzs().zza(zzat.zzck) != false;
                        var30_11 = var2_2;
                        var29_10 = this.zzy.zzh();
                        if (var29_10.zza("event", (String)var30_11)) break block34;
                        v1 = 2;
                        break block35;
                    }
                    if (!var31_16) break block36;
                    if (var29_10.zza("event", zzgs.zza, zzgs.zzb, (String)var30_11)) ** GOTO lbl-1000
                    v1 = 13;
                    break block35;
                }
                if (!var29_10.zza("event", zzgs.zza, (String)var30_11)) {
                    v1 = 13;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = var11_20 = var29_10.zza("event", 40, (String)var30_11) == false ? 2 : 0;
                }
            }
            if (v1 != 0) {
                this.zzq().zzg().zza("Invalid public event name. Event will not be logged (FE)", this.zzn().zza(var2_2));
                this.zzy.zzh();
                var12_22 = zzkw.zza(var2_2, 40, true);
                var13_25 = var2_2 != null ? var2_2.length() : 0;
                this.zzy.zzh().zza(this.zzn, var11_20, "_ev", var12_22, var13_25);
                return;
            }
        }
        if ((var12_23 = this.zzh().zza(false)) != null && !var5_4.containsKey("_sc")) {
            var12_23.zzd = true;
        }
        var11_21 = var12_23;
        zzij.zza(var11_21, var5_4, var6_5 != false && var8_7 != false);
        var12_24 = "am".equals(var1_1);
        var13_26 = zzkw.zzd(var2_2);
        if (var6_5 && this.zzc != null && !var13_26 && !var12_24) {
            this.zzq().zzv().zza("Passing event to registered event handler (FE)", this.zzn().zza(var2_2), this.zzn().zza(var5_4));
            this.zzc.interceptEvent(var1_1, var2_2, var5_4, var3_3);
            return;
        }
        if (!this.zzy.zzaf()) {
            return;
        }
        var14_27 = this.zzo().zza(var2_2, zzlq.zzb() != false && this.zzs().zza(zzat.zzck) != false);
        if (var14_27 != 0) {
            this.zzq().zzg().zza("Invalid event name. Event will not be logged (FE)", this.zzn().zza(var2_2));
            this.zzo();
            var15_28 = zzkw.zza(var2_2, 40, true);
            var16_30 = var2_2 != null ? var2_2.length() : 0;
            this.zzy.zzh().zza(this.zzn, var9_8, var14_27, "_ev", var15_28, var16_30);
            return;
        }
        var15_29 = CollectionUtils.listOf((Object[])new String[]{"_o", "_sn", "_sc", "_si"});
        var16_31 = this.zzo().zza(var9_8, var2_2, var5_4, var15_29, var8_7, true);
        var29_10 = var16_31;
        if (var16_31 == null || !var29_10.containsKey("_sc") || !var29_10.containsKey("_si")) {
        } else {
            var30_11 = var29_10.getString("_sn");
            var31_17 = var29_10.getString("_sc");
            var32_32 = var29_10.getLong("_si");
            new zzig((String)var30_11, var31_17, var32_32);
        }
        if (this.zzs().zza(zzat.zzas) && this.zzh().zza(false) != null && "_ae".equals(var2_2) && (var17_33 = this.zzj().zzb.zzb()) > 0L) {
            this.zzo().zza(var16_31, var17_33);
        }
        if (zzmu.zzb() && this.zzs().zza(zzat.zzbo)) {
            if (!"auto".equals(var1_1) && "_ssr".equals(var2_2)) {
                var30_11 = var16_31;
                var29_10 = this.zzo();
                var31_18 /* !! */  = var30_11.getString("_ffr");
                var31_18 /* !! */  = Strings.isEmptyOrWhitespace((String)var31_18 /* !! */ ) != false ? null : var31_18 /* !! */ .trim();
                if (zzkw.zzc(var31_18 /* !! */ , var29_10.zzr().zzu.zza())) {
                    var29_10.zzq().zzv().zza("Not logging duplicate session_start_with_rollout event");
                    v2 = false;
                } else {
                    var29_10.zzr().zzu.zza(var31_18 /* !! */ );
                    v2 = true;
                }
                if (!v2) {
                    return;
                }
            } else if ("_ae".equals(var2_2)) {
                var30_11 = var16_31;
                var31_19 = this.zzo().zzr().zzu.zza();
                if (!TextUtils.isEmpty((CharSequence)var31_19)) {
                    var30_11.putString("_ffr", var31_19);
                }
            }
        }
        var17_34 = new ArrayList<Bundle>();
        var17_34.add(var16_31);
        this.zzo().zzg().nextLong();
        if (this.zzr().zzp.zza() > 0L && this.zzr().zza(var3_3) && this.zzr().zzr.zza()) {
            this.zzq().zzw().zza("Current session is expired, remove the session number, ID, and engagement time");
            this.zza("auto", "_sid", null, this.zzl().currentTimeMillis());
            this.zza("auto", "_sno", null, this.zzl().currentTimeMillis());
            this.zza("auto", "_se", null, this.zzl().currentTimeMillis());
        }
        if (var16_31.getLong("extend_session", 0L) == 1L) {
            this.zzq().zzw().zza("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
            var30_12 = var3_3;
            this.zzy.zzd().zza.zza(var30_12, true);
        }
        var19_35 = var16_31.keySet().toArray(new String[var16_31.size()]);
        Arrays.sort(var19_35);
        var20_36 = var19_35;
        var21_38 = var19_35.length;
        for (var22_40 = 0; var22_40 < var21_38; ++var22_40) {
            var23_41 = var20_36[var22_40];
            this.zzo();
            var24_42 = zzkw.zzb(var16_31.get((String)var23_41));
            if (var24_42 == null) continue;
            var16_31.putParcelableArray((String)var23_41, (Parcelable[])var24_42);
        }
        for (var20_37 = 0; var20_37 < var17_34.size(); ++var20_37) {
            var21_39 = (Bundle)var17_34.get(var20_37);
            var23_41 = var20_37 != 0 != false ? "_ep" : var2_2;
            var21_39.putString("_o", var1_1);
            var24_42 = var7_6 != false ? this.zzo().zza(var21_39) : var21_39;
            var25_43 = new zzar((String)var23_41, new zzam(var24_42), var1_1, var3_3);
            this.zzg().zza(var25_43, var9_8);
            if (var12_24) continue;
            for (zzgw var27_45 : this.zzd) {
                var28_46 = new Bundle(var24_42);
                var27_45.onEvent(var1_1, var2_2, var28_46, var3_3);
            }
        }
        if (this.zzh().zza(false) != null && "_ae".equals(var2_2)) {
            this.zzj().zza(true, true, this.zzl().elapsedRealtime());
        }
    }

    public final void zza(String string, String string2, Bundle bundle, String string3) {
        ((zzgo)this).zza();
        String string4 = string3;
        Bundle bundle2 = bundle;
        String string5 = string2;
        String string6 = string;
        zzgy zzgy2 = this;
        zzgy2.zzb(string6, string5, ((zzgo)zzgy2).zzl().currentTimeMillis(), bundle2, false, true, false, string4);
    }

    public final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        if (string == null) {
            string = "app";
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (((zzgo)this).zzs().zza(zzat.zzbu) && zzkw.zzc(string2, "screen_view")) {
            ((zzd)this).zzh().zza(bundle, l);
            return;
        }
        boolean bl3 = !bl2 || this.zzc == null || zzkw.zzd(string2);
        this.zzb(string, string2, l, bundle, bl2, bl3, !bl, null);
    }

    private final void zzb(String string, String string2, long l, Bundle bundle, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle2 = zzkw.zzb(bundle);
        ((zzgo)this).zzp().zza(new zzhh(this, string, string2, l, bundle2, bl, bl2, bl3, string3));
    }

    public final void zza(String string, String string2, Object object, boolean bl) {
        this.zza(string, string2, object, true, ((zzgo)this).zzl().currentTimeMillis());
    }

    public final void zza(String string, String string2, Object object, boolean bl, long l) {
        int n;
        int n2;
        if (string == null) {
            string = "app";
        }
        if (bl) {
            n2 = ((zzgo)this).zzo().zzb(string2);
        } else {
            String string3 = string2;
            zzkw zzkw2 = ((zzgo)this).zzo();
            n2 = !zzkw2.zza("user property", string3) ? 6 : (!zzkw2.zza("user property", zzgu.zza, string3) ? 15 : (n = !zzkw2.zza("user property", 24, string3) ? 6 : 0));
        }
        if (n2 != 0) {
            ((zzgo)this).zzo();
            String string4 = zzkw.zza(string2, 24, true);
            int n3 = string2 != null ? string2.length() : 0;
            this.zzy.zzh().zza(this.zzn, n, "_ev", string4, n3);
            return;
        }
        if (object != null) {
            n = ((zzgo)this).zzo().zzb(string2, object);
            if (n != 0) {
                ((zzgo)this).zzo();
                String string5 = zzkw.zza(string2, 24, true);
                int n4 = 0;
                if (object instanceof String || object instanceof CharSequence) {
                    n4 = String.valueOf(object).length();
                }
                this.zzy.zzh().zza(this.zzn, n, "_ev", string5, n4);
                return;
            }
            Object object2 = ((zzgo)this).zzo().zzc(string2, object);
            if (object2 != null) {
                this.zza(string, string2, l, object2);
            }
            return;
        }
        this.zza(string, string2, l, (Object)null);
    }

    private final void zza(String string, String string2, long l, Object object) {
        ((zzgo)this).zzp().zza(new zzhg(this, string, string2, object, l));
    }

    @WorkerThread
    final void zza(String string, String string2, Object object, long l) {
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ((zzgo)this).zzc();
        this.zzv();
        if ("allow_personalized_ads".equals(string2)) {
            if (object instanceof String && !TextUtils.isEmpty((CharSequence)((String)object))) {
                object = "false".equals(((String)object).toLowerCase(Locale.ENGLISH)) ? 1L : 0L;
                string2 = "_npa";
                ((zzgo)this).zzr().zzn.zza((Long)object == 1L ? "true" : "false");
            } else if (object == null) {
                string2 = "_npa";
                ((zzgo)this).zzr().zzn.zza("unset");
            }
        }
        if (!this.zzy.zzaa()) {
            ((zzgo)this).zzq().zzw().zza("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzy.zzaf()) {
            return;
        }
        zzkr zzkr2 = new zzkr(string2, l, object, string);
        ((zzd)this).zzg().zza(zzkr2);
    }

    public final List<zzkr> zza(boolean bl) {
        this.zzv();
        ((zzgo)this).zzq().zzw().zza("Getting user properties (FE)");
        if (((zzgo)this).zzp().zzf()) {
            ((zzgo)this).zzq().zze().zza("Cannot get all user properties from analytics worker thread");
            return Collections.emptyList();
        }
        if (zzx.zza()) {
            ((zzgo)this).zzq().zze().zza("Cannot get all user properties from main thread");
            return Collections.emptyList();
        }
        AtomicReference atomicReference = new AtomicReference();
        this.zzy.zzp().zza(atomicReference, 5000L, "get user properties", new zzhj(this, atomicReference, bl));
        List list = (List)atomicReference.get();
        if (list == null) {
            ((zzgo)this).zzq().zze().zza("Timed out waiting for get user properties, includeInternal", bl);
            return Collections.emptyList();
        }
        return list;
    }

    @Nullable
    public final String zzag() {
        return this.zzf.get();
    }

    final void zza(@Nullable String string) {
        this.zzf.set(string);
    }

    final void zza(long l, boolean bl) {
        boolean bl2;
        ((zzgo)this).zzc();
        this.zzv();
        ((zzgo)this).zzq().zzv().zza("Resetting analytics data (FE)");
        zzgo zzgo2 = ((zzd)this).zzj();
        zzgo2.zzc();
        ((zzju)zzgo2).zzb.zza();
        boolean bl3 = bl2 = this.zzy.zzaa();
        long l2 = l;
        zzgo2 = ((zzgo)this).zzr();
        ((zzfd)zzgo2).zzh.zza(l2);
        if (!TextUtils.isEmpty((CharSequence)zzgo2.zzr().zzu.zza())) {
            ((zzfd)zzgo2).zzu.zza(null);
        }
        if (zznh.zzb() && zzgo2.zzs().zza(zzat.zzbp)) {
            ((zzfd)zzgo2).zzp.zza(0L);
        }
        if (!zzgo2.zzs().zzf()) {
            ((zzfd)zzgo2).zzb(!bl3);
        }
        ((zzfd)zzgo2).zzv.zza(null);
        ((zzfd)zzgo2).zzw.zza(0L);
        ((zzfd)zzgo2).zzx.zza(null);
        if (bl) {
            ((zzd)this).zzg().zzac();
        }
        if (zznh.zzb() && ((zzgo)this).zzs().zza(zzat.zzbp)) {
            ((zzd)this).zzj().zza.zza();
        }
        this.zzm = !bl2;
    }

    @WorkerThread
    public final void zzah() {
        zzy zzy2;
        Boolean bl;
        ((zzgo)this).zzc();
        this.zzv();
        if (!this.zzy.zzaf()) {
            return;
        }
        if (((zzgo)this).zzs().zza(zzat.zzbc) && (bl = (zzy2 = ((zzgo)this).zzs()).zzf("google_analytics_deferred_deep_link_enabled")) != null && bl != false) {
            ((zzgo)this).zzq().zzv().zza("Deferred Deep Link feature enabled.");
            ((zzgo)this).zzp().zza(new zzha(this));
        }
        ((zzd)this).zzg().zzad();
        this.zzm = false;
        String string = ((zzgo)this).zzr().zzx();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            ((zzgo)this).zzk().zzaa();
            if (!string.equals(Build.VERSION.RELEASE)) {
                Bundle bundle = new Bundle();
                bundle.putString("_po", string);
                this.zza("auto", "_ou", bundle);
            }
        }
    }

    @WorkerThread
    public final void zza(zzgx zzgx2) {
        ((zzgo)this).zzc();
        this.zzv();
        if (zzgx2 != null && zzgx2 != this.zzc) {
            Preconditions.checkState((this.zzc == null ? 1 : 0) != 0, (Object)"EventInterceptor already set.");
        }
        this.zzc = zzgx2;
    }

    public final void zza(zzgw zzgw2) {
        this.zzv();
        Preconditions.checkNotNull((Object)zzgw2);
        if (!this.zzd.add(zzgw2)) {
            ((zzgo)this).zzq().zzh().zza("OnEventListener already registered");
        }
    }

    public final void zzb(zzgw zzgw2) {
        this.zzv();
        Preconditions.checkNotNull((Object)zzgw2);
        if (!this.zzd.remove(zzgw2)) {
            ((zzgo)this).zzq().zzh().zza("OnEventListener had not been registered");
        }
    }

    public final void zza(Bundle bundle) {
        this.zza(bundle, ((zzgo)this).zzl().currentTimeMillis());
    }

    public final void zza(Bundle bundle, long l) {
        Preconditions.checkNotNull((Object)bundle);
        Bundle bundle2 = new Bundle(bundle);
        if (!TextUtils.isEmpty((CharSequence)bundle2.getString("app_id"))) {
            ((zzgo)this).zzq().zzh().zza("Package name should be null when calling setConditionalUserProperty");
        }
        bundle2.remove("app_id");
        this.zzb(bundle2, l);
    }

    public final void zzb(Bundle bundle) {
        Preconditions.checkNotNull((Object)bundle);
        Preconditions.checkNotEmpty((String)bundle.getString("app_id"));
        ((zzgo)this).zza();
        this.zzb(new Bundle(bundle), ((zzgo)this).zzl().currentTimeMillis());
    }

    private final void zzb(Bundle bundle, long l) {
        Preconditions.checkNotNull((Object)bundle);
        Bundle bundle2 = bundle;
        zzgt.zza((Bundle)bundle2, (String)"app_id", String.class, null);
        zzgt.zza((Bundle)bundle2, (String)"origin", String.class, null);
        zzgt.zza((Bundle)bundle2, (String)"name", String.class, null);
        zzgt.zza((Bundle)bundle2, (String)"value", Object.class, null);
        zzgt.zza((Bundle)bundle2, (String)"trigger_event_name", String.class, null);
        zzgt.zza((Bundle)bundle2, (String)"trigger_timeout", Long.class, (Object)0L);
        zzgt.zza((Bundle)bundle2, (String)"timed_out_event_name", String.class, null);
        zzgt.zza((Bundle)bundle2, (String)"timed_out_event_params", Bundle.class, null);
        zzgt.zza((Bundle)bundle2, (String)"triggered_event_name", String.class, null);
        zzgt.zza((Bundle)bundle2, (String)"triggered_event_params", Bundle.class, null);
        zzgt.zza((Bundle)bundle2, (String)"time_to_live", Long.class, (Object)0L);
        zzgt.zza((Bundle)bundle2, (String)"expired_event_name", String.class, null);
        zzgt.zza((Bundle)bundle2, (String)"expired_event_params", Bundle.class, null);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
        Preconditions.checkNotNull((Object)bundle.get("value"));
        bundle.putLong("creation_timestamp", l);
        String string = bundle.getString("name");
        Object object = bundle.get("value");
        if (((zzgo)this).zzo().zzb(string) != 0) {
            ((zzgo)this).zzq().zze().zza("Invalid conditional user property name", ((zzgo)this).zzn().zzc(string));
            return;
        }
        if (((zzgo)this).zzo().zzb(string, object) != 0) {
            ((zzgo)this).zzq().zze().zza("Invalid conditional user property value", ((zzgo)this).zzn().zzc(string), object);
            return;
        }
        Object object2 = ((zzgo)this).zzo().zzc(string, object);
        if (object2 == null) {
            ((zzgo)this).zzq().zze().zza("Unable to normalize conditional user property value", ((zzgo)this).zzn().zzc(string), object);
            return;
        }
        zzgt.zza((Bundle)bundle, (Object)object2);
        long l2 = bundle.getLong("trigger_timeout");
        if (!(TextUtils.isEmpty((CharSequence)bundle.getString("trigger_event_name")) || l2 <= 15552000000L && l2 >= 1L)) {
            ((zzgo)this).zzq().zze().zza("Invalid conditional user property timeout", ((zzgo)this).zzn().zzc(string), l2);
            return;
        }
        long l3 = bundle.getLong("time_to_live");
        if (l3 > 15552000000L || l3 < 1L) {
            ((zzgo)this).zzq().zze().zza("Invalid conditional user property time to live", ((zzgo)this).zzn().zzc(string), l3);
            return;
        }
        ((zzgo)this).zzp().zza(new zzhk(this, bundle));
    }

    public final void zzc(String string, String string2, Bundle bundle) {
        this.zzb(null, string, string2, bundle);
    }

    public final void zza(String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotEmpty((String)string);
        ((zzgo)this).zza();
        this.zzb(string, string2, string3, bundle);
    }

    private final void zzb(String string, String string2, String string3, Bundle bundle) {
        long l = ((zzgo)this).zzl().currentTimeMillis();
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle2 = new Bundle();
        if (string != null) {
            bundle2.putString("app_id", string);
        }
        bundle2.putString("name", string2);
        bundle2.putLong("creation_timestamp", l);
        if (string3 != null) {
            bundle2.putString("expired_event_name", string3);
            bundle2.putBundle("expired_event_params", bundle);
        }
        ((zzgo)this).zzp().zza(new zzhm(this, bundle2));
    }

    @WorkerThread
    private final void zzd(Bundle bundle) {
        zzar zzar2;
        zzar zzar3;
        zzar zzar4;
        ((zzgo)this).zzc();
        this.zzv();
        Preconditions.checkNotNull((Object)bundle);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
        Preconditions.checkNotNull((Object)bundle.get("value"));
        if (!this.zzy.zzaa()) {
            ((zzgo)this).zzq().zzw().zza("Conditional property not set since app measurement is disabled");
            return;
        }
        zzkr zzkr2 = new zzkr(bundle.getString("name"), bundle.getLong("triggered_timestamp"), bundle.get("value"), bundle.getString("origin"));
        try {
            zzar4 = ((zzgo)this).zzo().zza(bundle.getString("app_id"), bundle.getString("triggered_event_name"), bundle.getBundle("triggered_event_params"), bundle.getString("origin"), 0L, true, false, zzlq.zzb() && ((zzgo)this).zzs().zza(zzat.zzck));
            zzar3 = ((zzgo)this).zzo().zza(bundle.getString("app_id"), bundle.getString("timed_out_event_name"), bundle.getBundle("timed_out_event_params"), bundle.getString("origin"), 0L, true, false, zzlq.zzb() && ((zzgo)this).zzs().zza(zzat.zzck));
            zzar2 = ((zzgo)this).zzo().zza(bundle.getString("app_id"), bundle.getString("expired_event_name"), bundle.getBundle("expired_event_params"), bundle.getString("origin"), 0L, true, false, zzlq.zzb() && ((zzgo)this).zzs().zza(zzat.zzck));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzw zzw2 = new zzw(bundle.getString("app_id"), bundle.getString("origin"), zzkr2, bundle.getLong("creation_timestamp"), false, bundle.getString("trigger_event_name"), zzar3, bundle.getLong("trigger_timeout"), zzar4, bundle.getLong("time_to_live"), zzar2);
        ((zzd)this).zzg().zza(zzw2);
    }

    @WorkerThread
    private final void zze(Bundle bundle) {
        zzar zzar2;
        ((zzgo)this).zzc();
        this.zzv();
        Preconditions.checkNotNull((Object)bundle);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        if (!this.zzy.zzaa()) {
            ((zzgo)this).zzq().zzw().zza("Conditional property not cleared since app measurement is disabled");
            return;
        }
        zzkr zzkr2 = new zzkr(bundle.getString("name"), 0L, null, null);
        try {
            zzar2 = ((zzgo)this).zzo().zza(bundle.getString("app_id"), bundle.getString("expired_event_name"), bundle.getBundle("expired_event_params"), bundle.getString("origin"), bundle.getLong("creation_timestamp"), true, false, zzlq.zzb() && ((zzgo)this).zzs().zza(zzat.zzck));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
        zzw zzw2 = new zzw(bundle.getString("app_id"), bundle.getString("origin"), zzkr2, bundle.getLong("creation_timestamp"), bundle.getBoolean("active"), bundle.getString("trigger_event_name"), null, bundle.getLong("trigger_timeout"), null, bundle.getLong("time_to_live"), zzar2);
        ((zzd)this).zzg().zza(zzw2);
    }

    public final ArrayList<Bundle> zza(String string, String string2) {
        return this.zzb(null, string, string2);
    }

    public final ArrayList<Bundle> zza(String string, String string2, String string3) {
        Preconditions.checkNotEmpty((String)string);
        ((zzgo)this).zza();
        return this.zzb(string, string2, string3);
    }

    @VisibleForTesting
    private final ArrayList<Bundle> zzb(String string, String string2, String string3) {
        if (((zzgo)this).zzp().zzf()) {
            ((zzgo)this).zzq().zze().zza("Cannot get conditional user properties from analytics worker thread");
            return new ArrayList<Bundle>(0);
        }
        if (zzx.zza()) {
            ((zzgo)this).zzq().zze().zza("Cannot get conditional user properties from main thread");
            return new ArrayList<Bundle>(0);
        }
        AtomicReference atomicReference = new AtomicReference();
        this.zzy.zzp().zza(atomicReference, 5000L, "get conditional user properties", new zzhp(this, atomicReference, string, string2, string3));
        List list = (List)atomicReference.get();
        if (list == null) {
            ((zzgo)this).zzq().zze().zza("Timed out waiting for get conditional user properties", string);
            return new ArrayList<Bundle>();
        }
        return zzkw.zzb(list);
    }

    public final Map<String, Object> zza(String string, String string2, boolean bl) {
        return this.zzb(null, string, string2, bl);
    }

    public final Map<String, Object> zza(String string, String string2, String string3, boolean bl) {
        Preconditions.checkNotEmpty((String)string);
        ((zzgo)this).zza();
        return this.zzb(string, string2, string3, bl);
    }

    @VisibleForTesting
    private final Map<String, Object> zzb(String string, String string2, String string3, boolean bl) {
        if (((zzgo)this).zzp().zzf()) {
            ((zzgo)this).zzq().zze().zza("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        if (zzx.zza()) {
            ((zzgo)this).zzq().zze().zza("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        this.zzy.zzp().zza(atomicReference, 5000L, "get user properties", new zzho(this, atomicReference, string, string2, string3, bl));
        List list = (List)atomicReference.get();
        if (list == null) {
            ((zzgo)this).zzq().zze().zza("Timed out waiting for handle get user properties, includeInternal", bl);
            return Collections.emptyMap();
        }
        ArrayMap arrayMap = new ArrayMap(list.size());
        for (zzkr zzkr2 : list) {
            arrayMap.put(zzkr2.zza, zzkr2.zza());
        }
        return arrayMap;
    }

    @Nullable
    public final String zzai() {
        zzig zzig2 = this.zzy.zzu().zzaa();
        if (zzig2 != null) {
            return zzig2.zza;
        }
        return null;
    }

    @Nullable
    public final String zzaj() {
        zzig zzig2 = this.zzy.zzu().zzaa();
        if (zzig2 != null) {
            return zzig2.zzb;
        }
        return null;
    }

    @Nullable
    public final String zzak() {
        if (this.zzy.zzn() != null) {
            return this.zzy.zzn();
        }
        try {
            return zzih.zza((Context)((zzgo)this).zzm(), (String)"google_app_id");
        }
        catch (IllegalStateException illegalStateException) {
            this.zzy.zzq().zze().zza("getGoogleAppId failed with exception", illegalStateException);
            return null;
        }
    }

    final /* synthetic */ void zzc(Bundle bundle) {
        if (!zzny.zzb() || !((zzgo)this).zzs().zza(zzat.zzby)) {
            return;
        }
        if (bundle == null) {
            ((zzgo)this).zzr().zzx.zza(new Bundle());
            return;
        }
        Bundle bundle2 = ((zzgo)this).zzr().zzx.zza();
        for (String string : bundle.keySet()) {
            Object object = bundle.get(string);
            if (!(object == null || object instanceof String || object instanceof Long || object instanceof Double)) {
                ((zzgo)this).zzo();
                if (zzkw.zza(object)) {
                    ((zzgo)this).zzo().zza(this.zzn, 27, null, null, 0);
                }
                ((zzgo)this).zzq().zzj().zza("Invalid default event parameter type. Name, value", string, object);
                continue;
            }
            if (zzkw.zzd(string)) {
                ((zzgo)this).zzq().zzj().zza("Invalid default event parameter name. Name", string);
                continue;
            }
            if (object == null) {
                bundle2.remove(string);
                continue;
            }
            if (!((zzgo)this).zzo().zza("param", string, 100, object)) continue;
            ((zzgo)this).zzo().zza(bundle2, string, object);
        }
        ((zzgo)this).zzo();
        if (zzkw.zza(bundle2, ((zzgo)this).zzs().zzd())) {
            ((zzgo)this).zzo().zza(this.zzn, 26, null, null, 0);
            ((zzgo)this).zzq().zzj().zza("Too many default event parameters set. Discarding beyond event parameter limit");
        }
        ((zzgo)this).zzr().zzx.zza(bundle2);
        ((zzd)this).zzg().zza(bundle2);
    }

    static /* synthetic */ void zza(zzgy zzgy2, Boolean bl, boolean bl2) {
        zzgy2.zza(bl, true);
    }

    static /* synthetic */ void zza(zzgy zzgy2, zzad zzad2, int n, long l, boolean bl, boolean bl2) {
        zzgy2.zza(zzad2, n, l, bl, bl2);
    }

    static /* synthetic */ void zza(zzgy zzgy2) {
        zzgy2.zzal();
    }

    static /* synthetic */ void zza(zzgy zzgy2, Bundle bundle) {
        zzgy2.zzd(bundle);
    }

    static /* synthetic */ void zzb(zzgy zzgy2, Bundle bundle) {
        zzgy2.zze(bundle);
    }
}

