/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzel;
import com.google.android.gms.measurement.internal.zzeo;
import com.google.android.gms.measurement.internal.zzer;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzjm;
import com.google.android.gms.measurement.internal.zzjn;
import com.google.android.gms.measurement.internal.zzjp;

@VisibleForTesting
public final class zzji
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzeo zzc;
    final /* synthetic */ zzio zza;

    protected zzji(zzio zzio2) {
        this.zza = zzio2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzgo)this.zza).zzc();
        Context context = ((zzgo)this.zza).zzm();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzji zzji2 = this;
        synchronized (zzji2) {
            if (this.zzb) {
                ((zzgo)this.zza).zzq().zzw().zza("Connection attempt already in progress");
                return;
            }
            ((zzgo)this.zza).zzq().zzw().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzio.zza(this.zza), 129);
            return;
        }
    }

    @WorkerThread
    public final void zza() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzji zzji2 = this;
        synchronized (zzji2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzgo)this.zza).zzq().zze().zza("Service connected with null binder");
                return;
            }
            zzej zzej2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzej2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzej ? (zzej)iInterface : new zzel(iBinder2));
                    ((zzgo)this.zza).zzq().zzw().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzgo)this.zza).zzq().zze().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzgo)this.zza).zzq().zze().zza("Service connect failed to get IMeasurementService");
            }
            if (zzej2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzgo)this.zza).zzm(), (ServiceConnection)zzio.zza(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzej2;
                ((zzgo)this.zza).zzp().zza(new zzjl(this, (zzej)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzgo)this.zza).zzq().zzv().zza("Service disconnected");
        ((zzgo)this.zza).zzp().zza(new zzjk(this, componentName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zzb() {
        ((zzgo)this.zza).zzc();
        Context context = ((zzgo)this.zza).zzm();
        zzji zzji2 = this;
        synchronized (zzji2) {
            if (this.zzb) {
                ((zzgo)this.zza).zzq().zzw().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzgo)this.zza).zzq().zzw().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzeo(context, Looper.getMainLooper(), this, this);
            ((zzgo)this.zza).zzq().zzw().zza("Connecting to remote service");
            this.zzb = true;
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzji zzji2 = this;
        synchronized (zzji2) {
            try {
                zzej zzej2 = (zzej)this.zzc.getService();
                ((zzgo)this.zza).zzp().zza(new zzjn(this, zzej2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzgo)this.zza).zzq().zzv().zza("Service connection suspended");
        ((zzgo)this.zza).zzp().zza(new zzjm(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzer zzer2 = this.zza.zzy.zzc();
        if (zzer2 != null) {
            zzer2.zzh().zza("Service connection failed", connectionResult);
        }
        zzji zzji2 = this;
        synchronized (zzji2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzgo)this.zza).zzp().zza(new zzjp(this));
    }

    static /* synthetic */ boolean zza(zzji zzji2, boolean bl) {
        zzji2.zzb = false;
        return false;
    }
}

