/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzmg;
import com.google.android.gms.internal.measurement.zzml;
import com.google.android.gms.internal.measurement.zznv;
import com.google.android.gms.internal.measurement.zzoh;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzej;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzkv;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;

public final class zzab
extends zzgr {
    private Boolean zza;
    @NonNull
    private zzad zzb = zzaa.zza;
    private Boolean zzc;

    zzab(zzfu zzfu2) {
        super(zzfu2);
    }

    final void zza(@NonNull zzad zzad2) {
        this.zzb = zzad2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final int zzd() {
        if (!zzmg.zzb()) return 25;
        zzej<Boolean> zzej2 = zzas.zzbw;
        if (!((zzgr)this).zzs().zzd(null, zzej2)) return 25;
        zzkv zzkv2 = ((zzgr)this).zzo();
        Boolean bl = zzkv2.zzy.zzv().zzaf();
        if (zzkv2.zzi() >= 201500) return 100;
        if (bl == null) return 25;
        if (bl != false) return 25;
        return 100;
    }

    public final int zza(@Size(min=1L) String string) {
        return this.zza(string, zzas.zzah, 25, 100);
    }

    final int zzb(@Size(min=1L) String string) {
        zzej<Boolean> zzej2;
        if (zzmg.zzb() && this.zzd(null, zzej2 = zzas.zzbv)) {
            return this.zza(string, zzas.zzag, 500, 2000);
        }
        return 500;
    }

    @WorkerThread
    public final int zzc(@Size(min=1L) String string) {
        return this.zzb(string, zzas.zzn);
    }

    final int zzd(@Size(min=1L) String string) {
        zzej<Boolean> zzej2;
        if (zzmg.zzb() && this.zzd(null, zzej2 = zzas.zzbv)) {
            return this.zza(string, zzas.zzaf, 25, 100);
        }
        return 25;
    }

    @WorkerThread
    final long zze(String string) {
        return this.zza(string, zzas.zza);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean zze() {
        if (this.zzc == null) {
            zzab zzab2 = this;
            synchronized (zzab2) {
                if (this.zzc == null) {
                    ApplicationInfo applicationInfo = ((zzgr)this).zzm().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzc = string2 != null && string2.equals(string);
                    }
                    if (this.zzc == null) {
                        this.zzc = Boolean.TRUE;
                        ((zzgr)this).zzq().zze().zza("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzc;
    }

    @WorkerThread
    public final long zza(String string, @NonNull zzej<Long> zzej2) {
        if (string == null) {
            return zzej2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzej2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzej2.zza(null);
        }
        try {
            long l = Long.parseLong(string2);
            return zzej2.zza(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzej2.zza(null);
        }
    }

    @WorkerThread
    public final int zzb(String string, @NonNull zzej<Integer> zzej2) {
        if (string == null) {
            return zzej2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzej2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzej2.zza(null);
        }
        try {
            int n = Integer.parseInt(string2);
            return zzej2.zza(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzej2.zza(null);
        }
    }

    @WorkerThread
    private final int zza(String string, @NonNull zzej<Integer> zzej2, int n, int n2) {
        return Math.max(Math.min(this.zzb(string, zzej2), n2), n);
    }

    @WorkerThread
    public final double zzc(String string, @NonNull zzej<Double> zzej2) {
        if (string == null) {
            return zzej2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzej2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzej2.zza(null);
        }
        try {
            double d = Double.parseDouble(string2);
            return zzej2.zza(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zzej2.zza(null);
        }
    }

    @WorkerThread
    public final boolean zzd(String string, @NonNull zzej<Boolean> zzej2) {
        if (string == null) {
            return zzej2.zza(null);
        }
        String string2 = this.zzb.zza(string, zzej2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzej2.zza(null);
        }
        boolean bl = Boolean.parseBoolean(string2);
        return zzej2.zza(bl);
    }

    public final boolean zze(String string, zzej<Boolean> zzej2) {
        return this.zzd(string, zzej2);
    }

    public final boolean zza(zzej<Boolean> zzej2) {
        zzej<Boolean> zzej3 = zzej2;
        return this.zzd(null, zzej3);
    }

    @Nullable
    @VisibleForTesting
    private final Bundle zzz() {
        try {
            if (((zzgr)this).zzm().getPackageManager() == null) {
                ((zzgr)this).zzq().zze().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzgr)this).zzm()).getApplicationInfo(((zzgr)this).zzm().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzgr)this).zzq().zze().zza("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            return applicationInfo.metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzgr)this).zzq().zze().zza("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    final Boolean zzf(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzz();
        if (bundle == null) {
            ((zzgr)this).zzq().zze().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    @Nullable
    @VisibleForTesting
    final List<String> zzg(@Size(min=1L) String string) {
        Integer n;
        Integer n2;
        String string2 = string;
        zzab zzab2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzab2.zzz();
        if (bundle == null) {
            ((zzgr)zzab2).zzq().zze().zza("Failed to load metadata: Metadata bundle is null");
            n2 = null;
        } else {
            n2 = n = !bundle.containsKey(string2) ? null : Integer.valueOf(bundle.getInt(string2));
        }
        if (n2 == null) {
            return null;
        }
        try {
            String[] stringArray = ((zzgr)this).zzm().getResources().getStringArray(n.intValue());
            if (stringArray == null) {
                return null;
            }
            return Arrays.asList(stringArray);
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzgr)this).zzq().zze().zza("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    public final boolean zzf() {
        Boolean bl = this.zzf("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final Boolean zzg() {
        Boolean bl = this.zzf("google_analytics_adid_collection_enabled");
        return bl == null || bl != false;
    }

    public final Boolean zzh() {
        if (!zzoh.zzb() || !this.zza(zzas.zzbt)) {
            return true;
        }
        Boolean bl = this.zzf("google_analytics_automatic_screen_reporting_enabled");
        return bl == null || bl != false;
    }

    public final Boolean zzi() {
        if (!zzml.zzb() || !this.zza(zzas.zzch)) {
            return null;
        }
        return this.zzf("google_analytics_default_allow_ad_storage");
    }

    public final Boolean zzj() {
        if (!zzml.zzb() || !this.zza(zzas.zzch)) {
            return null;
        }
        return this.zzf("google_analytics_default_allow_analytics_storage");
    }

    public static long zzu() {
        return zzas.zzac.zza(null);
    }

    public final String zza(zzf zzf2) {
        String string;
        Uri.Builder builder;
        block2: {
            block3: {
                builder = new Uri.Builder();
                string = zzf2.zze();
                if (!TextUtils.isEmpty((CharSequence)string)) break block2;
                if (!zznv.zzb()) break block3;
                zzej<Boolean> zzej2 = zzas.zzbi;
                if (((zzgr)this).zzs().zzd(zzf2.zzc(), zzej2) && !TextUtils.isEmpty((CharSequence)(string = zzf2.zzg()))) break block2;
            }
            string = zzf2.zzf();
        }
        String string2 = String.valueOf(string);
        builder.scheme((String)zzas.zzd.zza(null)).encodedAuthority((String)zzas.zze.zza(null)).path(string2.length() != 0 ? "config/app/".concat(string2) : new String("config/app/")).appendQueryParameter("app_instance_id", zzf2.zzd()).appendQueryParameter("platform", "android").appendQueryParameter("gmp_version", "33025");
        return builder.build().toString();
    }

    public static long zzv() {
        return zzas.zzc.zza(null);
    }

    public final String zzw() {
        return this.zza("debug.firebase.analytics.app", "");
    }

    public final String zzx() {
        return this.zza("debug.deferred.deeplink", "");
    }

    private final String zza(String string, String string2) {
        try {
            return (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzgr)this).zzq().zze().zza("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzgr)this).zzq().zze().zza("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzgr)this).zzq().zze().zza("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzgr)this).zzq().zze().zza("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return string2;
    }

    public final boolean zzh(String string) {
        return "1".equals(this.zzb.zza(string, "gaia_collection_enabled"));
    }

    public final boolean zzi(String string) {
        return "1".equals(this.zzb.zza(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzj(String string) {
        return this.zzd(string, zzas.zzaj);
    }

    @WorkerThread
    final String zzk(String string) {
        zzej<String> zzej2 = zzas.zzak;
        String string2 = string;
        zzab zzab2 = this;
        if (string2 == null) {
            return zzej2.zza(null);
        }
        return zzej2.zza(zzab2.zzb.zza(string2, zzej2.zza()));
    }

    @WorkerThread
    final boolean zzy() {
        if (this.zza == null) {
            this.zza = this.zzf("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzy.zzs();
    }
}

