/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzml;
import com.google.android.gms.internal.measurement.zzw;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzaq;
import com.google.android.gms.measurement.internal.zzas;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zzit;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import com.google.android.gms.measurement.internal.zziw;
import com.google.android.gms.measurement.internal.zzix;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zziz;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzjc;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjl;
import com.google.android.gms.measurement.internal.zzke;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzz;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

@VisibleForTesting
public final class zzir
extends zzg {
    private final zzjl zza;
    private zzei zzb;
    private volatile Boolean zzc;
    private final zzai zzd;
    private final zzke zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzai zzg;

    protected zzir(zzfu zzfu2) {
        super(zzfu2);
        this.zze = new zzke(zzfu2.zzl());
        this.zza = new zzjl(this);
        this.zzd = new zziq(this, zzfu2);
        this.zzg = new zzja(this, zzfu2);
    }

    @Override
    protected final boolean zzy() {
        return false;
    }

    @WorkerThread
    public final boolean zzaa() {
        ((zzgr)this).zzc();
        this.zzv();
        return this.zzb != null;
    }

    @WorkerThread
    protected final void zzab() {
        ((zzgr)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(true);
        this.zza(new zzjc(this, zzn2));
    }

    @WorkerThread
    protected final void zza(boolean bl) {
        if (zzml.zzb() && ((zzgr)this).zzs().zza(zzas.zzcg)) {
            ((zzgr)this).zzc();
            this.zzv();
            if (bl) {
                ((zzd)this).zzi().zzaa();
            }
            if (this.zzai()) {
                zzn zzn2 = this.zzb(false);
                this.zza(new zzjf(this, zzn2));
            }
        }
    }

    @WorkerThread
    @VisibleForTesting
    final void zza(zzei zzei2, AbstractSafeParcelable abstractSafeParcelable, zzn zzn2) {
        ((zzgr)this).zzc();
        this.zzv();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            List<AbstractSafeParcelable> list = ((zzd)this).zzi().zza(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzaq) {
                    try {
                        zzei2.zza((zzaq)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgr)this).zzq().zze().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzku) {
                    try {
                        zzei2.zza((zzku)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgr)this).zzq().zze().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzz) {
                    try {
                        zzei2.zza((zzz)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzgr)this).zzq().zze().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzgr)this).zzq().zze().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzaq zzaq2, String string) {
        Preconditions.checkNotNull((Object)((Object)zzaq2));
        ((zzgr)this).zzc();
        this.zzv();
        boolean bl = ((zzd)this).zzi().zza(zzaq2);
        zzn zzn2 = this.zzb(true);
        this.zza(new zzje(this, true, bl, zzaq2, zzn2, string));
    }

    @WorkerThread
    protected final void zza(zzz zzz2) {
        Preconditions.checkNotNull((Object)((Object)zzz2));
        ((zzgr)this).zzc();
        this.zzv();
        boolean bl = ((zzd)this).zzi().zza(zzz2);
        zzz zzz3 = new zzz(zzz2);
        zzn zzn2 = this.zzb(true);
        this.zza(new zzjh(this, true, bl, zzz3, zzn2, zzz2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzz>> atomicReference, String string, String string2, String string3) {
        ((zzgr)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzjg(this, atomicReference, string, string2, string3, zzn2));
    }

    @WorkerThread
    protected final void zza(zzw zzw2, String string, String string2) {
        ((zzgr)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzjj(this, string, string2, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzku>> atomicReference, String string, String string2, String string3, boolean bl) {
        ((zzgr)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzji(this, atomicReference, string, string2, string3, bl, zzn2));
    }

    @WorkerThread
    protected final void zza(zzw zzw2, String string, String string2, boolean bl) {
        ((zzgr)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzit(this, string, string2, bl, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zza(zzku zzku2) {
        ((zzgr)this).zzc();
        this.zzv();
        boolean bl = ((zzd)this).zzi().zza(zzku2);
        zzn zzn2 = this.zzb(true);
        this.zza(new zzis(this, bl, zzku2, zzn2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzku>> atomicReference, boolean bl) {
        ((zzgr)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zziv(this, atomicReference, zzn2, bl));
    }

    @WorkerThread
    protected final void zzac() {
        ((zzgr)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        ((zzd)this).zzi().zzaa();
        this.zza(new zziu(this, zzn2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzgr)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzix(this, atomicReference, zzn2));
    }

    @WorkerThread
    public final void zza(zzw zzw2) {
        ((zzgr)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zziw(this, zzn2, zzw2));
    }

    @WorkerThread
    protected final void zzad() {
        ((zzgr)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(true);
        ((zzd)this).zzi().zzab();
        this.zza(new zziz(this, zzn2));
    }

    @WorkerThread
    protected final void zza(zzij zzij2) {
        ((zzgr)this).zzc();
        this.zzv();
        this.zza(new zziy(this, zzij2));
    }

    @WorkerThread
    public final void zza(Bundle bundle) {
        ((zzgr)this).zzc();
        this.zzv();
        zzn zzn2 = this.zzb(false);
        this.zza(new zzjb(this, bundle, zzn2));
    }

    @WorkerThread
    private final void zzaj() {
        ((zzgr)this).zzc();
        this.zze.zza();
        this.zzd.zza((Long)zzas.zzai.zza(null));
    }

    @WorkerThread
    final void zzae() {
        ((zzgr)this).zzc();
        this.zzv();
        if (this.zzaa()) {
            return;
        }
        if (this.zzak()) {
            this.zza.zzb();
            return;
        }
        if (!((zzgr)this).zzs().zzy()) {
            Intent intent;
            zzir zzir2 = this;
            PackageManager packageManager = ((zzgr)zzir2).zzm().getPackageManager();
            List list = packageManager.queryIntentServices(intent = new Intent().setClassName(((zzgr)zzir2).zzm(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && list.size() > 0) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                intent2.setComponent(new ComponentName(((zzgr)this).zzm(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zzgr)this).zzq().zze().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    final Boolean zzaf() {
        return this.zzc;
    }

    @WorkerThread
    private final boolean zzak() {
        ((zzgr)this).zzc();
        this.zzv();
        if (this.zzc == null) {
            boolean bl;
            zzir zzir2 = this;
            ((zzgr)zzir2).zzc();
            zzir2.zzv();
            Boolean bl2 = ((zzgr)zzir2).zzr().zzi();
            if (bl2 != null && bl2.booleanValue()) {
                bl = true;
            } else {
                boolean bl3;
                boolean bl4;
                if (((zzd)zzir2).zzf().zzaf() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzgr)zzir2).zzq().zzw().zza("Checking service availability");
                    int n = ((zzgr)zzir2).zzo().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zzgr)zzir2).zzq().zzw().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzgr)zzir2).zzq().zzw().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzgr)zzir2).zzq().zzh().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzgr)zzir2).zzq().zzv().zza("Service container out of date");
                            if (((zzgr)zzir2).zzo().zzi() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            bl4 = bl2 == null;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzgr)zzir2).zzq().zzh().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzgr)zzir2).zzq().zzh().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzgr)zzir2).zzq().zzh().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzgr)zzir2).zzs().zzy()) {
                    ((zzgr)zzir2).zzq().zze().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzgr)zzir2).zzr().zza(bl4);
                }
                bl = bl4;
            }
            this.zzc = bl;
        }
        return this.zzc;
    }

    @WorkerThread
    @VisibleForTesting
    protected final void zza(zzei zzei2) {
        ((zzgr)this).zzc();
        Preconditions.checkNotNull((Object)zzei2);
        this.zzb = zzei2;
        this.zzaj();
        this.zzam();
    }

    @WorkerThread
    public final void zzag() {
        ((zzgr)this).zzc();
        this.zzv();
        this.zza.zza();
        try {
            ConnectionTracker.getInstance().unbindService(((zzgr)this).zzm(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zza(ComponentName componentName) {
        ((zzgr)this).zzc();
        if (this.zzb != null) {
            this.zzb = null;
            ((zzgr)this).zzq().zzw().zza("Disconnected from device MeasurementService", componentName);
            zzir zzir2 = this;
            ((zzgr)zzir2).zzc();
            zzir2.zzae();
        }
    }

    @WorkerThread
    private final void zzal() {
        ((zzgr)this).zzc();
        if (!this.zzaa()) {
            return;
        }
        ((zzgr)this).zzq().zzw().zza("Inactivity, disconnecting from the service");
        this.zzag();
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzgr)this).zzc();
        if (this.zzaa()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzgr)this).zzq().zze().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzae();
    }

    @WorkerThread
    private final void zzam() {
        ((zzgr)this).zzc();
        ((zzgr)this).zzq().zzw().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                ((zzgr)this).zzq().zze().zza("Task exception while flushing queue", exception);
            }
        }
        this.zzf.clear();
        this.zzg.zzc();
    }

    @WorkerThread
    @Nullable
    private final zzn zzb(boolean bl) {
        return ((zzd)this).zzf().zza(bl ? ((zzgr)this).zzq().zzx() : null);
    }

    @WorkerThread
    public final void zza(zzw zzw2, zzaq zzaq2, String string) {
        ((zzgr)this).zzc();
        this.zzv();
        if (((zzgr)this).zzo().zza(12451000) != 0) {
            ((zzgr)this).zzq().zzh().zza("Not bundling data. Service unavailable or out of date");
            ((zzgr)this).zzo().zza(zzw2, new byte[0]);
            return;
        }
        this.zza(new zzjd(this, zzaq2, string, zzw2));
    }

    @WorkerThread
    final boolean zzah() {
        ((zzgr)this).zzc();
        this.zzv();
        if (!this.zzak()) {
            return true;
        }
        return ((zzgr)this).zzo().zzi() >= 200900;
    }

    @WorkerThread
    final boolean zzai() {
        ((zzgr)this).zzc();
        this.zzv();
        if (!((zzgr)this).zzs().zza(zzas.zzci)) {
            return false;
        }
        if (!this.zzak()) {
            return true;
        }
        return ((zzgr)this).zzo().zzi() >= (Integer)zzas.zzcj.zza(null);
    }

    static /* synthetic */ zzjl zza(zzir zzir2) {
        return zzir2.zza;
    }

    static /* synthetic */ void zza(zzir zzir2, ComponentName componentName) {
        zzir2.zza(componentName);
    }

    static /* synthetic */ zzei zza(zzir zzir2, zzei zzei2) {
        zzir2.zzb = null;
        return null;
    }

    static /* synthetic */ void zzb(zzir zzir2) {
        zzir2.zzam();
    }

    static /* synthetic */ void zzc(zzir zzir2) {
        zzir2.zzal();
    }

    static /* synthetic */ zzei zzd(zzir zzir2) {
        return zzir2.zzb;
    }

    static /* synthetic */ void zze(zzir zzir2) {
        zzir2.zzaj();
    }
}

