/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzim;
import java.util.Map;

public final class zzd
extends zze {
    private final Map<String, Long> zza;
    private final Map<String, Integer> zzb;
    private long zzc;

    public zzd(zzfw zzfw2) {
        super(zzfw2);
        super();
        this.zzb = zzfw2;
        super();
        this.zza = zzfw2;
    }

    public final void zza(String string, long l) {
        if (string == null || string.length() == 0) {
            this.zzx.zzat().zzb().zza("Ad unit id must be a non-empty string");
            return;
        }
        zzgr zzgr2 = this.zzx;
        zzgr2 = ((zzfw)zzgr2).zzau();
        zza zza2 = new zza(this, string, l);
        ((zzft)zzgr2).zzh(zza2);
    }

    public final void zzb(String string, long l) {
        if (string == null || string.length() == 0) {
            this.zzx.zzat().zzb().zza("Ad unit id must be a non-empty string");
            return;
        }
        zzgr zzgr2 = this.zzx;
        zzgr2 = ((zzfw)zzgr2).zzau();
        zzb zzb2 = new zzb(this, string, l);
        ((zzft)zzgr2).zzh(zzb2);
    }

    @WorkerThread
    private final void zzh(long l, zzif zzif2) {
        if (zzif2 == null) {
            this.zzx.zzat().zzk().zza("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzx.zzat().zzk().zzb("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzim.zzm(zzif2, bundle, true);
        this.zzx.zzk().zzs("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zzi(String string, long l, zzif zzif2) {
        if (zzif2 == null) {
            this.zzx.zzat().zzk().zza("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzx.zzat().zzk().zzb("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzim.zzm(zzif2, bundle, true);
        this.zzx.zzk().zzs("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzc(long l) {
        zzif zzif2 = this.zzx.zzx().zzh(false);
        for (String string : this.zza.keySet()) {
            this.zzi(string, l - this.zza.get(string), zzif2);
        }
        if (!this.zza.isEmpty()) {
            this.zzh(l - this.zzc, zzif2);
        }
        this.zzj(l);
    }

    @WorkerThread
    private final void zzj(long l) {
        for (String string : this.zza.keySet()) {
            this.zza.put(string, l);
        }
        if (!this.zza.isEmpty()) {
            this.zzc = l;
            return;
        }
    }

    static /* synthetic */ void zzd(zzd zzd2, String string, long l) {
        Integer n;
        ((zzgp)zzd2).zzg();
        Preconditions.checkNotEmpty((String)string);
        if (zzd2.zzb.isEmpty()) {
            zzd2.zzc = l;
        }
        if ((n = zzd2.zzb.get(string)) != null) {
            zzd2.zzb.put(string, n + 1);
            return;
        }
        if (zzd2.zzb.size() >= 100) {
            zzd2.zzx.zzat().zze().zza("Too many ads visible");
            return;
        }
        zzd2.zzb.put(string, 1);
        zzd2.zza.put(string, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* synthetic */ void zze(zzd zzd2, String string, long l) {
        long l2;
        ((zzgp)zzd2).zzg();
        Preconditions.checkNotEmpty((String)string);
        Integer n = zzd2.zzb.get(string);
        if (n == null) {
            zzd2.zzx.zzat().zzb().zzb("Call to endAdUnitExposure for unknown ad unit id", string);
            return;
        }
        zzif zzif2 = zzd2.zzx.zzx().zzh(false);
        int n2 = n + -1;
        if (n2 != 0) {
            zzd2.zzb.put(string, n2);
            return;
        }
        zzd2.zzb.remove(string);
        Long l3 = zzd2.zza.get(string);
        if (l3 == null) {
            zzd2.zzx.zzat().zzb().zza("First ad unit exposure time was never set");
        } else {
            l2 = l3;
            zzd2.zza.remove(string);
            zzd2.zzi(string, l - l2, zzif2);
        }
        if (!zzd2.zzb.isEmpty()) {
            return;
        }
        l2 = zzd2.zzc;
        if (l2 == 0L) {
            zzd2.zzx.zzat().zzb().zza("First ad exposure time was never set");
            return;
        }
        zzd2.zzh(l - l2, zzif2);
        zzd2.zzc = 0L;
    }

    static /* synthetic */ void zzf(zzd zzd2, long l) {
        zzd2.zzj(l);
    }
}

