/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzek;
import com.google.android.gms.measurement.internal.zzep;
import com.google.android.gms.measurement.internal.zzet;
import com.google.android.gms.measurement.internal.zzft;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzgp;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzji;
import com.google.android.gms.measurement.internal.zzjj;
import com.google.android.gms.measurement.internal.zzjk;
import com.google.android.gms.measurement.internal.zzjm;

@VisibleForTesting
public final class zzjl
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzep zzc;
    final /* synthetic */ zzjm zza;

    protected zzjl(zzjm zzjm2) {
        this.zza = zzjm2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zza(Intent object) {
        ((zzgp)this.zza).zzg();
        Context context = this.zza.zzx.zzaw();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        synchronized (this) {
            boolean bl = this.zzb;
            if (bl) {
                object = this.zza;
                object = ((zzgp)object).zzx.zzat();
                ((zzet)object).zzk().zza("Connection attempt already in progress");
                return;
            }
            zzgp zzgp2 = this.zza;
            zzgp2 = zzgp2.zzx.zzat();
            ((zzet)zzgp2).zzk().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, (Intent)object, (ServiceConnection)zzjm.zzI(this.zza), 129);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final void zzb() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onServiceConnected(ComponentName object, IBinder object2) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        // MONITORENTER : this
        if (object2 == null) {
            this.zzb = false;
            object = this.zza;
            object = ((zzgp)object).zzx.zzat();
            ((zzet)object).zzb().zza("Service connected with null binder");
            // MONITOREXIT : this
            return;
        }
        try {
            object = object2.getInterfaceDescriptor();
            boolean bl = "com.google.android.gms.measurement.internal.IMeasurementService".equals(object);
            if (bl) {
                object = object2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService");
                bl = object instanceof zzek;
                object = bl ? (zzek)object : new zzei((IBinder)object2);
                object2 = this.zza;
                object2 = ((zzgp)object2).zzx.zzat();
                ((zzet)object2).zzk().zza("Bound to IMeasurementService interface");
                object2 = object;
            } else {
                object2 = this.zza;
                object2 = ((zzgp)object2).zzx.zzat();
                ((zzet)object2).zzb().zzb("Got binder with a wrong descriptor", object);
                object2 = null;
            }
            object = object2;
        }
        catch (RemoteException remoteException) {
            block14: {
                object = null;
                break block14;
                catch (RemoteException remoteException2) {}
            }
            object2 = this.zza;
            object2 = ((zzgp)object2).zzx.zzat();
            ((zzet)object2).zzb().zza("Service connect failed to get IMeasurementService");
        }
        if (object != null) {
            object2 = this.zza;
            object2 = ((zzgp)object2).zzx.zzau();
            zzjg zzjg2 = new zzjg(this, (zzek)object);
            ((zzft)object2).zzh(zzjg2);
            return;
        }
        this.zzb = false;
        try {
            object = ConnectionTracker.getInstance();
            object2 = this.zza;
            object2 = ((zzgp)object2).zzx.zzaw();
            object.unbindService((Context)object2, (ServiceConnection)zzjm.zzI(this.zza));
            // MONITOREXIT : this
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        this.zza.zzx.zzat().zzj().zza("Service disconnected");
        zzgr zzgr2 = this.zza;
        zzgr2 = ((zzgp)zzgr2).zzx;
        zzgr2 = ((zzfw)zzgr2).zzau();
        zzjh zzjh2 = new zzjh(this, componentName);
        ((zzft)zzgr2).zzh(zzjh2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzc() {
        ((zzgp)this.zza).zzg();
        Object object = this.zza.zzx.zzaw();
        synchronized (this) {
            zzep zzep2;
            boolean bl;
            boolean bl2 = this.zzb;
            if (bl2) {
                object = this.zza;
                object = object.zzx.zzat();
                object.zzk().zza("Connection attempt already in progress");
                return;
            }
            zzep zzep3 = this.zzc;
            if (zzep3 != null && ((bl = this.zzc.isConnecting()) || (bl = this.zzc.isConnected()))) {
                object = this.zza;
                object = object.zzx.zzat();
                object.zzk().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = zzep2 = new zzep((Context)object, Looper.getMainLooper(), this, this);
            object = this.zza;
            object = object.zzx.zzat();
            object.zzk().zza("Connecting to remote service");
            this.zzb = true;
            object = this.zzc;
            Preconditions.checkNotNull((Object)object);
            this.zzc.checkAvailabilityAndConnect();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onConnected(Bundle object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        // MONITORENTER : this
        try {
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            object = (zzek)this.zzc.getService();
            zzgp zzgp2 = this.zza;
            zzgp2 = zzgp2.zzx.zzau();
            zzji zzji2 = new zzji(this, (zzek)object);
            ((zzft)zzgp2).zzh(zzji2);
            // MONITOREXIT : this
            return;
        }
        catch (DeadObjectException | IllegalStateException throwable) {
            this.zzc = null;
            this.zzb = false;
            return;
            {
                catch (Throwable throwable2) {}
                {
                    // MONITOREXIT : this
                    throw throwable2;
                }
            }
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        this.zza.zzx.zzat().zzj().zza("Service connection suspended");
        zzgr zzgr2 = this.zza;
        zzgr2 = ((zzgp)zzgr2).zzx;
        zzgr2 = ((zzfw)zzgr2).zzau();
        zzjj zzjj2 = new zzjj(this);
        ((zzft)zzgr2).zzh(zzjj2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        Object object2 = this.zza.zzx.zzf();
        if (object2 != null) {
            ((zzet)object2).zze().zzb("Service connection failed", object);
        }
        synchronized (this) {
            this.zzb = false;
            this.zzc = null;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : this
            object = this.zza;
            object = ((zzgp)object).zzx;
            object = ((zzfw)object).zzau();
            object2 = new zzjk(this);
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        ((zzft)object).zzh((Runnable)object2);
    }

    static /* synthetic */ boolean zzd(zzjl zzjl2, boolean bl) {
        zzjl2.zzb = false;
        return false;
    }
}

