/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzdx;
import com.google.android.gms.measurement.internal.zzdz;
import com.google.android.gms.measurement.internal.zzee;
import com.google.android.gms.measurement.internal.zzei;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzjg;
import com.google.android.gms.measurement.internal.zzjh;
import com.google.android.gms.measurement.internal.zzjj;

@VisibleForTesting
public final class zzji
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzee zzc;
    final /* synthetic */ zzjj zza;

    static /* bridge */ /* synthetic */ void zza(zzji zzji2, boolean bl) {
        zzji2.zzb = false;
    }

    protected zzji(zzjj zzjj2) {
        this.zza = zzjj2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzb(Intent object) {
        ((zzgl)this.zza).zzg();
        Context context = this.zza.zzs.zzau();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        synchronized (this) {
            boolean bl = this.zzb;
            if (bl) {
                object = this.zza;
                object = ((zzgl)object).zzs.zzay();
                ((zzei)object).zzj().zza("Connection attempt already in progress");
                return;
            }
            zzgl zzgl2 = this.zza;
            zzgl2 = zzgl2.zzs.zzay();
            ((zzei)zzgl2).zzj().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, (Intent)object, (ServiceConnection)zzjj.zzi(this.zza), 129);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzc() {
        ((zzgl)this.zza).zzg();
        Object object = this.zza.zzs.zzau();
        synchronized (this) {
            zzee zzee2;
            boolean bl;
            boolean bl2 = this.zzb;
            if (bl2) {
                object = this.zza;
                object = ((zzgl)object).zzs.zzay();
                ((zzei)object).zzj().zza("Connection attempt already in progress");
                return;
            }
            zzee zzee3 = this.zzc;
            if (zzee3 != null && ((bl = this.zzc.isConnecting()) || (bl = this.zzc.isConnected()))) {
                object = this.zza;
                object = ((zzgl)object).zzs.zzay();
                ((zzei)object).zzj().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = zzee2 = new zzee((Context)object, Looper.getMainLooper(), this, this);
            object = this.zza;
            object = ((zzgl)object).zzs.zzay();
            ((zzei)object).zzj().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final void zzd() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onConnected(Bundle object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        // MONITORENTER : this
        try {
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            object = (zzdz)this.zzc.getService();
            zzgl zzgl2 = this.zza;
            zzgl2 = zzgl2.zzs.zzaz();
            zzjf zzjf2 = new zzjf(this, (zzdz)object);
            ((zzfp)zzgl2).zzp(zzjf2);
            // MONITOREXIT : this
            return;
        }
        catch (DeadObjectException | IllegalStateException throwable) {
            this.zzc = null;
            this.zzb = false;
            return;
            {
                catch (Throwable throwable2) {}
                {
                    // MONITOREXIT : this
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult object) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        Object object2 = this.zza.zzs.zzl();
        if (object2 != null) {
            ((zzei)object2).zzk().zzb("Service connection failed", object);
        }
        synchronized (this) {
            this.zzb = false;
            this.zzc = null;
            // MONITOREXIT @DISABLED, blocks:[0, 2] lbl9 : MonitorExitStatement: MONITOREXIT : this
            object = this.zza;
            object = ((zzgl)object).zzs;
            object = ((zzfs)object).zzaz();
            object2 = new zzjh(this);
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        ((zzfp)object).zzp((Runnable)object2);
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        this.zza.zzs.zzay().zzc().zza("Service connection suspended");
        zzgn zzgn2 = this.zza;
        zzgn2 = ((zzgl)zzgn2).zzs;
        zzgn2 = ((zzfs)zzgn2).zzaz();
        zzjg zzjg2 = new zzjg(this);
        ((zzfp)zzgn2).zzp(zzjg2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onServiceConnected(ComponentName object, IBinder object2) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        // MONITORENTER : this
        if (object2 == null) {
            this.zzb = false;
            object = this.zza;
            object = ((zzgl)object).zzs.zzay();
            ((zzei)object).zzd().zza("Service connected with null binder");
            // MONITOREXIT : this
            return;
        }
        try {
            object = object2.getInterfaceDescriptor();
            boolean bl = "com.google.android.gms.measurement.internal.IMeasurementService".equals(object);
            if (bl) {
                object = object2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService");
                bl = object instanceof zzdz;
                object = bl ? (zzdz)object : new zzdx((IBinder)object2);
                object2 = this.zza;
                object2 = ((zzgl)object2).zzs.zzay();
                ((zzei)object2).zzj().zza("Bound to IMeasurementService interface");
                object2 = object;
            } else {
                object2 = this.zza;
                object2 = ((zzgl)object2).zzs.zzay();
                ((zzei)object2).zzd().zzb("Got binder with a wrong descriptor", object);
                object2 = null;
            }
            object = object2;
        }
        catch (RemoteException remoteException) {
            block14: {
                object = null;
                break block14;
                catch (RemoteException remoteException2) {}
            }
            object2 = this.zza;
            object2 = ((zzgl)object2).zzs.zzay();
            ((zzei)object2).zzd().zza("Service connect failed to get IMeasurementService");
        }
        if (object != null) {
            object2 = this.zza;
            object2 = ((zzgl)object2).zzs.zzaz();
            zzjd zzjd2 = new zzjd(this, (zzdz)object);
            ((zzfp)object2).zzp(zzjd2);
            return;
        }
        this.zzb = false;
        try {
            object = ConnectionTracker.getInstance();
            object2 = this.zza;
            object2 = ((zzgl)object2).zzs.zzau();
            object.unbindService((Context)object2, (ServiceConnection)zzjj.zzi(this.zza));
            // MONITOREXIT : this
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        this.zza.zzs.zzay().zzc().zza("Service disconnected");
        zzgn zzgn2 = this.zza;
        zzgn2 = ((zzgl)zzgn2).zzs;
        zzgn2 = ((zzfs)zzgn2).zzaz();
        zzje zzje2 = new zzje(this, componentName);
        ((zzfp)zzgn2).zzp(zzje2);
    }
}

