/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzfs;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzgo;
import com.google.android.gms.measurement.internal.zzgq;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzkz;
import java.util.Map;

public final class zzd
extends zze {
    private final Map<String, Long> zza;
    private final Map<String, Integer> zzb;
    private long zzc;

    static /* bridge */ /* synthetic */ void zza(zzd zzd2, String string, long l) {
        Integer n;
        ((zzgo)zzd2).zzg();
        Preconditions.checkNotEmpty((String)string);
        if (zzd2.zzb.isEmpty()) {
            zzd2.zzc = l;
        }
        if ((n = zzd2.zzb.get(string)) != null) {
            zzd2.zzb.put(string, n + 1);
            return;
        }
        if (zzd2.zzb.size() >= 100) {
            zzd2.zzs.zzay().zzk().zza("Too many ads visible");
            return;
        }
        zzd2.zzb.put(string, 1);
        zzd2.zza.put(string, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzb(zzd zzd2, String string, long l) {
        long l2;
        ((zzgo)zzd2).zzg();
        Preconditions.checkNotEmpty((String)string);
        Integer n = zzd2.zzb.get(string);
        if (n == null) {
            zzd2.zzs.zzay().zzd().zzb("Call to endAdUnitExposure for unknown ad unit id", string);
            return;
        }
        zzih zzih2 = zzd2.zzs.zzs().zzj(false);
        int n2 = n + -1;
        if (n2 != 0) {
            zzd2.zzb.put(string, n2);
            return;
        }
        zzd2.zzb.remove(string);
        Long l3 = zzd2.zza.get(string);
        if (l3 == null) {
            zzd2.zzs.zzay().zzd().zza("First ad unit exposure time was never set");
        } else {
            l2 = l3;
            zzd2.zza.remove(string);
            zzd2.zzi(string, l - l2, zzih2);
        }
        if (!zzd2.zzb.isEmpty()) {
            return;
        }
        l2 = zzd2.zzc;
        if (l2 == 0L) {
            zzd2.zzs.zzay().zzd().zza("First ad exposure time was never set");
            return;
        }
        zzd2.zzh(l - l2, zzih2);
        zzd2.zzc = 0L;
    }

    static /* bridge */ /* synthetic */ void zzc(zzd zzd2, long l) {
        zzd2.zzj(l);
    }

    public zzd(zzfv zzfv2) {
        super(zzfv2);
        super();
        this.zzb = zzfv2;
        super();
        this.zza = zzfv2;
    }

    public final void zzd(String string, long l) {
        if (string == null || string.length() == 0) {
            this.zzs.zzay().zzd().zza("Ad unit id must be a non-empty string");
            return;
        }
        zzgq zzgq2 = this.zzs;
        zzgq2 = ((zzfv)zzgq2).zzaz();
        zza zza2 = new zza(this, string, l);
        ((zzfs)zzgq2).zzp(zza2);
    }

    public final void zze(String string, long l) {
        if (string == null || string.length() == 0) {
            this.zzs.zzay().zzd().zza("Ad unit id must be a non-empty string");
            return;
        }
        zzgq zzgq2 = this.zzs;
        zzgq2 = ((zzfv)zzgq2).zzaz();
        zzb zzb2 = new zzb(this, string, l);
        ((zzfs)zzgq2).zzp(zzb2);
    }

    @WorkerThread
    private final void zzh(long l, zzih zzih2) {
        if (zzih2 == null) {
            this.zzs.zzay().zzj().zza("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzs.zzay().zzj().zzb("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzkz.zzJ(zzih2, bundle, true);
        this.zzs.zzq().zzG("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zzi(String string, long l, zzih zzih2) {
        if (zzih2 == null) {
            this.zzs.zzay().zzj().zza("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzs.zzay().zzj().zzb("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzkz.zzJ(zzih2, bundle, true);
        this.zzs.zzq().zzG("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzf(long l) {
        zzih zzih2 = this.zzs.zzs().zzj(false);
        for (String string : this.zza.keySet()) {
            this.zzi(string, l - this.zza.get(string), zzih2);
        }
        if (!this.zza.isEmpty()) {
            this.zzh(l - this.zzc, zzih2);
        }
        this.zzj(l);
    }

    @WorkerThread
    private final void zzj(long l) {
        for (String string : this.zza.keySet()) {
            this.zza.put(string, l);
        }
        if (!this.zza.isEmpty()) {
            this.zzc = l;
            return;
        }
    }
}

