/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzdt;
import com.google.android.gms.measurement.internal.zzdu;
import com.google.android.gms.measurement.internal.zzeh;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzkw;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzaf
extends zzgk {
    private Boolean zza;
    private zzae zzb = zzad.zza;
    private Boolean zzc;

    @WorkerThread
    public final double zza(String string, zzdt zzdt2) {
        if (string == null) {
            return (Double)zzdt2.zza(null);
        }
        String string2 = ((zzaf)((Object)string2)).zzb.zza(string, zzdt2.zzb());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return (Double)zzdt2.zza(null);
        }
        try {
            double d = (Double)zzdt2.zza(Double.parseDouble(string2));
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return (Double)zzdt2.zza(null);
        }
    }

    final int zzb(@Size(min=1L) String string) {
        return this.zzf(string, zzdu.zzG, 500, 2000);
    }

    public final int zzc() {
        zzgk zzgk2 = zzgk2.zzs.zzv();
        Boolean bl = ((zzkw)zzgk2).zzs.zzt().zzj();
        if (((zzkw)zzgk2).zzm() >= 201500 || bl != null && !bl.booleanValue()) {
            return 100;
        }
        return 25;
    }

    public final int zzd(@Size(min=1L) String string) {
        return this.zzf(string, zzdu.zzH, 25, 100);
    }

    @WorkerThread
    public final int zze(String string, zzdt zzdt2) {
        if (string == null) {
            return (Integer)zzdt2.zza(null);
        }
        String string2 = ((zzaf)((Object)string2)).zzb.zza(string, zzdt2.zzb());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return (Integer)zzdt2.zza(null);
        }
        try {
            int n = (Integer)zzdt2.zza(Integer.parseInt(string2));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return (Integer)zzdt2.zza(null);
        }
    }

    @WorkerThread
    public final int zzf(String string, zzdt zzdt2, int n, int n2) {
        return Math.max(Math.min(this.zze(string, zzdt2), n2), n);
    }

    public final long zzh() {
        this.zzs.zzaw();
        return 55005L;
    }

    @WorkerThread
    public final long zzi(String string, zzdt zzdt2) {
        if (string == null) {
            return (Long)zzdt2.zza(null);
        }
        String string2 = ((zzaf)((Object)string2)).zzb.zza(string, zzdt2.zzb());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return (Long)zzdt2.zza(null);
        }
        try {
            long l = (Long)zzdt2.zza(Long.parseLong(string2));
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            return (Long)zzdt2.zza(null);
        }
    }

    @VisibleForTesting
    final Bundle zzj() {
        Object object;
        block7: {
            block6: {
                try {
                    object = this.zzs.zzau();
                    object = object.getPackageManager();
                    if (object != null) break block6;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    this.zzs.zzay().zzd().zzb("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
                    return null;
                }
                object = this.zzs.zzay();
                ((zzeh)object).zzd().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            object = this.zzs.zzau();
            object = Wrappers.packageManager((Context)object);
            Context context = this.zzs.zzau();
            object = object.getApplicationInfo(context.getPackageName(), 128);
            if (object != null) break block7;
            object = this.zzs.zzay();
            ((zzeh)object).zzd().zza("Failed to load metadata: ApplicationInfo is null");
            return null;
        }
        object = ((ApplicationInfo)object).metaData;
        return object;
    }

    @VisibleForTesting
    final Boolean zzk(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzj();
        if (bundle == null) {
            this.zzs.zzay().zzd().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    public final String zzl() {
        return this.zzB("debug.firebase.analytics.app", "");
    }

    public final String zzm() {
        return this.zzB("debug.deferred.deeplink", "");
    }

    final String zzn() {
        this.zzs.zzaw();
        return "FA";
    }

    @WorkerThread
    public final String zzo(String string, zzdt zzdt2) {
        if (string == null) {
            return (String)zzdt2.zza(null);
        }
        return (String)zzdt2.zza(this.zzb.zza(string, zzdt2.zzb()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String zzB(String string, String string2) {
        string2 = "";
        try {
            GenericDeclaration genericDeclaration = Class.forName("android.os.SystemProperties");
            Object[] objectArray = new Class[]{String.class, String.class};
            genericDeclaration = ((Class)genericDeclaration).getMethod("get", (Class<?>[])objectArray);
            objectArray = new Object[]{string, string2};
            string = (String)((Method)genericDeclaration).invoke(null, objectArray);
            Preconditions.checkNotNull((Object)string);
            return string;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzs.zzay().zzd().zzb("Could not find SystemProperties class", classNotFoundException);
            return string2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.zzs.zzay().zzd().zzb("Could not find SystemProperties.get() method", noSuchMethodException);
            return string2;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.zzs.zzay().zzd().zzb("Could not access SystemProperties.get()", illegalAccessException);
            return string2;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.zzs.zzay().zzd().zzb("SystemProperties.get() threw an exception", invocationTargetException);
            return string2;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    final List zzp(@Size(min=1L) String object) {
        void var1_4;
        String string = "analytics.safelisted_events";
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzj();
        if (bundle == null) {
            this.zzs.zzay().zzd().zza("Failed to load metadata: Metadata bundle is null");
            Object var1_3 = null;
        } else if (!bundle.containsKey(string)) {
            Object var1_7 = null;
        } else {
            Integer n = bundle.getInt(string);
        }
        if (var1_4 == null) {
            return null;
        }
        try {
            bundle = this.zzs.zzau();
            String[] stringArray = bundle.getResources().getStringArray(var1_4.intValue());
            if (stringArray != null) return Arrays.asList(stringArray);
            return null;
        }
        catch (Resources.NotFoundException notFoundException) {
            this.zzs.zzay().zzd().zzb("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    zzaf(zzfr zzfr2) {
        super(zzfr2);
    }

    final void zzq(zzae zzae2) {
        this.zzb = zzae2;
    }

    public final boolean zzr() {
        return (this = ((zzaf)this).zzk("google_analytics_adid_collection_enabled")) == null || ((Boolean)this).booleanValue();
    }

    @WorkerThread
    public final boolean zzs(String string, zzdt zzdt2) {
        if (string == null) {
            return (Boolean)zzdt2.zza(null);
        }
        String string2 = ((zzaf)((Object)string2)).zzb.zza(string, zzdt2.zzb());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return (Boolean)zzdt2.zza(null);
        }
        return (Boolean)zzdt2.zza("1".equals(string2));
    }

    public final boolean zzt(String string) {
        return "1".equals(this.zzb.zza(string, "gaia_collection_enabled"));
    }

    public final boolean zzu() {
        return (this = ((zzaf)this).zzk("google_analytics_automatic_screen_reporting_enabled")) == null || ((Boolean)this).booleanValue();
    }

    public final boolean zzv() {
        ((zzgk)((Object)bl)).zzs.zzaw();
        Boolean bl = ((zzaf)((Object)bl)).zzk("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final boolean zzw(String string) {
        return "1".equals(this.zzb.zza(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzx() {
        if (this.zza == null) {
            this.zza = this.zzk("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzs.zzN();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EnsuresNonNull(value={"this.isMainProcess"})
    public final boolean zzy() {
        if (this.zzc != null) return this.zzc;
        synchronized (this) {
            Object object;
            Object object2 = this.zzc;
            if (object2 != null) return this.zzc;
            object2 = this.zzs.zzau();
            object2 = object2.getApplicationInfo();
            String string = ProcessUtils.getMyProcessName();
            if (object2 != null) {
                boolean bl;
                object2 = ((ApplicationInfo)object2).processName;
                bl = object2 != null ? (bl = ((String)object2).equals(string)) : false;
                this.zzc = bl;
            }
            if ((object = this.zzc) != null) return this.zzc;
            this.zzc = Boolean.TRUE;
            object = this.zzs.zzay();
            ((zzeh)object).zzd().zza("My process not in the list of running processes");
            return this.zzc;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public static final long zzz() {
        return (Long)zzdu.zzc.zza(null);
    }

    public static final long zzA() {
        return (Long)zzdu.zzC.zza(null);
    }
}

