/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzel;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzhc;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class zzfn
extends zzhc {
    @VisibleForTesting
    static final Pair zza;
    private SharedPreferences zzt;
    public zzfl zzb;
    public final zzfj zzc;
    public final zzfj zzd;
    public final zzfm zze;
    private String zzu;
    private boolean zzv;
    private long zzw;
    public final zzfj zzf;
    public final zzfh zzg;
    public final zzfm zzh;
    public final zzfh zzi;
    public final zzfj zzj;
    public boolean zzk;
    public final zzfh zzl;
    public final zzfh zzm;
    public final zzfj zzn;
    public final zzfm zzo;
    public final zzfm zzp;
    public final zzfj zzq;
    public final zzfi zzr;

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zza() {
        this.zzg();
        this.zzu();
        Preconditions.checkNotNull((Object)this.zzt);
        return this.zzt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final Pair zzb(String string) {
        this.zzg();
        long l = this.zzs.zzaw().elapsedRealtime();
        String string2 = this.zzu;
        if (string2 != null && l < this.zzw) {
            return new Pair((Object)string2, (Object)this.zzv);
        }
        this.zzw = l + this.zzs.zzf().zzi(string, zzel.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            string = this.zzs.zzav();
            string = AdvertisingIdClient.getAdvertisingIdInfo((Context)string);
            this.zzu = "";
            string2 = string.getId();
            if (string2 != null) {
                this.zzu = string2;
            }
            this.zzv = string.isLimitAdTrackingEnabled();
        }
        catch (Exception exception) {
            this.zzs.zzaz().zzc().zzb("Unable to get advertising id", exception);
            this.zzu = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzu, (Object)this.zzv);
    }

    @WorkerThread
    final zzah zzc() {
        this.zzg();
        return zzah.zzb(this.zza().getString("consent_settings", "G1"));
    }

    @WorkerThread
    final Boolean zzd() {
        this.zzg();
        if (this.zza().contains("measurement_enabled")) {
            return this.zza().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    static {
        Pair pair;
        zza = pair = new Pair((Object)"", (Object)0L);
    }

    zzfn(zzgi object) {
        super((zzgi)object);
        this.zzf = object = new zzfj(this, "session_timeout", 1800000L);
        this.zzg = object = new zzfh(this, "start_new_session", true);
        this.zzj = object = new zzfj(this, "last_pause_time", 0L);
        this.zzh = object = new zzfm(this, "non_personalized_ads", null);
        this.zzi = object = new zzfh(this, "allow_remote_dynamite", false);
        this.zzc = object = new zzfj(this, "first_open_time", 0L);
        this.zzd = object = new zzfj(this, "app_install_time", 0L);
        this.zze = object = new zzfm(this, "app_instance_id", null);
        this.zzl = object = new zzfh(this, "app_backgrounded", false);
        this.zzm = object = new zzfh(this, "deep_link_retrieval_complete", false);
        this.zzn = object = new zzfj(this, "deep_link_retrieval_attempts", 0L);
        this.zzo = object = new zzfm(this, "firebase_feature_rollouts", null);
        this.zzp = object = new zzfm(this, "deferred_attribution_cache", null);
        this.zzq = object = new zzfj(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzr = object = new zzfi(this, "default_event_parameters", null);
    }

    @Override
    @EnsuresNonNull.List(value={@EnsuresNonNull(value={"this.preferences"}), @EnsuresNonNull(value={"this.monitoringSample"})})
    @WorkerThread
    protected final void zzaB() {
        zzfl zzfl2;
        boolean bl;
        this.zzt = this.zzs.zzav().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzk = bl = this.zzt.getBoolean("has_been_opened", false);
        if (!bl) {
            SharedPreferences.Editor editor = this.zzt.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzs.zzf();
        this.zzb = zzfl2 = new zzfl(this, "health_monitor", Math.max(0L, (Long)zzel.zzb.zza(null)), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzh(Boolean bl) {
        zzfn2.zzg();
        zzfn zzfn2 = zzfn2.zza().edit();
        if (bl != null) {
            zzfn2.putBoolean("measurement_enabled", bl);
        } else {
            zzfn2.remove("measurement_enabled");
        }
        zzfn2.apply();
    }

    @WorkerThread
    final void zzi(boolean bl) {
        zzfn2.zzg();
        zzfn2.zzs.zzaz().zzj().zzb("App measurement setting deferred collection", bl);
        zzfn zzfn2 = zzfn2.zza().edit();
        zzfn2.putBoolean("deferred_analytics_collection", bl);
        zzfn2.apply();
    }

    @WorkerThread
    final boolean zzj() {
        zzfn zzfn2 = zzfn2.zzt;
        if (zzfn2 == null) {
            return false;
        }
        return zzfn2.contains("deferred_analytics_collection");
    }

    final boolean zzk(long l) {
        return l - this.zzf.zza() > this.zzj.zza();
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    @WorkerThread
    final boolean zzl(int n) {
        return zzah.zzj(n, this.zza().getInt("consent_source", 100));
    }
}

