/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzoc;
import com.google.android.gms.internal.measurement.zzof;
import com.google.android.gms.internal.measurement.zzol;
import com.google.android.gms.internal.measurement.zzpm;
import com.google.android.gms.measurement.internal.zzaa;
import com.google.android.gms.measurement.internal.zzaf;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzat;
import com.google.android.gms.measurement.internal.zzav;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzel;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzfm;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzgf;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzhb;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzhm;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzif;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzii;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zzkb;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzkq;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzll;
import com.google.android.gms.measurement.internal.zzlo;
import com.google.android.gms.measurement.internal.zzlp;
import com.google.android.gms.measurement.internal.zzr;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzin
extends zzf {
    @VisibleForTesting
    protected zzim zza;
    private zzhi zzd;
    private final Set zze;
    private boolean zzf;
    private final AtomicReference zzg;
    private final Object zzh;
    @GuardedBy(value="consentLock")
    private zzah zzi;
    @GuardedBy(value="consentLock")
    private int zzj;
    private final AtomicLong zzk;
    private long zzl;
    private int zzm;
    final zzr zzb;
    @VisibleForTesting
    protected boolean zzc;
    private final zzlo zzn;

    public final int zzh(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzs.zzf();
        return 25;
    }

    public final Boolean zzi() {
        AtomicReference atomicReference = new AtomicReference();
        zzhd zzhd2 = this.zzs;
        zzhd2 = ((zzgi)zzhd2).zzaA();
        zzhz zzhz2 = new zzhz(this, atomicReference);
        return (Boolean)((zzgf)zzhd2).zzd(atomicReference, 15000L, "boolean test flag value", zzhz2);
    }

    public final Double zzj() {
        AtomicReference atomicReference = new AtomicReference();
        zzhd zzhd2 = this.zzs;
        zzhd2 = ((zzgi)zzhd2).zzaA();
        zzif zzif2 = new zzif(this, atomicReference);
        return (Double)((zzgf)zzhd2).zzd(atomicReference, 15000L, "double test flag value", zzif2);
    }

    public final Integer zzl() {
        AtomicReference atomicReference = new AtomicReference();
        zzhd zzhd2 = this.zzs;
        zzhd2 = ((zzgi)zzhd2).zzaA();
        zzie zzie2 = new zzie(this, atomicReference);
        return (Integer)((zzgf)zzhd2).zzd(atomicReference, 15000L, "int test flag value", zzie2);
    }

    public final Long zzm() {
        AtomicReference atomicReference = new AtomicReference();
        zzhd zzhd2 = this.zzs;
        zzhd2 = ((zzgi)zzhd2).zzaA();
        zzid zzid2 = new zzid(this, atomicReference);
        return (Long)((zzgf)zzhd2).zzd(atomicReference, 15000L, "long test flag value", zzid2);
    }

    public final String zzo() {
        return (String)this.zzg.get();
    }

    public final String zzp() {
        zziu zziu2 = ((zzin)((Object)zziu2)).zzs.zzs().zzi();
        if (zziu2 != null) {
            return zziu2.zzb;
        }
        return null;
    }

    public final String zzq() {
        zziu zziu2 = ((zzin)((Object)zziu2)).zzs.zzs().zzi();
        if (zziu2 != null) {
            return zziu2.zza;
        }
        return null;
    }

    public final String zzr() {
        AtomicReference atomicReference = new AtomicReference();
        zzhd zzhd2 = this.zzs;
        zzhd2 = ((zzgi)zzhd2).zzaA();
        zzic zzic2 = new zzic(this, atomicReference);
        return (String)((zzgf)zzhd2).zzd(atomicReference, 15000L, "String test flag value", zzic2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList zzs(String object, String string) {
        if (((zzhb)((Object)this)).zzs.zzaA().zzs()) {
            ((zzhb)((Object)this)).zzs.zzaz().zzd().zza("Cannot get conditional user properties from analytics worker thread");
            return new ArrayList(0);
        }
        ((zzhb)((Object)this)).zzs.zzax();
        if (zzaa.zza()) {
            ((zzhb)((Object)this)).zzs.zzaz().zzd().zza("Cannot get conditional user properties from main thread");
            return new ArrayList(0);
        }
        AtomicReference atomicReference = new AtomicReference();
        zzhd zzhd2 = ((zzin)((Object)this)).zzs;
        zzhd2 = ((zzgi)zzhd2).zzaA();
        zzhy zzhy2 = new zzhy((zzin)((Object)this), atomicReference, null, (String)object, string);
        ((zzgf)zzhd2).zzd(atomicReference, 5000L, "get conditional user properties", zzhy2);
        object = (List)atomicReference.get();
        if (object != null) return zzlp.zzH((List)object);
        ((zzhb)((Object)this)).zzs.zzaz().zzd().zzb("Timed out waiting for get conditional user properties", null);
        return new ArrayList();
    }

    public final List zzt(boolean bl) {
        this.zza();
        this.zzs.zzaz().zzj().zza("Getting user properties (FE)");
        if (!this.zzs.zzaA().zzs()) {
            this.zzs.zzax();
            if (zzaa.zza()) {
                this.zzs.zzaz().zzd().zza("Cannot get all user properties from main thread");
                return Collections.emptyList();
            }
            Object object = new AtomicReference();
            zzhd zzhd2 = this.zzs;
            zzhd2 = ((zzgi)zzhd2).zzaA();
            zzhu zzhu2 = new zzhu(this, (AtomicReference)object, bl);
            ((zzgf)zzhd2).zzd((AtomicReference)object, 5000L, "get user properties", zzhu2);
            object = (List)((AtomicReference)object).get();
            if (object == null) {
                this.zzs.zzaz().zzd().zzb("Timed out waiting for get user properties, includeInternal", bl);
                return Collections.emptyList();
            }
            return object;
        }
        this.zzs.zzaz().zzd().zza("Cannot get all user properties from analytics worker thread");
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Map zzu(String iterator, String object, boolean bl) {
        void var3_5;
        if (((zzhb)object2).zzs.zzaA().zzs()) {
            ((zzhb)object2).zzs.zzaz().zzd().zza("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzhb)object2).zzs.zzax();
        if (zzaa.zza()) {
            ((zzhb)object2).zzs.zzaz().zzd().zza("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        zzhd zzhd2 = ((zzin)object2).zzs;
        zzhd2 = ((zzgi)zzhd2).zzaA();
        zzia zzia2 = new zzia((zzin)object2, atomicReference, null, (String)((Object)iterator), (String)object, (boolean)var3_5);
        ((zzgf)zzhd2).zzd(atomicReference, 5000L, "get user properties", zzia2);
        iterator = (List)atomicReference.get();
        if (iterator == null) {
            ((zzhb)object2).zzs.zzaz().zzd().zzb("Timed out waiting for handle get user properties, includeInternal", (boolean)var3_5);
            return Collections.emptyMap();
        }
        Object object2 = new ArrayMap(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            zzll zzll2 = (zzll)((Object)iterator.next());
            Object object3 = zzll2.zza();
            if (object3 == null) continue;
            object2.put(zzll2.zzb, object3);
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzv(zzin zzin2, zzah zzah2, zzah zzah3) {
        int n;
        zzag[] zzagArray;
        block2: {
            zzagArray = new zzag[]{zzag.zzb, zzag.zza};
            for (n = 0; n < 2; ++n) {
                zzag zzag2 = zzagArray[n];
                if (zzah3.zzi(zzag2) || !zzah2.zzi(zzag2)) continue;
                n = 1;
                break block2;
            }
            n = 0;
        }
        zzagArray = new zzag[]{zzag.zzb, zzag.zza};
        boolean bl = zzah2.zzl(zzah3, zzagArray);
        if (n == 0 && !bl) {
            return;
        }
        zzin2.zzs.zzh().zzo();
    }

    static /* synthetic */ void zzw(zzin zzhd2, zzah atomicReference, int n, long l, boolean bl, boolean bl2) {
        ((zzhb)zzhd2).zzg();
        ((zzf)zzhd2).zza();
        if (l > ((zzin)zzhd2).zzl || !zzah.zzj(((zzin)zzhd2).zzm, n)) {
            zzfn zzfn2 = ((zzhb)zzhd2).zzs.zzm();
            zzgi cfr_ignored_0 = zzfn2.zzs;
            zzfn2.zzg();
            if (zzfn2.zzl(n)) {
                zzfn2 = zzfn2.zza().edit();
                zzfn2.putString("consent_settings", ((zzah)((Object)atomicReference)).zzh());
                zzfn2.putInt("consent_source", n);
                zzfn2.apply();
                ((zzin)zzhd2).zzl = l;
                ((zzin)zzhd2).zzm = n;
                ((zze)zzhd2).zzs.zzt().zzF(bl);
                if (bl2) {
                    zzhd2 = ((zze)zzhd2).zzs;
                    zzhd2 = ((zzgi)zzhd2).zzt();
                    atomicReference = new AtomicReference();
                    ((zzkb)zzhd2).zzu(atomicReference);
                    return;
                }
                return;
            }
            ((zzhb)zzhd2).zzs.zzaz().zzi().zzb("Lower precedence consent source ignored, proposed source", n);
            return;
        }
        ((zzhb)zzhd2).zzs.zzaz().zzi().zzb("Dropped out-of-date consent setting, proposed settings", atomicReference);
    }

    static /* bridge */ /* synthetic */ void zzx(zzin zzin2, Boolean bl, boolean bl2) {
        zzin2.zzad(bl, true);
    }

    static /* bridge */ /* synthetic */ void zzy(zzin zzin2) {
        zzin2.zzae();
    }

    protected zzin(zzgi zzgi2) {
        super(zzgi2);
        Object object = new CopyOnWriteArraySet();
        this.zze = object;
        this.zzh = object = new Object();
        this.zzc = true;
        this.zzn = object = new zzib(this);
        object = new AtomicReference();
        this.zzg = object;
        this.zzi = object = new zzah(null, null);
        this.zzj = 100;
        this.zzl = -1L;
        this.zzm = 100;
        this.zzk = object = new AtomicLong(0L);
        this.zzb = object = new zzr(zzgi2);
    }

    @WorkerThread
    public final void zzz() {
        ((zzhb)this).zzg();
        this.zza();
        if (this.zzs.zzM()) {
            Object object;
            Object object2;
            if (this.zzs.zzf().zzs(null, zzel.zzY)) {
                object2 = this.zzs.zzf();
                ((zzhb)object2).zzs.zzax();
                object2 = ((zzaf)object2).zzk("google_analytics_deferred_deep_link_enabled");
                if (object2 != null && ((Boolean)object2).booleanValue()) {
                    this.zzs.zzaz().zzc().zza("Deferred Deep Link feature enabled.");
                    object2 = this.zzs;
                    object2 = ((zzgi)object2).zzaA();
                    object = new zzhm(this);
                    ((zzgf)object2).zzp((Runnable)object);
                }
            }
            this.zzs.zzt().zzq();
            this.zzc = false;
            object2 = this.zzs.zzm();
            ((zzhb)object2).zzg();
            object = ((zzfn)object2).zza().getString("previous_os_version", null);
            ((zzhb)object2).zzs.zzg().zzu();
            String string = Build.VERSION.RELEASE;
            if (!TextUtils.isEmpty((CharSequence)string) && !string.equals(object)) {
                object2 = ((zzfn)object2).zza().edit();
                object2.putString("previous_os_version", string);
                object2.apply();
            }
            if (!TextUtils.isEmpty((CharSequence)object)) {
                this.zzs.zzg().zzu();
                if (!((String)object).equals(Build.VERSION.RELEASE)) {
                    object2 = new Bundle();
                    object2.putString("_po", (String)object);
                    this.zzH("auto", "_ou", (Bundle)object2);
                    return;
                }
            }
            return;
        }
    }

    public final void zzA(String object, String object2, Bundle bundle) {
        zzgi zzgi2 = this.zzs;
        zzgi2 = zzgi2.zzaw();
        long l = zzgi2.currentTimeMillis();
        Preconditions.checkNotEmpty((String)object);
        zzgi2 = new Bundle();
        zzgi2.putString("name", (String)object);
        zzgi2.putLong("creation_timestamp", l);
        if (object2 != null) {
            zzgi2.putString("expired_event_name", (String)object2);
            zzgi2.putBundle("expired_event_params", bundle);
        }
        object = this.zzs;
        object = ((zzgi)object).zzaA();
        object2 = new zzhx(this, (Bundle)zzgi2);
        ((zzgf)object).zzp((Runnable)object2);
    }

    public final void zzB() {
        if (this.zzs.zzav().getApplicationContext() instanceof Application && this.zza != null) {
            ((Application)this.zzs.zzav().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zza);
            return;
        }
    }

    final /* synthetic */ void zzC(Bundle bundle, long l) {
        this.zzac(bundle, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zzD(Bundle object) {
        Object object2;
        if (object == null) {
            Object object3 = ((zzhb)object3).zzs;
            object3 = ((zzgi)object3).zzm();
            object3 = ((zzfn)object3).zzr;
            object = new Bundle();
            ((zzfi)object3).zzb((Bundle)object);
            return;
        }
        Bundle bundle = ((zzhb)object3).zzs.zzm().zzr.zza();
        for (Object object4 : object.keySet()) {
            object2 = object.get((String)object4);
            if (!(object2 == null || object2 instanceof String || object2 instanceof Long || object2 instanceof Double)) {
                if (((zzhb)object3).zzs.zzv().zzaf(object2)) {
                    ((zzhb)object3).zzs.zzv().zzN(((zzin)object3).zzn, null, 27, null, null, 0);
                }
                ((zzhb)object3).zzs.zzaz().zzl().zzc("Invalid default event parameter type. Name, value", object4, object2);
                continue;
            }
            if (zzlp.zzah((String)object4)) {
                ((zzhb)object3).zzs.zzaz().zzl().zzb("Invalid default event parameter name. Name", object4);
                continue;
            }
            if (object2 == null) {
                bundle.remove((String)object4);
                continue;
            }
            zzhd zzhd2 = ((zzhb)object3).zzs;
            zzhd2 = ((zzgi)zzhd2).zzv();
            ((zzhb)object3).zzs.zzf();
            if (!((zzlp)zzhd2).zzaa("param", (String)object4, 100, object2)) continue;
            ((zzhb)object3).zzs.zzv().zzO(bundle, (String)object4, object2);
        }
        ((zzhb)object3).zzs.zzv();
        int n = ((zzhb)object3).zzs.zzf().zzc();
        if (bundle.size() > n) {
            Object object4;
            object = new TreeSet(bundle.keySet());
            object4 = object.iterator();
            int n2 = 0;
            while (object4.hasNext()) {
                object2 = (String)object4.next();
                if (++n2 <= n) continue;
                bundle.remove((String)object2);
            }
            ((zzhb)object3).zzs.zzv().zzN(((zzin)object3).zzn, null, 26, null, null, 0);
            ((zzhb)object3).zzs.zzaz().zzl().zza("Too many default event parameters set. Discarding beyond event parameter limit");
        }
        ((zzhb)object3).zzs.zzm().zzr.zzb(bundle);
        ((zze)object3).zzs.zzt().zzH(bundle);
    }

    public final void zzE(String string, String string2, Bundle bundle) {
        this.zzF(string, string2, bundle, true, true, this.zzs.zzaw().currentTimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzF(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        if (string == null) {
            string = "app";
        }
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (zzlp.zzal(string2, "screen_view")) {
            this.zzs.zzs().zzx(bundle, l);
            return;
        }
        boolean bl3 = bl2 ? (this.zzd != null ? zzlp.zzah(string2) : true) : true;
        this.zzN(string, string2, l, bundle, bl2, bl3, bl, null);
    }

    public final void zzG(String string, String string2, Bundle bundle, String string3) {
        zzgi.zzO();
        this.zzN("auto", string2, this.zzs.zzaw().currentTimeMillis(), bundle, false, true, true, string3);
    }

    @WorkerThread
    final void zzH(String string, String string2, Bundle bundle) {
        ((zzhb)this).zzg();
        this.zzI(string, string2, this.zzs.zzaw().currentTimeMillis(), bundle);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzI(String string, String string2, long l, Bundle bundle) {
        ((zzhb)this).zzg();
        boolean bl = this.zzd != null ? zzlp.zzah(string2) : true;
        this.zzJ(string, string2, l, bundle, true, bl, true, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    protected final void zzJ(String object, String string, long l, Bundle object2, boolean n, boolean bl, boolean bl2, String string2) {
        int n2;
        int n3;
        Object object32;
        block53: {
            block54: {
                Object[] objectArray;
                Preconditions.checkNotEmpty((String)object);
                Preconditions.checkNotNull((Object)object2);
                ((zzhb)zzhd2).zzg();
                ((zzf)zzhd2).zza();
                if (!((zzin)zzhd2).zzs.zzJ()) {
                    ((zzhb)zzhd2).zzs.zzaz().zzc().zza("Event not sent since app measurement is disabled");
                    return;
                }
                Object object4 = ((zze)zzhd2).zzs.zzh().zzn();
                if (object4 != null && !object4.contains(string)) {
                    ((zzhb)zzhd2).zzs.zzaz().zzc().zzc("Dropping non-safelisted event. event name, origin", string, object);
                    return;
                }
                if (!((zzin)zzhd2).zzf) {
                    GenericDeclaration genericDeclaration;
                    ((zzin)zzhd2).zzf = true;
                    boolean bl3 = ((zzin)zzhd2).zzs.zzN();
                    if (bl3) {
                        genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                        genericDeclaration = Class.forName((String)((Object)genericDeclaration));
                    }
                    genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                    objectArray = ((zzhb)zzhd2).zzs.zzav();
                    genericDeclaration = Class.forName((String)((Object)genericDeclaration), true, objectArray.getClassLoader());
                    try {
                        objectArray = new Class[]{Context.class};
                        genericDeclaration = ((Class)genericDeclaration).getDeclaredMethod("initialize", (Class<?>[])objectArray);
                        objectArray = new Object[1];
                        object32 = ((zzhb)zzhd2).zzs.zzav();
                        objectArray[0] = object32;
                        ((Method)genericDeclaration).invoke(null, objectArray);
                    }
                    catch (Exception exception) {
                        try {
                            ((zzhb)zzhd2).zzs.zzaz().zzk().zzb("Failed to invoke Tag Manager's initialize() method", exception);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            ((zzhb)zzhd2).zzs.zzaz().zzi().zza("Tag Manager is not found and thus will not be used");
                        }
                    }
                }
                if ("_cmp".equals(string) && object2.containsKey("gclid")) {
                    ((zzhb)zzhd2).zzs.zzax();
                    ((zzin)zzhd2).zzaa("auto", "_lgclid", object2.getString("gclid"), ((zzhb)zzhd2).zzs.zzaw().currentTimeMillis());
                }
                ((zzhb)zzhd2).zzs.zzax();
                if (n != 0 && zzlp.zzam(string)) {
                    ((zzhb)zzhd2).zzs.zzv().zzL((Bundle)object2, ((zzhb)zzhd2).zzs.zzm().zzr.zza());
                }
                if (!bl2) {
                    ((zzhb)zzhd2).zzs.zzax();
                    if (!"_iap".equals(string)) {
                        int n4;
                        object4 = ((zzin)zzhd2).zzs.zzv();
                        if (!((zzlp)object4).zzac("event", string)) {
                            n4 = 2;
                        } else if (!((zzlp)object4).zzZ("event", zzhf.zza, zzhf.zzb, string)) {
                            n4 = 13;
                        } else {
                            ((zzhb)object4).zzs.zzf();
                            n4 = !((zzlp)object4).zzY("event", 40, string) ? 2 : 0;
                        }
                        if (n4 != 0) {
                            ((zzhb)zzhd2).zzs.zzaz().zze().zzb("Invalid public event name. Event will not be logged (FE)", ((zzhb)zzhd2).zzs.zzj().zzd(string));
                            object = ((zzin)zzhd2).zzs;
                            object = ((zzgi)object).zzv();
                            ((zzin)zzhd2).zzs.zzf();
                            object2 = ((zzlp)object).zzD(string, 40, true);
                            int n5 = string != null ? string.length() : 0;
                            ((zzin)zzhd2).zzs.zzv().zzN(((zzin)zzhd2).zzn, null, n4, "_ev", (String)object2, n5);
                            return;
                        }
                    }
                }
                zzpm.zzc();
                if (((zzhb)zzhd2).zzs.zzf().zzs(null, zzel.zzat)) {
                    ((zzhb)zzhd2).zzs.zzax();
                    objectArray = ((zze)zzhd2).zzs.zzs().zzj(false);
                    if (objectArray != null && !object2.containsKey("_sc")) {
                        objectArray.zzd = true;
                    }
                    n3 = n != 0 ? (!bl2 ? 1 : 0) : 0;
                    zzlp.zzK((zziu)objectArray, (Bundle)object2, n3 != 0);
                } else {
                    ((zzhb)zzhd2).zzs.zzax();
                    objectArray = ((zze)zzhd2).zzs.zzs().zzj(false);
                    if (objectArray != null && !object2.containsKey("_sc")) {
                        objectArray.zzd = true;
                    }
                    n3 = n != 0 ? (!bl2 ? 1 : 0) : 0;
                    zzlp.zzK((zziu)objectArray, (Bundle)object2, n3 != 0);
                }
                n3 = "am".equals(object);
                boolean bl4 = zzlp.zzah(string);
                if (n == 0) break block54;
                if (((zzin)zzhd2).zzd != null) {
                    if (!bl4) {
                        if (n3 == 0) {
                            ((zzhb)zzhd2).zzs.zzaz().zzc().zzc("Passing event to registered event handler (FE)", ((zzhb)zzhd2).zzs.zzj().zzd(string), ((zzhb)zzhd2).zzs.zzj().zzb((Bundle)object2));
                            Preconditions.checkNotNull((Object)((zzin)zzhd2).zzd);
                            ((zzin)zzhd2).zzd.interceptEvent((String)object, string, (Bundle)object2, l);
                            return;
                        }
                        n = 1;
                        break block53;
                    } else {
                        n = n3;
                    }
                    break block53;
                } else {
                    n = n3;
                }
                break block53;
            }
            n = n3;
        }
        if (!((zzin)zzhd2).zzs.zzM()) {
            return;
        }
        n3 = ((zzhb)zzhd2).zzs.zzv().zzh(string);
        if (n3 != 0) {
            ((zzhb)zzhd2).zzs.zzaz().zze().zzb("Invalid event name. Event will not be logged (FE)", ((zzhb)zzhd2).zzs.zzj().zzd(string));
            object = ((zzhb)zzhd2).zzs;
            object = ((zzgi)object).zzv();
            ((zzhb)zzhd2).zzs.zzf();
            object2 = ((zzlp)object).zzD(string, 40, true);
            int n6 = string != null ? string.length() : 0;
            ((zzin)zzhd2).zzs.zzv().zzN(((zzin)zzhd2).zzn, string2, n3, "_ev", (String)object2, n6);
            return;
        }
        String[] stringArray = new String[]{"_o", "_sn", "_sc", "_si"};
        stringArray = CollectionUtils.listOf((Object[])stringArray);
        stringArray = ((zzhb)zzhd2).zzs.zzv().zzy(string2, string, (Bundle)object2, (List)stringArray, bl2);
        Preconditions.checkNotNull((Object)stringArray);
        ((zzhb)zzhd2).zzs.zzax();
        if (((zze)zzhd2).zzs.zzs().zzj(false) != null && "_ae".equals(string)) {
            object2 = ((zze)zzhd2).zzs.zzu().zzb;
            long l2 = ((zzkp)object2).zzc.zzs.zzaw().elapsedRealtime();
            long l3 = l2 - ((zzkp)object2).zzb;
            ((zzkp)object2).zzb = l2;
            if (l3 > 0L) {
                ((zzhb)zzhd2).zzs.zzv().zzI((Bundle)stringArray, l3);
            }
        }
        zzoc.zzc();
        if (((zzhb)zzhd2).zzs.zzf().zzs(null, zzel.zzad)) {
            if (!"auto".equals(object) && "_ssr".equals(string)) {
                zzlp zzlp2 = ((zzhb)zzhd2).zzs.zzv();
                object2 = stringArray.getString("_ffr");
                if (Strings.isEmptyOrWhitespace((String)object2)) {
                    object2 = null;
                } else if (object2 != null) {
                    object2 = ((String)object2).trim();
                }
                if (zzlp.zzal((String)object2, zzlp2.zzs.zzm().zzo.zza())) {
                    zzlp2.zzs.zzaz().zzc().zza("Not logging duplicate session_start_with_rollout event");
                    return;
                }
                zzlp2.zzs.zzm().zzo.zzb((String)object2);
            } else if ("_ae".equals(string) && !TextUtils.isEmpty((CharSequence)(object2 = ((zzhb)zzhd2).zzs.zzv().zzs.zzm().zzo.zza()))) {
                stringArray.putString("_ffr", (String)object2);
            }
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        arrayList.add((Bundle)stringArray);
        if (((zzhb)zzhd2).zzs.zzm().zzj.zza() > 0L && ((zzhb)zzhd2).zzs.zzm().zzk(l) && ((zzhb)zzhd2).zzs.zzm().zzl.zzb()) {
            ((zzhb)zzhd2).zzs.zzaz().zzj().zza("Current session is expired, remove the session number, ID, and engagement time");
            ((zzin)zzhd2).zzaa("auto", "_sid", null, ((zzhb)zzhd2).zzs.zzaw().currentTimeMillis());
            ((zzin)zzhd2).zzaa("auto", "_sno", null, ((zzhb)zzhd2).zzs.zzaw().currentTimeMillis());
            ((zzin)zzhd2).zzaa("auto", "_se", null, ((zzhb)zzhd2).zzs.zzaw().currentTimeMillis());
        }
        if (stringArray.getLong("extend_session", 0L) == 1L) {
            ((zzhb)zzhd2).zzs.zzaz().zzj().zza("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
            ((zzin)zzhd2).zzs.zzu().zza.zzb(l, true);
        }
        object32 = new ArrayList(stringArray.keySet());
        Collections.sort(object32);
        int n7 = object32.size();
        for (n2 = 0; n2 < n7; ++n2) {
            String string3 = (String)object32.get(n2);
            if (string3 == null) continue;
            ((zzhb)zzhd2).zzs.zzv();
            Object object5 = stringArray.get(string3);
            if (object5 instanceof Bundle) {
                Bundle[] bundleArray = new Bundle[]{(Bundle)object5};
                object5 = bundleArray;
            } else if (object5 instanceof Parcelable[]) {
                object5 = (Parcelable[])object5;
                object5 = (Bundle[])Arrays.copyOf(object5, ((Parcelable[])object5).length, Bundle[].class);
            } else if (object5 instanceof ArrayList) {
                object5 = (ArrayList)object5;
                object5 = ((ArrayList)object5).toArray(new Bundle[((ArrayList)object5).size()]);
            } else {
                object5 = null;
            }
            if (object5 == null) continue;
            stringArray.putParcelableArray(string3, (Parcelable[])object5);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            stringArray = (Bundle)arrayList.get(n2);
            String string4 = n2 != 0 ? "_ep" : string;
            stringArray.putString("_o", (String)object);
            if (bl) {
                stringArray = ((zzhb)zzhd2).zzs.zzv().zzt((Bundle)stringArray);
            }
            zzat zzat2 = new zzat((Bundle)stringArray);
            object32 = new zzav(string4, zzat2, (String)object, l);
            ((zze)zzhd2).zzs.zzt().zzA((zzav)((Object)object32), string2);
            if (n != 0) continue;
            for (Object object32 : ((zzin)zzhd2).zze) {
                object32 = (zzhj)object32;
                zzat2 = new Bundle((Bundle)stringArray);
                object32.onEvent((String)object, string, (Bundle)zzat2, l);
            }
        }
        ((zzhb)zzhd2).zzs.zzax();
        if (((zze)zzhd2).zzs.zzs().zzj(false) != null && "_ae".equals(string)) {
            object = ((zze)zzhd2).zzs;
            object = ((zzgi)object).zzu();
            zzhd zzhd2 = ((zzhb)zzhd2).zzs;
            zzhd2 = ((zzgi)zzhd2).zzaw();
            l = zzhd2.elapsedRealtime();
            ((zzkr)object).zzb.zzd(true, true, l);
            return;
        }
    }

    public final void zzK(zzhj zzhj2) {
        this.zza();
        Preconditions.checkNotNull((Object)zzhj2);
        if (!this.zze.add(zzhj2)) {
            this.zzs.zzaz().zzk().zza("OnEventListener already registered");
            return;
        }
    }

    public final void zzL(long l) {
        this.zzg.set(null);
        zzhd zzhd2 = this.zzs;
        zzhd2 = ((zzgi)zzhd2).zzaA();
        zzhv zzhv2 = new zzhv(this, l);
        ((zzgf)zzhd2).zzp(zzhv2);
    }

    final void zzM(long l, boolean bl) {
        ((zzhb)this).zzg();
        this.zza();
        this.zzs.zzaz().zzc().zza("Resetting analytics data (FE)");
        zzkr zzkr2 = this.zzs.zzu();
        ((zzhb)zzkr2).zzg();
        zzkq cfr_ignored_0 = zzkr2.zza;
        zzkr2.zzb.zza();
        boolean bl2 = this.zzs.zzJ();
        zzfn zzfn2 = this.zzs.zzm();
        zzfn2.zzc.zzb(l);
        if (!TextUtils.isEmpty((CharSequence)zzfn2.zzs.zzm().zzo.zza())) {
            zzfn2.zzo.zzb(null);
        }
        zzol.zzc();
        if (zzfn2.zzs.zzf().zzs(null, zzel.zzae)) {
            zzfn2.zzj.zzb(0L);
        }
        if (!zzfn2.zzs.zzf().zzv()) {
            zzfn2.zzi(bl2 ^ true);
        }
        zzfn2.zzp.zzb(null);
        zzfn2.zzq.zzb(0L);
        zzfn2.zzr.zzb(null);
        if (bl) {
            this.zzs.zzt().zzC();
        }
        zzol.zzc();
        if (this.zzs.zzf().zzs(null, zzel.zzae)) {
            this.zzs.zzu().zza.zza();
        }
        this.zzc = bl2 ^ true;
    }

    protected final void zzN(String string, String string2, long l, Bundle object2, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle = new Bundle((Bundle)object2);
        for (Object object2 : bundle.keySet()) {
            Bundle bundle2;
            Object object3;
            Object object4 = bundle.get((String)object2);
            if (object4 instanceof Bundle) {
                object3 = new Bundle((Bundle)object4);
                bundle.putBundle((String)object2, object3);
                continue;
            }
            if (object4 instanceof Parcelable[]) {
                object4 = (Parcelable[])object4;
                for (int i = 0; i < ((Parcelable[])object4).length; ++i) {
                    object3 = object4[i];
                    if (!(object3 instanceof Bundle)) continue;
                    bundle2 = new Bundle(object3);
                    object4[i] = bundle2;
                }
                continue;
            }
            if (!(object4 instanceof List)) continue;
            object4 = (List)object4;
            for (int i = 0; i < object4.size(); ++i) {
                object3 = object4.get(i);
                if (!(object3 instanceof Bundle)) continue;
                bundle2 = new Bundle(object3);
                object4.set(i, bundle2);
            }
        }
        object2 = this.zzs;
        object2 = ((zzgi)object2).zzaA();
        Object object5 = new zzhs(this, string, string2, l, bundle, bl, bl2, bl3, string3);
        ((zzgf)object2).zzp((Runnable)object5);
    }

    final void zzO(String string, String string2, long l, Object object) {
        zzhd zzhd2 = this.zzs;
        zzhd2 = ((zzgi)zzhd2).zzaA();
        zzht zzht2 = new zzht(this, string, string2, object, l);
        ((zzgf)zzhd2).zzp(zzht2);
    }

    final void zzP(String string) {
        this.zzg.set(string);
    }

    public final void zzQ(Bundle bundle) {
        this.zzR(bundle, this.zzs.zzaw().currentTimeMillis());
    }

    public final void zzR(Bundle object, long l) {
        Preconditions.checkNotNull((Object)object);
        Bundle bundle = new Bundle((Bundle)object);
        if (!TextUtils.isEmpty((CharSequence)bundle.getString("app_id"))) {
            this.zzs.zzaz().zzk().zza("Package name should be null when calling setConditionalUserProperty");
        }
        bundle.remove("app_id");
        Preconditions.checkNotNull((Object)bundle);
        zzhe.zza((Bundle)bundle, (String)"app_id", String.class, null);
        zzhe.zza((Bundle)bundle, (String)"origin", String.class, null);
        zzhe.zza((Bundle)bundle, (String)"name", String.class, null);
        zzhe.zza((Bundle)bundle, (String)"value", Object.class, null);
        zzhe.zza((Bundle)bundle, (String)"trigger_event_name", String.class, null);
        object = 0L;
        zzhe.zza((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)object);
        zzhe.zza((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
        zzhe.zza((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
        zzhe.zza((Bundle)bundle, (String)"triggered_event_name", String.class, null);
        zzhe.zza((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
        zzhe.zza((Bundle)bundle, (String)"time_to_live", Long.class, (Object)object);
        zzhe.zza((Bundle)bundle, (String)"expired_event_name", String.class, null);
        zzhe.zza((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
        Preconditions.checkNotNull((Object)bundle.get("value"));
        bundle.putLong("creation_timestamp", l);
        object = bundle.getString("name");
        Object object2 = bundle.get("value");
        if (this.zzs.zzv().zzl((String)object) == 0) {
            if (this.zzs.zzv().zzd((String)object, object2) == 0) {
                Object object3 = this.zzs.zzv().zzB((String)object, object2);
                if (object3 == null) {
                    this.zzs.zzaz().zzd().zzc("Unable to normalize conditional user property value", this.zzs.zzj().zzf((String)object), object2);
                    return;
                }
                zzhe.zzb((Bundle)bundle, (Object)object3);
                long l2 = bundle.getLong("trigger_timeout");
                if (!TextUtils.isEmpty((CharSequence)bundle.getString("trigger_event_name"))) {
                    this.zzs.zzf();
                    if (l2 > 15552000000L || l2 < 1L) {
                        this.zzs.zzaz().zzd().zzc("Invalid conditional user property timeout", this.zzs.zzj().zzf((String)object), l2);
                        return;
                    }
                }
                long l3 = bundle.getLong("time_to_live");
                this.zzs.zzf();
                if (l3 > 15552000000L || l3 < 1L) {
                    this.zzs.zzaz().zzd().zzc("Invalid conditional user property time to live", this.zzs.zzj().zzf((String)object), l3);
                    return;
                }
                object = this.zzs;
                object = ((zzgi)object).zzaA();
                object2 = new zzhw(this, bundle);
                ((zzgf)object).zzp((Runnable)object2);
                return;
            }
            this.zzs.zzaz().zzd().zzc("Invalid conditional user property value", this.zzs.zzj().zzf((String)object), object2);
            return;
        }
        this.zzs.zzaz().zzd().zzb("Invalid conditional user property name", this.zzs.zzj().zzf((String)object));
    }

    public final void zzS(Bundle bundle, int n, long l) {
        this.zza();
        String string = zzah.zzg(bundle);
        if (string != null) {
            this.zzs.zzaz().zzl().zzb("Ignoring invalid consent setting", string);
            this.zzs.zzaz().zzl().zza("Valid consent values are 'granted', 'denied'");
        }
        this.zzT(zzah.zza(bundle), n, l);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzT(zzah zzah2, int n, long l) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        zzah zzah3;
        block9: {
            this.zza();
            if (n != -10 && zzah2.zze() == null && zzah2.zzf() == null) {
                this.zzs.zzaz().zzl().zza("Discarding empty consent settings");
                return;
            }
            Object object = this.zzh;
            // MONITORENTER : object
            zzah3 = this.zzi;
            boolean bl4 = zzah.zzj(n, this.zzj);
            if (bl4) {
                zzah zzah4;
                bl3 = zzah2.zzk(this.zzi);
                bl4 = zzah2.zzi(zzag.zzb);
                bl4 = bl4 ? !(bl4 = (zzah4 = this.zzi).zzi(zzag.zzb)) : false;
                this.zzi = zzah2 = zzah2.zzd(this.zzi);
                this.zzj = n;
                bl2 = bl4;
                bl = true;
                // MONITOREXIT : object
                break block9;
            }
            bl3 = false;
            bl2 = false;
            bl = false;
            {
                catch (Throwable throwable) {}
                {
                    // MONITOREXIT : object
                    throw throwable;
                }
            }
        }
        if (!bl) {
            this.zzs.zzaz().zzi().zzb("Ignoring lower-priority consent settings, proposed settings", zzah2);
            return;
        }
        long l2 = this.zzk.getAndIncrement();
        if (bl3) {
            this.zzg.set(null);
            zzhd zzhd2 = this.zzs;
            zzhd2 = ((zzgi)zzhd2).zzaA();
            zzih zzih2 = new zzih(this, zzah2, l, n, l2, bl2, zzah3);
            ((zzgf)zzhd2).zzq(zzih2);
            return;
        }
        zzii zzii2 = new zzii(this, zzah2, n, l2, bl2, zzah3);
        if (n != 30 && n != -10) {
            this.zzs.zzaA().zzp(zzii2);
            return;
        }
        this.zzs.zzaA().zzq(zzii2);
    }

    public final void zzU(Bundle bundle, long l) {
        zzof.zzc();
        if (this.zzs.zzf().zzs(null, zzel.zzal)) {
            zzhd zzhd2 = this.zzs;
            zzhd2 = ((zzgi)zzhd2).zzaA();
            zzho zzho2 = new zzho(this, bundle, l);
            ((zzgf)zzhd2).zzq(zzho2);
            return;
        }
        this.zzac(bundle, l);
    }

    @WorkerThread
    private final void zzac(Bundle bundle, long l) {
        if (TextUtils.isEmpty((CharSequence)this.zzs.zzh().zzm())) {
            this.zzS(bundle, 0, l);
            return;
        }
        this.zzs.zzaz().zzl().zza("Using developer consent only; google app id found");
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zzV(zzhi zzhi2) {
        zzhi zzhi3;
        ((zzhb)this).zzg();
        this.zza();
        if (zzhi2 != null && zzhi2 != (zzhi3 = this.zzd)) {
            boolean bl = zzhi3 == null;
            Preconditions.checkState((boolean)bl, (Object)"EventInterceptor already set.");
        }
        this.zzd = zzhi2;
    }

    public final void zzW(Boolean bl) {
        this.zza();
        zzhd zzhd2 = this.zzs;
        zzhd2 = ((zzgi)zzhd2).zzaA();
        zzig zzig2 = new zzig(this, bl);
        ((zzgf)zzhd2).zzp(zzig2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzX(zzah zzah2) {
        ((zzhb)this).zzg();
        boolean bl = !zzah2.zzi(zzag.zzb) || !zzah2.zzi(zzag.zza) ? this.zzs.zzt().zzM() : true;
        if (bl != this.zzs.zzK()) {
            this.zzs.zzG(bl);
            Object object = this.zzs.zzm();
            zzgi cfr_ignored_0 = ((zzhb)object).zzs;
            ((zzhb)object).zzg();
            object = ((zzfn)object).zza().contains("measurement_enabled_from_api") ? Boolean.valueOf(((zzfn)object).zza().getBoolean("measurement_enabled_from_api", true)) : null;
            if (!bl || object == null || ((Boolean)object).booleanValue()) {
                this.zzad(bl, false);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzad(Boolean bl, boolean bl2) {
        ((zzhb)this).zzg();
        this.zza();
        this.zzs.zzaz().zzc().zzb("Setting app measurement enabled (FE)", bl);
        this.zzs.zzm().zzh(bl);
        if (bl2) {
            zzfn zzfn2 = this.zzs.zzm();
            zzgi cfr_ignored_0 = zzfn2.zzs;
            zzfn2.zzg();
            zzfn2 = zzfn2.zza().edit();
            if (bl != null) {
                zzfn2.putBoolean("measurement_enabled_from_api", bl);
            } else {
                zzfn2.remove("measurement_enabled_from_api");
            }
            zzfn2.apply();
        }
        if (this.zzs.zzK() || bl != null && !bl.booleanValue()) {
            this.zzae();
            return;
        }
    }

    public final void zzY(String string, String string2, Object object, boolean bl) {
        this.zzZ("auto", "_ldl", object, true, this.zzs.zzaw().currentTimeMillis());
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void zzZ(String object, String string, Object object2, boolean bl, long l) {
        void var5_15;
        void var4_8;
        if (object == null) {
            object = "app";
        }
        if (bl) {
            int n = this.zzs.zzv().zzl(string);
        } else {
            zzlp zzlp2 = this.zzs.zzv();
            if (!zzlp2.zzac("user property", string)) {
                int n = 6;
            } else if (!zzlp2.zzZ("user property", zzhh.zza, null, string)) {
                int n = 15;
            } else {
                zzlp2.zzs.zzf();
                if (!zzlp2.zzY("user property", 24, string)) {
                    int n = 6;
                } else {
                    boolean bl2 = false;
                }
            }
        }
        if (var4_8 != false) {
            object = this.zzs;
            object = ((zzgi)object).zzv();
            this.zzs.zzf();
            object2 = ((zzlp)object).zzD(string, 24, true);
            int n = string != null ? string.length() : 0;
            this.zzs.zzv().zzN(this.zzn, null, (int)var4_8, "_ev", (String)object2, n);
            return;
        }
        if (object2 == null) {
            this.zzO((String)object, string, (long)var5_15, null);
            return;
        }
        int n = this.zzs.zzv().zzd(string, object2);
        if (n != 0) {
            object = this.zzs;
            object = ((zzgi)object).zzv();
            this.zzs.zzf();
            string = ((zzlp)object).zzD(string, 24, true);
            int n2 = object2 instanceof String || object2 instanceof CharSequence ? object2.toString().length() : 0;
            this.zzs.zzv().zzN(this.zzn, null, n, "_ev", string, n2);
            return;
        }
        object2 = this.zzs.zzv().zzB(string, object2);
        if (object2 != null) {
            this.zzO((String)object, string, (long)var5_15, object2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzaa(String string, String string2, Object object, long l) {
        Object object2;
        block6: {
            block7: {
                Preconditions.checkNotEmpty((String)string);
                Preconditions.checkNotEmpty((String)string2);
                ((zzhb)this).zzg();
                this.zza();
                if (!"allow_personalized_ads".equals(string2)) break block7;
                if (object instanceof String && !TextUtils.isEmpty((CharSequence)(object2 = (String)object))) {
                    long l2 = true != "false".equals(((String)object2).toLowerCase(Locale.ENGLISH)) ? 0L : 1L;
                    object2 = l2;
                    object = this.zzs.zzm().zzh;
                    string2 = (Long)object2 == 1L ? "true" : "false";
                    ((zzfm)object).zzb(string2);
                    string2 = "_npa";
                    break block6;
                } else if (object == null) {
                    this.zzs.zzm().zzh.zzb("unset");
                    string2 = "_npa";
                    object2 = object;
                    break block6;
                } else {
                    object2 = object;
                }
                break block6;
            }
            object2 = object;
        }
        if (!this.zzs.zzJ()) {
            this.zzs.zzaz().zzj().zza("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzs.zzM()) {
            return;
        }
        object = new zzll(string2, l, object2, string);
        this.zzs.zzt().zzK((zzll)((Object)object));
    }

    public final void zzab(zzhj zzhj2) {
        this.zza();
        Preconditions.checkNotNull((Object)zzhj2);
        if (!this.zze.remove(zzhj2)) {
            this.zzs.zzaz().zzk().zza("OnEventListener had not been registered");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzae() {
        ((zzhb)this).zzg();
        Object object = this.zzs.zzm().zzh.zza();
        if (object != null) {
            if ("unset".equals(object)) {
                this.zzaa("app", "_npa", null, this.zzs.zzaw().currentTimeMillis());
            } else {
                long l = true != "true".equals(object) ? 0L : 1L;
                this.zzaa("app", "_npa", l, this.zzs.zzaw().currentTimeMillis());
            }
        }
        if (this.zzs.zzJ() && this.zzc) {
            this.zzs.zzaz().zzc().zza("Recording app launch after enabling measurement for the first time (FE)");
            this.zzz();
            zzol.zzc();
            if (this.zzs.zzf().zzs(null, zzel.zzae)) {
                this.zzs.zzu().zza.zza();
            }
            object = this.zzs;
            object = ((zzgi)object).zzaA();
            zzhq zzhq2 = new zzhq(this);
            ((zzgf)object).zzp(zzhq2);
            return;
        }
        this.zzs.zzaz().zzc().zza("Updating Scion state (FE)");
        this.zzs.zzt().zzI();
    }

    @Override
    protected final boolean zzf() {
        return false;
    }
}

