/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.SharedPreferences;
import android.util.Pair;
import androidx.annotation.WorkerThread;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzen;
import com.google.android.gms.measurement.internal.zzfj;
import com.google.android.gms.measurement.internal.zzfk;
import com.google.android.gms.measurement.internal.zzfl;
import com.google.android.gms.measurement.internal.zzfn;
import com.google.android.gms.measurement.internal.zzfo;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzhe;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

final class zzfp
extends zzhe {
    @VisibleForTesting
    static final Pair zza;
    private SharedPreferences zzt;
    public zzfn zzb;
    public final zzfl zzc;
    public final zzfl zzd;
    public final zzfo zze;
    private String zzu;
    private boolean zzv;
    private long zzw;
    public final zzfl zzf;
    public final zzfj zzg;
    public final zzfo zzh;
    public final zzfj zzi;
    public final zzfl zzj;
    public boolean zzk;
    public final zzfj zzl;
    public final zzfj zzm;
    public final zzfl zzn;
    public final zzfo zzo;
    public final zzfo zzp;
    public final zzfl zzq;
    public final zzfk zzr;

    @WorkerThread
    @VisibleForTesting
    protected final SharedPreferences zza() {
        this.zzg();
        this.zzu();
        Preconditions.checkNotNull((Object)this.zzt);
        return this.zzt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    final Pair zzb(String string) {
        this.zzg();
        long l = this.zzs.zzav().elapsedRealtime();
        String string2 = this.zzu;
        if (string2 != null && l < this.zzw) {
            return new Pair((Object)string2, (Object)this.zzv);
        }
        this.zzw = l + this.zzs.zzf().zzi(string, zzen.zza);
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)true);
        try {
            string = this.zzs.zzau();
            string = AdvertisingIdClient.getAdvertisingIdInfo((Context)string);
            this.zzu = "";
            string2 = string.getId();
            if (string2 != null) {
                this.zzu = string2;
            }
            this.zzv = string.isLimitAdTrackingEnabled();
        }
        catch (Exception exception) {
            this.zzs.zzay().zzc().zzb("Unable to get advertising id", exception);
            this.zzu = "";
        }
        AdvertisingIdClient.setShouldSkipGmsCoreVersionCheck((boolean)false);
        return new Pair((Object)this.zzu, (Object)this.zzv);
    }

    @WorkerThread
    final zzai zzc() {
        this.zzg();
        return zzai.zzb(this.zza().getString("consent_settings", "G1"));
    }

    @WorkerThread
    final Boolean zzd() {
        this.zzg();
        if (this.zza().contains("measurement_enabled")) {
            return this.zza().getBoolean("measurement_enabled", true);
        }
        return null;
    }

    static {
        Pair pair;
        zza = pair = new Pair((Object)"", (Object)0L);
    }

    zzfp(zzgk object) {
        super((zzgk)object);
        this.zzf = object = new zzfl(this, "session_timeout", 1800000L);
        this.zzg = object = new zzfj(this, "start_new_session", true);
        this.zzj = object = new zzfl(this, "last_pause_time", 0L);
        this.zzh = object = new zzfo(this, "non_personalized_ads", null);
        this.zzi = object = new zzfj(this, "allow_remote_dynamite", false);
        this.zzc = object = new zzfl(this, "first_open_time", 0L);
        this.zzd = object = new zzfl(this, "app_install_time", 0L);
        this.zze = object = new zzfo(this, "app_instance_id", null);
        this.zzl = object = new zzfj(this, "app_backgrounded", false);
        this.zzm = object = new zzfj(this, "deep_link_retrieval_complete", false);
        this.zzn = object = new zzfl(this, "deep_link_retrieval_attempts", 0L);
        this.zzo = object = new zzfo(this, "firebase_feature_rollouts", null);
        this.zzp = object = new zzfo(this, "deferred_attribution_cache", null);
        this.zzq = object = new zzfl(this, "deferred_attribution_cache_timestamp", 0L);
        this.zzr = object = new zzfk(this, "default_event_parameters", null);
    }

    @Override
    @EnsuresNonNull.List(value={@EnsuresNonNull(value={"this.preferences"}), @EnsuresNonNull(value={"this.monitoringSample"})})
    @WorkerThread
    protected final void zzaA() {
        zzfn zzfn2;
        boolean bl;
        this.zzt = this.zzs.zzau().getSharedPreferences("com.google.android.gms.measurement.prefs", 0);
        this.zzk = bl = this.zzt.getBoolean("has_been_opened", false);
        if (!bl) {
            SharedPreferences.Editor editor = this.zzt.edit();
            editor.putBoolean("has_been_opened", true);
            editor.apply();
        }
        this.zzs.zzf();
        this.zzb = zzfn2 = new zzfn(this, "health_monitor", Math.max(0L, (Long)zzen.zzb.zza(null)), null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzh(Boolean bl) {
        zzfp2.zzg();
        zzfp zzfp2 = zzfp2.zza().edit();
        if (bl != null) {
            zzfp2.putBoolean("measurement_enabled", bl);
        } else {
            zzfp2.remove("measurement_enabled");
        }
        zzfp2.apply();
    }

    @WorkerThread
    final void zzi(boolean bl) {
        zzfp2.zzg();
        zzfp2.zzs.zzay().zzj().zzb("App measurement setting deferred collection", bl);
        zzfp zzfp2 = zzfp2.zza().edit();
        zzfp2.putBoolean("deferred_analytics_collection", bl);
        zzfp2.apply();
    }

    @WorkerThread
    final boolean zzj() {
        zzfp zzfp2 = zzfp2.zzt;
        if (zzfp2 == null) {
            return false;
        }
        return zzfp2.contains("deferred_analytics_collection");
    }

    final boolean zzk(long l) {
        return l - this.zzf.zza() > this.zzj.zza();
    }

    @Override
    protected final boolean zzf() {
        return true;
    }

    @WorkerThread
    final boolean zzl(int n) {
        return zzai.zzj(n, this.zza().getInt("consent_source", 100));
    }
}

