/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.util.Strings;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.measurement.zzos;
import com.google.android.gms.internal.measurement.zzpe;
import com.google.android.gms.internal.measurement.zzqr;
import com.google.android.gms.measurement.internal.zzab;
import com.google.android.gms.measurement.internal.zzag;
import com.google.android.gms.measurement.internal.zzah;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzau;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzeg;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzfi;
import com.google.android.gms.measurement.internal.zzgd;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgz;
import com.google.android.gms.measurement.internal.zzha;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhk;
import com.google.android.gms.measurement.internal.zzhl;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzhr;
import com.google.android.gms.measurement.internal.zzhs;
import com.google.android.gms.measurement.internal.zzht;
import com.google.android.gms.measurement.internal.zzhu;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzhz;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzid;
import com.google.android.gms.measurement.internal.zzie;
import com.google.android.gms.measurement.internal.zzih;
import com.google.android.gms.measurement.internal.zzip;
import com.google.android.gms.measurement.internal.zzkl;
import com.google.android.gms.measurement.internal.zzkm;
import com.google.android.gms.measurement.internal.zzkn;
import com.google.android.gms.measurement.internal.zzli;
import com.google.android.gms.measurement.internal.zzll;
import com.google.android.gms.measurement.internal.zzlm;
import com.google.android.gms.measurement.internal.zzln;
import com.google.android.gms.measurement.internal.zzs;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzii
extends zzf {
    @VisibleForTesting
    protected zzih zza;
    private zzhd zzd;
    private final Set zze = new CopyOnWriteArraySet();
    private boolean zzf;
    private final AtomicReference zzg;
    private final Object zzh = new Object();
    @GuardedBy(value="consentLock")
    private zzai zzi;
    @GuardedBy(value="consentLock")
    private int zzj = 100;
    private final AtomicLong zzk;
    private long zzl = -1L;
    private int zzm = 100;
    final zzs zzb;
    @VisibleForTesting
    protected boolean zzc = true;
    private final zzlm zzn = new zzhx(this);

    public final int zzh(String string) {
        Preconditions.checkNotEmpty((String)string);
        this.zzt.zzf();
        return 25;
    }

    public final Boolean zzi() {
        AtomicReference atomicReference = new AtomicReference();
        zzhu zzhu2 = new zzhu(this, atomicReference);
        return (Boolean)this.zzt.zzaB().zzd(atomicReference, 15000L, "boolean test flag value", zzhu2);
    }

    public final Double zzj() {
        AtomicReference atomicReference = new AtomicReference();
        zzib zzib2 = new zzib(this, atomicReference);
        return (Double)this.zzt.zzaB().zzd(atomicReference, 15000L, "double test flag value", zzib2);
    }

    public final Integer zzl() {
        AtomicReference atomicReference = new AtomicReference();
        zzia zzia2 = new zzia(this, atomicReference);
        return (Integer)this.zzt.zzaB().zzd(atomicReference, 15000L, "int test flag value", zzia2);
    }

    public final Long zzm() {
        AtomicReference atomicReference = new AtomicReference();
        zzhz zzhz2 = new zzhz(this, atomicReference);
        return (Long)this.zzt.zzaB().zzd(atomicReference, 15000L, "long test flag value", zzhz2);
    }

    public final String zzo() {
        return (String)this.zzg.get();
    }

    public final String zzp() {
        zzip zzip2 = ((zzii)((Object)zzip2)).zzt.zzs().zzi();
        if (zzip2 != null) {
            return zzip2.zzb;
        }
        return null;
    }

    public final String zzq() {
        zzip zzip2 = ((zzii)((Object)zzip2)).zzt.zzs().zzi();
        if (zzip2 != null) {
            return zzip2.zza;
        }
        return null;
    }

    public final String zzr() {
        AtomicReference atomicReference = new AtomicReference();
        zzhy zzhy2 = new zzhy(this, atomicReference);
        return (String)this.zzt.zzaB().zzd(atomicReference, 15000L, "String test flag value", zzhy2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ArrayList zzs(String object, String string) {
        if (((zzgw)((Object)this)).zzt.zzaB().zzs()) {
            ((zzgw)((Object)this)).zzt.zzaA().zzd().zza("Cannot get conditional user properties from analytics worker thread");
            return new ArrayList(0);
        }
        ((zzgw)((Object)this)).zzt.zzay();
        if (zzab.zza()) {
            ((zzgw)((Object)this)).zzt.zzaA().zzd().zza("Cannot get conditional user properties from main thread");
            return new ArrayList(0);
        }
        AtomicReference atomicReference = new AtomicReference();
        zzht zzht2 = new zzht((zzii)((Object)this), atomicReference, null, (String)object, string);
        ((zzii)((Object)this)).zzt.zzaB().zzd(atomicReference, 5000L, "get conditional user properties", zzht2);
        object = (List)atomicReference.get();
        if (object != null) return zzln.zzH((List)object);
        ((zzgw)((Object)this)).zzt.zzaA().zzd().zzb("Timed out waiting for get conditional user properties", null);
        return new ArrayList();
    }

    public final List zzt(boolean bl) {
        ((zzf)((Object)bl2)).zza();
        ((zzgw)((Object)bl2)).zzt.zzaA().zzj().zza("Getting user properties (FE)");
        if (!((zzgw)((Object)bl2)).zzt.zzaB().zzs()) {
            ((zzgw)((Object)bl2)).zzt.zzay();
            if (zzab.zza()) {
                ((zzgw)((Object)bl2)).zzt.zzaA().zzd().zza("Cannot get all user properties from main thread");
                return Collections.emptyList();
            }
            Object object = new AtomicReference();
            zzhp zzhp2 = new zzhp((zzii)((Object)bl2), (AtomicReference)object, bl);
            ((zzii)((Object)bl2)).zzt.zzaB().zzd((AtomicReference)object, 5000L, "get user properties", zzhp2);
            object = (List)((AtomicReference)object).get();
            if (object == null) {
                Boolean bl2 = bl;
                ((zzgw)((Object)bl2)).zzt.zzaA().zzd().zzb("Timed out waiting for get user properties, includeInternal", bl2);
                return Collections.emptyList();
            }
            return object;
        }
        ((zzgw)((Object)bl2)).zzt.zzaA().zzd().zza("Cannot get all user properties from analytics worker thread");
        return Collections.emptyList();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Map zzu(String iterator, String object, boolean bl) {
        Object object2;
        void var3_5;
        if (((zzgw)object2).zzt.zzaB().zzs()) {
            ((zzgw)object2).zzt.zzaA().zzd().zza("Cannot get user properties from analytics worker thread");
            return Collections.emptyMap();
        }
        ((zzgw)object2).zzt.zzay();
        if (zzab.zza()) {
            ((zzgw)object2).zzt.zzaA().zzd().zza("Cannot get user properties from main thread");
            return Collections.emptyMap();
        }
        AtomicReference atomicReference = new AtomicReference();
        zzhv zzhv2 = new zzhv((zzii)object2, atomicReference, null, (String)((Object)iterator), (String)object, (boolean)var3_5);
        ((zzii)object2).zzt.zzaB().zzd(atomicReference, 5000L, "get user properties", zzhv2);
        iterator = (List)atomicReference.get();
        if (iterator == null) {
            object2 = (boolean)var3_5;
            ((zzgw)object2).zzt.zzaA().zzd().zzb("Timed out waiting for handle get user properties, includeInternal", object2);
            return Collections.emptyMap();
        }
        object2 = new ArrayMap(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            zzli zzli2 = (zzli)((Object)iterator.next());
            Object object3 = zzli2.zza();
            if (object3 == null) continue;
            object2.put(zzli2.zzb, object3);
        }
        return object2;
    }

    /*
     * Enabled aggressive block sorting
     */
    static /* bridge */ /* synthetic */ void zzv(zzii zzii2, zzai zzai2, zzai zzai3) {
        int n;
        block2: {
            zzah[] zzahArray = new zzah[]{zzah.zzb, zzah.zza};
            for (n = 0; n < 2; ++n) {
                zzah zzah2 = zzahArray[n];
                if (zzai3.zzi(zzah2) || !zzai2.zzi(zzah2)) continue;
                n = 1;
                break block2;
            }
            n = 0;
        }
        boolean bl = zzai2.zzl(zzai3, zzah.zzb, zzah.zza);
        if (n == 0 && !bl) {
            return;
        }
        zzii2.zzt.zzh().zzo();
    }

    static /* synthetic */ void zzw(zzii object, zzai object2, int n, long l, boolean bl, boolean bl2) {
        ((zzgw)object).zzg();
        ((zzf)object).zza();
        if (l > ((zzii)object).zzl || !zzai.zzj(((zzii)object).zzm, n)) {
            zzfi zzfi2 = ((zzgw)object).zzt.zzm();
            zzgd cfr_ignored_0 = zzfi2.zzt;
            zzfi2.zzg();
            if (zzfi2.zzl(n)) {
                SharedPreferences.Editor editor = zzfi2.zza().edit();
                object2 = ((zzai)object2).zzh();
                editor.putString("consent_settings", (String)object2);
                editor.putInt("consent_source", n);
                editor.apply();
                ((zzii)object).zzl = l;
                ((zzii)object).zzm = n;
                ((zze)object).zzt.zzt().zzF(bl);
                if (bl2) {
                    ((zze)object).zzt.zzt().zzu(new AtomicReference());
                    return;
                }
                return;
            }
            object = n;
            ((zzgw)object).zzt.zzaA().zzi().zzb("Lower precedence consent source ignored, proposed source", object);
            return;
        }
        ((zzgw)object).zzt.zzaA().zzi().zzb("Dropped out-of-date consent setting, proposed settings", object2);
    }

    static /* bridge */ /* synthetic */ void zzx(zzii zzii2, Boolean bl, boolean bl2) {
        zzii2.zzaa(bl, true);
    }

    static /* bridge */ /* synthetic */ void zzy(zzii zzii2) {
        zzii2.zzab();
    }

    protected zzii(zzgd zzgd2) {
        super(zzgd2);
        this.zzg = new AtomicReference();
        this.zzi = new zzai(null, null);
        this.zzk = new AtomicLong(0L);
        this.zzb = new zzs(zzgd2);
    }

    @WorkerThread
    public final void zzz() {
        ((zzgw)this).zzg();
        this.zza();
        if (this.zzt.zzM()) {
            Object object;
            if (this.zzt.zzf().zzs(null, zzeg.zzZ)) {
                zzag zzag2 = this.zzt.zzf();
                zzag2.zzt.zzay();
                object = zzag2.zzk("google_analytics_deferred_deep_link_enabled");
                if (object != null && ((Boolean)object).booleanValue()) {
                    this.zzt.zzaA().zzc().zza("Deferred Deep Link feature enabled.");
                    this.zzt.zzaB().zzp(new zzhk(this));
                }
            }
            this.zzt.zzt().zzq();
            this.zzc = false;
            object = this.zzt.zzm();
            ((zzgw)object).zzg();
            String string = ((zzfi)object).zza().getString("previous_os_version", null);
            ((zzgw)object).zzt.zzg().zzv();
            String string2 = Build.VERSION.RELEASE;
            if (!TextUtils.isEmpty((CharSequence)string2) && !string2.equals(string)) {
                SharedPreferences.Editor editor = ((zzfi)object).zza().edit();
                editor.putString("previous_os_version", string2);
                editor.apply();
            }
            if (!TextUtils.isEmpty((CharSequence)string)) {
                this.zzt.zzg().zzv();
                if (!string.equals(Build.VERSION.RELEASE)) {
                    object = new Bundle();
                    object.putString("_po", string);
                    this.zzG("auto", "_ou", (Bundle)object);
                    return;
                }
            }
            return;
        }
    }

    public final void zzA(String string, String string2, Bundle bundle) {
        long l = this.zzt.zzax().currentTimeMillis();
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle2 = new Bundle();
        bundle2.putString("name", string);
        bundle2.putLong("creation_timestamp", l);
        if (string2 != null) {
            bundle2.putString("expired_event_name", string2);
            bundle2.putBundle("expired_event_params", bundle);
        }
        this.zzt.zzaB().zzp(new zzhs(this, bundle2));
    }

    public final void zzB() {
        if (this.zzt.zzaw().getApplicationContext() instanceof Application && this.zza != null) {
            ((Application)this.zzt.zzaw().getApplicationContext()).unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this.zza);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zzC(Bundle bundle) {
        Object object;
        if (bundle == null) {
            this.zzt.zzm().zzs.zzb(new Bundle());
            return;
        }
        Bundle bundle2 = this.zzt.zzm().zzs.zza();
        for (Object object2 : bundle.keySet()) {
            object = bundle.get((String)object2);
            if (!(object == null || object instanceof String || object instanceof Long || object instanceof Double)) {
                if (this.zzt.zzv().zzag(object)) {
                    this.zzt.zzv().zzO(this.zzn, null, 27, null, null, 0);
                }
                this.zzt.zzaA().zzl().zzc("Invalid default event parameter type. Name, value", object2, object);
                continue;
            }
            if (zzln.zzaj((String)object2)) {
                this.zzt.zzaA().zzl().zzb("Invalid default event parameter name. Name", object2);
                continue;
            }
            if (object == null) {
                bundle2.remove((String)object2);
                continue;
            }
            zzln zzln2 = this.zzt.zzv();
            this.zzt.zzf();
            if (!zzln2.zzab("param", (String)object2, 100, object)) continue;
            this.zzt.zzv().zzP(bundle2, (String)object2, object);
        }
        this.zzt.zzv();
        int n = this.zzt.zzf().zzc();
        if (bundle2.size() > n) {
            Object object2;
            object2 = new TreeSet(bundle2.keySet()).iterator();
            int n2 = 0;
            while (object2.hasNext()) {
                object = (String)object2.next();
                if (++n2 <= n) continue;
                bundle2.remove((String)object);
            }
            this.zzt.zzv().zzO(this.zzn, null, 26, null, null, 0);
            this.zzt.zzaA().zzl().zza("Too many default event parameters set. Discarding beyond event parameter limit");
        }
        this.zzt.zzm().zzs.zzb(bundle2);
        this.zzt.zzt().zzH(bundle2);
    }

    public final void zzD(String string, String string2, Bundle bundle) {
        this.zzE(string, string2, bundle, true, true, this.zzt.zzax().currentTimeMillis());
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void zzE(String string, String string2, Bundle bundle, boolean bl, boolean bl2, long l) {
        String string3;
        if (bundle == null) {
            bundle = new Bundle();
        }
        if (!(string2 == (string3 = "screen_view") || string2 != null && string2.equals(string3))) {
            boolean bl3 = bl2 ? (this.zzd != null ? zzln.zzaj(string2) : true) : true;
            if (string == null) {
                string = "app";
            }
            this.zzM(string, string2, l, bundle, bl2, bl3, bl, null);
            return;
        }
        this.zzt.zzs().zzx(bundle, l);
    }

    public final void zzF(String string, String string2, Bundle bundle, String string3) {
        zzgd.zzO();
        long l = this.zzt.zzax().currentTimeMillis();
        this.zzM("auto", string2, l, bundle, false, true, true, string3);
    }

    @WorkerThread
    final void zzG(String string, String string2, Bundle bundle) {
        ((zzgw)this).zzg();
        zzii zzii2 = this;
        zzii2.zzH(string, string2, zzii2.zzt.zzax().currentTimeMillis(), bundle);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzH(String string, String string2, long l, Bundle bundle) {
        ((zzgw)this).zzg();
        boolean bl = this.zzd != null ? zzln.zzaj(string2) : true;
        this.zzI(string, string2, l, bundle, true, bl, true, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    protected final void zzI(String string, String string2, long l, Bundle object, boolean n, boolean bl, boolean bl2, String string3) {
        int n2;
        int n3;
        long l2;
        Object object2;
        block50: {
            block51: {
                Object[] objectArray;
                Preconditions.checkNotEmpty((String)string);
                Preconditions.checkNotNull((Object)object);
                ((zzgw)this).zzg();
                this.zza();
                if (!this.zzt.zzJ()) {
                    this.zzt.zzaA().zzc().zza("Event not sent since app measurement is disabled");
                    return;
                }
                Object object3 = this.zzt.zzh().zzn();
                if (object3 != null && !object3.contains(string2)) {
                    this.zzt.zzaA().zzc().zzc("Dropping non-safelisted event. event name, origin", string2, string);
                    return;
                }
                if (!this.zzf) {
                    GenericDeclaration genericDeclaration;
                    this.zzf = true;
                    boolean bl3 = this.zzt.zzN();
                    if (bl3) {
                        genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                        genericDeclaration = Class.forName((String)((Object)genericDeclaration));
                    }
                    genericDeclaration = "com.google.android.gms.tagmanager.TagManagerService";
                    objectArray = this.zzt.zzaw();
                    genericDeclaration = Class.forName((String)((Object)genericDeclaration), true, objectArray.getClassLoader());
                    try {
                        genericDeclaration = ((Class)genericDeclaration).getDeclaredMethod("initialize", Context.class);
                        objectArray = new Object[1];
                        object2 = this.zzt.zzaw();
                        objectArray[0] = object2;
                        ((Method)genericDeclaration).invoke(null, objectArray);
                    }
                    catch (Exception exception) {
                        try {
                            this.zzt.zzaA().zzk().zzb("Failed to invoke Tag Manager's initialize() method", exception);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            this.zzt.zzaA().zzi().zza("Tag Manager is not found and thus will not be used");
                        }
                    }
                }
                if ("_cmp".equals(string2) && object.containsKey("gclid")) {
                    this.zzt.zzay();
                    object3 = object.getString("gclid");
                    l2 = this.zzt.zzax().currentTimeMillis();
                    this.zzY("auto", "_lgclid", object3, l2);
                }
                this.zzt.zzay();
                if (n != 0 && zzln.zzan(string2)) {
                    this.zzt.zzv().zzL((Bundle)object, this.zzt.zzm().zzs.zza());
                }
                if (!bl2) {
                    this.zzt.zzay();
                    if (!"_iap".equals(string2)) {
                        int n4;
                        object3 = this.zzt.zzv();
                        if (!((zzln)object3).zzad("event", string2)) {
                            n4 = 2;
                        } else if (!((zzln)object3).zzaa("event", zzha.zza, zzha.zzb, string2)) {
                            n4 = 13;
                        } else {
                            ((zzgw)object3).zzt.zzf();
                            n4 = !((zzln)object3).zzZ("event", 40, string2) ? 2 : 0;
                        }
                        if (n4 != 0) {
                            string = this.zzt.zzj().zzd(string2);
                            this.zzt.zzaA().zze().zzb("Invalid public event name. Event will not be logged (FE)", string);
                            zzln zzln2 = this.zzt.zzv();
                            this.zzt.zzf();
                            object = zzln2.zzD(string2, 40, true);
                            int n5 = string2 != null ? string2.length() : 0;
                            this.zzt.zzv().zzO(this.zzn, null, n4, "_ev", (String)object, n5);
                            return;
                        }
                    }
                }
                this.zzt.zzay();
                objectArray = this.zzt.zzs().zzj(false);
                if (objectArray != null && !object.containsKey("_sc")) {
                    objectArray.zzd = true;
                }
                n3 = n != 0 ? (!bl2 ? 1 : 0) : 0;
                zzln.zzK((zzip)objectArray, (Bundle)object, n3 != 0);
                n3 = "am".equals(string);
                boolean bl4 = zzln.zzaj(string2);
                if (n == 0) break block51;
                if (this.zzd != null) {
                    if (!bl4) {
                        if (n3 == 0) {
                            String string4 = this.zzt.zzj().zzd(string2);
                            String string5 = this.zzt.zzj().zzb((Bundle)object);
                            this.zzt.zzaA().zzc().zzc("Passing event to registered event handler (FE)", string4, string5);
                            Preconditions.checkNotNull((Object)this.zzd);
                            this.zzd.interceptEvent(string, string2, (Bundle)object, l);
                            return;
                        }
                        n = 1;
                        break block50;
                    } else {
                        n = n3;
                    }
                    break block50;
                } else {
                    n = n3;
                }
                break block50;
            }
            n = n3;
        }
        if (!this.zzt.zzM()) {
            return;
        }
        n3 = this.zzt.zzv().zzh(string2);
        if (n3 != 0) {
            string = this.zzt.zzj().zzd(string2);
            this.zzt.zzaA().zze().zzb("Invalid event name. Event will not be logged (FE)", string);
            zzln zzln3 = this.zzt.zzv();
            this.zzt.zzf();
            object = zzln3.zzD(string2, 40, true);
            int n6 = string2 != null ? string2.length() : 0;
            this.zzt.zzv().zzO(this.zzn, string3, n3, "_ev", (String)object, n6);
            return;
        }
        Object object4 = "_o";
        object4 = CollectionUtils.listOf((Object[])new String[]{object4, "_sn", "_sc", "_si"});
        object4 = this.zzt.zzv().zzu(string3, string2, (Bundle)object, (List)object4, bl2);
        Preconditions.checkNotNull((Object)object4);
        this.zzt.zzay();
        if (this.zzt.zzs().zzj(false) != null && "_ae".equals(string2)) {
            object = this.zzt.zzu().zzb;
            long l3 = ((zzkl)object).zzc.zzt.zzax().elapsedRealtime();
            long l4 = l3 - ((zzkl)object).zzb;
            ((zzkl)object).zzb = l3;
            if (l4 > 0L) {
                this.zzt.zzv().zzI((Bundle)object4, l4);
            }
        }
        zzos.zzc();
        if (this.zzt.zzf().zzs(null, zzeg.zzae)) {
            if (!"auto".equals(string) && "_ssr".equals(string2)) {
                zzln zzln4 = this.zzt.zzv();
                object = object4.getString("_ffr");
                if (Strings.isEmptyOrWhitespace((String)object)) {
                    object = null;
                } else if (object != null) {
                    object = ((String)object).trim();
                }
                if (zzll.zza(object, zzln4.zzt.zzm().zzp.zza())) {
                    zzln4.zzt.zzaA().zzc().zza("Not logging duplicate session_start_with_rollout event");
                    return;
                }
                zzln4.zzt.zzm().zzp.zzb((String)object);
            } else if ("_ae".equals(string2) && !TextUtils.isEmpty((CharSequence)(object = this.zzt.zzv().zzt.zzm().zzp.zza()))) {
                object4.putString("_ffr", (String)object);
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(object4);
        if (this.zzt.zzm().zzj.zza() > 0L && this.zzt.zzm().zzk(l) && this.zzt.zzm().zzm.zzb()) {
            this.zzt.zzaA().zzj().zza("Current session is expired, remove the session number, ID, and engagement time");
            l2 = this.zzt.zzax().currentTimeMillis();
            this.zzY("auto", "_sid", null, l2);
            l2 = this.zzt.zzax().currentTimeMillis();
            this.zzY("auto", "_sno", null, l2);
            l2 = this.zzt.zzax().currentTimeMillis();
            this.zzY("auto", "_se", null, l2);
            this.zzt.zzm().zzk.zzb(0L);
        }
        if (object4.getLong("extend_session", 0L) == 1L) {
            this.zzt.zzaA().zzj().zza("EXTEND_SESSION param attached: initiate a new session or extend the current active session");
            this.zzt.zzu().zza.zzb(l, true);
        }
        object2 = new ArrayList(object4.keySet());
        Collections.sort(object2);
        int n7 = object2.size();
        for (n2 = 0; n2 < n7; ++n2) {
            String string6 = (String)object2.get(n2);
            if (string6 == null) continue;
            this.zzt.zzv();
            Bundle[] bundleArray = object4.get(string6);
            if (bundleArray instanceof Bundle) {
                bundleArray = new Bundle[]{(Bundle)bundleArray};
            } else if (bundleArray instanceof Parcelable[]) {
                Parcelable[] parcelableArray = (Parcelable[])bundleArray;
                bundleArray = (Bundle[])Arrays.copyOf(parcelableArray, parcelableArray.length, Bundle[].class);
            } else if (bundleArray instanceof ArrayList) {
                ArrayList arrayList2 = (ArrayList)bundleArray;
                bundleArray = arrayList2.toArray(new Bundle[arrayList2.size()]);
            } else {
                bundleArray = null;
            }
            if (bundleArray == null) continue;
            object4.putParcelableArray(string6, (Parcelable[])bundleArray);
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            object4 = (Bundle)arrayList.get(n2);
            Object object5 = n2 != 0 ? "_ep" : string2;
            object4.putString("_o", string);
            if (bl) {
                object4 = this.zzt.zzv().zzt((Bundle)object4);
            }
            object2 = new zzaw((String)object5, new zzau((Bundle)object4), string, l);
            this.zzt.zzt().zzA((zzaw)((Object)object2), string3);
            if (n != 0) continue;
            object5 = this.zze.iterator();
            while (object5.hasNext()) {
                ((zzhe)object5.next()).onEvent(string, string2, new Bundle((Bundle)object4), l);
            }
        }
        this.zzt.zzay();
        if (this.zzt.zzs().zzj(false) != null && "_ae".equals(string2)) {
            l = this.zzt.zzax().elapsedRealtime();
            this.zzt.zzu().zzb.zzd(true, true, l);
            return;
        }
    }

    public final void zzJ(zzhe zzhe2) {
        this.zza();
        Preconditions.checkNotNull((Object)zzhe2);
        if (!this.zze.add(zzhe2)) {
            this.zzt.zzaA().zzk().zza("OnEventListener already registered");
            return;
        }
    }

    public final void zzK(long l) {
        this.zzg.set(null);
        this.zzt.zzaB().zzp(new zzhq(this, l));
    }

    final void zzL(long l, boolean bl) {
        ((zzgw)this).zzg();
        this.zza();
        this.zzt.zzaA().zzc().zza("Resetting analytics data (FE)");
        zzkn zzkn2 = this.zzt.zzu();
        ((zzgw)zzkn2).zzg();
        zzkm cfr_ignored_0 = zzkn2.zza;
        zzkn2.zzb.zza();
        zzqr.zzc();
        if (this.zzt.zzf().zzs(null, zzeg.zzan)) {
            this.zzt.zzh().zzo();
        }
        boolean bl2 = this.zzt.zzJ();
        zzfi zzfi2 = this.zzt.zzm();
        zzfi2.zzc.zzb(l);
        if (!TextUtils.isEmpty((CharSequence)zzfi2.zzt.zzm().zzp.zza())) {
            zzfi2.zzp.zzb(null);
        }
        zzpe.zzc();
        if (zzfi2.zzt.zzf().zzs(null, zzeg.zzaf)) {
            zzfi2.zzj.zzb(0L);
        }
        zzfi2.zzk.zzb(0L);
        if (!zzfi2.zzt.zzf().zzv()) {
            zzfi2.zzi(bl2 ^ true);
        }
        zzfi2.zzq.zzb(null);
        zzfi2.zzr.zzb(0L);
        zzfi2.zzs.zzb(null);
        if (bl) {
            this.zzt.zzt().zzC();
        }
        zzpe.zzc();
        if (this.zzt.zzf().zzs(null, zzeg.zzaf)) {
            this.zzt.zzu().zza.zza();
        }
        this.zzc = bl2 ^ true;
    }

    protected final void zzM(String string, String string2, long l, Bundle object2, boolean bl, boolean bl2, boolean bl3, String string3) {
        Bundle bundle = new Bundle(object2);
        for (Object object2 : bundle.keySet()) {
            Object object3;
            Object object4 = bundle.get((String)object2);
            if (object4 instanceof Bundle) {
                bundle.putBundle((String)object2, new Bundle((Bundle)object4));
                continue;
            }
            if (object4 instanceof Parcelable[]) {
                object4 = (Parcelable[])object4;
                for (int i = 0; i < ((Parcelable[])object4).length; ++i) {
                    object3 = object4[i];
                    if (!(object3 instanceof Bundle)) continue;
                    object4[i] = new Bundle((Bundle)object3);
                }
                continue;
            }
            if (!(object4 instanceof List)) continue;
            object4 = (List)object4;
            for (int i = 0; i < object4.size(); ++i) {
                object3 = object4.get(i);
                if (!(object3 instanceof Bundle)) continue;
                object4.set(i, new Bundle((Bundle)object3));
            }
        }
        this.zzt.zzaB().zzp(new zzhn(this, string, string2, l, bundle, bl, bl2, bl3, string3));
    }

    final void zzN(String string, String string2, long l, Object object) {
        this.zzt.zzaB().zzp(new zzho(this, string, string2, object, l));
    }

    final void zzO(String string) {
        this.zzg.set(string);
    }

    public final void zzP(Bundle bundle) {
        zzii zzii2 = this;
        zzii2.zzQ(bundle, zzii2.zzt.zzax().currentTimeMillis());
    }

    public final void zzQ(Bundle object, long l) {
        Object object2;
        Preconditions.checkNotNull((Object)object);
        Bundle bundle = new Bundle(object);
        if (!TextUtils.isEmpty((CharSequence)bundle.getString("app_id"))) {
            ((zzgw)object2).zzt.zzaA().zzk().zza("Package name should be null when calling setConditionalUserProperty");
        }
        bundle.remove("app_id");
        Preconditions.checkNotNull((Object)bundle);
        zzgz.zza((Bundle)bundle, (String)"app_id", String.class, null);
        zzgz.zza((Bundle)bundle, (String)"origin", String.class, null);
        zzgz.zza((Bundle)bundle, (String)"name", String.class, null);
        zzgz.zza((Bundle)bundle, (String)"value", Object.class, null);
        zzgz.zza((Bundle)bundle, (String)"trigger_event_name", String.class, null);
        object = 0L;
        zzgz.zza((Bundle)bundle, (String)"trigger_timeout", Long.class, (Object)object);
        zzgz.zza((Bundle)bundle, (String)"timed_out_event_name", String.class, null);
        zzgz.zza((Bundle)bundle, (String)"timed_out_event_params", Bundle.class, null);
        zzgz.zza((Bundle)bundle, (String)"triggered_event_name", String.class, null);
        zzgz.zza((Bundle)bundle, (String)"triggered_event_params", Bundle.class, null);
        zzgz.zza((Bundle)bundle, (String)"time_to_live", Long.class, (Object)object);
        zzgz.zza((Bundle)bundle, (String)"expired_event_name", String.class, null);
        zzgz.zza((Bundle)bundle, (String)"expired_event_params", Bundle.class, null);
        Preconditions.checkNotEmpty((String)bundle.getString("name"));
        Preconditions.checkNotEmpty((String)bundle.getString("origin"));
        Preconditions.checkNotNull((Object)bundle.get("value"));
        bundle.putLong("creation_timestamp", l);
        object = bundle.getString("name");
        Object object3 = bundle.get("value");
        if (((zzgw)object2).zzt.zzv().zzl((String)object) == 0) {
            if (((zzgw)object2).zzt.zzv().zzd((String)object, object3) == 0) {
                Object object4 = ((zzgw)object2).zzt.zzv().zzB((String)object, object3);
                if (object4 == null) {
                    object2 = ((zzgw)object2).zzt.zzj().zzf((String)object);
                    ((zzgw)object2).zzt.zzaA().zzd().zzc("Unable to normalize conditional user property value", object2, object3);
                    return;
                }
                zzgz.zzb((Bundle)bundle, (Object)object4);
                long l2 = bundle.getLong("trigger_timeout");
                if (!TextUtils.isEmpty((CharSequence)bundle.getString("trigger_event_name"))) {
                    ((zzgw)object2).zzt.zzf();
                    if (l2 > 15552000000L || l2 < 1L) {
                        object2 = ((zzgw)object2).zzt.zzj().zzf((String)object);
                        object = l2;
                        ((zzgw)object2).zzt.zzaA().zzd().zzc("Invalid conditional user property timeout", object2, object);
                        return;
                    }
                }
                long l3 = bundle.getLong("time_to_live");
                ((zzgw)object2).zzt.zzf();
                if (l3 > 15552000000L || l3 < 1L) {
                    object2 = ((zzgw)object2).zzt.zzj().zzf((String)object);
                    object = l3;
                    ((zzgw)object2).zzt.zzaA().zzd().zzc("Invalid conditional user property time to live", object2, object);
                    return;
                }
                ((zzgw)object2).zzt.zzaB().zzp(new zzhr((zzii)object2, bundle));
                return;
            }
            object2 = ((zzgw)object2).zzt.zzj().zzf((String)object);
            ((zzgw)object2).zzt.zzaA().zzd().zzc("Invalid conditional user property value", object2, object3);
            return;
        }
        object2 = ((zzgw)object2).zzt.zzj().zzf((String)object);
        ((zzgw)object2).zzt.zzaA().zzd().zzb("Invalid conditional user property name", object2);
    }

    public final void zzR(Bundle bundle, int n, long l) {
        this.zza();
        String string = zzai.zzg(bundle);
        if (string != null) {
            this.zzt.zzaA().zzl().zzb("Ignoring invalid consent setting", string);
            this.zzt.zzaA().zzl().zza("Valid consent values are 'granted', 'denied'");
        }
        this.zzS(zzai.zza(bundle), n, l);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public final void zzS(zzai zzai2, int n, long l) {
        boolean bl;
        boolean bl2;
        boolean bl3;
        zzai zzai3;
        block9: {
            this.zza();
            if (n != -10 && zzai2.zze() == null && zzai2.zzf() == null) {
                this.zzt.zzaA().zzl().zza("Discarding empty consent settings");
                return;
            }
            Object object = this.zzh;
            // MONITORENTER : object
            zzai3 = this.zzi;
            bl3 = zzai.zzj(n, this.zzj);
            if (bl3) {
                zzai zzai4;
                bl2 = zzai2.zzk(this.zzi);
                bl3 = zzai2.zzi(zzah.zzb);
                bl3 = bl3 ? !(bl3 = (zzai4 = this.zzi).zzi(zzah.zzb)) : false;
                this.zzi = zzai2 = zzai2.zzd(this.zzi);
                this.zzj = n;
                boolean bl4 = bl3;
                bl3 = bl2;
                bl2 = bl4;
                bl = true;
                // MONITOREXIT : object
                break block9;
            }
            bl3 = false;
            bl2 = false;
            bl = false;
            {
                catch (Throwable throwable) {}
                {
                    // MONITOREXIT : object
                    throw throwable;
                }
            }
        }
        if (!bl) {
            this.zzt.zzaA().zzi().zzb("Ignoring lower-priority consent settings, proposed settings", zzai2);
            return;
        }
        long l2 = this.zzk.getAndIncrement();
        if (bl3) {
            this.zzg.set(null);
            this.zzt.zzaB().zzq(new zzid(this, zzai2, l, n, l2, bl2, zzai3));
            return;
        }
        zzie zzie2 = new zzie(this, zzai2, n, l2, bl2, zzai3);
        if (n != 30 && n != -10) {
            this.zzt.zzaB().zzp(zzie2);
            return;
        }
        this.zzt.zzaB().zzq(zzie2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public final void zzT(zzhd zzhd2) {
        zzhd zzhd3;
        ((zzgw)this).zzg();
        this.zza();
        if (zzhd2 != null && zzhd2 != (zzhd3 = this.zzd)) {
            boolean bl = zzhd3 == null;
            Preconditions.checkState((boolean)bl, (Object)"EventInterceptor already set.");
        }
        this.zzd = zzhd2;
    }

    public final void zzU(Boolean bl) {
        this.zza();
        this.zzt.zzaB().zzp(new zzic(this, bl));
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzV(zzai zzai2) {
        ((zzgw)this).zzg();
        boolean bl = !zzai2.zzi(zzah.zzb) || !zzai2.zzi(zzah.zza) ? this.zzt.zzt().zzM() : true;
        if (bl != this.zzt.zzK()) {
            this.zzt.zzG(bl);
            Object object = this.zzt.zzm();
            zzgd cfr_ignored_0 = ((zzgw)object).zzt;
            ((zzgw)object).zzg();
            object = ((zzfi)object).zza().contains("measurement_enabled_from_api") ? Boolean.valueOf(((zzfi)object).zza().getBoolean("measurement_enabled_from_api", true)) : null;
            if (!bl || object == null || ((Boolean)object).booleanValue()) {
                this.zzaa(bl, false);
                return;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzaa(Boolean bl, boolean bl2) {
        ((zzgw)this).zzg();
        this.zza();
        this.zzt.zzaA().zzc().zzb("Setting app measurement enabled (FE)", bl);
        this.zzt.zzm().zzh(bl);
        if (bl2) {
            zzfi zzfi2 = this.zzt.zzm();
            zzgd cfr_ignored_0 = zzfi2.zzt;
            zzfi2.zzg();
            SharedPreferences.Editor editor = zzfi2.zza().edit();
            if (bl != null) {
                editor.putBoolean("measurement_enabled_from_api", bl.booleanValue());
            } else {
                editor.remove("measurement_enabled_from_api");
            }
            editor.apply();
        }
        if (this.zzt.zzK() || bl != null && !bl.booleanValue()) {
            this.zzab();
            return;
        }
    }

    public final void zzW(String string, String string2, Object object, boolean bl) {
        long l = this.zzt.zzax().currentTimeMillis();
        this.zzX("auto", "_ldl", object, true, l);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void zzX(String string, String string2, Object object, boolean bl, long l) {
        void var5_15;
        void var4_8;
        if (bl) {
            int n = this.zzt.zzv().zzl(string2);
        } else {
            zzln zzln2 = this.zzt.zzv();
            if (!zzln2.zzad("user property", string2)) {
                int n = 6;
            } else if (!zzln2.zzaa("user property", zzhc.zza, null, string2)) {
                int n = 15;
            } else {
                zzln2.zzt.zzf();
                if (!zzln2.zzZ("user property", 24, string2)) {
                    int n = 6;
                } else {
                    boolean bl2 = false;
                }
            }
        }
        if (var4_8 != false) {
            zzln zzln3 = this.zzt.zzv();
            this.zzt.zzf();
            object = zzln3.zzD(string2, 24, true);
            int n = string2 != null ? string2.length() : 0;
            this.zzt.zzv().zzO(this.zzn, null, (int)var4_8, "_ev", (String)object, n);
            return;
        }
        if (string == null) {
            string = "app";
        }
        if (object == null) {
            this.zzN(string, string2, (long)var5_15, null);
            return;
        }
        int n = this.zzt.zzv().zzd(string2, object);
        if (n != 0) {
            zzln zzln4 = this.zzt.zzv();
            this.zzt.zzf();
            string2 = zzln4.zzD(string2, 24, true);
            int n2 = object instanceof String || object instanceof CharSequence ? object.toString().length() : 0;
            this.zzt.zzv().zzO(this.zzn, null, n, "_ev", string2, n2);
            return;
        }
        object = this.zzt.zzv().zzB(string2, object);
        if (object != null) {
            this.zzN(string, string2, (long)var5_15, object);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzY(String string, String string2, Object object, long l) {
        Object object2;
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotEmpty((String)string2);
        ((zzgw)this).zzg();
        this.zza();
        if ("allow_personalized_ads".equals(string2)) {
            if (object instanceof String && !TextUtils.isEmpty((CharSequence)(object2 = (String)object))) {
                string2 = ((String)object2).toLowerCase(Locale.ENGLISH);
                long l2 = true != "false".equals(string2) ? 0L : 1L;
                object = l2;
                object2 = this.zzt.zzm().zzh;
                string2 = (Long)object == 1L ? "true" : "false";
                ((zzfh)object2).zzb(string2);
                string2 = "_npa";
            } else if (object == null) {
                this.zzt.zzm().zzh.zzb("unset");
                string2 = "_npa";
            }
        }
        if (!this.zzt.zzJ()) {
            this.zzt.zzaA().zzj().zza("User property not set since app measurement is disabled");
            return;
        }
        if (!this.zzt.zzM()) {
            return;
        }
        object2 = new zzli(string2, l, object, string);
        this.zzt.zzt().zzK((zzli)((Object)object2));
    }

    public final void zzZ(zzhe zzhe2) {
        this.zza();
        Preconditions.checkNotNull((Object)zzhe2);
        if (!this.zze.remove(zzhe2)) {
            this.zzt.zzaA().zzk().zza("OnEventListener had not been registered");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    private final void zzab() {
        ((zzgw)this).zzg();
        Object object = this.zzt.zzm().zzh.zza();
        if (object != null) {
            if ("unset".equals(object)) {
                long l = this.zzt.zzax().currentTimeMillis();
                this.zzY("app", "_npa", null, l);
            } else {
                long l = true != "true".equals(object) ? 0L : 1L;
                object = l;
                l = this.zzt.zzax().currentTimeMillis();
                this.zzY("app", "_npa", object, l);
            }
        }
        if (this.zzt.zzJ() && this.zzc) {
            this.zzt.zzaA().zzc().zza("Recording app launch after enabling measurement for the first time (FE)");
            this.zzz();
            zzpe.zzc();
            if (this.zzt.zzf().zzs(null, zzeg.zzaf)) {
                this.zzt.zzu().zza.zza();
            }
            this.zzt.zzaB().zzp(new zzhl(this));
            return;
        }
        this.zzt.zzaA().zzc().zza("Updating Scion state (FE)");
        this.zzt.zzt().zzI();
    }

    @Override
    protected final boolean zzf() {
        return false;
    }
}

