/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.measurement.zzcv;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzaw;
import com.google.android.gms.measurement.internal.zzbg;
import com.google.android.gms.measurement.internal.zzbi;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzfh;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzia;
import com.google.android.gms.measurement.internal.zzkf;
import com.google.android.gms.measurement.internal.zzkp;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzkx;
import com.google.android.gms.measurement.internal.zzky;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzla;
import com.google.android.gms.measurement.internal.zzlb;
import com.google.android.gms.measurement.internal.zzlc;
import com.google.android.gms.measurement.internal.zzld;
import com.google.android.gms.measurement.internal.zzle;
import com.google.android.gms.measurement.internal.zzlf;
import com.google.android.gms.measurement.internal.zzlg;
import com.google.android.gms.measurement.internal.zzlh;
import com.google.android.gms.measurement.internal.zzli;
import com.google.android.gms.measurement.internal.zzlj;
import com.google.android.gms.measurement.internal.zzlk;
import com.google.android.gms.measurement.internal.zzmf;
import com.google.android.gms.measurement.internal.zzmi;
import com.google.android.gms.measurement.internal.zzmz;
import com.google.android.gms.measurement.internal.zzo;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzkq
extends zze {
    private final zzlj zza;
    private @Nullable zzfh zzb;
    private volatile Boolean zzc;
    private final zzaw zzd;
    private final zzmf zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzaw zzg;

    @WorkerThread
    private final @Nullable zzo zzb(boolean bl) {
        return ((zzf)this).zzg().zza(bl ? ((zzia)this).zzj().zzx() : null);
    }

    @WorkerThread
    protected final @Nullable zzam zzaa() {
        ((zzia)this).zzt();
        this.zzu();
        zzfh zzfh2 = this.zzb;
        if (zzfh2 == null) {
            this.zzad();
            ((zzia)this).zzj().zzc().zza("Failed to get consents; not connected to service yet.");
            return null;
        }
        zzo zzo2 = this.zzb(false);
        Preconditions.checkNotNull((Object)((Object)zzo2));
        try {
            zzam zzam2 = zzfh2.zza(zzo2);
            this.zzal();
            return zzam2;
        }
        catch (RemoteException remoteException) {
            ((zzia)this).zzj().zzg().zza("Failed to get consents; remote exception", (Object)remoteException);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ zzfh zza(zzkq zzkq2) {
        return zzkq2.zzb;
    }

    static /* bridge */ /* synthetic */ zzlj zzb(zzkq zzkq2) {
        return zzkq2.zza;
    }

    final Boolean zzab() {
        return this.zzc;
    }

    static /* bridge */ /* synthetic */ void zza(zzkq zzkq2, zzfh zzfh2) {
        zzkq2.zzb = null;
    }

    static /* synthetic */ void zzc(zzkq zzkq2) {
        zzkq2.zzak();
    }

    static /* synthetic */ void zzd(zzkq zzkq2) {
        zzkq zzkq3 = zzkq2;
        ((zzia)zzkq3).zzt();
        if (zzkq3.zzah()) {
            ((zzia)zzkq3).zzj().zzp().zza("Inactivity, disconnecting from the service");
            zzkq3.zzae();
        }
    }

    static /* synthetic */ void zza(zzkq zzkq2, ComponentName componentName) {
        ComponentName componentName2 = componentName;
        zzkq zzkq3 = zzkq2;
        ((zzia)zzkq3).zzt();
        if (zzkq3.zzb != null) {
            zzkq3.zzb = null;
            ((zzia)zzkq3).zzj().zzp().zza("Disconnected from device MeasurementService", componentName2);
            zzkq zzkq4 = zzkq3;
            ((zzia)zzkq4).zzt();
            zzkq4.zzad();
        }
    }

    static /* synthetic */ void zze(zzkq zzkq2) {
        zzkq2.zzal();
    }

    protected zzkq(zzhc zzhc2) {
        super(zzhc2);
        this.zze = new zzmf(zzhc2.zzb());
        this.zza = new zzlj(this);
        this.zzd = new zzkp(this, zzhc2);
        this.zzg = new zzlc(this, zzhc2);
    }

    @WorkerThread
    protected final void zzac() {
        ((zzia)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(true);
        ((zzf)this).zzh().zzab();
        this.zza(new zzkx(this, zzo2));
    }

    @WorkerThread
    final void zzad() {
        ((zzia)this).zzt();
        this.zzu();
        if (this.zzah()) {
            return;
        }
        if (this.zzam()) {
            this.zza.zza();
            return;
        }
        if (!((zzia)this).zze().zzw()) {
            Intent intent;
            zzkq zzkq2 = this;
            PackageManager packageManager = ((zzia)zzkq2).zza().getPackageManager();
            List list = packageManager.queryIntentServices(intent = new Intent().setClassName(((zzia)zzkq2).zza(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && !list.isEmpty()) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                intent2.setComponent(new ComponentName(((zzia)this).zza(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zzia)this).zzj().zzg().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    @WorkerThread
    public final void zzae() {
        ((zzia)this).zzt();
        this.zzu();
        this.zza.zzb();
        try {
            ConnectionTracker.getInstance().unbindService(((zzia)this).zza(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zzak() {
        ((zzia)this).zzt();
        ((zzia)this).zzj().zzp().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                ((zzia)this).zzj().zzg().zza("Task exception while flushing queue", runtimeException);
            }
        }
        this.zzf.clear();
        this.zzg.zza();
    }

    @WorkerThread
    public final void zza(zzcv zzcv2) {
        ((zzia)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzky(this, zzo2, zzcv2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzia)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzkv(this, atomicReference, zzo2));
    }

    @WorkerThread
    protected final void zza(zzcv zzcv2, @Nullable String string, @Nullable String string2) {
        ((zzia)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzlh(this, string, string2, zzo2, zzcv2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzad>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3) {
        ((zzia)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzli(this, atomicReference, string, string2, string3, zzo2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zzmi>> atomicReference, Bundle bundle) {
        ((zzia)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzku(this, atomicReference, zzo2, bundle));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zzmz>> atomicReference, boolean bl) {
        ((zzia)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzkr(this, atomicReference, zzo2, bl));
    }

    @WorkerThread
    protected final void zza(zzcv zzcv2, @Nullable String string, @Nullable String string2, boolean bl) {
        ((zzia)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzks(this, string, string2, zzo2, bl, zzcv2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzmz>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3, boolean bl) {
        ((zzia)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzlk(this, atomicReference, string, string2, string3, zzo2, bl));
    }

    @WorkerThread
    protected final void zza(zzbg zzbg2, @Nullable String string) {
        Preconditions.checkNotNull((Object)((Object)zzbg2));
        ((zzia)this).zzt();
        this.zzu();
        boolean bl = ((zzf)this).zzh().zza(zzbg2);
        zzo zzo2 = this.zzb(true);
        this.zza(new zzlg(this, true, zzo2, bl, zzbg2, string));
    }

    @WorkerThread
    public final void zza(zzcv zzcv2, zzbg zzbg2, String string) {
        ((zzia)this).zzt();
        this.zzu();
        if (((zzia)this).zzq().zza(12451000) != 0) {
            ((zzia)this).zzj().zzu().zza("Not bundling data. Service unavailable or out of date");
            ((zzia)this).zzq().zza(zzcv2, new byte[0]);
            return;
        }
        this.zza(new zzlb(this, zzbg2, string, zzcv2));
    }

    @WorkerThread
    private final void zzal() {
        ((zzia)this).zzt();
        this.zze.zzb();
        this.zzd.zza((Long)zzbi.zzaj.zza(null));
    }

    @WorkerThread
    protected final void zzaf() {
        ((zzia)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        ((zzf)this).zzh().zzaa();
        this.zza(new zzkw(this, zzo2));
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzia)this).zzt();
        if (this.zzah()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzia)this).zzj().zzg().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzad();
    }

    @WorkerThread
    final void zza(zzfh zzfh2, @Nullable AbstractSafeParcelable abstractSafeParcelable, zzo zzo2) {
        ((zzia)this).zzt();
        this.zzu();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            List<AbstractSafeParcelable> list = ((zzf)this).zzh().zza(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzbg) {
                    try {
                        zzfh2.zza((zzbg)abstractSafeParcelable2, zzo2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzia)this).zzj().zzg().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzmz) {
                    try {
                        zzfh2.zza((zzmz)abstractSafeParcelable2, zzo2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzia)this).zzj().zzg().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzad) {
                    try {
                        zzfh2.zza((zzad)abstractSafeParcelable2, zzo2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzia)this).zzj().zzg().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzia)this).zzj().zzg().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzad zzad2) {
        Preconditions.checkNotNull((Object)((Object)zzad2));
        ((zzia)this).zzt();
        this.zzu();
        boolean bl = ((zzf)this).zzh().zza(zzad2);
        zzad zzad3 = new zzad(zzad2);
        zzo zzo2 = this.zzb(true);
        this.zza(new zzlf(this, true, zzo2, bl, zzad3, zzad2));
    }

    @WorkerThread
    protected final void zza(boolean bl) {
        ((zzia)this).zzt();
        this.zzu();
        if (bl) {
            ((zzf)this).zzh().zzaa();
        }
        if (this.zzaj()) {
            zzo zzo2 = this.zzb(false);
            this.zza(new zzld(this, zzo2));
        }
    }

    @WorkerThread
    protected final void zza(@Nullable zzkf zzkf2) {
        ((zzia)this).zzt();
        this.zzu();
        this.zza(new zzla(this, zzkf2));
    }

    @WorkerThread
    public final void zza(Bundle bundle) {
        ((zzia)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(false);
        this.zza(new zzkz(this, zzo2, bundle));
    }

    @WorkerThread
    protected final void zzag() {
        ((zzia)this).zzt();
        this.zzu();
        zzo zzo2 = this.zzb(true);
        this.zza(new zzle(this, zzo2));
    }

    @WorkerThread
    protected final void zza(zzfh zzfh2) {
        ((zzia)this).zzt();
        Preconditions.checkNotNull((Object)zzfh2);
        this.zzb = zzfh2;
        this.zzal();
        this.zzak();
    }

    @WorkerThread
    protected final void zza(zzmz zzmz2) {
        ((zzia)this).zzt();
        this.zzu();
        boolean bl = ((zzf)this).zzh().zza(zzmz2);
        zzo zzo2 = this.zzb(true);
        this.zza(new zzkt(this, zzo2, bl, zzmz2));
    }

    @WorkerThread
    public final boolean zzah() {
        ((zzia)this).zzt();
        this.zzu();
        return this.zzb != null;
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    final boolean zzai() {
        ((zzia)this).zzt();
        this.zzu();
        if (!this.zzam()) {
            return true;
        }
        return ((zzia)this).zzq().zzg() >= 200900;
    }

    @WorkerThread
    final boolean zzaj() {
        ((zzia)this).zzt();
        this.zzu();
        if (!this.zzam()) {
            return true;
        }
        return ((zzia)this).zzq().zzg() >= (Integer)zzbi.zzbo.zza(null);
    }

    @WorkerThread
    private final boolean zzam() {
        ((zzia)this).zzt();
        this.zzu();
        if (this.zzc == null) {
            boolean bl;
            zzkq zzkq2 = this;
            ((zzia)zzkq2).zzt();
            zzkq2.zzu();
            Boolean bl2 = ((zzia)zzkq2).zzk().zzn();
            if (bl2 != null && bl2.booleanValue()) {
                bl = true;
            } else {
                boolean bl3;
                boolean bl4;
                if (((zzf)zzkq2).zzg().zzaa() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzia)zzkq2).zzj().zzp().zza("Checking service availability");
                    int n = ((zzia)zzkq2).zzq().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zzia)zzkq2).zzj().zzp().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzia)zzkq2).zzj().zzp().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzia)zzkq2).zzj().zzu().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzia)zzkq2).zzj().zzc().zza("Service container out of date");
                            if (((zzia)zzkq2).zzq().zzg() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            bl4 = bl2 == null;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzia)zzkq2).zzj().zzu().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzia)zzkq2).zzj().zzu().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzia)zzkq2).zzj().zzu().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzia)zzkq2).zze().zzw()) {
                    ((zzia)zzkq2).zzj().zzg().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzia)zzkq2).zzk().zza(bl4);
                }
                bl = bl4;
            }
            this.zzc = bl;
        }
        return this.zzc;
    }
}

