/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzc;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzki;
import com.google.android.gms.measurement.internal.zzkj;
import com.google.android.gms.measurement.internal.zzkk;
import com.google.android.gms.measurement.internal.zzkl;
import com.google.android.gms.measurement.internal.zzkm;
import com.google.android.gms.measurement.internal.zzkn;
import com.google.android.gms.measurement.internal.zzko;
import com.google.android.gms.measurement.internal.zzng;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzkh
extends zze {
    private volatile @Nullable zzki zzb;
    private volatile @Nullable zzki zzc;
    @VisibleForTesting
    protected @Nullable zzki zza;
    private final Map<Activity, zzki> zzd;
    @GuardedBy(value="activityLock")
    private @Nullable Activity zze;
    @GuardedBy(value="activityLock")
    private volatile boolean zzf;
    private volatile @Nullable zzki zzg;
    private @Nullable zzki zzh;
    @GuardedBy(value="activityLock")
    private boolean zzi;
    private final Object zzj = new Object();

    static /* bridge */ /* synthetic */ zzki zza(zzkh zzkh2) {
        return zzkh2.zzh;
    }

    @MainThread
    private final zzki zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzki zzki2 = this.zzd.get(activity);
        if (zzki2 == null) {
            String string = this.zza(activity.getClass(), "Activity");
            zzki2 = new zzki(null, string, ((zzib)this).zzq().zzm());
            this.zzd.put(activity, zzki2);
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return zzki2;
    }

    public final @Nullable zzki zzaa() {
        return this.zzb;
    }

    @WorkerThread
    public final @Nullable zzki zza(boolean bl) {
        this.zzu();
        ((zzib)this).zzt();
        if (!bl) {
            return this.zza;
        }
        if (this.zza != null) {
            return this.zza;
        }
        return this.zzh;
    }

    @VisibleForTesting
    private final String zza(Class<?> clazz, String string) {
        String string2 = clazz.getCanonicalName();
        if (string2 == null) {
            return string;
        }
        String string3 = string2;
        zzkh zzkh2 = this;
        String[] stringArray = string3.split("\\.");
        String string4 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string4.length() > ((zzib)zzkh2).zze().zza(null, false)) {
            return string4.substring(0, ((zzib)zzkh2).zze().zza(null, false));
        }
        return string4;
    }

    static /* bridge */ /* synthetic */ void zza(zzkh zzkh2, zzki zzki2) {
        zzkh2.zzh = null;
    }

    static /* bridge */ /* synthetic */ void zza(zzkh zzkh2, zzki zzki2, zzki zzki3, long l, boolean bl, Bundle bundle) {
        zzkh2.zza(zzki2, zzki3, l, bl, null);
    }

    static /* synthetic */ void zza(zzkh zzkh2, Bundle bundle, zzki zzki2, zzki zzki3, long l) {
        long l2 = l;
        zzki zzki4 = zzki3;
        zzki zzki5 = zzki2;
        Bundle bundle2 = bundle;
        zzkh zzkh3 = zzkh2;
        if (bundle2 != null) {
            bundle2.remove("screen_name");
            bundle2.remove("screen_class");
        }
        Bundle bundle3 = ((zzib)zzkh3).zzq().zza(null, "screen_view", bundle2, null, false);
        zzkh3.zza(zzki5, zzki4, l2, true, bundle3);
    }

    static /* bridge */ /* synthetic */ void zza(zzkh zzkh2, zzki zzki2, boolean bl, long l) {
        zzkh2.zza(zzki2, false, l);
    }

    public zzkh(zzhd zzhd2) {
        super(zzhd2);
        this.zzd = new ConcurrentHashMap<Activity, zzki>();
    }

    @MainThread
    private final void zza(Activity activity, zzki zzki2, boolean bl) {
        zzki zzki3;
        zzki zzki4;
        zzki zzki5 = zzki4 = this.zzb == null ? this.zzc : this.zzb;
        if (zzki2.zzb == null) {
            zzki3 = activity != null ? this.zza(activity.getClass(), "Activity") : null;
            zzki2 = new zzki(zzki2.zza, (String)((Object)zzki3), zzki2.zzc, zzki2.zze, zzki2.zzf);
        }
        zzki3 = zzki2;
        this.zzc = this.zzb;
        this.zzb = zzki3;
        long l = ((zzib)this).zzb().elapsedRealtime();
        ((zzib)this).zzl().zzb(new zzkj(this, zzki3, zzki4, l, bl));
    }

    @WorkerThread
    private final void zza(zzki zzki2, @Nullable zzki zzki3, long l, boolean bl, @Nullable Bundle bundle) {
        boolean bl2;
        ((zzib)this).zzt();
        boolean bl3 = zzki3 == null || zzki3.zzc != zzki2.zzc || !Objects.equals(zzki3.zzb, zzki2.zzb) || !Objects.equals(zzki3.zza, zzki2.zza);
        boolean bl4 = bl2 = bl && this.zza != null;
        if (bl3) {
            long l2;
            long l3;
            Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            zzng.zza(zzki2, bundle2, true);
            if (zzki3 != null) {
                if (zzki3.zza != null) {
                    bundle2.putString("_pn", zzki3.zza);
                }
                if (zzki3.zzb != null) {
                    bundle2.putString("_pc", zzki3.zzb);
                }
                bundle2.putLong("_pi", zzki3.zzc);
            }
            if (bl2 && (l3 = ((zzf)this).zzp().zzb.zza(l2 = l)) > 0L) {
                ((zzib)this).zzq().zza(bundle2, l3);
            }
            if (!((zzib)this).zze().zzv()) {
                bundle2.putLong("_mst", 1L);
            }
            String string = zzki2.zze ? "app" : "auto";
            long l4 = ((zzib)this).zzb().currentTimeMillis();
            if (zzki2.zze && zzki2.zzf != 0L) {
                l4 = zzki2.zzf;
            }
            ((zzf)this).zzm().zza(string, "_vs", l4, bundle2);
        }
        if (bl2) {
            this.zza(this.zza, true, l);
        }
        this.zza = zzki2;
        if (zzki2.zze) {
            this.zzh = zzki2;
        }
        ((zzf)this).zzo().zza(zzki2);
    }

    @MainThread
    public final void zza(Activity activity, @Nullable Bundle bundle) {
        if (!((zzib)this).zze().zzv()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzki zzki2 = new zzki(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzki2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            if (activity == this.zze) {
                this.zze = null;
            }
        }
        if (!((zzib)this).zze().zzv()) {
            return;
        }
        this.zzd.remove(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzb(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = false;
            this.zzf = true;
        }
        long l = ((zzib)this).zzb().elapsedRealtime();
        if (!((zzib)this).zze().zzv()) {
            this.zzb = null;
            ((zzib)this).zzl().zzb(new zzkl(this, l));
            return;
        }
        zzki zzki2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzib)this).zzl().zzb(new zzko(this, zzki2, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzc(Activity activity) {
        zzf zzf2;
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = true;
            if (activity != this.zze) {
                Activity activity2 = activity;
                zzf2 = this;
                Object object2 = ((zzkh)zzf2).zzj;
                synchronized (object2) {
                    ((zzkh)zzf2).zze = activity2;
                    ((zzkh)zzf2).zzf = false;
                }
                if (zzf2.zze().zzv()) {
                    ((zzkh)zzf2).zzg = null;
                    zzf2.zzl().zzb(new zzkn((zzkh)zzf2));
                }
            }
        }
        if (!((zzib)this).zze().zzv()) {
            this.zzb = this.zzg;
            ((zzib)this).zzl().zzb(new zzkm(this));
            return;
        }
        object = this.zzd(activity);
        this.zza(activity, (zzki)object, false);
        zzf2 = ((zzf)this).zzc();
        long l = zzf2.zzb().elapsedRealtime();
        zzf2.zzl().zzb(new zzc((zzb)zzf2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (!((zzib)this).zze().zzv()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzki zzki2 = this.zzd.get(activity);
        if (zzki2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzki2.zzc);
        bundle2.putString("name", zzki2.zza);
        bundle2.putString("referrer_name", zzki2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @WorkerThread
    private final void zza(@Nullable zzki zzki2, boolean bl, long l) {
        boolean bl2;
        ((zzf)this).zzc().zza(((zzib)this).zzb().elapsedRealtime());
        boolean bl3 = bl2 = zzki2 != null && zzki2.zzd;
        if (((zzf)this).zzp().zza(bl2, bl, l) && zzki2 != null) {
            zzki2.zzd = false;
        }
    }

    @Deprecated
    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!((zzib)this).zze().zzv()) {
            ((zzib)this).zzj().zzv().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
            return;
        }
        zzki zzki2 = this.zzb;
        if (zzki2 == null) {
            ((zzib)this).zzj().zzv().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzib)this).zzj().zzv().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = this.zza(activity.getClass(), "Activity");
        }
        boolean bl = Objects.equals(zzki2.zzb, string2);
        boolean bl2 = Objects.equals(zzki2.zza, string);
        if (bl && bl2) {
            ((zzib)this).zzj().zzv().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > ((zzib)this).zze().zza(null, false))) {
            ((zzib)this).zzj().zzv().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzib)this).zze().zza(null, false))) {
            ((zzib)this).zzj().zzv().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzib)this).zzj().zzp().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzki zzki3 = new zzki(string, string2, ((zzib)this).zzq().zzm());
        this.zzd.put(activity, zzki3);
        this.zza(activity, zzki3, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Bundle bundle, long l) {
        zzki zzki2;
        String string = null;
        String string2 = null;
        Object object = this.zzj;
        synchronized (object) {
            if (!this.zzi) {
                ((zzib)this).zzj().zzv().zza("Cannot log screen view event when the app is in the background.");
                return;
            }
            if (bundle != null) {
                string = bundle.getString("screen_name");
                if (string != null && (string.length() <= 0 || string.length() > ((zzib)this).zze().zza(null, false))) {
                    ((zzib)this).zzj().zzv().zza("Invalid screen name length for screen view. Length", string.length());
                    return;
                }
                string2 = bundle.getString("screen_class");
                if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzib)this).zze().zza(null, false))) {
                    ((zzib)this).zzj().zzv().zza("Invalid screen class length for screen view. Length", string2.length());
                    return;
                }
            }
            if (string2 == null) {
                string2 = this.zze != null ? this.zza(this.zze.getClass(), "Activity") : "Activity";
            }
            zzki2 = this.zzb;
            if (this.zzf && zzki2 != null) {
                this.zzf = false;
                boolean bl = Objects.equals(zzki2.zzb, string2);
                boolean bl2 = Objects.equals(zzki2.zza, string);
                if (bl && bl2) {
                    ((zzib)this).zzj().zzv().zza("Ignoring call to log screen view event with duplicate parameters.");
                    return;
                }
            }
        }
        ((zzib)this).zzj().zzp().zza("Logging screen view with name, class", string == null ? "null" : string, string2 == null ? "null" : string2);
        object = this.zzb == null ? this.zzc : this.zzb;
        this.zzb = zzki2 = new zzki(string, string2, ((zzib)this).zzq().zzm(), true, l);
        this.zzc = object;
        this.zzg = zzki2;
        long l2 = ((zzib)this).zzb().elapsedRealtime();
        ((zzib)this).zzl().zzb(new zzkk(this, bundle, zzki2, (zzki)object, l2));
    }

    @Override
    protected final boolean zzz() {
        return false;
    }
}

