/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzks;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzkx;
import com.google.android.gms.measurement.internal.zzky;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zzlb;
import com.google.android.gms.measurement.internal.zznt;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzkv
extends zzg {
    private volatile @Nullable zzks zzb;
    private volatile @Nullable zzks zzc;
    @VisibleForTesting
    protected @Nullable zzks zza;
    private final Map<Activity, zzks> zzd;
    @GuardedBy(value="activityLock")
    private @Nullable Activity zze;
    @GuardedBy(value="activityLock")
    private volatile boolean zzf;
    private volatile @Nullable zzks zzg;
    private @Nullable zzks zzh;
    @GuardedBy(value="activityLock")
    private boolean zzi;
    private final Object zzj = new Object();

    static /* bridge */ /* synthetic */ zzks zza(zzkv zzkv2) {
        return zzkv2.zzh;
    }

    @MainThread
    private final zzks zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzks zzks2 = this.zzd.get(activity);
        if (zzks2 == null) {
            String string = this.zza(activity.getClass(), "Activity");
            zzks2 = new zzks(null, string, ((zzim)this).zzq().zzm());
            this.zzd.put(activity, zzks2);
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return zzks2;
    }

    public final @Nullable zzks zzaa() {
        return this.zzb;
    }

    @WorkerThread
    public final @Nullable zzks zza(boolean bl) {
        this.zzu();
        ((zzim)this).zzt();
        if (!bl) {
            return this.zza;
        }
        if (this.zza != null) {
            return this.zza;
        }
        return this.zzh;
    }

    @VisibleForTesting
    private final String zza(Class<?> clazz, String string) {
        String string2 = clazz.getCanonicalName();
        if (string2 == null) {
            return string;
        }
        String string3 = string2;
        zzkv zzkv2 = this;
        String[] stringArray = string3.split("\\.");
        String string4 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string4.length() > ((zzim)zzkv2).zze().zza(null, false)) {
            return string4.substring(0, ((zzim)zzkv2).zze().zza(null, false));
        }
        return string4;
    }

    static /* bridge */ /* synthetic */ void zza(zzkv zzkv2, zzks zzks2) {
        zzkv2.zzh = null;
    }

    static /* bridge */ /* synthetic */ void zza(zzkv zzkv2, zzks zzks2, zzks zzks3, long l, boolean bl, Bundle bundle) {
        zzkv2.zza(zzks2, zzks3, l, bl, null);
    }

    static /* synthetic */ void zza(zzkv zzkv2, Bundle bundle, zzks zzks2, zzks zzks3, long l) {
        long l2 = l;
        zzks zzks4 = zzks3;
        zzks zzks5 = zzks2;
        Bundle bundle2 = bundle;
        zzkv zzkv3 = zzkv2;
        if (bundle2 != null) {
            bundle2.remove("screen_name");
            bundle2.remove("screen_class");
        }
        Bundle bundle3 = ((zzim)zzkv3).zzq().zza(null, "screen_view", bundle2, null, false);
        zzkv3.zza(zzks5, zzks4, l2, true, bundle3);
    }

    static /* bridge */ /* synthetic */ void zza(zzkv zzkv2, zzks zzks2, boolean bl, long l) {
        zzkv2.zza(zzks2, false, l);
    }

    public zzkv(zzho zzho2) {
        super(zzho2);
        this.zzd = new ConcurrentHashMap<Activity, zzks>();
    }

    @MainThread
    private final void zza(Activity activity, zzks zzks2, boolean bl) {
        zzks zzks3;
        zzks zzks4;
        zzks zzks5 = zzks4 = this.zzb == null ? this.zzc : this.zzb;
        if (zzks2.zzb == null) {
            zzks3 = activity != null ? this.zza(activity.getClass(), "Activity") : null;
            zzks2 = new zzks(zzks2.zza, (String)((Object)zzks3), zzks2.zzc, zzks2.zze, zzks2.zzf);
        }
        zzks3 = zzks2;
        this.zzc = this.zzb;
        this.zzb = zzks3;
        long l = ((zzim)this).zzb().elapsedRealtime();
        ((zzim)this).zzl().zzb(new zzkx(this, zzks3, zzks4, l, bl));
    }

    @WorkerThread
    private final void zza(zzks zzks2, @Nullable zzks zzks3, long l, boolean bl, @Nullable Bundle bundle) {
        boolean bl2;
        ((zzim)this).zzt();
        boolean bl3 = zzks3 == null || zzks3.zzc != zzks2.zzc || !Objects.equals(zzks3.zzb, zzks2.zzb) || !Objects.equals(zzks3.zza, zzks2.zza);
        boolean bl4 = bl2 = bl && this.zza != null;
        if (bl3) {
            long l2;
            long l3;
            Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            zznt.zza(zzks2, bundle2, true);
            if (zzks3 != null) {
                if (zzks3.zza != null) {
                    bundle2.putString("_pn", zzks3.zza);
                }
                if (zzks3.zzb != null) {
                    bundle2.putString("_pc", zzks3.zzb);
                }
                bundle2.putLong("_pi", zzks3.zzc);
            }
            if (bl2 && (l3 = ((zzd)this).zzp().zzb.zza(l2 = l)) > 0L) {
                ((zzim)this).zzq().zza(bundle2, l3);
            }
            if (!((zzim)this).zze().zzv()) {
                bundle2.putLong("_mst", 1L);
            }
            String string = zzks2.zze ? "app" : "auto";
            long l4 = ((zzim)this).zzb().currentTimeMillis();
            if (zzks2.zze && zzks2.zzf != 0L) {
                l4 = zzks2.zzf;
            }
            ((zzd)this).zzm().zza(string, "_vs", l4, bundle2);
        }
        if (bl2) {
            this.zza(this.zza, true, l);
        }
        this.zza = zzks2;
        if (zzks2.zze) {
            this.zzh = zzks2;
        }
        ((zzd)this).zzo().zza(zzks2);
    }

    @MainThread
    public final void zza(Activity activity, @Nullable Bundle bundle) {
        if (!((zzim)this).zze().zzv()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzks zzks2 = new zzks(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzks2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            if (activity == this.zze) {
                this.zze = null;
            }
        }
        if (!((zzim)this).zze().zzv()) {
            return;
        }
        this.zzd.remove(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzb(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = false;
            this.zzf = true;
        }
        long l = ((zzim)this).zzb().elapsedRealtime();
        if (!((zzim)this).zze().zzv()) {
            this.zzb = null;
            ((zzim)this).zzl().zzb(new zzkz(this, l));
            return;
        }
        zzks zzks2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzim)this).zzl().zzb(new zzky(this, zzks2, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzc(Activity activity) {
        zzd zzd2;
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = true;
            if (activity != this.zze) {
                Activity activity2 = activity;
                zzd2 = this;
                Object object2 = ((zzkv)zzd2).zzj;
                synchronized (object2) {
                    ((zzkv)zzd2).zze = activity2;
                    ((zzkv)zzd2).zzf = false;
                }
                if (zzd2.zze().zzv()) {
                    ((zzkv)zzd2).zzg = null;
                    zzd2.zzl().zzb(new zzlb((zzkv)zzd2));
                }
            }
        }
        if (!((zzim)this).zze().zzv()) {
            this.zzb = this.zzg;
            ((zzim)this).zzl().zzb(new zzkw(this));
            return;
        }
        object = this.zzd(activity);
        this.zza(activity, (zzks)object, false);
        zzd2 = ((zzd)this).zzc();
        long l = zzd2.zzb().elapsedRealtime();
        zzd2.zzl().zzb(new zze((zza)zzd2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (!((zzim)this).zze().zzv()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzks zzks2 = this.zzd.get(activity);
        if (zzks2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzks2.zzc);
        bundle2.putString("name", zzks2.zza);
        bundle2.putString("referrer_name", zzks2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @WorkerThread
    private final void zza(@Nullable zzks zzks2, boolean bl, long l) {
        boolean bl2;
        ((zzd)this).zzc().zza(((zzim)this).zzb().elapsedRealtime());
        boolean bl3 = bl2 = zzks2 != null && zzks2.zzd;
        if (((zzd)this).zzp().zza(bl2, bl, l) && zzks2 != null) {
            zzks2.zzd = false;
        }
    }

    @Deprecated
    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!((zzim)this).zze().zzv()) {
            ((zzim)this).zzj().zzv().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
            return;
        }
        zzks zzks2 = this.zzb;
        if (zzks2 == null) {
            ((zzim)this).zzj().zzv().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzim)this).zzj().zzv().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = this.zza(activity.getClass(), "Activity");
        }
        boolean bl = Objects.equals(zzks2.zzb, string2);
        boolean bl2 = Objects.equals(zzks2.zza, string);
        if (bl && bl2) {
            ((zzim)this).zzj().zzv().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > ((zzim)this).zze().zza(null, false))) {
            ((zzim)this).zzj().zzv().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzim)this).zze().zza(null, false))) {
            ((zzim)this).zzj().zzv().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzim)this).zzj().zzp().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzks zzks3 = new zzks(string, string2, ((zzim)this).zzq().zzm());
        this.zzd.put(activity, zzks3);
        this.zza(activity, zzks3, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Bundle bundle, long l) {
        zzks zzks2;
        String string = null;
        String string2 = null;
        Object object = this.zzj;
        synchronized (object) {
            if (!this.zzi) {
                ((zzim)this).zzj().zzv().zza("Cannot log screen view event when the app is in the background.");
                return;
            }
            if (bundle != null) {
                string = bundle.getString("screen_name");
                if (string != null && (string.length() <= 0 || string.length() > ((zzim)this).zze().zza(null, false))) {
                    ((zzim)this).zzj().zzv().zza("Invalid screen name length for screen view. Length", string.length());
                    return;
                }
                string2 = bundle.getString("screen_class");
                if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzim)this).zze().zza(null, false))) {
                    ((zzim)this).zzj().zzv().zza("Invalid screen class length for screen view. Length", string2.length());
                    return;
                }
            }
            if (string2 == null) {
                string2 = this.zze != null ? this.zza(this.zze.getClass(), "Activity") : "Activity";
            }
            zzks2 = this.zzb;
            if (this.zzf && zzks2 != null) {
                this.zzf = false;
                boolean bl = Objects.equals(zzks2.zzb, string2);
                boolean bl2 = Objects.equals(zzks2.zza, string);
                if (bl && bl2) {
                    ((zzim)this).zzj().zzv().zza("Ignoring call to log screen view event with duplicate parameters.");
                    return;
                }
            }
        }
        ((zzim)this).zzj().zzp().zza("Logging screen view with name, class", string == null ? "null" : string, string2 == null ? "null" : string2);
        object = this.zzb == null ? this.zzc : this.zzb;
        this.zzb = zzks2 = new zzks(string, string2, ((zzim)this).zzq().zzm(), true, l);
        this.zzc = object;
        this.zzg = zzks2;
        long l2 = ((zzim)this).zzb().elapsedRealtime();
        ((zzim)this).zzl().zzb(new zzku(this, bundle, zzks2, (zzks)object, l2));
    }

    @Override
    protected final boolean zzz() {
        return false;
    }
}

