/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzdq;
import com.google.android.gms.internal.measurement.zzhi;
import com.google.android.gms.internal.measurement.zznx;
import com.google.android.gms.internal.measurement.zzoo;
import com.google.android.gms.internal.measurement.zzpg;
import com.google.android.gms.internal.measurement.zzpz;
import com.google.android.gms.internal.measurement.zzqx;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzad;
import com.google.android.gms.measurement.internal.zzae;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzax;
import com.google.android.gms.measurement.internal.zzaz;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzfu;
import com.google.android.gms.measurement.internal.zzfv;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzhh;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzhp;
import com.google.android.gms.measurement.internal.zzhq;
import com.google.android.gms.measurement.internal.zzin;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zziq;
import com.google.android.gms.measurement.internal.zzir;
import com.google.android.gms.measurement.internal.zzis;
import com.google.android.gms.measurement.internal.zziy;
import com.google.android.gms.measurement.internal.zzja;
import com.google.android.gms.measurement.internal.zzjb;
import com.google.android.gms.measurement.internal.zzkm;
import com.google.android.gms.measurement.internal.zzkr;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzlf;
import com.google.android.gms.measurement.internal.zzmp;
import com.google.android.gms.measurement.internal.zznw;
import com.google.android.gms.measurement.internal.zzo;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.json.JSONException;
import org.json.JSONObject;

public class zzho
implements zziq {
    private static volatile @Nullable zzho zzb;
    private final Context zzc;
    private final @Nullable String zzd;
    private final @Nullable String zze;
    private final @Nullable String zzf;
    private final boolean zzg;
    private final zzad zzh;
    private final zzae zzi;
    private final zzgm zzj;
    private final zzgb zzk;
    private final zzhh zzl;
    private final zzmp zzm;
    private final zznw zzn;
    private final zzfw zzo;
    private final Clock zzp;
    private final zzkw zzq;
    private final zzja zzr;
    private final zza zzs;
    private final zzkr zzt;
    private final @Nullable String zzu;
    private zzfu zzv;
    private zzlf zzw;
    private zzaz zzx;
    private zzfv zzy;
    private boolean zzz = false;
    private Boolean zzaa;
    private long zzab;
    private volatile @Nullable Boolean zzac;
    @VisibleForTesting
    private Boolean zzad;
    @VisibleForTesting
    private Boolean zzae;
    private volatile boolean zzaf;
    private int zzag;
    private int zzah;
    private AtomicInteger zzai = new AtomicInteger(0);
    @VisibleForTesting
    final long zza;

    @WorkerThread
    public final int zzc() {
        ((zzio)this.zzl()).zzt();
        if (this.zzi.zzw()) {
            return 1;
        }
        if (this.zzae != null && this.zzae.booleanValue()) {
            return 2;
        }
        if (!this.zzad()) {
            return 8;
        }
        Boolean bl = this.zzn().zzv();
        if (bl != null) {
            if (bl.booleanValue()) {
                return 0;
            }
            return 3;
        }
        zzae zzae2 = this.zzi;
        Boolean bl2 = zzae2.zzf("firebase_analytics_collection_enabled");
        if (bl2 != null) {
            if (bl2.booleanValue()) {
                return 0;
            }
            return 4;
        }
        if (this.zzad != null) {
            if (this.zzad.booleanValue()) {
                return 0;
            }
            return 5;
        }
        if (this.zzac != null) {
            if (this.zzac.booleanValue()) {
                return 0;
            }
            return 7;
        }
        return 0;
    }

    @Override
    @Pure
    public final Context zza() {
        return this.zzc;
    }

    @Override
    @Pure
    public final Clock zzb() {
        return this.zzp;
    }

    @Pure
    public final zza zze() {
        if (this.zzs == null) {
            throw new IllegalStateException("Component not created");
        }
        return this.zzs;
    }

    @Override
    @Pure
    public final zzad zzd() {
        return this.zzh;
    }

    @Pure
    public final zzae zzf() {
        return this.zzi;
    }

    @Pure
    public final zzaz zzg() {
        zzho.zza(this.zzx);
        return this.zzx;
    }

    @Pure
    public final zzfv zzh() {
        zzho.zza(this.zzy);
        return this.zzy;
    }

    @Pure
    public final zzfu zzi() {
        zzho.zza(this.zzv);
        return this.zzv;
    }

    @Pure
    public final zzfw zzk() {
        return this.zzo;
    }

    @Override
    @Pure
    public final zzgb zzj() {
        zzho.zza(this.zzk);
        return this.zzk;
    }

    public final @Nullable zzgb zzm() {
        if (this.zzk != null && this.zzk.zzaf()) {
            return this.zzk;
        }
        return null;
    }

    @Pure
    public final zzgm zzn() {
        zzho.zza((zzio)this.zzj);
        return this.zzj;
    }

    @Override
    @Pure
    public final zzhh zzl() {
        zzho.zza(this.zzl);
        return this.zzl;
    }

    @SideEffectFree
    final @Nullable zzhh zzo() {
        return this.zzl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzho zza(Context context, @Nullable zzdq zzdq2, @Nullable Long l) {
        if (zzdq2 != null && (zzdq2.zze == null || zzdq2.zzf == null)) {
            zzdq2 = new zzdq(zzdq2.zza, zzdq2.zzb, zzdq2.zzc, zzdq2.zzd, null, null, zzdq2.zzg, null);
        }
        Preconditions.checkNotNull((Object)context);
        Preconditions.checkNotNull((Object)context.getApplicationContext());
        if (zzb == null) {
            Class<zzho> clazz = zzho.class;
            synchronized (zzho.class) {
                if (zzb == null) {
                    zziy zziy2 = new zziy(context, zzdq2, l);
                    zzb = new zzho(zziy2);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
            }
        } else if (zzdq2 != null && zzdq2.zzg != null && zzdq2.zzg.containsKey("dataCollectionDefaultEnabled")) {
            Preconditions.checkNotNull((Object)zzb);
            zzb.zza(zzdq2.zzg.getBoolean("dataCollectionDefaultEnabled"));
        }
        {
            Preconditions.checkNotNull((Object)zzb);
            return zzb;
        }
    }

    @Pure
    public final zzja zzp() {
        zzho.zza(this.zzr);
        return this.zzr;
    }

    @Pure
    private final zzkr zzai() {
        zzho.zza(this.zzt);
        return this.zzt;
    }

    @Pure
    public final zzkw zzq() {
        zzho.zza(this.zzq);
        return this.zzq;
    }

    @Pure
    public final zzlf zzr() {
        zzho.zza(this.zzw);
        return this.zzw;
    }

    @Pure
    public final zzmp zzs() {
        zzho.zza(this.zzm);
        return this.zzm;
    }

    @Pure
    public final zznw zzt() {
        zzho.zza((zzio)this.zzn);
        return this.zzn;
    }

    @Pure
    public final @Nullable String zzu() {
        return this.zzd;
    }

    @Pure
    public final @Nullable String zzv() {
        return this.zze;
    }

    @Pure
    public final @Nullable String zzw() {
        return this.zzf;
    }

    @Pure
    public final @Nullable String zzx() {
        return this.zzu;
    }

    static /* synthetic */ void zza(zzho zzho2, zziy zziy2) {
        zziy zziy3 = zziy2;
        zzho zzho3 = zzho2;
        ((zzio)zzho3.zzl()).zzt();
        Object object = zzho3;
        zzaz zzaz2 = new zzaz((zzho)object);
        zzaz2.zzad();
        zzho3.zzx = zzaz2;
        zzho zzho4 = zzho3;
        object = zziy3;
        zzfv zzfv2 = new zzfv(zzho4, ((zziy)object).zzf);
        zzfv2.zzv();
        zzho3.zzy = zzfv2;
        object = zzho3;
        zzfu zzfu2 = new zzfu((zzho)object);
        zzfu2.zzv();
        zzho3.zzv = zzfu2;
        object = zzho3;
        zzlf zzlf2 = new zzlf((zzho)object);
        zzlf2.zzv();
        zzho3.zzw = zzlf2;
        zzho3.zzn.zzae();
        zzho3.zzj.zzae();
        zzho3.zzy.zzw();
        zzho3.zzj().zzn().zza("App measurement initialized, version", 88000L);
        zzho3.zzj().zzn().zza("To enable debug logging run: adb shell setprop log.tag.FA VERBOSE");
        String string = zzfv2.zzad();
        if (TextUtils.isEmpty((CharSequence)zzho3.zzd)) {
            if (zzho3.zzt().zzd(string, zzho3.zzi.zzp())) {
                zzho3.zzj().zzn().zza("Faster debug mode event logging enabled. To disable, run:\n  adb shell setprop debug.firebase.analytics.app .none.");
            } else {
                String string2 = string;
                zzho3.zzj().zzn().zza("To enable faster debug mode event logging run:\n  adb shell setprop debug.firebase.analytics.app " + string2);
            }
        }
        zzho3.zzj().zzc().zza("Debug-level message logging enabled");
        if (zzho3.zzag != zzho3.zzai.get()) {
            zzho3.zzj().zzg().zza("Not all components initialized", zzho3.zzag, zzho3.zzai.get());
        }
        zzho3.zzz = true;
    }

    private zzho(zziy zziy2) {
        Object object;
        Preconditions.checkNotNull((Object)zziy2);
        Object object2 = zziy2.zza;
        zzfp.zza = this.zzh = new zzad((Context)object2);
        this.zzc = zziy2.zza;
        this.zzd = zziy2.zzb;
        this.zze = zziy2.zzc;
        this.zzf = zziy2.zzd;
        this.zzg = zziy2.zzh;
        this.zzac = zziy2.zze;
        this.zzu = zziy2.zzj;
        this.zzaf = true;
        zzdq zzdq2 = zziy2.zzg;
        if (zzdq2 != null && zzdq2.zzg != null) {
            object = zzdq2.zzg.get("measurementEnabled");
            if (object instanceof Boolean) {
                this.zzad = (Boolean)object;
            }
            if ((object = zzdq2.zzg.get("measurementDeactivated")) instanceof Boolean) {
                this.zzae = (Boolean)object;
            }
        }
        zzhi.zzb(this.zzc);
        this.zzp = DefaultClock.getInstance();
        this.zza = zziy2.zzi != null ? zziy2.zzi.longValue() : this.zzp.currentTimeMillis();
        object2 = this;
        this.zzi = new zzae((zzho)object2);
        object2 = this;
        object = new zzgm((zzho)object2);
        ((zzin)object).zzad();
        this.zzj = object;
        object2 = this;
        zzgb zzgb2 = new zzgb((zzho)object2);
        zzgb2.zzad();
        this.zzk = zzgb2;
        object2 = this;
        zznw zznw2 = new zznw((zzho)object2);
        zznw2.zzad();
        this.zzn = zznw2;
        zzho zzho2 = this;
        object2 = zziy2;
        Object object3 = new zzjb((zziy)object2, zzho2);
        this.zzo = new zzfw((zzfz)object3);
        object2 = this;
        this.zzs = new zza((zzho)object2);
        object2 = this;
        zzkw zzkw2 = new zzkw((zzho)object2);
        zzkw2.zzv();
        this.zzq = zzkw2;
        object2 = this;
        zzja zzja2 = new zzja((zzho)object2);
        zzja2.zzv();
        this.zzr = zzja2;
        object2 = this;
        zzmp zzmp2 = new zzmp((zzho)object2);
        zzmp2.zzv();
        this.zzm = zzmp2;
        object2 = this;
        zzkr zzkr2 = new zzkr((zzho)object2);
        zzkr2.zzad();
        this.zzt = zzkr2;
        object2 = this;
        zzhh zzhh2 = new zzhh((zzho)object2);
        zzhh2.zzad();
        this.zzl = zzhh2;
        boolean bl = zziy2.zzg != null && zziy2.zzg.zzb != 0L;
        boolean bl2 = !bl;
        object2 = this;
        if (((zzho)object2).zzc.getApplicationContext() instanceof Application) {
            boolean bl3 = bl2;
            object3 = ((zzho)object2).zzp();
            if (((zzio)object3).zza().getApplicationContext() instanceof Application) {
                Application application = (Application)((zzio)object3).zza().getApplicationContext();
                if (((zzja)object3).zza == null) {
                    ((zzja)object3).zza = new zzkm((zzja)object3);
                }
                if (bl3) {
                    application.unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzja)object3).zza);
                    application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)((zzja)object3).zza);
                    ((zzio)object3).zzj().zzp().zza("Registered activity lifecycle callback");
                }
            }
        } else {
            ((zzho)object2).zzj().zzu().zza("Application context is not an Application");
        }
        this.zzl.zzb(new zzhp(this, zziy2));
    }

    private static void zza(zzio zzio2) {
        if (zzio2 == null) {
            throw new IllegalStateException("Component not created");
        }
    }

    private static void zza(zzg zzg2) {
        if (zzg2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzg2.zzy()) {
            String string = String.valueOf(zzg2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    private static void zza(zzin zzin2) {
        if (zzin2 == null) {
            throw new IllegalStateException("Component not created");
        }
        if (!zzin2.zzaf()) {
            String string = String.valueOf(zzin2.getClass());
            throw new IllegalStateException("Component not initialized: " + string);
        }
    }

    final void zzy() {
        throw new IllegalStateException("Unexpected call on client side");
    }

    final void zzz() {
        this.zzai.incrementAndGet();
    }

    final /* synthetic */ void zza(String string, int n, Throwable throwable, byte[] byArray, Map map) {
        Throwable throwable2 = throwable;
        byte[] byArray2 = byArray;
        int n2 = n;
        zzho zzho2 = this;
        if (!((n2 == 200 || n2 == 204 || n2 == 304) && throwable2 == null)) {
            zzho2.zzj().zzu().zza("Network Request for Deferred Deep Link failed. response, exception", n2, throwable2);
            return;
        }
        zzho2.zzn().zzo.zza(true);
        if (byArray2 == null || byArray2.length == 0) {
            zzho2.zzj().zzc().zza("Deferred Deep Link response empty.");
            return;
        }
        String string2 = new String(byArray2);
        try {
            JSONObject jSONObject = new JSONObject(string2);
            String string3 = jSONObject.optString("deeplink", "");
            String string4 = jSONObject.optString("gclid", "");
            String string5 = jSONObject.optString("gbraid", "");
            double d = jSONObject.optDouble("timestamp", 0.0);
            if (TextUtils.isEmpty((CharSequence)string3)) {
                zzho2.zzj().zzc().zza("Deferred Deep Link is empty.");
                return;
            }
            Bundle bundle = new Bundle();
            if (zzpg.zza() && zzho2.zzi.zza(zzbh.zzct)) {
                if (!zzho2.zzt().zzi(string3)) {
                    zzho2.zzj().zzu().zza("Deferred Deep Link validation failed. gclid, gbraid, deep link", string4, string5, string3);
                    return;
                }
                bundle.putString("gbraid", string5);
            } else if (!zzho2.zzt().zzi(string3)) {
                zzho2.zzj().zzu().zza("Deferred Deep Link validation failed. gclid, deep link", string4, string3);
                return;
            }
            bundle.putString("gclid", string4);
            bundle.putString("_cis", "ddp");
            zzho2.zzr.zzc("auto", "_cmp", bundle);
            String string6 = string3;
            zznw zznw2 = zzho2.zzt();
            if (!TextUtils.isEmpty((CharSequence)string6) && zznw2.zza(string6, d)) {
                Intent intent = new Intent("android.google.analytics.action.DEEPLINK_ACTION");
                ((zzio)zznw2).zza().sendBroadcast(intent);
            }
            return;
        }
        catch (JSONException jSONException) {
            zzho2.zzj().zzg().zza("Failed to parse the Deferred Deep Link response. exception", (Object)jSONException);
            return;
        }
    }

    final void zzaa() {
        ++this.zzag;
    }

    @WorkerThread
    final void zza(boolean bl) {
        this.zzac = bl;
    }

    @WorkerThread
    public final void zzb(boolean bl) {
        ((zzio)this.zzl()).zzt();
        this.zzaf = bl;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    protected final void zza(@Nullable zzdq var1_1) {
        block39: {
            block38: {
                this.zzl().zzt();
                if (zzpz.zza() && this.zzi.zza(zzbh.zzch) && this.zzt().zzw()) {
                    var9_2 = this.zzt();
                    var9_2.zzt();
                    var10_3 = new IntentFilter();
                    var10_3.addAction("com.google.android.gms.measurement.TRIGGERS_AVAILABLE");
                    var11_4 = new zzo(var9_2.zzu);
                    ContextCompat.registerReceiver((Context)var9_2.zza(), (BroadcastReceiver)var11_4, (IntentFilter)var10_3, (int)2);
                    var9_2.zzj().zzc().zza("Registered app receiver");
                }
                var2_7 = this.zzn().zzn();
                var3_8 = var2_7.zza();
                var4_9 = null;
                if (zznx.zza() && this.zzi.zza(zzbh.zzda)) {
                    var5_11 = this.zzi.zze("google_analytics_default_allow_ad_storage");
                    var6_13 = this.zzi.zze("google_analytics_default_allow_analytics_storage");
                    if ((var5_11 != zzir.zza || var6_13 != zzir.zza) && this.zzn().zza(-10)) {
                        var4_9 = zzis.zza(var5_11, var6_13, -10);
                    } else if (!(TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || var3_8 != 0 && var3_8 != 30 && var3_8 != 10 && var3_8 != 30 && var3_8 != 30 && var3_8 != 40)) {
                        var11_5 = this.zza;
                        this.zzp().zza(new zzis(null, null, -10), var11_5, false);
                    } else if (TextUtils.isEmpty((CharSequence)this.zzh().zzae()) && var1_1 != null && var1_1.zzg != null && this.zzn().zza(30) && (var7_15 = zzis.zza(var1_1.zzg, 30)).zzk()) {
                        var4_9 = var7_15;
                    }
                } else {
                    var9_2 = this.zzi;
                    var5_12 = var9_2.zzf("google_analytics_default_allow_ad_storage");
                    var9_2 = this.zzi;
                    var6_14 = var9_2.zzf("google_analytics_default_allow_analytics_storage");
                    if ((var5_12 != null || var6_14 != null) && this.zzn().zza(-10)) {
                        var4_9 = new zzis(var5_12, var6_14, -10);
                    } else if (!(TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || var3_8 != 0 && var3_8 != 30 && var3_8 != 10 && var3_8 != 30 && var3_8 != 30 && var3_8 != 40)) {
                        var11_6 = this.zza;
                        this.zzp().zza(new zzis(null, null, -10), var11_6, false);
                    } else if (TextUtils.isEmpty((CharSequence)this.zzh().zzae()) && var1_1 != null && var1_1.zzg != null && this.zzn().zza(30) && (var7_16 = zzis.zza(var1_1.zzg, 30)).zzk()) {
                        var4_9 = var7_16;
                    }
                }
                if (var4_9 != null) {
                    var2_7 = var4_9;
                    this.zzp().zza(var2_7, this.zza, this.zzi.zza(zzbh.zzde));
                }
                this.zzp().zza(var2_7);
                var10_3 = var1_1;
                var9_2 = this;
                var12_17 = var9_2.zzn().zzm().zza();
                if (!zznx.zza() || !var9_2.zzi.zza(zzbh.zzda)) break block38;
                var13_18 /* !! */  = var9_2.zzi.zze("google_analytics_default_allow_ad_user_data");
                if (var13_18 /* !! */  == zzir.zza || !zzis.zza(-10, var12_17)) ** GOTO lbl-1000
                var9_2.zzp().zza(zzax.zza((zzir)var13_18 /* !! */ , -10), var9_2.zzi.zza(zzbh.zzde));
                break block39;
            }
            var15_19 = var9_2.zzi;
            var13_18 /* !! */  = var15_19.zzf("google_analytics_default_allow_ad_user_data");
            if (var13_18 /* !! */  != null && zzis.zza(-10, var12_17)) {
                var9_2.zzp().zza(new zzax(var13_18 /* !! */ , -10), var9_2.zzi.zza(zzbh.zzde));
            } else if (!(TextUtils.isEmpty((CharSequence)var9_2.zzh().zzae()) || var12_17 != 0 && var12_17 != 30)) {
                var9_2.zzp().zza(new zzax(null, -10), var9_2.zzi.zza(zzbh.zzde));
            } else {
                if (TextUtils.isEmpty((CharSequence)var9_2.zzh().zzae()) && var10_3 != null && var10_3.zzg != null && zzis.zza(30, var12_17) && (var13_18 /* !! */  = zzax.zza(var10_3.zzg, 30)).zzg()) {
                    var9_2.zzp().zza((zzax)var13_18 /* !! */ , var9_2.zzi.zza(zzbh.zzde));
                }
                if (TextUtils.isEmpty((CharSequence)var9_2.zzh().zzae()) && var10_3 != null && var10_3.zzg != null && var9_2.zzn().zzh.zza() == null && (var14_20 = zzax.zza(var10_3.zzg)) != null) {
                    var9_2.zzp().zza(var10_3.zze, "allow_personalized_ads", (Object)var14_20.toString(), false);
                }
            }
        }
        if (zzqx.zza() && this.zzi.zza(zzbh.zzcx) && ((var10_3 = (var9_2 = this.zzi).zzf("google_analytics_tcf_data_enabled")) == null ? true : var10_3.booleanValue())) {
            this.zzj().zzc().zza("TCF client enabled.");
            this.zzp().zzaq();
            this.zzp().zzao();
        }
        if (this.zzn().zzc.zza() == 0L) {
            this.zzj().zzp().zza("Persisting first open", this.zza);
            this.zzn().zzc.zza(this.zza);
        }
        this.zzp().zzb.zzb();
        if (!this.zzaf()) {
            if (this.zzac()) {
                if (!this.zzt().zze("android.permission.INTERNET")) {
                    this.zzj().zzg().zza("App is missing INTERNET permission");
                }
                if (!this.zzt().zze("android.permission.ACCESS_NETWORK_STATE")) {
                    this.zzj().zzg().zza("App is missing ACCESS_NETWORK_STATE permission");
                }
                if (!Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() && !this.zzi.zzx()) {
                    if (!zznw.zza(this.zzc)) {
                        this.zzj().zzg().zza("AppMeasurementReceiver not registered/enabled");
                    }
                    if (!zznw.zza(this.zzc, false)) {
                        this.zzj().zzg().zza("AppMeasurementService not registered/enabled");
                    }
                }
                this.zzj().zzg().zza("Uploading is not possible. App measurement disabled");
            }
        } else {
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac())) {
                this.zzt();
                if (zznw.zza(this.zzh().zzae(), this.zzn().zzy(), this.zzh().zzac(), this.zzn().zzx())) {
                    this.zzj().zzn().zza("Rechecking which service to use due to a GMP App Id change");
                    this.zzn().zzz();
                    this.zzi().zzaa();
                    this.zzw.zzae();
                    this.zzw.zzad();
                    this.zzn().zzc.zza(this.zza);
                    this.zzn().zze.zza(null);
                }
                this.zzn().zzc(this.zzh().zzae());
                this.zzn().zzb(this.zzh().zzac());
            }
            if (!this.zzn().zzn().zza(zzis.zza.zzb)) {
                this.zzn().zze.zza(null);
            }
            this.zzp().zza(this.zzn().zze.zza());
            if (!this.zzt().zzx() && !TextUtils.isEmpty((CharSequence)this.zzn().zzq.zza())) {
                this.zzj().zzu().zza("Remote config removed with active feature rollouts");
                this.zzn().zzq.zza(null);
            }
            if (!TextUtils.isEmpty((CharSequence)this.zzh().zzae()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac())) {
                var4_10 = this.zzac();
                if (!this.zzn().zzab() && !this.zzi.zzw()) {
                    this.zzn().zzb(var4_10 == false);
                }
                if (var4_10) {
                    this.zzp().zzak();
                }
                this.zzs().zza.zza();
                this.zzr().zza(new AtomicReference<String>());
                this.zzr().zza(this.zzn().zzt.zza());
            }
        }
        if (zzpz.zza() && this.zzi.zza(zzbh.zzch) && this.zzt().zzw()) {
            v0 = this.zzp();
            Objects.requireNonNull(v0);
            var8_21 = v0;
            new Thread(new zzhn(var8_21)).start();
        }
        this.zzn().zzj.zza(true);
    }

    @WorkerThread
    public final boolean zzab() {
        return this.zzac != null && this.zzac != false;
    }

    @WorkerThread
    public final boolean zzac() {
        return this.zzc() == 0;
    }

    @WorkerThread
    public final boolean zzad() {
        ((zzio)this.zzl()).zzt();
        return this.zzaf;
    }

    @Pure
    public final boolean zzae() {
        return TextUtils.isEmpty((CharSequence)this.zzd);
    }

    @WorkerThread
    protected final boolean zzaf() {
        if (!this.zzz) {
            throw new IllegalStateException("AppMeasurement is not initialized");
        }
        ((zzio)this.zzl()).zzt();
        if (this.zzaa == null || this.zzab == 0L || this.zzaa != null && !this.zzaa.booleanValue() && Math.abs(this.zzp.elapsedRealtime() - this.zzab) > 1000L) {
            this.zzab = this.zzp.elapsedRealtime();
            this.zzaa = this.zzt().zze("android.permission.INTERNET") && this.zzt().zze("android.permission.ACCESS_NETWORK_STATE") && (Wrappers.packageManager((Context)this.zzc).isCallerInstantApp() || this.zzi.zzx() || zznw.zza(this.zzc) && zznw.zza(this.zzc, false));
            if (this.zzaa.booleanValue()) {
                this.zzaa = this.zzt().zza(this.zzh().zzae(), this.zzh().zzac()) || !TextUtils.isEmpty((CharSequence)this.zzh().zzac());
            }
        }
        return this.zzaa;
    }

    @Pure
    public final boolean zzag() {
        return this.zzg;
    }

    @WorkerThread
    public final boolean zzah() {
        URL uRL;
        zzio zzio2;
        ((zzio)this.zzl()).zzt();
        zzho.zza(this.zzai());
        String string = this.zzh().zzad();
        Pair<String, Boolean> pair = this.zzn().zza(string);
        if (!this.zzi.zzu() || ((Boolean)pair.second).booleanValue() || TextUtils.isEmpty((CharSequence)((CharSequence)pair.first))) {
            this.zzj().zzc().zza("ADID unavailable to retrieve Deferred Deep Link. Skipping");
            return false;
        }
        if (!this.zzai().zzc()) {
            this.zzj().zzu().zza("Network is not available for Deferred Deep Link request. Skipping");
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (zzoo.zza() && this.zzi.zza(zzbh.zzco)) {
            zzio2 = this.zzr();
            zzio2.zzt();
            ((zzg)zzio2).zzu();
            if (!((zzlf)zzio2).zzao() ? true : zzio2.zzq().zzg() >= 234200) {
                uRL = null;
                zzio2 = this.zzp();
                zzio2.zzt();
                zzal zzal2 = ((zzd)zzio2).zzo().zzaa();
                if (zzal2 != null) {
                    uRL = zzal2.zza;
                }
                if (uRL == null) {
                    boolean bl = this.zzah++ < 10;
                    String string2 = bl ? "Retrying." : "Skipping.";
                    this.zzj().zzc().zza("Failed to retrieve DMA consent from the service, " + string2 + " retryCount", this.zzah);
                    return bl;
                }
                zzis zzis2 = zzis.zza((Bundle)uRL, 100);
                stringBuilder.append("&gcs=").append(zzis2.zzg());
                zzax zzax2 = zzax.zza((Bundle)uRL, 100);
                stringBuilder.append("&dma=").append(zzax2.zzd() == Boolean.FALSE ? 0 : 1);
                if (!TextUtils.isEmpty((CharSequence)zzax2.zze())) {
                    stringBuilder.append("&dma_cps=").append(zzax2.zze());
                }
                int n = zzax.zza((Bundle)uRL) == Boolean.TRUE ? 0 : 1;
                stringBuilder.append("&npa=").append(n);
                this.zzj().zzp().zza("Consent query parameters to Bow", stringBuilder);
            }
        }
        zznw zznw2 = this.zzt();
        this.zzh();
        uRL = zznw2.zza(88000L, string, (String)pair.first, this.zzn().zzp.zza() - 1L, stringBuilder.toString());
        if (uRL != null) {
            zzho zzho2 = this;
            zzhq zzhq2 = new zzhq(zzho2);
            URL uRL2 = uRL;
            String string3 = string;
            zzio2 = this.zzai();
            zzio2.zzt();
            ((zzin)zzio2).zzac();
            Preconditions.checkNotNull((Object)uRL2);
            Preconditions.checkNotNull((Object)zzhq2);
            zzio2.zzl().zza(new zzkt((zzkr)zzio2, string3, uRL2, null, null, zzhq2));
        }
        return false;
    }
}

