/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.VisibleForTesting;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzof;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzfz;
import com.google.android.gms.measurement.internal.zzgb;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzhg;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzim;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzfw
extends zzim {
    private char zza = '\u0000';
    private long zzb = -1L;
    @GuardedBy(value="this")
    private @MonotonicNonNull String zzc;
    private final zzfy zzd = new zzfy(this, 6, false, false);
    private final zzfy zze = new zzfy(this, 6, true, false);
    private final zzfy zzf = new zzfy(this, 6, false, true);
    private final zzfy zzg = new zzfy(this, 5, false, false);
    private final zzfy zzh = new zzfy(this, 5, true, false);
    private final zzfy zzi = new zzfy(this, 5, false, true);
    private final zzfy zzj = new zzfy(this, 4, false, false);
    private final zzfy zzk = new zzfy(this, 3, false, false);
    private final zzfy zzl = new zzfy(this, 2, false, false);

    static /* bridge */ /* synthetic */ char zza(zzfw zzfw2) {
        return zzfw2.zza;
    }

    static /* bridge */ /* synthetic */ long zzb(zzfw zzfw2) {
        return zzfw2.zzb;
    }

    public final zzfy zzc() {
        return this.zzk;
    }

    public final zzfy zzg() {
        return this.zzd;
    }

    public final zzfy zzh() {
        return this.zzf;
    }

    public final zzfy zzm() {
        return this.zze;
    }

    public final zzfy zzn() {
        return this.zzj;
    }

    public final zzfy zzp() {
        return this.zzl;
    }

    public final zzfy zzu() {
        return this.zzg;
    }

    public final zzfy zzv() {
        return this.zzi;
    }

    public final zzfy zzw() {
        return this.zzh;
    }

    protected static @Nullable Object zza(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return new zzgb(string);
    }

    static String zza(boolean bl, @Nullable String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        if (string == null) {
            string = "";
        }
        String string2 = zzfw.zza(bl, object);
        String string3 = zzfw.zza(bl, object2);
        String string4 = zzfw.zza(bl, object3);
        StringBuilder stringBuilder = new StringBuilder();
        String string5 = "";
        if (!TextUtils.isEmpty((CharSequence)string)) {
            stringBuilder.append(string);
            string5 = ": ";
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder.append(string5);
            stringBuilder.append(string2);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            stringBuilder.append(string5);
            stringBuilder.append(string3);
            string5 = ", ";
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            stringBuilder.append(string5);
            stringBuilder.append(string4);
        }
        return stringBuilder.toString();
    }

    @VisibleForTesting
    private static String zza(boolean bl, @Nullable Object object) {
        if (object == null) {
            return "";
        }
        if (object instanceof Integer) {
            object = (long)((Integer)object).intValue();
        }
        if (object instanceof Long) {
            if (!bl) {
                return String.valueOf(object);
            }
            if (Math.abs((Long)object) < 100L) {
                return String.valueOf(object);
            }
            String string = String.valueOf(object).charAt(0) == '-' ? "-" : "";
            String string2 = String.valueOf(Math.abs((Long)object));
            long l = Math.round(Math.pow(10.0, string2.length()) - 1.0);
            String string3 = string;
            long l2 = Math.round(Math.pow(10.0, string2.length() - 1));
            String string4 = string;
            return string4 + l2 + "..." + string3 + l;
        }
        if (object instanceof Boolean) {
            return String.valueOf(object);
        }
        if (object instanceof Throwable) {
            Throwable throwable = (Throwable)object;
            StringBuilder stringBuilder = new StringBuilder(bl ? throwable.getClass().getName() : throwable.toString());
            String string = zzfw.zzb(zzhj.class.getCanonicalName());
            for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
                String string5;
                if (stackTraceElement.isNativeMethod() || (string5 = stackTraceElement.getClassName()) == null || !zzfw.zzb(string5).equals(string)) continue;
                stringBuilder.append(": ");
                stringBuilder.append(stackTraceElement);
                break;
            }
            return stringBuilder.toString();
        }
        if (object instanceof zzgb) {
            return zzgb.zza((zzgb)object);
        }
        if (bl) {
            return "-";
        }
        return String.valueOf(object);
    }

    @VisibleForTesting
    private static String zzb(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            if (zzof.zza() && ((Boolean)zzbh.zzby.zza(null)).booleanValue()) {
                return "";
            }
            return string;
        }
        return string.substring(0, n);
    }

    public final @Nullable String zzx() {
        if (((zzij)this).zzk().zzb == null) {
            return null;
        }
        Pair<String, Long> pair = ((zzij)this).zzk().zzb.zza();
        if (pair == null || pair == zzgl.zza) {
            return null;
        }
        String string = (String)pair.first;
        String string2 = String.valueOf(pair.second);
        return string2 + ":" + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"logTagDoNotUseDirectly"})
    @VisibleForTesting
    private final String zzy() {
        zzfw zzfw2 = this;
        synchronized (zzfw2) {
            if (this.zzc == null) {
                String string;
                zzfw zzfw3;
                if (this.zzu.zzw() != null) {
                    zzfw3 = this;
                    string = this.zzu.zzw();
                } else {
                    zzfw3 = this;
                    string = "FA";
                }
                zzfw3.zzc = string;
            }
            Preconditions.checkNotNull((Object)this.zzc);
            return this.zzc;
        }
    }

    static /* bridge */ /* synthetic */ void zza(zzfw zzfw2, long l) {
        zzfw2.zzb = l;
    }

    static /* bridge */ /* synthetic */ void zza(zzfw zzfw2, char c) {
        zzfw2.zza = c;
    }

    zzfw(zzhj zzhj2) {
        super(zzhj2);
    }

    protected final void zza(int n, boolean bl, boolean bl2, String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        if (!bl && this.zza(n)) {
            String string2 = zzfw.zza(false, string, object, object2, object3);
            this.zza(n, string2);
        }
        if (!bl2 && n >= 5) {
            Object object4 = object3;
            Object object5 = object2;
            Object object6 = object;
            String string3 = string;
            int n2 = n;
            zzfw zzfw2 = this;
            Preconditions.checkNotNull((Object)string3);
            zzhg zzhg2 = zzfw2.zzu.zzo();
            if (zzhg2 == null) {
                zzfw2.zza(6, "Scheduler not set. Not logging error/warn");
                return;
            }
            if (!zzhg2.zzaf()) {
                zzfw2.zza(6, "Scheduler not initialized. Not logging error/warn");
                return;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            if (n2 >= 9) {
                n2 = 8;
            }
            int n3 = n2;
            zzhg2.zzb(new zzfz(zzfw2, n3, string3, object6, object5, object4));
        }
    }

    @VisibleForTesting
    protected final void zza(int n, String string) {
        Log.println((int)n, (String)this.zzy(), (String)string);
    }

    @VisibleForTesting
    protected final boolean zza(int n) {
        return Log.isLoggable((String)this.zzy(), (int)n);
    }

    @Override
    protected final boolean zzo() {
        return false;
    }
}

