/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.app.Activity;
import android.os.Bundle;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzku;
import com.google.android.gms.measurement.internal.zzkv;
import com.google.android.gms.measurement.internal.zzkw;
import com.google.android.gms.measurement.internal.zzkx;
import com.google.android.gms.measurement.internal.zzky;
import com.google.android.gms.measurement.internal.zzkz;
import com.google.android.gms.measurement.internal.zznt;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzks
extends zzg {
    private volatile @Nullable zzkt zzb;
    private volatile @Nullable zzkt zzc;
    @VisibleForTesting
    protected @Nullable zzkt zza;
    private final Map<Activity, zzkt> zzd;
    @GuardedBy(value="activityLock")
    private @Nullable Activity zze;
    @GuardedBy(value="activityLock")
    private volatile boolean zzf;
    private volatile @Nullable zzkt zzg;
    private @Nullable zzkt zzh;
    @GuardedBy(value="activityLock")
    private boolean zzi;
    private final Object zzj = new Object();

    static /* bridge */ /* synthetic */ zzkt zza(zzks zzks2) {
        return zzks2.zzh;
    }

    @MainThread
    private final zzkt zzd(@NonNull Activity activity) {
        Preconditions.checkNotNull((Object)activity);
        zzkt zzkt2 = this.zzd.get(activity);
        if (zzkt2 == null) {
            String string = this.zza(activity.getClass(), "Activity");
            zzkt2 = new zzkt(null, string, ((zzij)this).zzq().zzm());
            this.zzd.put(activity, zzkt2);
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return zzkt2;
    }

    public final @Nullable zzkt zzaa() {
        return this.zzb;
    }

    @WorkerThread
    public final @Nullable zzkt zza(boolean bl) {
        this.zzu();
        ((zzij)this).zzt();
        if (!bl) {
            return this.zza;
        }
        if (this.zza != null) {
            return this.zza;
        }
        return this.zzh;
    }

    @VisibleForTesting
    private final String zza(Class<?> clazz, String string) {
        String string2 = clazz.getCanonicalName();
        if (string2 == null) {
            return string;
        }
        String string3 = string2;
        zzks zzks2 = this;
        String[] stringArray = string3.split("\\.");
        String string4 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string4.length() > ((zzij)zzks2).zze().zza(null, false)) {
            return string4.substring(0, ((zzij)zzks2).zze().zza(null, false));
        }
        return string4;
    }

    static /* bridge */ /* synthetic */ void zza(zzks zzks2, zzkt zzkt2) {
        zzks2.zzh = null;
    }

    static /* bridge */ /* synthetic */ void zza(zzks zzks2, zzkt zzkt2, zzkt zzkt3, long l, boolean bl, Bundle bundle) {
        zzks2.zza(zzkt2, zzkt3, l, bl, null);
    }

    static /* synthetic */ void zza(zzks zzks2, Bundle bundle, zzkt zzkt2, zzkt zzkt3, long l) {
        long l2 = l;
        zzkt zzkt4 = zzkt3;
        zzkt zzkt5 = zzkt2;
        Bundle bundle2 = bundle;
        zzks zzks3 = zzks2;
        if (bundle2 != null) {
            bundle2.remove("screen_name");
            bundle2.remove("screen_class");
        }
        Bundle bundle3 = ((zzij)zzks3).zzq().zza(null, "screen_view", bundle2, null, false);
        zzks3.zza(zzkt5, zzkt4, l2, true, bundle3);
    }

    static /* bridge */ /* synthetic */ void zza(zzks zzks2, zzkt zzkt2, boolean bl, long l) {
        zzks2.zza(zzkt2, false, l);
    }

    public zzks(zzhj zzhj2) {
        super(zzhj2);
        this.zzd = new ConcurrentHashMap<Activity, zzkt>();
    }

    @MainThread
    private final void zza(Activity activity, zzkt zzkt2, boolean bl) {
        zzkt zzkt3;
        zzkt zzkt4;
        zzkt zzkt5 = zzkt4 = this.zzb == null ? this.zzc : this.zzb;
        if (zzkt2.zzb == null) {
            zzkt3 = activity != null ? this.zza(activity.getClass(), "Activity") : null;
            zzkt2 = new zzkt(zzkt2.zza, (String)((Object)zzkt3), zzkt2.zzc, zzkt2.zze, zzkt2.zzf);
        }
        zzkt3 = zzkt2;
        this.zzc = this.zzb;
        this.zzb = zzkt3;
        long l = ((zzij)this).zzb().elapsedRealtime();
        ((zzij)this).zzl().zzb(new zzku(this, zzkt3, zzkt4, l, bl));
    }

    @WorkerThread
    private final void zza(zzkt zzkt2, @Nullable zzkt zzkt3, long l, boolean bl, @Nullable Bundle bundle) {
        boolean bl2;
        ((zzij)this).zzt();
        boolean bl3 = zzkt3 == null || zzkt3.zzc != zzkt2.zzc || !Objects.equals(zzkt3.zzb, zzkt2.zzb) || !Objects.equals(zzkt3.zza, zzkt2.zza);
        boolean bl4 = bl2 = bl && this.zza != null;
        if (bl3) {
            long l2;
            long l3;
            Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            zznt.zza(zzkt2, bundle2, true);
            if (zzkt3 != null) {
                if (zzkt3.zza != null) {
                    bundle2.putString("_pn", zzkt3.zza);
                }
                if (zzkt3.zzb != null) {
                    bundle2.putString("_pc", zzkt3.zzb);
                }
                bundle2.putLong("_pi", zzkt3.zzc);
            }
            if (bl2 && (l3 = ((zzd)this).zzp().zzb.zza(l2 = l)) > 0L) {
                ((zzij)this).zzq().zza(bundle2, l3);
            }
            if (!((zzij)this).zze().zzv()) {
                bundle2.putLong("_mst", 1L);
            }
            String string = zzkt2.zze ? "app" : "auto";
            long l4 = ((zzij)this).zzb().currentTimeMillis();
            if (zzkt2.zze && zzkt2.zzf != 0L) {
                l4 = zzkt2.zzf;
            }
            ((zzd)this).zzm().zza(string, "_vs", l4, bundle2);
        }
        if (bl2) {
            this.zza(this.zza, true, l);
        }
        this.zza = zzkt2;
        if (zzkt2.zze) {
            this.zzh = zzkt2;
        }
        ((zzd)this).zzo().zza(zzkt2);
    }

    @MainThread
    public final void zza(Activity activity, @Nullable Bundle bundle) {
        if (!((zzij)this).zze().zzv()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzkt zzkt2 = new zzkt(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(activity, zzkt2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            if (activity == this.zze) {
                this.zze = null;
            }
        }
        if (!((zzij)this).zze().zzv()) {
            return;
        }
        this.zzd.remove(activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzb(Activity activity) {
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = false;
            this.zzf = true;
        }
        long l = ((zzij)this).zzb().elapsedRealtime();
        if (!((zzij)this).zze().zzv()) {
            this.zzb = null;
            ((zzij)this).zzl().zzb(new zzkw(this, l));
            return;
        }
        zzkt zzkt2 = this.zzd(activity);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzij)this).zzl().zzb(new zzkz(this, zzkt2, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzc(Activity activity) {
        zzd zzd2;
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = true;
            if (activity != this.zze) {
                Activity activity2 = activity;
                zzd2 = this;
                Object object2 = ((zzks)zzd2).zzj;
                synchronized (object2) {
                    ((zzks)zzd2).zze = activity2;
                    ((zzks)zzd2).zzf = false;
                }
                if (zzd2.zze().zzv()) {
                    ((zzks)zzd2).zzg = null;
                    zzd2.zzl().zzb(new zzky((zzks)zzd2));
                }
            }
        }
        if (!((zzij)this).zze().zzv()) {
            this.zzb = this.zzg;
            ((zzij)this).zzl().zzb(new zzkx(this));
            return;
        }
        object = this.zzd(activity);
        this.zza(activity, (zzkt)object, false);
        zzd2 = ((zzd)this).zzc();
        long l = zzd2.zzb().elapsedRealtime();
        zzd2.zzl().zzb(new zze((zza)zzd2, l));
    }

    @MainThread
    public final void zzb(Activity activity, Bundle bundle) {
        if (!((zzij)this).zze().zzv()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzkt zzkt2 = this.zzd.get(activity);
        if (zzkt2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzkt2.zzc);
        bundle2.putString("name", zzkt2.zza);
        bundle2.putString("referrer_name", zzkt2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @WorkerThread
    private final void zza(@Nullable zzkt zzkt2, boolean bl, long l) {
        boolean bl2;
        ((zzd)this).zzc().zza(((zzij)this).zzb().elapsedRealtime());
        boolean bl3 = bl2 = zzkt2 != null && zzkt2.zzd;
        if (((zzd)this).zzp().zza(bl2, bl, l) && zzkt2 != null) {
            zzkt2.zzd = false;
        }
    }

    @Deprecated
    public final void zza(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!((zzij)this).zze().zzv()) {
            ((zzij)this).zzj().zzv().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
            return;
        }
        zzkt zzkt2 = this.zzb;
        if (zzkt2 == null) {
            ((zzij)this).zzj().zzv().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(activity) == null) {
            ((zzij)this).zzj().zzv().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = this.zza(activity.getClass(), "Activity");
        }
        boolean bl = Objects.equals(zzkt2.zzb, string2);
        boolean bl2 = Objects.equals(zzkt2.zza, string);
        if (bl && bl2) {
            ((zzij)this).zzj().zzv().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > ((zzij)this).zze().zza(null, false))) {
            ((zzij)this).zzj().zzv().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzij)this).zze().zza(null, false))) {
            ((zzij)this).zzj().zzv().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzij)this).zzj().zzp().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzkt zzkt3 = new zzkt(string, string2, ((zzij)this).zzq().zzm());
        this.zzd.put(activity, zzkt3);
        this.zza(activity, zzkt3, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Bundle bundle, long l) {
        zzkt zzkt2;
        String string = null;
        String string2 = null;
        Object object = this.zzj;
        synchronized (object) {
            if (!this.zzi) {
                ((zzij)this).zzj().zzv().zza("Cannot log screen view event when the app is in the background.");
                return;
            }
            if (bundle != null) {
                string = bundle.getString("screen_name");
                if (string != null && (string.length() <= 0 || string.length() > ((zzij)this).zze().zza(null, false))) {
                    ((zzij)this).zzj().zzv().zza("Invalid screen name length for screen view. Length", string.length());
                    return;
                }
                string2 = bundle.getString("screen_class");
                if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzij)this).zze().zza(null, false))) {
                    ((zzij)this).zzj().zzv().zza("Invalid screen class length for screen view. Length", string2.length());
                    return;
                }
            }
            if (string2 == null) {
                string2 = this.zze != null ? this.zza(this.zze.getClass(), "Activity") : "Activity";
            }
            zzkt2 = this.zzb;
            if (this.zzf && zzkt2 != null) {
                this.zzf = false;
                boolean bl = Objects.equals(zzkt2.zzb, string2);
                boolean bl2 = Objects.equals(zzkt2.zza, string);
                if (bl && bl2) {
                    ((zzij)this).zzj().zzv().zza("Ignoring call to log screen view event with duplicate parameters.");
                    return;
                }
            }
        }
        ((zzij)this).zzj().zzp().zza("Logging screen view with name, class", string == null ? "null" : string, string2 == null ? "null" : string2);
        object = this.zzb == null ? this.zzc : this.zzb;
        this.zzb = zzkt2 = new zzkt(string, string2, ((zzij)this).zzq().zzm(), true, l);
        this.zzc = object;
        this.zzg = zzkt2;
        long l2 = ((zzij)this).zzb().elapsedRealtime();
        ((zzij)this).zzl().zzb(new zzkv(this, bundle, zzkt2, (zzkt)object, l2));
    }

    @Override
    protected final boolean zzz() {
        return false;
    }
}

