/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.os.RemoteException;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.internal.measurement.zzdd;
import com.google.android.gms.internal.measurement.zznh;
import com.google.android.gms.measurement.internal.zzac;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzav;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzd;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzhj;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzkt;
import com.google.android.gms.measurement.internal.zzla;
import com.google.android.gms.measurement.internal.zzlc;
import com.google.android.gms.measurement.internal.zzld;
import com.google.android.gms.measurement.internal.zzle;
import com.google.android.gms.measurement.internal.zzlf;
import com.google.android.gms.measurement.internal.zzlg;
import com.google.android.gms.measurement.internal.zzlh;
import com.google.android.gms.measurement.internal.zzli;
import com.google.android.gms.measurement.internal.zzlj;
import com.google.android.gms.measurement.internal.zzlk;
import com.google.android.gms.measurement.internal.zzll;
import com.google.android.gms.measurement.internal.zzlm;
import com.google.android.gms.measurement.internal.zzln;
import com.google.android.gms.measurement.internal.zzlo;
import com.google.android.gms.measurement.internal.zzlp;
import com.google.android.gms.measurement.internal.zzlq;
import com.google.android.gms.measurement.internal.zzlr;
import com.google.android.gms.measurement.internal.zzls;
import com.google.android.gms.measurement.internal.zzlt;
import com.google.android.gms.measurement.internal.zzlu;
import com.google.android.gms.measurement.internal.zzlv;
import com.google.android.gms.measurement.internal.zzlw;
import com.google.android.gms.measurement.internal.zzlx;
import com.google.android.gms.measurement.internal.zzmu;
import com.google.android.gms.measurement.internal.zzmv;
import com.google.android.gms.measurement.internal.zzn;
import com.google.android.gms.measurement.internal.zzno;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzlb
extends zzg {
    private final zzlw zza;
    private @Nullable zzfp zzb;
    private volatile Boolean zzc;
    private final zzav zzd;
    private final zzmv zze;
    private final List<Runnable> zzf = new ArrayList<Runnable>();
    private final zzav zzg;

    @WorkerThread
    private final @Nullable zzn zzc(boolean bl) {
        return ((zzd)this).zzg().zza(bl ? ((zzij)this).zzj().zzx() : null);
    }

    @WorkerThread
    protected final @Nullable zzal zzaa() {
        ((zzij)this).zzt();
        this.zzu();
        zzfp zzfp2 = this.zzb;
        if (zzfp2 == null) {
            this.zzad();
            ((zzij)this).zzj().zzc().zza("Failed to get consents; not connected to service yet.");
            return null;
        }
        zzn zzn2 = this.zzc(false);
        Preconditions.checkNotNull((Object)((Object)zzn2));
        try {
            zzal zzal2 = zzfp2.zza(zzn2);
            this.zzaq();
            return zzal2;
        }
        catch (RemoteException remoteException) {
            ((zzij)this).zzj().zzg().zza("Failed to get consents; remote exception", (Object)remoteException);
            return null;
        }
    }

    static /* bridge */ /* synthetic */ zzfp zza(zzlb zzlb2) {
        return zzlb2.zzb;
    }

    static /* bridge */ /* synthetic */ zzlw zzb(zzlb zzlb2) {
        return zzlb2.zza;
    }

    final Boolean zzab() {
        return this.zzc;
    }

    static /* bridge */ /* synthetic */ void zza(zzlb zzlb2, zzfp zzfp2) {
        zzlb2.zzb = null;
    }

    static /* synthetic */ void zzc(zzlb zzlb2) {
        zzlb2.zzap();
    }

    static /* synthetic */ void zzd(zzlb zzlb2) {
        zzlb zzlb3 = zzlb2;
        ((zzij)zzlb3).zzt();
        if (zzlb3.zzak()) {
            ((zzij)zzlb3).zzj().zzp().zza("Inactivity, disconnecting from the service");
            zzlb3.zzae();
        }
    }

    static /* synthetic */ void zza(zzlb zzlb2, ComponentName componentName) {
        ComponentName componentName2 = componentName;
        zzlb zzlb3 = zzlb2;
        ((zzij)zzlb3).zzt();
        if (zzlb3.zzb != null) {
            zzlb3.zzb = null;
            ((zzij)zzlb3).zzj().zzp().zza("Disconnected from device MeasurementService", componentName2);
            zzlb zzlb4 = zzlb3;
            ((zzij)zzlb4).zzt();
            zzlb4.zzad();
        }
    }

    static /* synthetic */ void zze(zzlb zzlb2) {
        zzlb2.zzaq();
    }

    protected zzlb(zzhj zzhj2) {
        super(zzhj2);
        this.zze = new zzmv(zzhj2.zzb());
        this.zza = new zzlw(this);
        this.zzd = new zzlc(this, zzhj2);
        this.zzg = new zzlp(this, zzhj2);
    }

    @WorkerThread
    protected final void zzac() {
        ((zzij)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(true);
        ((zzd)this).zzh().zzab();
        this.zza(new zzlk(this, zzn2));
    }

    @WorkerThread
    final void zzad() {
        ((zzij)this).zzt();
        this.zzu();
        if (this.zzak()) {
            return;
        }
        if (this.zzao()) {
            this.zza.zza();
            return;
        }
        if (!((zzij)this).zze().zzx()) {
            Intent intent;
            zzlb zzlb2 = this;
            PackageManager packageManager = ((zzij)zzlb2).zza().getPackageManager();
            List list = packageManager.queryIntentServices(intent = new Intent().setClassName(((zzij)zzlb2).zza(), "com.google.android.gms.measurement.AppMeasurementService"), 65536);
            if (list != null && !list.isEmpty()) {
                Intent intent2 = new Intent("com.google.android.gms.measurement.START");
                intent2.setComponent(new ComponentName(((zzij)this).zza(), "com.google.android.gms.measurement.AppMeasurementService"));
                this.zza.zza(intent2);
                return;
            }
            ((zzij)this).zzj().zzg().zza("Unable to use remote or local measurement implementation. Please register the AppMeasurementService service in the app manifest");
        }
    }

    @WorkerThread
    public final void zzae() {
        ((zzij)this).zzt();
        this.zzu();
        this.zza.zzb();
        try {
            ConnectionTracker.getInstance().unbindService(((zzij)this).zza(), (ServiceConnection)this.zza);
        }
        catch (IllegalArgumentException | IllegalStateException runtimeException) {}
        this.zzb = null;
    }

    @WorkerThread
    private final void zzap() {
        ((zzij)this).zzt();
        ((zzij)this).zzj().zzp().zza("Processing queued up service tasks", this.zzf.size());
        for (Runnable runnable : this.zzf) {
            try {
                runnable.run();
            }
            catch (RuntimeException runtimeException) {
                ((zzij)this).zzj().zzg().zza("Task exception while flushing queue", runtimeException);
            }
        }
        this.zzf.clear();
        this.zzg.zza();
    }

    @WorkerThread
    public final void zza(zzdd zzdd2) {
        ((zzij)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzll(this, zzn2, zzdd2));
    }

    @WorkerThread
    public final void zza(AtomicReference<String> atomicReference) {
        ((zzij)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzli(this, atomicReference, zzn2));
    }

    @WorkerThread
    protected final void zza(zzdd zzdd2, @Nullable String string, @Nullable String string2) {
        ((zzij)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzlu(this, string, string2, zzn2, zzdd2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzac>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3) {
        ((zzij)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzlv(this, atomicReference, string, string2, string3, zzn2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zzmu>> atomicReference, Bundle bundle) {
        ((zzij)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzlh(this, atomicReference, zzn2, bundle));
    }

    @WorkerThread
    protected final void zza(AtomicReference<@Nullable List<zzno>> atomicReference, boolean bl) {
        ((zzij)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzle(this, atomicReference, zzn2, bl));
    }

    @WorkerThread
    protected final void zza(zzdd zzdd2, @Nullable String string, @Nullable String string2, boolean bl) {
        ((zzij)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzlf(this, string, string2, zzn2, bl, zzdd2));
    }

    @WorkerThread
    protected final void zza(AtomicReference<List<zzno>> atomicReference, @Nullable String string, @Nullable String string2, @Nullable String string3, boolean bl) {
        ((zzij)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzlx(this, atomicReference, string, string2, string3, zzn2, bl));
    }

    final /* synthetic */ void zzaf() {
        zzfp zzfp2 = this.zzb;
        if (zzfp2 == null) {
            ((zzij)this).zzj().zzg().zza("Failed to send Dma consent settings to service");
            return;
        }
        try {
            zzn zzn2 = this.zzc(false);
            Preconditions.checkNotNull((Object)((Object)zzn2));
            zzfp2.zzf(zzn2);
            this.zzaq();
            return;
        }
        catch (RemoteException remoteException) {
            ((zzij)this).zzj().zzg().zza("Failed to send Dma consent settings to the service", (Object)remoteException);
            return;
        }
    }

    final /* synthetic */ void zzag() {
        zzfp zzfp2 = this.zzb;
        if (zzfp2 == null) {
            ((zzij)this).zzj().zzg().zza("Failed to send storage consent settings to service");
            return;
        }
        try {
            zzn zzn2 = this.zzc(false);
            Preconditions.checkNotNull((Object)((Object)zzn2));
            zzfp2.zzh(zzn2);
            this.zzaq();
            return;
        }
        catch (RemoteException remoteException) {
            ((zzij)this).zzj().zzg().zza("Failed to send storage consent settings to the service", (Object)remoteException);
            return;
        }
    }

    @WorkerThread
    protected final void zza(zzbf zzbf2, @Nullable String string) {
        Preconditions.checkNotNull((Object)((Object)zzbf2));
        ((zzij)this).zzt();
        this.zzu();
        boolean bl = ((zzd)this).zzh().zza(zzbf2);
        zzn zzn2 = this.zzc(true);
        this.zza(new zzlt(this, true, zzn2, bl, zzbf2, string));
    }

    @WorkerThread
    public final void zza(zzdd zzdd2, zzbf zzbf2, String string) {
        ((zzij)this).zzt();
        this.zzu();
        if (((zzij)this).zzq().zza(12451000) != 0) {
            ((zzij)this).zzj().zzu().zza("Not bundling data. Service unavailable or out of date");
            ((zzij)this).zzq().zza(zzdd2, new byte[0]);
            return;
        }
        this.zza(new zzlo(this, zzbf2, string, zzdd2));
    }

    @WorkerThread
    private final void zzaq() {
        ((zzij)this).zzt();
        this.zze.zzb();
        this.zzd.zza((Long)zzbh.zzaj.zza(null));
    }

    @WorkerThread
    protected final void zzah() {
        ((zzij)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        ((zzd)this).zzh().zzaa();
        this.zza(new zzlj(this, zzn2));
    }

    @WorkerThread
    private final void zza(Runnable runnable) throws IllegalStateException {
        ((zzij)this).zzt();
        if (this.zzak()) {
            runnable.run();
            return;
        }
        if ((long)this.zzf.size() >= 1000L) {
            ((zzij)this).zzj().zzg().zza("Discarding data. Max runnable queue size reached");
            return;
        }
        this.zzf.add(runnable);
        this.zzg.zza(60000L);
        this.zzad();
    }

    @WorkerThread
    final void zza(zzfp zzfp2, @Nullable AbstractSafeParcelable abstractSafeParcelable, zzn zzn2) {
        ((zzij)this).zzt();
        this.zzu();
        int n = 100;
        for (int i = 0; i < 1001 && n == 100; ++i) {
            ArrayList<AbstractSafeParcelable> arrayList = new ArrayList<AbstractSafeParcelable>();
            n = 0;
            List<AbstractSafeParcelable> list = ((zzd)this).zzh().zza(100);
            if (list != null) {
                arrayList.addAll(list);
                n = list.size();
            }
            if (abstractSafeParcelable != null && n < 100) {
                arrayList.add(abstractSafeParcelable);
            }
            ArrayList<AbstractSafeParcelable> arrayList2 = arrayList;
            int n2 = arrayList2.size();
            int n3 = 0;
            while (n3 < n2) {
                Object e = arrayList2.get(n3);
                ++n3;
                AbstractSafeParcelable abstractSafeParcelable2 = (AbstractSafeParcelable)e;
                if (abstractSafeParcelable2 instanceof zzbf) {
                    try {
                        zzfp2.zza((zzbf)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzij)this).zzj().zzg().zza("Failed to send event to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzno) {
                    try {
                        zzfp2.zza((zzno)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzij)this).zzj().zzg().zza("Failed to send user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                if (abstractSafeParcelable2 instanceof zzac) {
                    try {
                        zzfp2.zza((zzac)abstractSafeParcelable2, zzn2);
                    }
                    catch (RemoteException remoteException) {
                        ((zzij)this).zzj().zzg().zza("Failed to send conditional user property to the service", (Object)remoteException);
                    }
                    continue;
                }
                ((zzij)this).zzj().zzg().zza("Discarding data. Unrecognized parcel type.");
            }
        }
    }

    @WorkerThread
    protected final void zza(zzac zzac2) {
        Preconditions.checkNotNull((Object)((Object)zzac2));
        ((zzij)this).zzt();
        this.zzu();
        boolean bl = ((zzd)this).zzh().zza(zzac2);
        zzac zzac3 = new zzac(zzac2);
        zzn zzn2 = this.zzc(true);
        this.zza(new zzls(this, true, zzn2, bl, zzac3, zzac2));
    }

    @WorkerThread
    protected final void zza(boolean bl) {
        ((zzij)this).zzt();
        this.zzu();
        if (!(zznh.zza() && ((zzij)this).zze().zza(zzbh.zzdb) || !bl)) {
            ((zzd)this).zzh().zzaa();
        }
        if (this.zzam()) {
            zzn zzn2 = this.zzc(false);
            this.zza(new zzlq(this, zzn2));
        }
    }

    @WorkerThread
    protected final void zza(@Nullable zzkt zzkt2) {
        ((zzij)this).zzt();
        this.zzu();
        this.zza(new zzln(this, zzkt2));
    }

    @WorkerThread
    public final void zza(Bundle bundle) {
        ((zzij)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(false);
        this.zza(new zzlm(this, zzn2, bundle));
    }

    @WorkerThread
    protected final void zzai() {
        ((zzij)this).zzt();
        this.zzu();
        zzlb zzlb2 = this;
        this.zza(new zzld(zzlb2));
    }

    @WorkerThread
    protected final void zzaj() {
        ((zzij)this).zzt();
        this.zzu();
        zzn zzn2 = this.zzc(true);
        this.zza(new zzlr(this, zzn2));
    }

    @WorkerThread
    protected final void zza(zzfp zzfp2) {
        ((zzij)this).zzt();
        Preconditions.checkNotNull((Object)zzfp2);
        this.zzb = zzfp2;
        this.zzaq();
        this.zzap();
    }

    @WorkerThread
    protected final void zzb(boolean bl) {
        ((zzij)this).zzt();
        this.zzu();
        if (!(zznh.zza() && ((zzij)this).zze().zza(zzbh.zzdb) || !bl)) {
            ((zzd)this).zzh().zzaa();
        }
        zzlb zzlb2 = this;
        this.zza(new zzla(zzlb2));
    }

    @WorkerThread
    protected final void zza(zzno zzno2) {
        ((zzij)this).zzt();
        this.zzu();
        boolean bl = ((zzd)this).zzh().zza(zzno2);
        zzn zzn2 = this.zzc(true);
        this.zza(new zzlg(this, zzn2, bl, zzno2));
    }

    @WorkerThread
    public final boolean zzak() {
        ((zzij)this).zzt();
        this.zzu();
        return this.zzb != null;
    }

    @Override
    protected final boolean zzz() {
        return false;
    }

    @WorkerThread
    final boolean zzal() {
        ((zzij)this).zzt();
        this.zzu();
        if (!this.zzao()) {
            return true;
        }
        return ((zzij)this).zzq().zzg() >= 200900;
    }

    @WorkerThread
    final boolean zzam() {
        ((zzij)this).zzt();
        this.zzu();
        if (!this.zzao()) {
            return true;
        }
        return ((zzij)this).zzq().zzg() >= (Integer)zzbh.zzbp.zza(null);
    }

    @WorkerThread
    final boolean zzan() {
        ((zzij)this).zzt();
        this.zzu();
        if (!this.zzao()) {
            return true;
        }
        return ((zzij)this).zzq().zzg() >= 241200;
    }

    @WorkerThread
    final boolean zzao() {
        ((zzij)this).zzt();
        this.zzu();
        if (this.zzc == null) {
            boolean bl;
            zzlb zzlb2 = this;
            ((zzij)zzlb2).zzt();
            zzlb2.zzu();
            Boolean bl2 = ((zzij)zzlb2).zzk().zzp();
            if (bl2 != null && bl2.booleanValue()) {
                bl = true;
            } else {
                boolean bl3;
                boolean bl4;
                if (((zzd)zzlb2).zzg().zzaa() == 1) {
                    bl4 = true;
                    bl3 = true;
                } else {
                    ((zzij)zzlb2).zzj().zzp().zza("Checking service availability");
                    int n = ((zzij)zzlb2).zzq().zza(12451000);
                    switch (n) {
                        case 0: {
                            ((zzij)zzlb2).zzj().zzp().zza("Service available");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 1: {
                            ((zzij)zzlb2).zzj().zzp().zza("Service missing");
                            bl4 = false;
                            bl3 = true;
                            break;
                        }
                        case 18: {
                            ((zzij)zzlb2).zzj().zzu().zza("Service updating");
                            bl4 = true;
                            bl3 = true;
                            break;
                        }
                        case 2: {
                            ((zzij)zzlb2).zzj().zzc().zza("Service container out of date");
                            if (((zzij)zzlb2).zzq().zzg() < 17443) {
                                bl4 = false;
                                bl3 = true;
                                break;
                            }
                            bl4 = bl2 == null;
                            bl3 = false;
                            break;
                        }
                        case 3: {
                            ((zzij)zzlb2).zzj().zzu().zza("Service disabled");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        case 9: {
                            ((zzij)zzlb2).zzj().zzu().zza("Service invalid");
                            bl4 = false;
                            bl3 = false;
                            break;
                        }
                        default: {
                            ((zzij)zzlb2).zzj().zzu().zza("Unexpected service status", n);
                            bl4 = false;
                            bl3 = false;
                        }
                    }
                }
                if (!bl4 && ((zzij)zzlb2).zze().zzx()) {
                    ((zzij)zzlb2).zzj().zzg().zza("No way to upload. Consider using the full version of Analytics");
                    bl3 = false;
                }
                if (bl3) {
                    ((zzij)zzlb2).zzk().zza(bl4);
                }
                bl = bl4;
            }
            this.zzc = bl;
        }
        return this.zzc;
    }
}

