/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.measurement.internal.zzfp;
import com.google.android.gms.measurement.internal.zzfr;
import com.google.android.gms.measurement.internal.zzfw;
import com.google.android.gms.measurement.internal.zzfx;
import com.google.android.gms.measurement.internal.zzij;
import com.google.android.gms.measurement.internal.zzlb;
import com.google.android.gms.measurement.internal.zzly;
import com.google.android.gms.measurement.internal.zzlz;
import com.google.android.gms.measurement.internal.zzma;
import com.google.android.gms.measurement.internal.zzmb;
import com.google.android.gms.measurement.internal.zzmd;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzlw
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile @Nullable zzfx zzc;
    final /* synthetic */ zzlb zza;

    static /* bridge */ /* synthetic */ void zza(zzlw zzlw2, boolean bl) {
        zzlw2.zzb = false;
    }

    protected zzlw(zzlb zzlb2) {
        this.zza = zzlb2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzij)this.zza).zzt();
        Context context = ((zzij)this.zza).zza();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zzlw zzlw2 = this;
        synchronized (zzlw2) {
            if (this.zzb) {
                ((zzij)this.zza).zzj().zzp().zza("Connection attempt already in progress");
                return;
            }
            ((zzij)this.zza).zzj().zzp().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzlb.zzb(this.zza), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza() {
        ((zzij)this.zza).zzt();
        Context context = ((zzij)this.zza).zza();
        zzlw zzlw2 = this;
        synchronized (zzlw2) {
            if (this.zzb) {
                ((zzij)this.zza).zzj().zzp().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzij)this.zza).zzj().zzp().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzfx(context, Looper.getMainLooper(), this, this);
            ((zzij)this.zza).zzj().zzp().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    @WorkerThread
    public final void zzb() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zzlw zzlw2 = this;
        synchronized (zzlw2) {
            try {
                Preconditions.checkNotNull((Object)((Object)this.zzc));
                zzfp zzfp2 = (zzfp)this.zzc.getService();
                ((zzij)this.zza).zzl().zzb(new zzmb(this, zzfp2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzfw zzfw2 = this.zza.zzu.zzm();
        if (zzfw2 != null) {
            zzfw2.zzu().zza("Service connection failed", connectionResult);
        }
        zzlw zzlw2 = this;
        synchronized (zzlw2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzij)this.zza).zzl().zzb(new zzmd(this));
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzij)this.zza).zzj().zzc().zza("Service connection suspended");
        ((zzij)this.zza).zzl().zzb(new zzma(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, @Nullable IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zzlw zzlw2 = this;
        synchronized (zzlw2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzij)this.zza).zzj().zzg().zza("Service connected with null binder");
                return;
            }
            zzfp zzfp2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzfp2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzfp ? (zzfp)iInterface : new zzfr(iBinder2));
                    ((zzij)this.zza).zzj().zzp().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzij)this.zza).zzj().zzg().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzij)this.zza).zzj().zzg().zza("Service connect failed to get IMeasurementService");
            }
            if (zzfp2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzij)this.zza).zza(), (ServiceConnection)zzlb.zzb(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzfp2;
                ((zzij)this.zza).zzl().zzb(new zzlz(this, (zzfp)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzij)this.zza).zzj().zzc().zza("Service disconnected");
        ((zzij)this.zza).zzl().zzb(new zzly(this, componentName));
    }
}

