/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import androidx.annotation.GuardedBy;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzjf;
import com.google.android.gms.measurement.internal.zzlw;
import com.google.android.gms.measurement.internal.zzly;
import com.google.android.gms.measurement.internal.zzma;
import com.google.android.gms.measurement.internal.zzmb;
import com.google.android.gms.measurement.internal.zzmc;
import com.google.android.gms.measurement.internal.zzmd;
import com.google.android.gms.measurement.internal.zzmf;
import com.google.android.gms.measurement.internal.zzpn;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzlz
extends zzf {
    private volatile @Nullable zzlw zzb;
    private volatile @Nullable zzlw zzc;
    @VisibleForTesting
    protected @Nullable zzlw zza;
    private final Map<Integer, zzlw> zzd;
    @GuardedBy(value="activityLock")
    private @Nullable zzeb zze;
    @GuardedBy(value="activityLock")
    private volatile boolean zzf;
    private volatile @Nullable zzlw zzg;
    private @Nullable zzlw zzh;
    @GuardedBy(value="activityLock")
    private boolean zzi;
    private final Object zzj = new Object();

    static /* bridge */ /* synthetic */ zzlw zza(zzlz zzlz2) {
        return zzlz2.zzh;
    }

    @MainThread
    private final zzlw zzd(@NonNull zzeb zzeb2) {
        Preconditions.checkNotNull((Object)zzeb2);
        zzlw zzlw2 = this.zzd.get(zzeb2.zza);
        if (zzlw2 == null) {
            String string = this.zza(zzeb2.zzb, "Activity");
            zzlw2 = new zzlw(null, string, ((zzjf)this).zzs().zzo());
            this.zzd.put(zzeb2.zza, zzlw2);
        }
        if (this.zzg != null) {
            return this.zzg;
        }
        return zzlw2;
    }

    public final @Nullable zzlw zzac() {
        return this.zzb;
    }

    @WorkerThread
    public final @Nullable zzlw zza(boolean bl) {
        this.zzw();
        ((zzjf)this).zzv();
        if (!bl) {
            return this.zza;
        }
        if (this.zza != null) {
            return this.zza;
        }
        return this.zzh;
    }

    @VisibleForTesting
    private final String zza(@Nullable String string, String string2) {
        if (string == null) {
            return string2;
        }
        String string3 = string;
        zzlz zzlz2 = this;
        String[] stringArray = string3.split("\\.");
        String string4 = stringArray.length > 0 ? stringArray[stringArray.length - 1] : "";
        if (string4.length() > ((zzjf)zzlz2).zze().zza(null, false)) {
            return string4.substring(0, ((zzjf)zzlz2).zze().zza(null, false));
        }
        return string4;
    }

    static /* bridge */ /* synthetic */ void zza(zzlz zzlz2, zzlw zzlw2) {
        zzlz2.zzh = null;
    }

    static /* bridge */ /* synthetic */ void zza(zzlz zzlz2, zzlw zzlw2, zzlw zzlw3, long l, boolean bl, Bundle bundle) {
        zzlz2.zza(zzlw2, zzlw3, l, bl, null);
    }

    static /* synthetic */ void zza(zzlz zzlz2, Bundle bundle, zzlw zzlw2, zzlw zzlw3, long l) {
        long l2 = l;
        zzlw zzlw4 = zzlw3;
        zzlw zzlw5 = zzlw2;
        Bundle bundle2 = bundle;
        zzlz zzlz3 = zzlz2;
        if (bundle2 != null) {
            bundle2.remove("screen_name");
            bundle2.remove("screen_class");
        }
        Bundle bundle3 = ((zzjf)zzlz3).zzs().zza(null, "screen_view", bundle2, null, false);
        zzlz3.zza(zzlw5, zzlw4, l2, true, bundle3);
    }

    static /* bridge */ /* synthetic */ void zza(zzlz zzlz2, zzlw zzlw2, boolean bl, long l) {
        zzlz2.zza(zzlw2, false, l);
    }

    public zzlz(zzic zzic2) {
        super(zzic2);
        this.zzd = new ConcurrentHashMap<Integer, zzlw>();
    }

    @MainThread
    private final void zza(@Nullable String string, zzlw zzlw2, boolean bl) {
        zzlw zzlw3;
        zzlw zzlw4;
        zzlw zzlw5 = zzlw4 = this.zzb == null ? this.zzc : this.zzb;
        if (zzlw2.zzb == null) {
            zzlw3 = string != null ? this.zza(string, "Activity") : null;
            zzlw2 = new zzlw(zzlw2.zza, (String)((Object)zzlw3), zzlw2.zzc, zzlw2.zze, zzlw2.zzf);
        }
        zzlw3 = zzlw2;
        this.zzc = this.zzb;
        this.zzb = zzlw3;
        long l = ((zzjf)this).zzb().elapsedRealtime();
        ((zzjf)this).zzl().zzb(new zzmb(this, zzlw3, zzlw4, l, bl));
    }

    @WorkerThread
    private final void zza(zzlw zzlw2, @Nullable zzlw zzlw3, long l, boolean bl, @Nullable Bundle bundle) {
        boolean bl2;
        ((zzjf)this).zzv();
        boolean bl3 = zzlw3 == null || zzlw3.zzc != zzlw2.zzc || !Objects.equals(zzlw3.zzb, zzlw2.zzb) || !Objects.equals(zzlw3.zza, zzlw2.zza);
        boolean bl4 = bl2 = bl && this.zza != null;
        if (bl3) {
            long l2;
            long l3;
            Bundle bundle2 = bundle != null ? new Bundle(bundle) : new Bundle();
            zzpn.zza(zzlw2, bundle2, true);
            if (zzlw3 != null) {
                if (zzlw3.zza != null) {
                    bundle2.putString("_pn", zzlw3.zza);
                }
                if (zzlw3.zzb != null) {
                    bundle2.putString("_pc", zzlw3.zzb);
                }
                bundle2.putLong("_pi", zzlw3.zzc);
            }
            if (bl2 && (l3 = ((zzg)this).zzr().zzb.zza(l2 = l)) > 0L) {
                ((zzjf)this).zzs().zza(bundle2, l3);
            }
            if (!((zzjf)this).zze().zzx()) {
                bundle2.putLong("_mst", 1L);
            }
            String string = zzlw2.zze ? "app" : "auto";
            long l4 = ((zzjf)this).zzb().currentTimeMillis();
            if (zzlw2.zze && zzlw2.zzf != 0L) {
                l4 = zzlw2.zzf;
            }
            ((zzg)this).zzm().zza(string, "_vs", l4, bundle2);
        }
        if (bl2) {
            this.zza(this.zza, true, l);
        }
        this.zza = zzlw2;
        if (zzlw2.zze) {
            this.zzh = zzlw2;
        }
        ((zzg)this).zzq().zza(zzlw2);
    }

    @MainThread
    public final void zza(zzeb zzeb2, @Nullable Bundle bundle) {
        if (!((zzjf)this).zze().zzx()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        Bundle bundle2 = bundle.getBundle("com.google.app_measurement.screen_service");
        if (bundle2 == null) {
            return;
        }
        zzlw zzlw2 = new zzlw(bundle2.getString("name"), bundle2.getString("referrer_name"), bundle2.getLong("id"));
        this.zzd.put(zzeb2.zza, zzlw2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zza(zzeb zzeb2) {
        Object object = this.zzj;
        synchronized (object) {
            if (Objects.equals(this.zze, zzeb2)) {
                this.zze = null;
            }
        }
        if (!((zzjf)this).zze().zzx()) {
            return;
        }
        this.zzd.remove(zzeb2.zza);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzb(zzeb zzeb2) {
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = false;
            this.zzf = true;
        }
        long l = ((zzjf)this).zzb().elapsedRealtime();
        if (!((zzjf)this).zze().zzx()) {
            this.zzb = null;
            ((zzjf)this).zzl().zzb(new zzmd(this, l));
            return;
        }
        zzlw zzlw2 = this.zzd(zzeb2);
        this.zzc = this.zzb;
        this.zzb = null;
        ((zzjf)this).zzl().zzb(new zzmc(this, zzlw2, l));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void zzc(zzeb zzeb2) {
        zzg zzg2;
        Object object = this.zzj;
        synchronized (object) {
            this.zzi = true;
            if (!Objects.equals(zzeb2, this.zze)) {
                zzeb zzeb3 = zzeb2;
                zzg2 = this;
                Object object2 = ((zzlz)zzg2).zzj;
                synchronized (object2) {
                    ((zzlz)zzg2).zze = zzeb3;
                    ((zzlz)zzg2).zzf = false;
                }
                if (zzg2.zze().zzx()) {
                    ((zzlz)zzg2).zzg = null;
                    zzg2.zzl().zzb(new zzmf((zzlz)zzg2));
                }
            }
        }
        if (!((zzjf)this).zze().zzx()) {
            this.zzb = this.zzg;
            ((zzjf)this).zzl().zzb(new zzma(this));
            return;
        }
        object = this.zzd(zzeb2);
        this.zza(zzeb2.zzb, (zzlw)object, false);
        zzg2 = ((zzg)this).zzc();
        long l = zzg2.zzb().elapsedRealtime();
        zzg2.zzl().zzb(new zze((zza)zzg2, l));
    }

    @MainThread
    public final void zzb(zzeb zzeb2, Bundle bundle) {
        if (!((zzjf)this).zze().zzx()) {
            return;
        }
        if (bundle == null) {
            return;
        }
        zzlw zzlw2 = this.zzd.get(zzeb2.zza);
        if (zzlw2 == null) {
            return;
        }
        Bundle bundle2 = new Bundle();
        bundle2.putLong("id", zzlw2.zzc);
        bundle2.putString("name", zzlw2.zza);
        bundle2.putString("referrer_name", zzlw2.zzb);
        bundle.putBundle("com.google.app_measurement.screen_service", bundle2);
    }

    @WorkerThread
    private final void zza(@Nullable zzlw zzlw2, boolean bl, long l) {
        boolean bl2;
        ((zzg)this).zzc().zza(((zzjf)this).zzb().elapsedRealtime());
        boolean bl3 = bl2 = zzlw2 != null && zzlw2.zzd;
        if (((zzg)this).zzr().zza(bl2, bl, l) && zzlw2 != null) {
            zzlw2.zzd = false;
        }
    }

    @Deprecated
    public final void zza(@NonNull zzeb zzeb2, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        if (!((zzjf)this).zze().zzx()) {
            ((zzjf)this).zzj().zzw().zza("setCurrentScreen cannot be called while screen reporting is disabled.");
            return;
        }
        zzlw zzlw2 = this.zzb;
        if (zzlw2 == null) {
            ((zzjf)this).zzj().zzw().zza("setCurrentScreen cannot be called while no activity active");
            return;
        }
        if (this.zzd.get(zzeb2.zza) == null) {
            ((zzjf)this).zzj().zzw().zza("setCurrentScreen must be called with an activity in the activity lifecycle");
            return;
        }
        if (string2 == null) {
            string2 = this.zza(zzeb2.zzb, "Activity");
        }
        boolean bl = Objects.equals(zzlw2.zzb, string2);
        boolean bl2 = Objects.equals(zzlw2.zza, string);
        if (bl && bl2) {
            ((zzjf)this).zzj().zzw().zza("setCurrentScreen cannot be called with the same class and name");
            return;
        }
        if (string != null && (string.length() <= 0 || string.length() > ((zzjf)this).zze().zza(null, false))) {
            ((zzjf)this).zzj().zzw().zza("Invalid screen name length in setCurrentScreen. Length", string.length());
            return;
        }
        if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzjf)this).zze().zza(null, false))) {
            ((zzjf)this).zzj().zzw().zza("Invalid class name length in setCurrentScreen. Length", string2.length());
            return;
        }
        ((zzjf)this).zzj().zzq().zza("Setting current screen to name, class", string == null ? "null" : string, string2);
        zzlw zzlw3 = new zzlw(string, string2, ((zzjf)this).zzs().zzo());
        this.zzd.put(zzeb2.zza, zzlw3);
        this.zza(zzeb2.zzb, zzlw3, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(Bundle bundle, long l) {
        zzlw zzlw2;
        String string = null;
        String string2 = null;
        Object object = this.zzj;
        synchronized (object) {
            if (!this.zzi) {
                ((zzjf)this).zzj().zzw().zza("Cannot log screen view event when the app is in the background.");
                return;
            }
            if (bundle != null) {
                string = bundle.getString("screen_name");
                if (string != null && (string.length() <= 0 || string.length() > ((zzjf)this).zze().zza(null, false))) {
                    ((zzjf)this).zzj().zzw().zza("Invalid screen name length for screen view. Length", string.length());
                    return;
                }
                string2 = bundle.getString("screen_class");
                if (string2 != null && (string2.length() <= 0 || string2.length() > ((zzjf)this).zze().zza(null, false))) {
                    ((zzjf)this).zzj().zzw().zza("Invalid screen class length for screen view. Length", string2.length());
                    return;
                }
            }
            if (string2 == null) {
                string2 = this.zze != null ? this.zza(this.zze.zzb, "Activity") : "Activity";
            }
            zzlw2 = this.zzb;
            if (this.zzf && zzlw2 != null) {
                this.zzf = false;
                boolean bl = Objects.equals(zzlw2.zzb, string2);
                boolean bl2 = Objects.equals(zzlw2.zza, string);
                if (bl && bl2) {
                    ((zzjf)this).zzj().zzw().zza("Ignoring call to log screen view event with duplicate parameters.");
                    return;
                }
            }
        }
        ((zzjf)this).zzj().zzq().zza("Logging screen view with name, class", string == null ? "null" : string, string2 == null ? "null" : string2);
        object = this.zzb == null ? this.zzc : this.zzb;
        this.zzb = zzlw2 = new zzlw(string, string2, ((zzjf)this).zzs().zzo(), true, l);
        this.zzc = object;
        this.zzg = zzlw2;
        long l2 = ((zzjf)this).zzb().elapsedRealtime();
        ((zzjf)this).zzl().zzb(new zzly(this, bundle, zzlw2, (zzlw)object, l2));
    }

    @Override
    protected final boolean zzab() {
        return false;
    }
}

