/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.measurement.internal.zzaj;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzbl;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjx;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzak
extends zzjq {
    private @Nullable Boolean zza;
    private @Nullable String zzb;
    private zzam zzc = new zzaj();
    private @MonotonicNonNull Boolean zzd;

    @WorkerThread
    public final double zza(@Nullable String string, zzgi<Double> zzgi2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return zzgi2.zza(null);
        }
        String string2 = this.zzc.zza(string, zzgi2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzgi2.zza(null);
        }
        try {
            double d = Double.parseDouble(string2);
            return zzgi2.zza(d);
        }
        catch (NumberFormatException numberFormatException) {
            return zzgi2.zza(null);
        }
    }

    final int zza(@Size(min=1L) String string) {
        return this.zza(string, zzbl.zzav, 500, 2000);
    }

    final int zza(@Nullable String string, boolean bl) {
        if (bl) {
            return this.zza(string, zzbl.zzbf, 100, 500);
        }
        return 500;
    }

    final int zzb(@Nullable String string, boolean bl) {
        return Math.max(this.zza(string, bl), 256);
    }

    public final int zzc() {
        if (((zzjq)this).zzs().zza(201500000, true)) {
            return 100;
        }
        return 25;
    }

    public final int zzb(@Size(min=1L) String string) {
        return this.zza(string, zzbl.zzaw, 25, 100);
    }

    @WorkerThread
    public final int zzc(@Size(min=1L) String string) {
        return this.zzb(string, zzbl.zzo);
    }

    @WorkerThread
    public final int zzb(@Nullable String string, zzgi<Integer> zzgi2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return zzgi2.zza(null);
        }
        String string2 = this.zzc.zza(string, zzgi2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzgi2.zza(null);
        }
        try {
            int n = Integer.parseInt(string2);
            return zzgi2.zza(n);
        }
        catch (NumberFormatException numberFormatException) {
            return zzgi2.zza(null);
        }
    }

    @WorkerThread
    public final int zza(@Nullable String string, zzgi<Integer> zzgi2, int n, int n2) {
        return Math.max(Math.min(this.zzb(string, zzgi2), n2), n);
    }

    @WorkerThread
    final long zzd(String string) {
        return this.zzc(string, zzbl.zza);
    }

    public static long zzg() {
        return zzbl.zzd.zza(null);
    }

    public static long zzh() {
        return ((Integer)zzbl.zzk.zza(null)).intValue();
    }

    public static long zzm() {
        return zzbl.zzaq.zza(null);
    }

    @WorkerThread
    public final long zzc(@Nullable String string, zzgi<Long> zzgi2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return zzgi2.zza(null);
        }
        String string2 = this.zzc.zza(string, zzgi2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzgi2.zza(null);
        }
        try {
            long l = Long.parseLong(string2);
            return zzgi2.zza(l);
        }
        catch (NumberFormatException numberFormatException) {
            return zzgi2.zza(null);
        }
    }

    public static long zzo() {
        return zzbl.zzal.zza(null);
    }

    @VisibleForTesting
    private final @Nullable Bundle zzac() {
        try {
            if (((zzjq)this).zza().getPackageManager() == null) {
                ((zzjq)this).zzj().zzg().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            ApplicationInfo applicationInfo = Wrappers.packageManager((Context)((zzjq)this).zza()).getApplicationInfo(((zzjq)this).zza().getPackageName(), 128);
            if (applicationInfo == null) {
                ((zzjq)this).zzj().zzg().zza("Failed to load metadata: ApplicationInfo is null");
                return null;
            }
            return applicationInfo.metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            ((zzjq)this).zzj().zzg().zza("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
            return null;
        }
    }

    public final zzjx zzc(String string, boolean bl) {
        Object object;
        Object object2;
        String string2 = string;
        zzak zzak2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzak2.zzac();
        if (bundle == null) {
            ((zzjq)zzak2).zzj().zzg().zza("Failed to load metadata: Metadata bundle is null");
            object2 = null;
        } else {
            object2 = object = bundle.get(string2);
        }
        if (object2 == null) {
            return zzjx.zza;
        }
        if (Boolean.TRUE.equals(object)) {
            return zzjx.zzd;
        }
        if (Boolean.FALSE.equals(object)) {
            return zzjx.zzc;
        }
        if (bl && "eu_consent_policy".equals(object)) {
            return zzjx.zzb;
        }
        ((zzjq)this).zzj().zzr().zza("Invalid manifest metadata for", string);
        return zzjx.zza;
    }

    final @Nullable Boolean zze(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzac();
        if (bundle == null) {
            ((zzjq)this).zzj().zzg().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    public final String zzp() {
        return this.zza("debug.firebase.analytics.app", "");
    }

    public final String zzq() {
        return this.zza("debug.deferred.deeplink", "");
    }

    @WorkerThread
    public final String zzd(@Nullable String string, zzgi<String> zzgi2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return zzgi2.zza(null);
        }
        return zzgi2.zza(this.zzc.zza(string, zzgi2.zza()));
    }

    public final @Nullable String zzr() {
        return this.zzb;
    }

    @WorkerThread
    final String zzf(String string) {
        return this.zzd(string, zzbl.zzaz);
    }

    private final String zza(String string, String string2) {
        try {
            String string3 = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
            Preconditions.checkNotNull((Object)string3);
            return string3;
        }
        catch (ClassNotFoundException classNotFoundException) {
            ((zzjq)this).zzj().zzg().zza("Could not find SystemProperties class", classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            ((zzjq)this).zzj().zzg().zza("Could not find SystemProperties.get() method", noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            ((zzjq)this).zzj().zzg().zza("Could not access SystemProperties.get()", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            ((zzjq)this).zzj().zzg().zza("SystemProperties.get() threw an exception", invocationTargetException);
        }
        return string2;
    }

    final @Nullable List<String> zzg(@Size(min=1L) String string) {
        Integer n;
        Integer n2;
        String string2 = string;
        zzak zzak2 = this;
        Preconditions.checkNotEmpty((String)string2);
        Bundle bundle = zzak2.zzac();
        if (bundle == null) {
            ((zzjq)zzak2).zzj().zzg().zza("Failed to load metadata: Metadata bundle is null");
            n2 = null;
        } else {
            n2 = n = !bundle.containsKey(string2) ? null : Integer.valueOf(bundle.getInt(string2));
        }
        if (n2 == null) {
            return null;
        }
        try {
            String[] stringArray = ((zzjq)this).zza().getResources().getStringArray(n.intValue());
            if (stringArray == null) {
                return null;
            }
            return Arrays.asList(stringArray);
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzjq)this).zzj().zzg().zza("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    zzak(zzim zzim2) {
        super(zzim2);
    }

    final void zza(zzam zzam2) {
        this.zzc = zzam2;
    }

    public final void zzh(@Nullable String string) {
        this.zzb = string;
    }

    public final boolean zzw() {
        Boolean bl = this.zze("google_analytics_adid_collection_enabled");
        return bl == null || bl != false;
    }

    @WorkerThread
    final boolean zzi(String string) {
        return this.zzf(string, zzbl.zzay);
    }

    public final boolean zza(zzgi<Boolean> zzgi2) {
        zzgi<Boolean> zzgi3 = zzgi2;
        return this.zzf(null, zzgi3);
    }

    public final boolean zze(@Nullable String string, zzgi<Boolean> zzgi2) {
        return this.zzf(string, zzgi2);
    }

    @WorkerThread
    public final boolean zzf(@Nullable String string, zzgi<Boolean> zzgi2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return zzgi2.zza(null);
        }
        String string2 = this.zzc.zza(string, zzgi2.zza());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return zzgi2.zza(null);
        }
        return zzgi2.zza("1".equals(string2));
    }

    public final boolean zzj(String string) {
        return "1".equals(this.zzc.zza(string, "gaia_collection_enabled"));
    }

    public final boolean zzx() {
        Boolean bl = this.zze("google_analytics_automatic_screen_reporting_enabled");
        return bl == null || bl != false;
    }

    public final boolean zzy() {
        Boolean bl = this.zze("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final boolean zzk(String string) {
        return "1".equals(this.zzc.zza(string, "measurement.event_sampling_enabled"));
    }

    @WorkerThread
    final boolean zzz() {
        if (this.zza == null) {
            this.zza = this.zze("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzu.zzai();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @EnsuresNonNull(value={"this.isMainProcess"})
    public final boolean zzaa() {
        if (this.zzd == null) {
            zzak zzak2 = this;
            synchronized (zzak2) {
                if (this.zzd == null) {
                    ApplicationInfo applicationInfo = ((zzjq)this).zza().getApplicationInfo();
                    String string = ProcessUtils.getMyProcessName();
                    if (applicationInfo != null) {
                        String string2 = applicationInfo.processName;
                        this.zzd = string2 != null && string2.equals(string);
                    }
                    if (this.zzd == null) {
                        this.zzd = Boolean.TRUE;
                        ((zzjq)this).zzj().zzg().zza("My process not in the list of running processes");
                    }
                }
            }
        }
        return this.zzd;
    }

    public final boolean zzab() {
        Boolean bl = this.zze("google_analytics_sgtm_upload_enabled");
        if (bl == null) {
            return false;
        }
        return bl;
    }
}

