/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.wrappers.InstantApps;
import com.google.android.gms.internal.measurement.zzpf;
import com.google.android.gms.measurement.internal.zzbl;
import com.google.android.gms.measurement.internal.zze;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzho;
import com.google.android.gms.measurement.internal.zzig;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzju;
import com.google.android.gms.measurement.internal.zzjx;
import com.google.android.gms.measurement.internal.zzq;
import com.google.android.gms.measurement.internal.zzqd;
import java.math.BigInteger;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzgr
extends zzh {
    private @MonotonicNonNull String zza;
    private @Nullable String zzb;
    private int zzc;
    private @MonotonicNonNull String zzd;
    private @MonotonicNonNull String zze;
    private long zzf;
    private long zzg;
    private @Nullable List<String> zzh;
    private @Nullable String zzi;
    private int zzj;
    private @MonotonicNonNull String zzk;
    private @Nullable String zzl;
    private @Nullable String zzm;
    private long zzn = 0L;
    private @Nullable String zzo = null;

    @WorkerThread
    final int zzac() {
        this.zzw();
        return this.zzj;
    }

    @WorkerThread
    final int zzad() {
        this.zzw();
        return this.zzc;
    }

    @WorkerThread
    final zzq zza(@Nullable String string) {
        int n;
        String string2;
        ((zzjq)this).zzv();
        String string3 = this.zzaf();
        String string4 = this.zzah();
        zzjs zzjs2 = this;
        ((zzh)zzjs2).zzw();
        String string5 = ((zzgr)zzjs2).zzb;
        long l = this.zzad();
        zzjs2 = this;
        ((zzh)zzjs2).zzw();
        Preconditions.checkNotNull((Object)((zzgr)zzjs2).zzd);
        String string6 = ((zzgr)zzjs2).zzd;
        zzjs2 = this;
        ((zzh)zzjs2).zzw();
        ((zzjq)zzjs2).zzv();
        if (((zzgr)zzjs2).zzf == 0L) {
            ((zzgr)zzjs2).zzf = ((zzgr)zzjs2).zzu.zzv().zza(((zzjq)zzjs2).zza(), ((zzjq)zzjs2).zza().getPackageName());
        }
        long l2 = ((zzgr)zzjs2).zzf;
        boolean bl = this.zzu.zzae();
        boolean bl2 = !((zzjq)this).zzk().zzm;
        zzjs2 = this;
        ((zzjq)zzjs2).zzv();
        String string7 = !((zzgr)zzjs2).zzu.zzae() ? null : ((zzgr)zzjs2).zzak();
        zzjs2 = this.zzu;
        long l3 = ((zzim)zzjs2).zzn().zzc.zza();
        long l4 = l3 == 0L ? ((zzim)zzjs2).zza : Math.min(((zzim)zzjs2).zza, l3);
        int n2 = this.zzac();
        boolean bl3 = ((zzjq)this).zze().zzw();
        zzjs2 = ((zzjq)this).zzk();
        ((zzjq)zzjs2).zzv();
        boolean bl4 = ((zzho)zzjs2).zzg().getBoolean("deferred_analytics_collection", false);
        String string8 = this.zzae();
        Boolean bl5 = ((zzjq)this).zze().zzc("google_analytics_default_allow_ad_personalization_signals", true) != zzjx.zzd;
        String string9 = ((zzjq)this).zzk().zzp().zzf();
        zzjs2 = this;
        if (((zzgr)zzjs2).zzi == null) {
            ((zzgr)zzjs2).zzi = ((zzjq)zzjs2).zzs().zzq();
        }
        String string10 = ((zzgr)zzjs2).zzi;
        zzjs2 = this;
        if (!((zzjq)zzjs2).zzk().zzp().zza(zzju.zza.zzb)) {
            string2 = null;
        } else {
            ((zzjq)zzjs2).zzv();
            zzjs zzjs3 = zzjs2;
            if (((zzgr)zzjs3).zzn != 0L) {
                long l5 = ((zzjq)zzjs3).zzb().currentTimeMillis() - ((zzgr)zzjs3).zzn;
                if (((zzgr)zzjs3).zzm != null && l5 > 86400000L && ((zzgr)zzjs3).zzo == null) {
                    ((zzgr)zzjs3).zzaj();
                }
            }
            zzjs3 = zzjs2;
            if (((zzgr)zzjs3).zzm == null) {
                ((zzgr)zzjs3).zzaj();
            }
            string2 = ((zzgr)zzjs2).zzm;
        }
        boolean bl6 = ((zzjq)this).zze().zzab();
        long l6 = ((zzjq)this).zzs().zzc(this.zzaf());
        int n3 = ((zzjq)this).zzk().zzp().zza();
        String string11 = ((zzjq)this).zzk().zzo().zzf();
        zzjs2 = this;
        if (zzpf.zza() && ((zzjq)zzjs2).zze().zza(zzbl.zzcv)) {
            ((zzjq)zzjs2).zzs();
            n = zzqd.zzc();
        } else {
            n = 0;
        }
        zzjs2 = this;
        long l7 = zzpf.zza() && ((zzjq)zzjs2).zze().zza(zzbl.zzcv) ? ((zzjq)zzjs2).zzs().zzm() : 0L;
        zzjx zzjx2 = ((zzjq)this).zze().zzc("google_analytics_default_allow_ad_personalization_signals", true);
        zzjs2 = this;
        return new zzq(string3, string4, string5, l, string6, 118003L, l2, string, bl, bl2, string7, l4, n2, bl3, bl4, string8, bl5, this.zzg, this.zzh, null, string9, string10, string2, bl6, l6, n3, string11, n, l7, ((zzjq)this).zze().zzr(), new zzf(zzjx2).zzb(), this.zzu.zza, ((zzjq)zzjs2).zze().zza(zzbl.zzcq) ? ((zze)zzjs2).zzo().zzac().zza() : 0);
    }

    @WorkerThread
    final @Nullable String zzae() {
        this.zzw();
        return this.zzl;
    }

    @WorkerThread
    final String zzaf() {
        this.zzw();
        Preconditions.checkNotNull((Object)this.zza);
        return this.zza;
    }

    @WorkerThread
    final String zzag() {
        this.zzw();
        Preconditions.checkNotNull((Object)this.zze);
        return this.zze;
    }

    @WorkerThread
    @VisibleForTesting
    private final @Nullable String zzak() {
        Object object;
        Class<?> clazz;
        if (com.google.android.gms.internal.measurement.zzqd.zza() && ((zzjq)this).zze().zza(zzbl.zzcf)) {
            ((zzjq)this).zzj().zzq().zza("Disabled IID for tests.");
            return null;
        }
        try {
            clazz = ((zzjq)this).zza().getClassLoader().loadClass("com.google.firebase.analytics.FirebaseAnalytics");
            if (clazz == null) {
                return null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        try {
            object = clazz.getDeclaredMethod("getInstance", Context.class).invoke(null, ((zzjq)this).zza());
            if (object == null) {
                return null;
            }
        }
        catch (Exception exception) {
            ((zzjq)this).zzj().zzx().zza("Failed to obtain Firebase Analytics instance");
            return null;
        }
        try {
            return (String)clazz.getDeclaredMethod("getFirebaseInstanceId", new Class[0]).invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            ((zzjq)this).zzj().zzw().zza("Failed to retrieve Firebase Instance Id");
            return null;
        }
    }

    @WorkerThread
    final String zzah() {
        ((zzjq)this).zzv();
        this.zzw();
        Preconditions.checkNotNull((Object)this.zzk);
        return this.zzk;
    }

    @WorkerThread
    final @Nullable List<String> zzai() {
        return this.zzh;
    }

    zzgr(zzim zzim2, long l) {
        super(zzim2);
        this.zzg = l;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @EnsuresNonNull(value={"appId", "appStore", "appName", "gmpAppId", "gaAppId"})
    @WorkerThread
    protected final void zzz() {
        block30: {
            var1_1 = "unknown";
            var2_2 = "Unknown";
            var3_3 = -2147483648;
            var4_4 = "Unknown";
            var5_5 = this.zza().getPackageName();
            var6_6 = this.zza().getPackageManager();
            if (var6_6 == null) {
                this.zzj().zzg().zza("PackageManager is null, app identity information might be inaccurate. appId", zzhc.zza(var5_5));
            } else {
                try {
                    var1_1 = var6_6.getInstallerPackageName(var5_5);
                }
                catch (IllegalArgumentException v0) {
                    this.zzj().zzg().zza("Error retrieving app installer package name. appId", zzhc.zza(var5_5));
                }
                if (var1_1 == null) {
                    var1_1 = "manual_install";
                } else if ("com.android.vending".equals(var1_1)) {
                    var1_1 = "";
                }
                try {
                    var7_7 = var6_6.getPackageInfo(this.zza().getPackageName(), 0);
                    if (var7_7 != null) {
                        var8_9 = var6_6.getApplicationLabel(var7_7.applicationInfo);
                        if (!TextUtils.isEmpty((CharSequence)var8_9)) {
                            var4_4 = var8_9.toString();
                        }
                        var2_2 = var7_7.versionName;
                        var3_3 = var7_7.versionCode;
                    }
                }
                catch (PackageManager.NameNotFoundException v1) {
                    this.zzj().zzg().zza("Error retrieving package info. appId, appName", zzhc.zza(var5_5), var4_4);
                }
            }
            this.zza = var5_5;
            this.zzd = var1_1;
            this.zzb = var2_2;
            this.zzc = var3_3;
            this.zze = var4_4;
            this.zzf = 0L;
            var7_8 = TextUtils.isEmpty((CharSequence)this.zzu.zzw()) == false && "am".equals(this.zzu.zzx()) != false;
            var11_11 = this;
            var12_12 = var11_11.zzu.zzc();
            switch (var12_12) {
                case 3: {
                    var11_11.zzj().zzp().zza("App measurement disabled by setAnalyticsCollectionEnabled(false)");
                    break;
                }
                case 7: {
                    var11_11.zzj().zzp().zza("App measurement disabled via the global data collection setting");
                    break;
                }
                case 0: {
                    var11_11.zzj().zzq().zza("App measurement collection enabled");
                    break;
                }
                case 1: {
                    var11_11.zzj().zzp().zza("App measurement deactivated via the manifest");
                    break;
                }
                case 4: {
                    var11_11.zzj().zzp().zza("App measurement disabled via the manifest");
                    break;
                }
                case 6: {
                    var11_11.zzj().zzw().zza("App measurement deactivated via resources. This method is being deprecated. Please refer to https://firebase.google.com/support/guides/disable-analytics");
                    break;
                }
                case 8: {
                    var11_11.zzj().zzp().zza("App measurement disabled due to denied storage consent");
                    break;
                }
                default: {
                    var11_11.zzj().zzp().zza("App measurement disabled");
                    var11_11.zzj().zzo().zza("Invalid scion state in identity");
                }
            }
            var8_10 = var12_12 == 0;
            this.zzk = "";
            this.zzl = "";
            if (var7_8) {
                this.zzl = this.zzu.zzw();
            }
            try {
                var15_15 = var12_13 = this.zzu.zzz();
                var14_16 = "google_app_id";
                var13_17 = this.zza();
                var9_18 = new zzig((Context)var13_17, var15_15).zza(var14_16);
                v2 = this.zzk = TextUtils.isEmpty((CharSequence)var9_18) != false ? "" : var9_18;
                if (!TextUtils.isEmpty((CharSequence)var9_18)) {
                    var10_20 = new zzig(this.zza(), this.zzu.zzz());
                    this.zzl = var10_20.zza("admob_app_id");
                }
                if (var8_10) {
                    this.zzj().zzq().zza("App measurement enabled for app package, google app id", this.zza, TextUtils.isEmpty((CharSequence)this.zzk) != false ? this.zzl : this.zzk);
                }
            }
            catch (IllegalStateException var9_19) {
                this.zzj().zzg().zza("Fetching Google App Id failed with exception. appId", zzhc.zza(var5_5), var9_19);
            }
            this.zzh = null;
            var12_14 = var9_18 = this.zze().zzg("analytics.safelisted_events");
            var11_11 = this;
            if (var12_14 == null) ** GOTO lbl98
            if (var12_14.isEmpty()) {
                var11_11.zzj().zzw().zza("Safelisted event list is empty. Ignoring");
                v3 = false;
            } else {
                var13_17 = var12_14.iterator();
                while (var13_17.hasNext()) {
                    var14_16 = (String)var13_17.next();
                    if (var11_11.zzs().zzb("safelisted event", var14_16)) continue;
                    v3 = false;
                    break block30;
                }
lbl98:
                // 2 sources

                v3 = true;
            }
        }
        if (v3) {
            this.zzh = var9_18;
        }
        if (var6_6 != null) {
            this.zzj = InstantApps.isInstantApp((Context)this.zza()) != false ? 1 : 0;
            return;
        }
        this.zzj = 0;
    }

    @WorkerThread
    final void zzaj() {
        String string;
        ((zzjq)this).zzv();
        zzju zzju2 = ((zzjq)this).zzk().zzp();
        zzgr zzgr2 = this;
        if (!zzju2.zza(zzju.zza.zzb)) {
            ((zzjq)zzgr2).zzj().zzc().zza("Analytics Storage consent is not granted");
            string = null;
        } else {
            byte[] byArray = new byte[16];
            ((zzjq)zzgr2).zzs().zzw().nextBytes(byArray);
            string = String.format(Locale.US, "%032x", new BigInteger(1, byArray));
        }
        String string2 = string;
        ((zzjq)this).zzj().zzc().zza(String.format("Resetting session stitching token to %s", string2 == null ? "null" : "not null"));
        this.zzm = string2;
        this.zzn = ((zzjq)this).zzb().currentTimeMillis();
    }

    @Override
    protected final boolean zzab() {
        return true;
    }

    final boolean zzb(@Nullable String string) {
        boolean bl = this.zzo != null && !this.zzo.equals(string);
        this.zzo = string;
        return bl;
    }
}

