/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteFullException;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelReader;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzbi;
import com.google.android.gms.measurement.internal.zzbj;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzh;
import com.google.android.gms.measurement.internal.zzim;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzpy;
import com.google.android.gms.measurement.internal.zzqd;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zzgu
extends zzh {
    private static final String[] zza = new String[]{"app_version", "ALTER TABLE messages ADD COLUMN app_version TEXT;", "app_version_int", "ALTER TABLE messages ADD COLUMN app_version_int INTEGER;"};
    private final zzgt zzb = new zzgt(this, ((zzjq)this).zza(), "google_app_measurement_local.db");
    private boolean zzc;

    private static long zza(SQLiteDatabase sQLiteDatabase) {
        Cursor cursor;
        block4: {
            long l;
            block5: {
                cursor = null;
                try {
                    cursor = sQLiteDatabase.query("messages", new String[]{"rowid"}, "type=?", new String[]{"3"}, null, null, "rowid desc", "1");
                    if (!cursor.moveToFirst()) break block4;
                    l = cursor.getLong(0);
                    if (cursor == null) break block5;
                }
                catch (Throwable throwable) {
                    if (cursor != null) {
                        cursor.close();
                    }
                    throw throwable;
                }
                cursor.close();
            }
            return l;
        }
        if (cursor != null) {
            cursor.close();
        }
        return -1L;
    }

    @VisibleForTesting
    @WorkerThread
    private final @Nullable SQLiteDatabase zzag() throws SQLiteException {
        if (this.zzc) {
            return null;
        }
        SQLiteDatabase sQLiteDatabase = this.zzb.getWritableDatabase();
        if (sQLiteDatabase == null) {
            this.zzc = true;
            return null;
        }
        return sQLiteDatabase;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final @Nullable List<zzgw> zza(int n) {
        ((zzjq)this).zzv();
        if (this.zzc) {
            return null;
        }
        ArrayList<zzgw> arrayList = new ArrayList<zzgw>();
        if (!this.zzah()) {
            return arrayList;
        }
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block50: {
                if (n3 >= 5) {
                    ((zzjq)this).zzj().zzr().zza("Failed to read events from database in reasonable time");
                    return null;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.zzag();
                    if (sQLiteDatabase != null) {
                        Object object;
                        sQLiteDatabase.beginTransaction();
                        long l = zzgu.zza(sQLiteDatabase);
                        String string = null;
                        String[] stringArray = null;
                        if (l != -1L) {
                            string = "rowid<?";
                            stringArray = new String[]{String.valueOf(l)};
                        }
                        cursor = sQLiteDatabase.query("messages", new String[]{"rowid", "type", "entry"}, string, stringArray, null, null, "rowid asc", Integer.toString(100));
                        long l2 = -1L;
                        while (cursor.moveToNext()) {
                            AbstractSafeParcelable abstractSafeParcelable;
                            Parcel parcel;
                            l2 = cursor.getLong(0);
                            int n4 = cursor.getInt(1);
                            object = cursor.getBlob(2);
                            if (n4 == 0) {
                                parcel = Parcel.obtain();
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    abstractSafeParcelable = (zzbj)((Object)zzbj.CREATOR.createFromParcel(parcel));
                                }
                                catch (SafeParcelReader.ParseException parseException) {
                                    ((zzjq)this).zzj().zzg().zza("Failed to load event from local database");
                                    continue;
                                }
                                finally {
                                    parcel.recycle();
                                    continue;
                                }
                                if (abstractSafeParcelable == null) continue;
                                arrayList.add(new zzgw(abstractSafeParcelable, "", 0L));
                                continue;
                            }
                            if (n4 == 1) {
                                parcel = Parcel.obtain();
                                abstractSafeParcelable = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    abstractSafeParcelable = (zzpy)((Object)zzpy.CREATOR.createFromParcel(parcel));
                                }
                                catch (SafeParcelReader.ParseException parseException) {
                                    ((zzjq)this).zzj().zzg().zza("Failed to load user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (abstractSafeParcelable == null) continue;
                                arrayList.add(new zzgw(abstractSafeParcelable, "", 0L));
                                continue;
                            }
                            if (n4 == 2) {
                                parcel = Parcel.obtain();
                                abstractSafeParcelable = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    abstractSafeParcelable = (zzai)((Object)zzai.CREATOR.createFromParcel(parcel));
                                }
                                catch (SafeParcelReader.ParseException parseException) {
                                    ((zzjq)this).zzj().zzg().zza("Failed to load conditional user property from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (abstractSafeParcelable == null) continue;
                                arrayList.add(new zzgw(abstractSafeParcelable, "", 0L));
                                continue;
                            }
                            if (n4 == 4) {
                                parcel = Parcel.obtain();
                                abstractSafeParcelable = null;
                                try {
                                    parcel.unmarshall(object, 0, ((byte[])object).length);
                                    parcel.setDataPosition(0);
                                    abstractSafeParcelable = (zzbi)zzbi.CREATOR.createFromParcel(parcel);
                                }
                                catch (SafeParcelReader.ParseException parseException) {
                                    ((zzjq)this).zzj().zzg().zza("Failed to load default event parameters from local database");
                                }
                                finally {
                                    parcel.recycle();
                                }
                                if (abstractSafeParcelable == null) continue;
                                arrayList.add(new zzgw(abstractSafeParcelable, "", 0L));
                                continue;
                            }
                            if (n4 == 3) {
                                ((zzjq)this).zzj().zzr().zza("Skipping app launch break");
                                continue;
                            }
                            ((zzjq)this).zzj().zzg().zza("Unknown record type in local database");
                        }
                        if (sQLiteDatabase.delete("messages", "rowid <= ?", new String[]{Long.toString(l2)}) < arrayList.size()) {
                            ((zzjq)this).zzj().zzg().zza("Fewer entries removed from local database than expected");
                        }
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        object = arrayList;
                        return object;
                    }
                    this.zzc = true;
                    if (sQLiteDatabase == null) return null;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzjq)this).zzj().zzg().zza("Error reading entries from local database", (Object)sQLiteFullException);
                    this.zzc = true;
                    break block50;
                }
                catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
                    SystemClock.sleep((long)n2);
                    n2 += 20;
                    break block50;
                }
                catch (SQLiteException sQLiteException) {
                    if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                        sQLiteDatabase.endTransaction();
                    }
                    ((zzjq)this).zzj().zzg().zza("Error reading entries from local database", (Object)sQLiteException);
                    this.zzc = true;
                    break block50;
                }
                sQLiteDatabase.close();
                return null;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    zzgu(zzim zzim2) {
        super(zzim2);
    }

    @WorkerThread
    public final void zzac() {
        ((zzjq)this).zzv();
        try {
            SQLiteDatabase sQLiteDatabase = this.zzag();
            if (sQLiteDatabase != null) {
                int n = 0 + sQLiteDatabase.delete("messages", null, null);
                if (n > 0) {
                    ((zzjq)this).zzj().zzq().zza("Reset local analytics data. records", n);
                }
            }
            return;
        }
        catch (SQLiteException sQLiteException) {
            ((zzjq)this).zzj().zzg().zza("Error resetting local analytics data. error", (Object)sQLiteException);
            return;
        }
    }

    @WorkerThread
    public final boolean zzad() {
        return this.zza(3, new byte[0]);
    }

    @VisibleForTesting
    private final boolean zzah() {
        return ((zzjq)this).zza().getDatabasePath("google_app_measurement_local.db").exists();
    }

    @Override
    protected final boolean zzab() {
        return false;
    }

    @WorkerThread
    public final boolean zzae() {
        ((zzjq)this).zzv();
        if (this.zzc) {
            return false;
        }
        if (!this.zzah()) {
            return false;
        }
        int n = 5;
        for (int i = 0; i < 5; ++i) {
            try (SQLiteDatabase sQLiteDatabase = null;){
                sQLiteDatabase = this.zzag();
                if (sQLiteDatabase == null) {
                    this.zzc = true;
                    return false;
                }
                sQLiteDatabase.beginTransaction();
                sQLiteDatabase.delete("messages", "type == ?", new String[]{Integer.toString(3)});
                sQLiteDatabase.setTransactionSuccessful();
                sQLiteDatabase.endTransaction();
                return true;
            }
        }
        ((zzjq)this).zzj().zzr().zza("Error deleting app launch break from local database in reasonable time");
        return false;
    }

    public final boolean zza(zzai zzai2) {
        ((zzjq)this).zzs();
        byte[] byArray = zzqd.zza((Parcelable)zzai2);
        if (byArray.length > 131072) {
            ((zzjq)this).zzj().zzo().zza("Conditional user property too long for local database. Sending directly to service");
            return false;
        }
        return this.zza(2, byArray);
    }

    public final boolean zza(zzbi zzbi2) {
        ((zzjq)this).zzs();
        byte[] byArray = zzqd.zza((Parcelable)zzbi2);
        if (byArray == null) {
            ((zzjq)this).zzj().zzo().zza("Null default event parameters; not writing to database");
            return false;
        }
        if (byArray.length > 131072) {
            ((zzjq)this).zzj().zzo().zza("Default event parameters too long for local database. Sending directly to service");
            return false;
        }
        return this.zza(4, byArray);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    private final boolean zza(int n, byte[] byArray) {
        ((zzjq)this).zzv();
        if (this.zzc) {
            return false;
        }
        ContentValues contentValues = new ContentValues();
        contentValues.put("type", Integer.valueOf(n));
        contentValues.put("entry", byArray);
        int n2 = 5;
        int n3 = 0;
        while (true) {
            block20: {
                if (n3 >= 5) {
                    ((zzjq)this).zzj().zzq().zza("Failed to write entry to local database");
                    return false;
                }
                SQLiteDatabase sQLiteDatabase = null;
                Cursor cursor = null;
                try {
                    sQLiteDatabase = this.zzag();
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.beginTransaction();
                        long l = 0L;
                        cursor = sQLiteDatabase.rawQuery("select count(1) from messages", null);
                        if (cursor != null && cursor.moveToFirst()) {
                            l = cursor.getLong(0);
                        }
                        if (l >= 100000L) {
                            ((zzjq)this).zzj().zzg().zza("Data loss, local db full");
                            long l2 = 100000L - l + 1L;
                            long l3 = sQLiteDatabase.delete("messages", "rowid in (select rowid from messages order by rowid asc limit ?)", new String[]{Long.toString(l2)});
                            if (l3 != l2) {
                                ((zzjq)this).zzj().zzg().zza("Different delete count than expected in local db. expected, received, difference", l2, l3, l2 - l3);
                            }
                        }
                        sQLiteDatabase.insertOrThrow("messages", null, contentValues);
                        sQLiteDatabase.setTransactionSuccessful();
                        sQLiteDatabase.endTransaction();
                        return true;
                    }
                    this.zzc = true;
                    if (sQLiteDatabase == null) return false;
                }
                catch (SQLiteFullException sQLiteFullException) {
                    ((zzjq)this).zzj().zzg().zza("Error writing entry; local database full", (Object)sQLiteFullException);
                    this.zzc = true;
                    break block20;
                }
                catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
                    SystemClock.sleep((long)n2);
                    n2 += 20;
                    break block20;
                }
                catch (SQLiteException sQLiteException) {
                    if (sQLiteDatabase != null && sQLiteDatabase.inTransaction()) {
                        sQLiteDatabase.endTransaction();
                    }
                    ((zzjq)this).zzj().zzg().zza("Error writing entry to local database", (Object)sQLiteException);
                    this.zzc = true;
                    break block20;
                }
                sQLiteDatabase.close();
                return false;
                finally {
                    if (cursor != null) {
                        cursor.close();
                    }
                    if (sQLiteDatabase != null) {
                        sQLiteDatabase.close();
                    }
                }
            }
            ++n3;
        }
    }

    public final boolean zza(zzbj zzbj2) {
        Parcel parcel = Parcel.obtain();
        zzbj2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzjq)this).zzj().zzo().zza("Event is too long for local database. Sending event directly to service");
            return false;
        }
        return this.zza(0, byArray);
    }

    public final boolean zza(zzpy zzpy2) {
        Parcel parcel = Parcel.obtain();
        zzpy2.writeToParcel(parcel, 0);
        byte[] byArray = parcel.marshall();
        parcel.recycle();
        if (byArray.length > 131072) {
            ((zzjq)this).zzj().zzo().zza("User property too long for local database. Sending directly to service");
            return false;
        }
        return this.zza(1, byArray);
    }

    static /* bridge */ /* synthetic */ String[] zzaf() {
        return zza;
    }
}

