/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzda;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzlz;
import com.google.android.gms.measurement.internal.zzma;
import com.google.android.gms.measurement.internal.zzmb;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.checkerframework.checker.nullness.qual.Nullable;

@WorkerThread
final class zzmc
implements Runnable {
    private final URL zza;
    private final byte @Nullable [] zzb;
    private final zzlz zzc;
    private final String zzd;
    private final @Nullable Map<String, String> zze;
    private final /* synthetic */ zzma zzf;

    public static /* synthetic */ void zza(zzmc zzmc2, int n, Exception exception, byte[] byArray, Map map) {
        Map map2 = map;
        byte[] byArray2 = byArray;
        Exception exception2 = exception;
        int n2 = n;
        zzmc zzmc3 = zzmc2;
        zzmc3.zzc.zza(zzmc3.zzd, n2, exception2, byArray2, map2);
    }

    /*
     * Ignored method signature, as it can't be verified against descriptor
     */
    public zzmc(zzma zzma2, String string, @Nullable URL uRL, byte @Nullable [] byArray, Map map, zzlz zzlz2) {
        this.zzf = zzma2;
        Preconditions.checkNotEmpty((String)string);
        Preconditions.checkNotNull((Object)uRL);
        Preconditions.checkNotNull((Object)zzlz2);
        this.zza = uRL;
        this.zzb = byArray;
        this.zzc = zzlz2;
        this.zzd = string;
        this.zze = map;
    }

    private final void zza(int n, @Nullable Exception exception, byte @Nullable [] byArray, @Nullable Map<String, List<String>> map) {
        Map<String, List<String>> map2 = map;
        byte[] byArray2 = byArray;
        Exception exception2 = exception;
        int n2 = n;
        zzmc zzmc2 = this;
        ((zzjq)this.zzf).zzl().zzb(new zzmb(zzmc2, n2, exception2, byArray2, map2));
    }

    @Override
    public final void run() {
        ((zzjq)this.zzf).zzt();
        HttpURLConnection httpURLConnection = null;
        OutputStream outputStream = null;
        int n = 0;
        Map<String, List<String>> map = null;
        try {
            URL uRL = this.zza;
            Object object = zzda.zza().zza(uRL, "client-measurement");
            if (!(object instanceof HttpURLConnection)) {
                throw new IOException("Failed to obtain HTTP connection");
            }
            Object object2 = (HttpURLConnection)object;
            ((URLConnection)object2).setDefaultUseCaches(false);
            ((URLConnection)object2).setConnectTimeout(60000);
            ((URLConnection)object2).setReadTimeout(61000);
            ((HttpURLConnection)object2).setInstanceFollowRedirects(false);
            ((URLConnection)object2).setDoInput(true);
            httpURLConnection = object2;
            if (this.zze != null) {
                for (Map.Entry<String, String> entry : this.zze.entrySet()) {
                    httpURLConnection.addRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if (this.zzb != null) {
                Object object3;
                try {
                    byte[] byArray = this.zzb;
                    object = new ByteArrayOutputStream();
                    object2 = new GZIPOutputStream((OutputStream)object);
                    ((FilterOutputStream)object2).write(byArray);
                    ((DeflaterOutputStream)object2).close();
                    ((ByteArrayOutputStream)object).close();
                    object3 = ((ByteArrayOutputStream)object).toByteArray();
                }
                catch (IOException iOException) {
                    ((zzjq)this.zzf).zzj().zzg().zza("Failed to gzip post request content", iOException);
                    throw iOException;
                }
                ((zzjq)this.zzf).zzj().zzq().zza("Uploading data. size", ((Object)object3).length);
                httpURLConnection.setDoOutput(true);
                httpURLConnection.addRequestProperty("Content-Encoding", "gzip");
                httpURLConnection.setFixedLengthStreamingMode(((Object)object3).length);
                httpURLConnection.connect();
                outputStream = httpURLConnection.getOutputStream();
                outputStream.write((byte[])object3);
                outputStream.close();
                outputStream = null;
            }
            n = httpURLConnection.getResponseCode();
            map = httpURLConnection.getHeaderFields();
            byte[] byArray = zzma.zza(this.zzf, httpURLConnection);
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            this.zza(n, null, byArray, map);
            return;
        }
        catch (IOException iOException) {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException2) {
                    ((zzjq)this.zzf).zzj().zzg().zza("Error closing HTTP compressed POST connection output stream. appId", zzhc.zza(this.zzd), iOException2);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            this.zza(n, iOException, null, map);
            return;
        }
        catch (Throwable throwable) {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    ((zzjq)this.zzf).zzj().zzg().zza("Error closing HTTP compressed POST connection output stream. appId", zzhc.zza(this.zzd), iOException);
                }
            }
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
            this.zza(n, null, null, map);
            throw throwable;
        }
    }
}

