/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.measurement.internal.zzgk;
import com.google.android.gms.measurement.internal.zzgm;
import com.google.android.gms.measurement.internal.zzgx;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzmp;
import com.google.android.gms.measurement.internal.zznt;
import com.google.android.gms.measurement.internal.zznv;
import com.google.android.gms.measurement.internal.zznw;
import com.google.android.gms.measurement.internal.zznx;
import com.google.android.gms.measurement.internal.zzny;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class zznu
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile @Nullable zzgx zzc;
    final /* synthetic */ zzmp zza;

    static /* bridge */ /* synthetic */ void zza(zznu zznu2, boolean bl) {
        zznu2.zzb = false;
    }

    protected zznu(zzmp zzmp2) {
        this.zza = zzmp2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza(Intent intent) {
        ((zzjq)this.zza).zzv();
        Context context = ((zzjq)this.zza).zza();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        zznu zznu2 = this;
        synchronized (zznu2) {
            if (this.zzb) {
                ((zzjq)this.zza).zzj().zzq().zza("Connection attempt already in progress");
                return;
            }
            ((zzjq)this.zza).zzj().zzq().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, intent, (ServiceConnection)zzmp.zzb(this.zza), 129);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    public final void zza() {
        ((zzjq)this.zza).zzv();
        Context context = ((zzjq)this.zza).zza();
        zznu zznu2 = this;
        synchronized (zznu2) {
            if (this.zzb) {
                ((zzjq)this.zza).zzj().zzq().zza("Connection attempt already in progress");
                return;
            }
            if (this.zzc != null && (this.zzc.isConnecting() || this.zzc.isConnected())) {
                ((zzjq)this.zza).zzj().zzq().zza("Already awaiting connection attempt");
                return;
            }
            this.zzc = new zzgx(context, Looper.getMainLooper(), this, this);
            ((zzjq)this.zza).zzj().zzq().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
        }
    }

    @WorkerThread
    public final void zzb() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnected(@Nullable Bundle bundle) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnected");
        zznu zznu2 = this;
        synchronized (zznu2) {
            try {
                Preconditions.checkNotNull((Object)((Object)this.zzc));
                zzgk zzgk2 = (zzgk)this.zzc.getService();
                ((zzjq)this.zza).zzl().zzb(new zznv(this, zzgk2));
            }
            catch (DeadObjectException | IllegalStateException throwable) {
                this.zzc = null;
                this.zzb = false;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionFailed");
        zzhc zzhc2 = this.zza.zzu.zzm();
        if (zzhc2 != null) {
            zzhc2.zzr().zza("Service connection failed", connectionResult);
        }
        zznu zznu2 = this;
        synchronized (zznu2) {
            this.zzb = false;
            this.zzc = null;
        }
        ((zzjq)this.zza).zzl().zzb(new zznx(this, connectionResult));
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onConnectionSuspended");
        ((zzjq)this.zza).zzj().zzc().zza("Service connection suspended");
        ((zzjq)this.zza).zzl().zzb(new zzny(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    public final void onServiceConnected(ComponentName componentName, @Nullable IBinder iBinder) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceConnected");
        zznu zznu2 = this;
        synchronized (zznu2) {
            String string;
            if (iBinder == null) {
                this.zzb = false;
                ((zzjq)this.zza).zzj().zzg().zza("Service connected with null binder");
                return;
            }
            zzgk zzgk2 = null;
            try {
                string = iBinder.getInterfaceDescriptor();
                if ("com.google.android.gms.measurement.internal.IMeasurementService".equals(string)) {
                    IInterface iInterface;
                    IBinder iBinder2 = iBinder;
                    zzgk2 = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService")) instanceof zzgk ? (zzgk)iInterface : new zzgm(iBinder2));
                    ((zzjq)this.zza).zzj().zzq().zza("Bound to IMeasurementService interface");
                } else {
                    ((zzjq)this.zza).zzj().zzg().zza("Got binder with a wrong descriptor", string);
                }
            }
            catch (RemoteException remoteException) {
                ((zzjq)this.zza).zzj().zzg().zza("Service connect failed to get IMeasurementService");
            }
            if (zzgk2 == null) {
                this.zzb = false;
                try {
                    ConnectionTracker.getInstance().unbindService(((zzjq)this.zza).zza(), (ServiceConnection)zzmp.zzb(this.zza));
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            } else {
                string = zzgk2;
                ((zzjq)this.zza).zzl().zzb(new zznt(this, (zzgk)((Object)string)));
            }
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        Preconditions.checkMainThread((String)"MeasurementServiceConnection.onServiceDisconnected");
        ((zzjq)this.zza).zzj().zzc().zza("Service disconnected");
        ((zzjq)this.zza).zzl().zzb(new zznw(this, componentName));
    }
}

