/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.annotation.Size;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.measurement.internal.zzak;
import com.google.android.gms.measurement.internal.zzal;
import com.google.android.gms.measurement.internal.zzgg;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzju;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzam
extends zzjq {
    private Boolean zza;
    private String zzb;
    private zzal zzc = new zzak();
    private Boolean zzd;

    @WorkerThread
    public final double zza(String string, zzgg zzgg2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return (Double)zzgg2.zza(null);
        }
        String string2 = ((zzam)((Object)string2)).zzc.zza(string, zzgg2.zzb());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return (Double)zzgg2.zza(null);
        }
        try {
            double d = (Double)zzgg2.zza(Double.parseDouble(string2));
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            return (Double)zzgg2.zza(null);
        }
    }

    final int zzb(@Size(min=1L) String string) {
        return this.zzi(string, zzgi.zzV, 500, 2000);
    }

    final int zzc(String string, boolean bl) {
        if (bl) {
            return this.zzi(string, zzgi.zzag, 100, 500);
        }
        return 500;
    }

    final int zzd(String string, boolean bl) {
        return Math.max(this.zzc(string, bl), 256);
    }

    public final int zze() {
        if (this.zzu.zzw().zzao(201500000, true)) {
            return 100;
        }
        return 25;
    }

    public final int zzf(@Size(min=1L) String string) {
        return this.zzi(string, zzgi.zzW, 25, 100);
    }

    @WorkerThread
    public final int zzh(String string, zzgg zzgg2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return (Integer)zzgg2.zza(null);
        }
        String string2 = ((zzam)((Object)string2)).zzc.zza(string, zzgg2.zzb());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return (Integer)zzgg2.zza(null);
        }
        try {
            int n = (Integer)zzgg2.zza(Integer.parseInt(string2));
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            return (Integer)zzgg2.zza(null);
        }
    }

    @WorkerThread
    public final int zzi(String string, zzgg zzgg2, int n, int n2) {
        return Math.max(Math.min(this.zzh(string, zzgg2), n2), n);
    }

    public final long zzj() {
        this.zzu.zzaV();
        return 119002L;
    }

    @WorkerThread
    public final long zzk(String string, zzgg zzgg2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return (Long)zzgg2.zza(null);
        }
        String string2 = ((zzam)((Object)string2)).zzc.zza(string, zzgg2.zzb());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return (Long)zzgg2.zza(null);
        }
        try {
            long l = (Long)zzgg2.zza(Long.parseLong(string2));
            return l;
        }
        catch (NumberFormatException numberFormatException) {
            return (Long)zzgg2.zza(null);
        }
    }

    @VisibleForTesting
    final Bundle zzl() {
        Context context;
        block7: {
            zzjs zzjs2;
            block6: {
                try {
                    zzjs2 = zzam2.zzu;
                    context = ((zzio)zzjs2).zzaT();
                    context = context.getPackageManager();
                    if (context != null) break block6;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    zzam2.zzu.zzaW().zze().zzb("Failed to load metadata: Package name not found", (Object)nameNotFoundException);
                    return null;
                }
                zzjs2 = ((zzio)zzjs2).zzaW();
                ((zzhe)zzjs2).zze().zza("Failed to load metadata: PackageManager is null");
                return null;
            }
            context = ((zzio)zzjs2).zzaT();
            context = Wrappers.packageManager((Context)context);
            Context context2 = ((zzio)zzjs2).zzaT();
            context = context.getApplicationInfo(context2.getPackageName(), 128);
            if (context != null) break block7;
            zzjs2 = ((zzio)zzjs2).zzaW();
            ((zzhe)zzjs2).zze().zza("Failed to load metadata: ApplicationInfo is null");
            return null;
        }
        zzam zzam2 = context.metaData;
        return zzam2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public final zzju zzm(String string, boolean bl) {
        Preconditions.checkNotEmpty((String)string);
        zzio zzio2 = ((zzjq)object).zzu;
        Object object = ((zzam)object).zzl();
        if (object == null) {
            zzio2.zzaW().zze().zza("Failed to load metadata: Metadata bundle is null");
            object = null;
        } else {
            object = object.get(string);
        }
        if (object == null) {
            return zzju.zza;
        }
        if (Boolean.TRUE.equals(object)) {
            return zzju.zzd;
        }
        if (Boolean.FALSE.equals(object)) {
            return zzju.zzc;
        }
        if (bl && "eu_consent_policy".equals(object)) {
            return zzju.zzb;
        }
        zzio2.zzaW().zzk().zzb("Invalid manifest metadata for", string);
        return zzju.zza;
    }

    final Boolean zzn(@Size(min=1L) String string) {
        Preconditions.checkNotEmpty((String)string);
        Bundle bundle = this.zzl();
        if (bundle == null) {
            this.zzu.zzaW().zze().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey(string)) {
            return null;
        }
        return bundle.getBoolean(string);
    }

    public final String zzo() {
        return this.zzK("debug.firebase.analytics.app", "");
    }

    public final String zzp() {
        return this.zzK("debug.deferred.deeplink", "");
    }

    final String zzq() {
        this.zzu.zzaV();
        return "FA";
    }

    @WorkerThread
    public final String zzr(String string, zzgg zzgg2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return (String)zzgg2.zza(null);
        }
        zzgg zzgg3 = zzgg2;
        return (String)zzgg3.zza(this.zzc.zza(string, zzgg3.zzb()));
    }

    public final String zzs() {
        return this.zzb;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String zzK(String string, String string2) {
        string2 = "";
        try {
            string = (String)Class.forName("android.os.SystemProperties").getMethod("get", String.class, String.class).invoke(null, string, string2);
            Preconditions.checkNotNull((Object)string);
            return string;
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.zzu.zzaW().zze().zzb("Could not find SystemProperties class", classNotFoundException);
            return string2;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            this.zzu.zzaW().zze().zzb("Could not find SystemProperties.get() method", noSuchMethodException);
            return string2;
        }
        catch (IllegalAccessException illegalAccessException) {
            this.zzu.zzaW().zze().zzb("Could not access SystemProperties.get()", illegalAccessException);
            return string2;
        }
        catch (InvocationTargetException invocationTargetException) {
            this.zzu.zzaW().zze().zzb("SystemProperties.get() threw an exception", invocationTargetException);
            return string2;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final List zzt(@Size(min=1L) String object) {
        object = "analytics.safelisted_events";
        Preconditions.checkNotEmpty((String)object);
        Bundle bundle = ((zzam)this).zzl();
        if (bundle == null) {
            ((zzjq)this).zzu.zzaW().zze().zza("Failed to load metadata: Metadata bundle is null");
            return null;
        }
        if (!bundle.containsKey((String)object)) {
            return null;
        }
        object = bundle.getInt((String)object);
        if (object == null) {
            return null;
        }
        try {
            bundle = ((zzjq)this).zzu.zzaT();
            object = bundle.getResources().getStringArray(((Integer)object).intValue());
            if (object != null) return Arrays.asList(object);
            return null;
        }
        catch (Resources.NotFoundException notFoundException) {
            ((zzjq)this).zzu.zzaW().zze().zzb("Failed to load string array from metadata: resource not found", (Object)notFoundException);
            return null;
        }
    }

    zzam(zzio zzio2) {
        super(zzio2);
    }

    final void zzu(zzal zzal2) {
        this.zzc = zzal2;
    }

    public final void zzv(String string) {
        this.zzb = string;
    }

    public final boolean zzw() {
        return (this = ((zzam)this).zzn("google_analytics_adid_collection_enabled")) == null || ((Boolean)this).booleanValue();
    }

    @WorkerThread
    public final boolean zzx(String string, zzgg zzgg2) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return (Boolean)zzgg2.zza(null);
        }
        String string2 = ((zzam)((Object)string2)).zzc.zza(string, zzgg2.zzb());
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return (Boolean)zzgg2.zza(null);
        }
        return (Boolean)zzgg2.zza("1".equals(string2));
    }

    public final boolean zzy(String string) {
        String string2 = "gaia_collection_enabled";
        String string3 = ((zzam)((Object)string3)).zzc.zza(string, string2);
        return "1".equals(string3);
    }

    public final boolean zzz() {
        return (this = ((zzam)this).zzn("google_analytics_automatic_screen_reporting_enabled")) == null || ((Boolean)this).booleanValue();
    }

    public final boolean zzA() {
        ((zzjq)((Object)bl)).zzu.zzaV();
        Boolean bl = ((zzam)((Object)bl)).zzn("firebase_analytics_collection_deactivated");
        return bl != null && bl != false;
    }

    public final boolean zzB(String string) {
        String string2 = "measurement.event_sampling_enabled";
        String string3 = ((zzam)((Object)string3)).zzc.zza(string, string2);
        return "1".equals(string3);
    }

    @WorkerThread
    final boolean zzC() {
        if (this.zza == null) {
            this.zza = this.zzn("app_measurement_lite");
            if (this.zza == null) {
                this.zza = false;
            }
        }
        return this.zza != false || !this.zzu.zzN();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EnsuresNonNull(value={"this.isMainProcess"})
    public final boolean zzD() {
        if (this.zzd != null) return this.zzd;
        synchronized (this) {
            Object object;
            Object object2 = this.zzd;
            if (object2 != null) return this.zzd;
            zzio zzio2 = this.zzu;
            object2 = zzio2.zzaT();
            object2 = object2.getApplicationInfo();
            String string = ProcessUtils.getMyProcessName();
            if (object2 != null) {
                boolean bl;
                object2 = ((ApplicationInfo)object2).processName;
                bl = object2 != null ? (bl = ((String)object2).equals(string)) : false;
                this.zzd = bl;
            }
            if ((object = this.zzd) != null) return this.zzd;
            this.zzd = Boolean.TRUE;
            object = zzio2.zzaW();
            ((zzhe)object).zze().zza("My process not in the list of running processes");
            return this.zzd;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final boolean zzE() {
        if ((this = ((zzam)this).zzn("google_analytics_sgtm_upload_enabled")) == null) {
            return false;
        }
        return (Boolean)this;
    }

    public static final long zzF() {
        return (Long)zzgi.zzd.zza(null);
    }

    public static final int zzG() {
        return Math.max(0, (Integer)zzgi.zzi.zza(null));
    }

    public static final long zzH() {
        return ((Integer)zzgi.zzk.zza(null)).intValue();
    }

    public static final long zzI() {
        return (Long)zzgi.zzQ.zza(null);
    }

    public static final long zzJ() {
        return (Long)zzgi.zzL.zza(null);
    }
}

