/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.os.Build;
import android.os.PersistableBundle;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.measurement.zzih;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzg;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzqf;

public final class zzmd
extends zzg {
    private JobScheduler zza;

    @VisibleForTesting
    final int zzh() {
        String string = String.valueOf(((zzjq)((Object)string)).zzu.zzaT().getPackageName());
        return "measurement-client".concat(string).hashCode();
    }

    @WorkerThread
    final zzih zzi() {
        ((zzg)zzjs2).zza();
        ((zzjq)zzjs2).zzg();
        zzio zzio2 = ((zzjq)zzjs2).zzu;
        if (!zzio2.zzf().zzx(null, zzgi.zzaR)) {
            return zzih.zzi;
        }
        if (((zzmd)zzjs2).zza != null) {
            if (zzio2.zzf().zzE()) {
                zzjs zzjs2 = ((zzf)zzjs2).zzu;
                if (((zzio)zzjs2).zzh().zzj() >= 119000L) {
                    if (!zzqf.zzas(zzio2.zzaT(), "com.google.android.gms.measurement.AppMeasurementJobService")) {
                        return zzih.zzc;
                    }
                    if (Build.VERSION.SDK_INT >= 24) {
                        if (!((zzio)zzjs2).zzu().zzad()) {
                            return zzih.zze;
                        }
                        return zzih.zzb;
                    }
                    return zzih.zzd;
                }
                return zzih.zzf;
            }
            return zzih.zzh;
        }
        return zzih.zzg;
    }

    public zzmd(zzio zzio2) {
        super(zzio2);
    }

    @Override
    @WorkerThread
    @TargetApi(value=24)
    protected final void zzd() {
        this.zza = (JobScheduler)this.zzu.zzaT().getSystemService("jobscheduler");
    }

    /*
     * Enabled aggressive block sorting
     */
    @TargetApi(value=24)
    @WorkerThread
    public final void zzj(long l) {
        Object object;
        ((zzg)object).zza();
        ((zzjq)object).zzg();
        JobScheduler jobScheduler = ((zzmd)object).zza;
        if (jobScheduler != null && jobScheduler.getPendingJob(((zzmd)object).zzh()) != null) {
            ((zzjq)object).zzu.zzaW().zzj().zza("[sgtm] There's an existing pending job, skip this schedule.");
            return;
        }
        zzih zzih2 = ((zzmd)object).zzi();
        if (zzih2 != zzih.zzb) {
            object = zzih2.name();
            ((zzjq)object).zzu.zzaW().zzj().zzb("[sgtm] Not eligible for Scion upload", object);
            return;
        }
        zzio zzio2 = ((zzjq)object).zzu;
        Long l2 = l;
        zzio2.zzaW().zzj().zzb("[sgtm] Scheduling Scion upload, millis", l2);
        l2 = new PersistableBundle();
        l2.putString("action", "com.google.android.gms.measurement.SCION_UPLOAD");
        long l3 = l;
        l2 = new JobInfo.Builder(((zzmd)object).zzh(), new ComponentName(zzio2.zzaT(), "com.google.android.gms.measurement.AppMeasurementJobService")).setRequiredNetworkType(1).setMinimumLatency(l).setOverrideDeadline(l3 + l3).setExtras((PersistableBundle)l2).build();
        zzhc zzhc2 = zzio2.zzaW().zzj();
        object = ((JobScheduler)Preconditions.checkNotNull((Object)((zzmd)object).zza)).schedule((JobInfo)l2) == 1 ? "SUCCESS" : "FAILURE";
        zzhc2.zzb("[sgtm] Scion upload job scheduled with result", object);
    }

    @Override
    protected final boolean zzf() {
        return true;
    }
}

