/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.measurement.internal.zzgj;
import com.google.android.gms.measurement.internal.zzgl;
import com.google.android.gms.measurement.internal.zzgy;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzil;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zznq;
import com.google.android.gms.measurement.internal.zznr;
import com.google.android.gms.measurement.internal.zzns;
import com.google.android.gms.measurement.internal.zznt;
import com.google.android.gms.measurement.internal.zznw;
import com.google.android.gms.measurement.internal.zzny;

public final class zznx
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzgy zzc;
    final /* synthetic */ zzny zza;

    static /* bridge */ /* synthetic */ void zza(zznx zznx2, boolean bl) {
        zznx2.zzb = false;
    }

    protected zznx(zzny zzny2) {
        this.zza = zzny2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzb(Intent object) {
        zzny zzny2 = this.zza;
        ((zzjq)zzny2).zzg();
        Context context = zzny2.zzu.zzaT();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        synchronized (this) {
            boolean bl = this.zzb;
            if (bl) {
                object = this.zza;
                object = ((zzjq)object).zzu.zzaW();
                ((zzhe)object).zzj().zza("Connection attempt already in progress");
                return;
            }
            zzny zzny3 = this.zza;
            zzhe zzhe2 = zzny3.zzu.zzaW();
            zzhe2.zzj().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, (Intent)object, (ServiceConnection)zzny.zzj(zzny3), 129);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzc() {
        zzny zzny2 = this.zza;
        ((zzjq)zzny2).zzg();
        Object object = zzny2.zzu.zzaT();
        synchronized (this) {
            boolean bl;
            boolean bl2 = this.zzb;
            if (bl2) {
                object = this.zza;
                object = ((zzjq)object).zzu.zzaW();
                ((zzhe)object).zzj().zza("Connection attempt already in progress");
                return;
            }
            zzgy zzgy2 = this.zzc;
            if (zzgy2 != null && ((bl = this.zzc.isConnecting()) || (bl = this.zzc.isConnected()))) {
                object = this.zza;
                object = ((zzjq)object).zzu.zzaW();
                ((zzhe)object).zzj().zza("Already awaiting connection attempt");
                return;
            }
            zznx zznx2 = this;
            this.zzc = new zzgy((Context)object, Looper.getMainLooper(), zznx2, zznx2);
            object = this.zza;
            object = ((zzjq)object).zzu.zzaW();
            ((zzhe)object).zzj().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final void zzd() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onConnected(Bundle object) {
        this.zza.zzu.zzaX().zzn();
        // MONITORENTER : this
        try {
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            object = (zzgl)this.zzc.getService();
            zzjq zzjq2 = this.zza;
            zzjq2 = zzjq2.zzu.zzaX();
            ((zzil)zzjq2).zzq(new zzns(this, (zzgl)object));
            // MONITOREXIT : this
            return;
        }
        catch (DeadObjectException | IllegalStateException throwable) {
            this.zzc = null;
            this.zzb = false;
            return;
            {
                catch (Throwable throwable2) {}
                {
                    // MONITOREXIT : this
                    throw throwable2;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zzny zzny2 = this.zza;
        zzny2.zzu.zzaX().zzn();
        zzhe zzhe2 = zzny2.zzu.zzl();
        if (zzhe2 != null) {
            zzhe2.zzk().zzb("Service connection failed", connectionResult);
        }
        synchronized (this) {
            this.zzb = false;
            this.zzc = null;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        this.zza.zzu.zzaX().zzq(new zznw(this, connectionResult));
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        zzio zzio2 = this.zza.zzu;
        zzio2.zzaX().zzn();
        zzio2.zzaW().zzd().zza("Service connection suspended");
        zzio2.zzaX().zzq(new zznt(this));
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onServiceConnected(ComponentName object, IBinder object2) {
        block13: {
            this.zza.zzu.zzaX().zzn();
            // MONITORENTER : this
            if (object2 == null) {
                this.zzb = false;
                object = this.zza;
                object = ((zzjq)object).zzu.zzaW();
                ((zzhe)object).zze().zza("Service connected with null binder");
                // MONITOREXIT : this
                return;
            }
            try {
                object = object2.getInterfaceDescriptor();
                boolean bl = "com.google.android.gms.measurement.internal.IMeasurementService".equals(object);
                if (bl) {
                    object = object2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService");
                    bl = object instanceof zzgl;
                    object = bl ? (zzgl)object : new zzgj((IBinder)object2);
                    object2 = this.zza;
                    object2 = ((zzjq)object2).zzu.zzaW();
                    ((zzhe)object2).zzj().zza("Bound to IMeasurementService interface");
                    break block13;
                }
                object2 = this.zza;
                object2 = ((zzjq)object2).zzu.zzaW();
                ((zzhe)object2).zze().zzb("Got binder with a wrong descriptor", object);
                object = null;
            }
            catch (RemoteException remoteException) {
                block14: {
                    object = null;
                    break block14;
                    catch (RemoteException remoteException2) {}
                }
                object2 = this.zza;
                object2 = ((zzjq)object2).zzu.zzaW();
                ((zzhe)object2).zze().zza("Service connect failed to get IMeasurementService");
            }
        }
        if (object != null) {
            object2 = this.zza;
            object2 = ((zzjq)object2).zzu.zzaX();
            ((zzil)object2).zzq(new zznq(this, (zzgl)object));
            return;
        }
        this.zzb = false;
        try {
            object = ConnectionTracker.getInstance();
            object2 = this.zza;
            Context context = ((zzjq)object2).zzu.zzaT();
            object.unbindService(context, (ServiceConnection)zzny.zzj((zzny)object2));
            // MONITOREXIT : this
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        zzio zzio2 = this.zza.zzu;
        zzio2.zzaX().zzn();
        zzio2.zzaW().zzd().zza("Service disconnected");
        zzio2.zzaX().zzq(new zznr(this, componentName));
    }
}

