/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.annotation.TargetApi;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ext.SdkExtensions;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import androidx.privacysandbox.ads.adservices.java.measurement.MeasurementManagerFutures;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.CollectionUtils;
import com.google.android.gms.common.wrappers.Wrappers;
import com.google.android.gms.internal.measurement.zzcy;
import com.google.android.gms.measurement.internal.zzai;
import com.google.android.gms.measurement.internal.zzam;
import com.google.android.gms.measurement.internal.zzbf;
import com.google.android.gms.measurement.internal.zzbh;
import com.google.android.gms.measurement.internal.zzgi;
import com.google.android.gms.measurement.internal.zzhc;
import com.google.android.gms.measurement.internal.zzhe;
import com.google.android.gms.measurement.internal.zzhf;
import com.google.android.gms.measurement.internal.zzio;
import com.google.android.gms.measurement.internal.zzjq;
import com.google.android.gms.measurement.internal.zzjr;
import com.google.android.gms.measurement.internal.zzjs;
import com.google.android.gms.measurement.internal.zzjt;
import com.google.android.gms.measurement.internal.zzjy;
import com.google.android.gms.measurement.internal.zzjz;
import com.google.android.gms.measurement.internal.zzka;
import com.google.android.gms.measurement.internal.zzmh;
import com.google.android.gms.measurement.internal.zzny;
import com.google.android.gms.measurement.internal.zzqe;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import java.util.TreeSet;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.security.auth.x500.X500Principal;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;

public final class zzqf
extends zzjr {
    private static final String[] zzb;
    private static final String[] zzc;
    private SecureRandom zzd;
    private final AtomicLong zze = new AtomicLong(0L);
    private int zzf;
    private MeasurementManagerFutures zzg;
    private Boolean zzh;
    private Integer zzi = null;
    public static final /* synthetic */ int zza;

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final int zza(String object, String string, String string2, Object object2, Bundle bundle, List list, boolean bl, boolean bl2) {
        Object object3;
        int n;
        block15: {
            block16: {
                block19: {
                    block20: {
                        Object object4;
                        block21: {
                            int n2;
                            boolean bl3;
                            zzio zzio2;
                            block18: {
                                block17: {
                                    ((zzjq)object3).zzg();
                                    if (!((zzqf)object3).zzal(object2)) break block16;
                                    if (!bl2) return 21;
                                    if (!zzqf.zzaC(string2, zzjz.zzc)) {
                                        return 20;
                                    }
                                    zzny zzny2 = ((zzqf)object3).zzu.zzu();
                                    ((zzjq)zzny2).zzg();
                                    zzny2.zza();
                                    if (zzny2.zzad() && zzny2.zzu.zzw().zzm() < 200900) {
                                        return 25;
                                    }
                                    zzio2 = ((zzjq)object3).zzu;
                                    zzio2.zzf();
                                    bl3 = object2 instanceof Parcelable[];
                                    if (!bl3) break block17;
                                    n2 = ((Parcelable[])object2).length;
                                    break block18;
                                }
                                if (!(object2 instanceof ArrayList)) break block19;
                                n2 = ((ArrayList)object2).size();
                            }
                            if (n2 <= 200) break block20;
                            object4 = Integer.valueOf(n2);
                            zzio2.zzaW().zzl().zzd("Parameter array is too long; discarded. Value kind, name, array length", "param", string2, object4);
                            zzio2.zzf();
                            if (!bl3) break block21;
                            object4 = (Parcelable[])object2;
                            if (((Parcelable[])object4).length > 200) {
                                bundle.putParcelableArray(string2, (Parcelable[])Arrays.copyOf(object4, 200));
                                n = 17;
                                break block15;
                            } else {
                                n = 17;
                            }
                            break block15;
                        }
                        if (object2 instanceof ArrayList) {
                            object4 = (ArrayList)object2;
                            if (((ArrayList)object4).size() > 200) {
                                bundle.putParcelableArrayList(string2, new ArrayList(((ArrayList)object4).subList(0, 200)));
                                n = 17;
                                break block15;
                            } else {
                                n = 17;
                            }
                            break block15;
                        } else {
                            n = 17;
                        }
                        break block15;
                    }
                    n = 0;
                    break block15;
                }
                n = 0;
                break block15;
            }
            n = 0;
        }
        int n3 = zzqf.zzap(string) || zzqf.zzap(string2) ? ((zzjq)object3).zzu.zzf().zzd(null, false) : ((zzjq)object3).zzu.zzf().zzc(null, false);
        if (((zzqf)object3).zzaf("param", string2, n3, object2)) {
            return n;
        }
        if (!bl2) return 4;
        if (object2 instanceof Bundle) {
            ((zzqf)object3).zzaa((String)object, string, string2, (Bundle)object2, list, bl);
            return n;
        }
        if (object2 instanceof Parcelable[]) {
            Parcelable[] parcelableArray = (Parcelable[])object2;
            n3 = parcelableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Parcelable parcelable = parcelableArray[n4];
                if (!(parcelable instanceof Bundle)) {
                    object3 = parcelable.getClass();
                    ((zzjq)object3).zzu.zzaW().zzl().zzc("All Parcelable[] elements must be of type Bundle. Value type, name", object3, string2);
                    return 4;
                }
                ((zzqf)object3).zzaa((String)object, string, string2, (Bundle)parcelable, list, bl);
                ++n4;
            }
            return n;
        }
        if (!(object2 instanceof ArrayList)) return 4;
        ArrayList arrayList = (ArrayList)object2;
        n3 = arrayList.size();
        int n5 = 0;
        while (n5 < n3) {
            Object e = arrayList.get(n5);
            if (!(e instanceof Bundle)) {
                object = ((zzjq)object3).zzu.zzaW().zzl();
                object3 = e != null ? e.getClass() : "null";
                ((zzhc)object).zzc("All ArrayList elements must be of type Bundle. Value type, name", object3, string2);
                return 4;
            }
            ((zzqf)object3).zzaa((String)object, string, string2, (Bundle)e, list, bl);
            ++n5;
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     */
    final int zzd(String string, Object object) {
        boolean bl;
        if ("_ldl".equals(string)) {
            int n = this.zzaA(string);
            bl = this.zzaf("user property referrer", string, n, object);
        } else {
            int n = this.zzaA(string);
            bl = this.zzaf("user property", string, n, object);
        }
        if (bl) {
            return 0;
        }
        return 7;
    }

    final int zzf(String string) {
        if (!this.zzag("event", string)) {
            return 2;
        }
        if (!this.zzae("event", zzjy.zza, zzjy.zzb, string)) {
            return 13;
        }
        this.zzu.zzf();
        if (!this.zzad("event", 40, string)) {
            return 2;
        }
        return 0;
    }

    final int zzh(String string) {
        if (!this.zzag("event param", string)) {
            return 3;
        }
        if (!this.zzae("event param", null, null, string)) {
            return 14;
        }
        this.zzu.zzf();
        if (!this.zzad("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    final int zzi(String string) {
        if (!this.zzah("event param", string)) {
            return 3;
        }
        if (!this.zzae("event param", null, null, string)) {
            return 14;
        }
        this.zzu.zzf();
        if (!this.zzad("event param", 40, string)) {
            return 3;
        }
        return 0;
    }

    final int zzj(String string) {
        if (!this.zzag("user property", string)) {
            return 6;
        }
        if (!this.zzae("user property", zzka.zza, null, string)) {
            return 15;
        }
        this.zzu.zzf();
        if (!this.zzad("user property", 24, string)) {
            return 6;
        }
        return 0;
    }

    final int zzl() {
        if (Build.VERSION.SDK_INT >= 30 && SdkExtensions.getExtensionVersion((int)30) > 3) {
            return SdkExtensions.getExtensionVersion((int)1000000);
        }
        return 0;
    }

    @EnsuresNonNull(value={"this.apkVersion"})
    public final int zzm() {
        if (this.zzi == null) {
            zzio zzio2 = this.zzu;
            this.zzi = GoogleApiAvailabilityLight.getInstance().getApkVersion(zzio2.zzaT()) / 1000;
        }
        return this.zzi;
    }

    private final int zzaA(String string) {
        if ("_ldl".equals(string)) {
            this.zzu.zzf();
            return 2048;
        }
        if ("_id".equals(string)) {
            this.zzu.zzf();
            return 256;
        }
        if ("_lgclid".equals(string)) {
            this.zzu.zzf();
            return 100;
        }
        this.zzu.zzf();
        return 36;
    }

    public final int zzp(int n) {
        zzjs zzjs2 = ((zzjq)zzjs2).zzu;
        return GoogleApiAvailabilityLight.getInstance().isGooglePlayServicesAvailable(((zzio)zzjs2).zzaT(), 12451000);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final long zzq() {
        long l;
        long l2;
        this.zzg();
        zzqf zzqf2 = this;
        if (!zzqf2.zzab(zzqf2.zzu.zzh().zzm())) {
            return 0L;
        }
        if (Build.VERSION.SDK_INT < 30) {
            l2 = 4L;
        } else if (SdkExtensions.getExtensionVersion((int)30) < 4) {
            l2 = 8L;
        } else {
            zzio zzio2 = this.zzu;
            int n = this.zzl();
            zzio2.zzf();
            l2 = n < (Integer)zzgi.zzak.zza(null) ? 16L : 0L;
        }
        long l3 = !this.zzaj("android.permission.ACCESS_ADSERVICES_ATTRIBUTION") ? l2 | 2L : l2;
        if (l3 == 0L) {
            if (!this.zzai()) {
                return 64L;
            }
            l = l3;
        } else {
            l = l3;
        }
        if (l != 0L) return l;
        return 1L;
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    static long zzr(byte[] byArray) {
        Preconditions.checkNotNull((Object)byArray);
        int n = byArray.length;
        int n2 = n > 0 ? 1 : 0;
        Preconditions.checkState(n2 != 0);
        long l = 0L;
        n2 = 0;
        --n;
        while (n >= 0 && n >= byArray.length + -8) {
            l += ((long)byArray[n] & 0xFFL) << n2;
            n2 += 8;
            --n;
        }
        return l;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long zzs() {
        AtomicLong atomicLong = ((zzqf)((Object)atomicLong2)).zze;
        if (atomicLong.get() == 0L) {
            synchronized (atomicLong) {
                long l = System.nanoTime();
                Clock clock = ((zzjq)((Object)atomicLong2)).zzu.zzaU();
                Random random = new Random(l ^ clock.currentTimeMillis());
                return random.nextLong() + (long)(++((zzqf)((Object)atomicLong2)).zzf);
            }
        }
        AtomicLong atomicLong2 = ((zzqf)((Object)atomicLong2)).zze;
        synchronized (atomicLong2) {
            atomicLong2.compareAndSet(-1L, 1L);
            return atomicLong2.getAndIncrement();
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    public final long zzt(long l, long l2) {
        return (l + l2 * 60000L) / 86400000L;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final Bundle zzu(Uri uri) {
        Object object;
        String string;
        String string2;
        String string3;
        String string4;
        String string5;
        String string6;
        String string7;
        block23: {
            Object object2;
            block22: {
                Object object3;
                if (uri == null) {
                    return null;
                }
                try {
                    boolean bl = uri.isHierarchical();
                    if (!bl) break block22;
                    string7 = uri.getQueryParameter("utm_campaign");
                    string6 = uri.getQueryParameter("utm_source");
                    string5 = uri.getQueryParameter("utm_medium");
                    string4 = uri.getQueryParameter("gclid");
                    string3 = uri.getQueryParameter("gbraid");
                    string2 = uri.getQueryParameter("utm_id");
                    string = uri.getQueryParameter("dclid");
                    object = uri.getQueryParameter("srsltid");
                    object3 = object2 = uri.getQueryParameter("sfmc_id");
                    object2 = string7;
                    string7 = string6;
                    string6 = string5;
                    string5 = string4;
                    string4 = string3;
                    string3 = string2;
                    string2 = string;
                    string = object;
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    ((zzjq)object2).zzu.zzaW().zzk().zzb("Install referrer url isn't a hierarchical URI", unsupportedOperationException);
                    return null;
                }
                object = object3;
                break block23;
            }
            object2 = null;
            string7 = null;
            string6 = null;
            string5 = null;
            string4 = null;
            string3 = null;
            string2 = null;
            string = null;
            object = null;
        }
        if (TextUtils.isEmpty((CharSequence)object2) && TextUtils.isEmpty((CharSequence)string7) && TextUtils.isEmpty((CharSequence)string6) && TextUtils.isEmpty((CharSequence)string5) && TextUtils.isEmpty((CharSequence)string4) && TextUtils.isEmpty((CharSequence)string3) && TextUtils.isEmpty((CharSequence)string2) && TextUtils.isEmpty((CharSequence)string) && TextUtils.isEmpty((CharSequence)object)) {
            return null;
        }
        Bundle bundle = new Bundle();
        if (!TextUtils.isEmpty((CharSequence)object2)) {
            bundle.putString("campaign", (String)object2);
        }
        if (!TextUtils.isEmpty((CharSequence)string7)) {
            bundle.putString("source", string7);
        }
        if (!TextUtils.isEmpty((CharSequence)string6)) {
            bundle.putString("medium", string6);
        }
        if (!TextUtils.isEmpty((CharSequence)string5)) {
            bundle.putString("gclid", string5);
        }
        if (!TextUtils.isEmpty((CharSequence)string4)) {
            bundle.putString("gbraid", string4);
        }
        if (!TextUtils.isEmpty((CharSequence)(object2 = uri.getQueryParameter("gad_source")))) {
            bundle.putString("gad_source", (String)object2);
        }
        if (!TextUtils.isEmpty((CharSequence)(object2 = uri.getQueryParameter("utm_term")))) {
            bundle.putString("term", (String)object2);
        }
        if (!TextUtils.isEmpty((CharSequence)(object2 = uri.getQueryParameter("utm_content")))) {
            bundle.putString("content", (String)object2);
        }
        if (!TextUtils.isEmpty((CharSequence)(object2 = uri.getQueryParameter("aclid")))) {
            bundle.putString("aclid", (String)object2);
        }
        if (!TextUtils.isEmpty((CharSequence)(object2 = uri.getQueryParameter("cp1")))) {
            bundle.putString("cp1", (String)object2);
        }
        if (!TextUtils.isEmpty((CharSequence)(object2 = uri.getQueryParameter("anid")))) {
            bundle.putString("anid", (String)object2);
        }
        if (!TextUtils.isEmpty((CharSequence)string3)) {
            bundle.putString("campaign_id", string3);
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            bundle.putString("dclid", string2);
        }
        if (!TextUtils.isEmpty((CharSequence)(object2 = uri.getQueryParameter("utm_source_platform")))) {
            bundle.putString("source_platform", (String)object2);
        }
        if (!TextUtils.isEmpty((CharSequence)(object2 = uri.getQueryParameter("utm_creative_format")))) {
            bundle.putString("creative_format", (String)object2);
        }
        if (!TextUtils.isEmpty((CharSequence)(object2 = uri.getQueryParameter("utm_marketing_tactic")))) {
            bundle.putString("marketing_tactic", (String)object2);
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            bundle.putString("srsltid", string);
        }
        if (!TextUtils.isEmpty((CharSequence)object)) {
            bundle.putString("sfmc_id", (String)object);
        }
        return bundle;
    }

    final Bundle zzz(Bundle bundle, String string) {
        string = new Bundle();
        if (bundle != null) {
            Iterator iterator = bundle.keySet().iterator();
            while (iterator.hasNext()) {
                String string2;
                String string3 = string2 = (String)iterator.next();
                Object object = this.zzD(string3, bundle.get(string3));
                if (object == null) {
                    object = this.zzu;
                    string2 = ((zzio)object).zzj().zze(string2);
                    ((zzio)object).zzaW().zzl().zzb("Param value can't be null", string2);
                    continue;
                }
                this.zzS((Bundle)string, string2, object);
            }
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    final Bundle zzA(String string, String string2, Bundle bundle, List list, boolean bl) {
        boolean bl2 = zzqf.zzaC(string2, zzjy.zzd);
        if (bundle == null) {
            return null;
        }
        Bundle bundle2 = new Bundle(bundle);
        zzio zzio2 = this.zzu;
        int n = zzio2.zzf().zze();
        Iterator iterator = new TreeSet(bundle.keySet()).iterator();
        int n2 = 0;
        boolean bl3 = false;
        while (iterator.hasNext()) {
            String string3;
            int n3;
            String string4 = (String)iterator.next();
            if (list == null || !list.contains(string4)) {
                n3 = !bl ? this.zzi(string4) : 0;
                if (n3 == 0) {
                    n3 = this.zzh(string4);
                }
            } else {
                n3 = 0;
            }
            if (n3 != 0) {
                String string5 = n3 == 3 ? string4 : null;
                this.zzM(bundle2, n3, string4, string5);
                bundle2.remove(string4);
                continue;
            }
            String string6 = string4;
            int n4 = this.zza(string, string2, string6, bundle.get(string6), bundle2, list, bl, bl2);
            if (n4 == 17) {
                this.zzM(bundle2, 17, string4, false);
            } else if (n4 != 0 && !"_ev".equals(string4)) {
                string3 = n4 == 21 ? string2 : string4;
            }
            if (!zzqf.zzaq(string4) || ++n2 <= n) continue;
            if (!zzio2.zzf().zzx(null, zzgi.zzbr) || !bl3) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Event can't contain more than ");
                stringBuilder.append(n);
                stringBuilder.append(" params");
                String string7 = stringBuilder.toString();
                zzio2.zzaW().zzf().zzc(string7, zzio2.zzj().zzd(string2), zzio2.zzj().zzb(bundle));
            }
            zzqf.zzaz(bundle2, 5);
            bundle2.remove(string4);
            bl3 = true;
            continue;
            this.zzM(bundle2, n4, string3, bundle.get(string4));
            bundle2.remove(string4);
        }
        return bundle2;
    }

    final MeasurementManagerFutures zzB() {
        if (this.zzg == null) {
            this.zzg = MeasurementManagerFutures.from((Context)this.zzu.zzaT());
        }
        return this.zzg;
    }

    /*
     * Enabled aggressive block sorting
     */
    final zzbh zzC(String string, String string2, Bundle bundle, String string3, long l, boolean bl, boolean bl2) {
        Object object;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        if (((zzqf)object).zzf(string2) != 0) {
            object = ((zzjq)object).zzu;
            zzhc zzhc2 = ((zzio)object).zzaW().zze();
            object = ((zzio)object).zzj().zzf(string2);
            zzhc2.zzb("Invalid conditional property event name", object);
            throw new IllegalArgumentException();
        }
        bundle = bundle != null ? new Bundle(bundle) : new Bundle();
        bundle.putString("_o", string3);
        bundle = ((zzqf)object).zzA(string, string2, bundle, CollectionUtils.listOf((Object)"_o"), true);
        object = bl ? ((zzqf)object).zzz(bundle, string) : bundle;
        Preconditions.checkNotNull((Object)object);
        return new zzbh(string2, new zzbf((Bundle)object), string3, l);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final Object zzD(String string, Object object) {
        int n;
        if ("_ev".equals(string)) {
            zzqf zzqf2 = this;
            return zzqf2.zzaB(zzqf2.zzu.zzf().zzd(null, false), object, true, true, null);
        }
        if (zzqf.zzap(string)) {
            n = this.zzu.zzf().zzd(null, false);
            return this.zzaB(n, object, false, true, null);
        }
        n = this.zzu.zzf().zzc(null, false);
        return this.zzaB(n, object, false, true, null);
    }

    final Object zzE(String string, Object object) {
        if ("_ldl".equals(string)) {
            zzqf zzqf2 = this;
            return zzqf2.zzaB(zzqf2.zzaA(string), object, true, false, null);
        }
        zzqf zzqf3 = this;
        return zzqf3.zzaB(zzqf3.zzaA(string), object, false, false, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Object zzaB(int n, Object parcelableArray, boolean bl, boolean n2, String string) {
        if (parcelableArray == null) {
            return null;
        }
        if (parcelableArray instanceof Long || parcelableArray instanceof Double) {
            return parcelableArray;
        }
        if (parcelableArray instanceof Integer) {
            return (long)((Integer)parcelableArray).intValue();
        }
        if (parcelableArray instanceof Byte) {
            return (long)((Byte)parcelableArray).byteValue();
        }
        if (parcelableArray instanceof Short) {
            return (long)((Short)parcelableArray).shortValue();
        }
        if (parcelableArray instanceof Boolean) {
            long l;
            if (!((Boolean)parcelableArray).booleanValue()) {
                l = 0L;
                return l;
            }
            l = 1L;
            return l;
        }
        if (parcelableArray instanceof Float) {
            return ((Float)parcelableArray).doubleValue();
        }
        if (parcelableArray instanceof String || parcelableArray instanceof Character || parcelableArray instanceof CharSequence) {
            return this.zzG(parcelableArray.toString(), n, bl);
        }
        if (n2 == 0 || !(parcelableArray instanceof Bundle[]) && !(parcelableArray instanceof Parcelable[])) return null;
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>();
        for (Parcelable parcelable : parcelableArray) {
            Bundle bundle;
            if (!(parcelable instanceof Bundle) || (bundle = this.zzz((Bundle)parcelable, null)).isEmpty()) continue;
            arrayList.add(bundle);
        }
        ArrayList<Bundle> arrayList2 = arrayList;
        return arrayList2.toArray(new Bundle[arrayList2.size()]);
    }

    final String zzF() {
        byte[] byArray = new byte[16];
        objectArray.zzJ().nextBytes(byArray);
        Object[] objectArray = new Object[]{new BigInteger(1, byArray)};
        return String.format(Locale.US, "%032x", objectArray);
    }

    public final String zzG(String string, int n, boolean bl) {
        if (string == null) {
            return null;
        }
        String string2 = string;
        if (string2.codePointCount(0, string2.length()) > n) {
            if (bl) {
                String string3 = string;
                return String.valueOf(string3.substring(0, string3.offsetByCodePoints(0, n))).concat("...");
            }
            return null;
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final URL zzH(long l, String string, String string2, long l2, String string3) {
        try {
            Preconditions.checkNotEmpty((String)string2);
            Preconditions.checkNotEmpty((String)string);
            string2 = String.format("https://www.googleadservices.com/pagead/conversion/app/deeplink?id_type=adid&sdk_version=%s&rdid=%s&bundleid=%s&retry=%s", String.format("v%s.%s", 119002L, this.zzm()), string2, string, l2);
            zzam zzam2 = this.zzu.zzf();
            boolean bl = string.equals(zzam2.zzp());
            String string4 = bl ? string2.concat("&ddl_test=1") : string2;
            char c = string3.isEmpty();
            if (c != '\u0000') return new URL(string4);
            c = string3.charAt(0);
            if (c != '&') {
                string4 = string4.concat("&");
            }
            string4 = string4.concat(string3);
            return new URL(string4);
        }
        catch (IllegalArgumentException | MalformedURLException exception) {
            this.zzu.zzaW().zze().zzb("Failed to create BOW URL for Deferred Deep Link. exception", exception.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static MessageDigest zzI() {
        int n = 0;
        while (n < 2) {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                if (messageDigest != null) {
                    return messageDigest;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {}
            ++n;
        }
        return null;
    }

    @EnsuresNonNull(value={"this.secureRandom"})
    @WorkerThread
    final SecureRandom zzJ() {
        this.zzg();
        if (this.zzd == null) {
            this.zzd = new SecureRandom();
        }
        return this.zzd;
    }

    public static ArrayList zzK(List object) {
        if (object == null) {
            return new ArrayList(0);
        }
        ArrayList<Bundle> arrayList = new ArrayList<Bundle>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            AbstractSafeParcelable abstractSafeParcelable = (zzai)((Object)object.next());
            Bundle bundle = new Bundle();
            Object object2 = abstractSafeParcelable.zza;
            bundle.putString("app_id", (String)object2);
            object2 = abstractSafeParcelable.zzb;
            bundle.putString("origin", (String)object2);
            long l = abstractSafeParcelable.zzd;
            bundle.putLong("creation_timestamp", l);
            object2 = abstractSafeParcelable.zzc.zzb;
            bundle.putString("name", (String)object2);
            zzjt.zzb((Bundle)bundle, (Object)Preconditions.checkNotNull((Object)abstractSafeParcelable.zzc.zza()));
            boolean bl = abstractSafeParcelable.zze;
            bundle.putBoolean("active", bl);
            object2 = abstractSafeParcelable.zzf;
            if (object2 != null) {
                bundle.putString("trigger_event_name", (String)object2);
            }
            if ((object2 = abstractSafeParcelable.zzg) != null) {
                bundle.putString("timed_out_event_name", ((zzbh)((Object)object2)).zza);
                object2 = ((zzbh)((Object)object2)).zzb;
                if (object2 != null) {
                    bundle.putBundle("timed_out_event_params", ((zzbf)object2).zzc());
                }
            }
            l = abstractSafeParcelable.zzh;
            bundle.putLong("trigger_timeout", l);
            object2 = abstractSafeParcelable.zzi;
            if (object2 != null) {
                bundle.putString("triggered_event_name", ((zzbh)((Object)object2)).zza);
                object2 = ((zzbh)((Object)object2)).zzb;
                if (object2 != null) {
                    bundle.putBundle("triggered_event_params", ((zzbf)object2).zzc());
                }
            }
            l = abstractSafeParcelable.zzc.zzc;
            bundle.putLong("triggered_timestamp", l);
            l = abstractSafeParcelable.zzj;
            bundle.putLong("time_to_live", l);
            abstractSafeParcelable = abstractSafeParcelable.zzk;
            if (abstractSafeParcelable != null) {
                bundle.putString("expired_event_name", abstractSafeParcelable.zza);
                abstractSafeParcelable = abstractSafeParcelable.zzb;
                if (abstractSafeParcelable != null) {
                    bundle.putBundle("expired_event_params", abstractSafeParcelable.zzc());
                }
            }
            arrayList.add(bundle);
        }
        return arrayList;
    }

    static {
        String string = "firebase_";
        zzb = new String[]{string, "google_", "ga_"};
        string = "_err";
        zzc = new String[]{string};
    }

    zzqf(zzio zzio2) {
        super(zzio2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    final void zzL(Bundle bundle, long l) {
        long l2;
        long l3 = bundle.getLong("_et");
        if (l3 != 0L) {
            this.zzu.zzaW().zzk().zzb("Params already contained engagement", l3);
            l2 = l3;
        } else {
            l2 = 0L;
        }
        bundle.putLong("_et", l += l2);
    }

    final void zzM(Bundle bundle, int n, String string, Object object) {
        if (zzqf.zzaz(bundle, n)) {
            ((zzjq)((Object)string2)).zzu.zzf();
            String string2 = ((zzqf)((Object)string2)).zzG(string, 40, true);
            bundle.putString("_ev", string2);
            if (object != null) {
                Preconditions.checkNotNull((Object)bundle);
                if (object instanceof String || object instanceof CharSequence) {
                    int n2 = object.toString().length();
                    bundle.putLong("_el", (long)n2);
                    return;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @WorkerThread
    public static void zzN(zzmh zzmh2, Bundle bundle, boolean bl) {
        if (bundle != null && zzmh2 != null) {
            if (!bundle.containsKey("_sc") || bl) {
                String string = zzmh2.zza;
                if (string != null) {
                    bundle.putString("_sn", string);
                } else {
                    bundle.remove("_sn");
                }
                if ((string = zzmh2.zzb) != null) {
                    bundle.putString("_sc", string);
                } else {
                    bundle.remove("_sc");
                }
                long l = zzmh2.zzc;
                bundle.putLong("_si", l);
                return;
            }
            bl = false;
        }
        if (bundle != null && zzmh2 == null && bl) {
            bundle.remove("_sn");
            bundle.remove("_sc");
            bundle.remove("_si");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzO(Bundle bundle, Bundle bundle2) {
        if (bundle2 != null) {
            for (String string : bundle2.keySet()) {
                if (bundle.containsKey(string)) continue;
                String string2 = string;
                this.zzu.zzw().zzS(bundle, string2, bundle2.get(string2));
            }
        }
    }

    final void zzP(Parcelable[] parcelableArray, int n) {
        Preconditions.checkNotNull((Object)parcelableArray);
        int n2 = parcelableArray.length;
        for (int i = 0; i < n2; ++i) {
            Bundle bundle = (Bundle)parcelableArray[i];
            Iterator iterator = new TreeSet(bundle.keySet()).iterator();
            int n3 = 0;
            boolean bl = false;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!zzqf.zzaq(string) || zzqf.zzaC(string, zzjz.zzd) || ++n3 <= n) continue;
                zzio zzio2 = this.zzu;
                if (!zzio2.zzf().zzx(null, zzgi.zzbr) || !bl) {
                    zzhc zzhc2 = zzio2.zzaW().zzf();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Param can't contain more than ");
                    stringBuilder.append(n);
                    stringBuilder.append(" item-scoped custom parameters");
                    zzhc2.zzc(stringBuilder.toString(), zzio2.zzj().zze(string), zzio2.zzj().zzb(bundle));
                }
                zzqf.zzaz(bundle, 28);
                bundle.remove(string);
                bl = true;
            }
        }
    }

    final void zzQ(zzhf zzhf2, int n) {
        Bundle bundle = zzhf2.zzd;
        Iterator iterator = new TreeSet(bundle.keySet()).iterator();
        int n2 = 0;
        boolean bl = false;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!zzqf.zzaq(string) || ++n2 <= n) continue;
            zzio zzio2 = this.zzu;
            if (!zzio2.zzf().zzx(null, zzgi.zzbr) || !bl) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("Event can't contain more than ");
                stringBuilder.append(n);
                stringBuilder.append(" params");
                String string2 = stringBuilder.toString();
                zzio2.zzaW().zzf().zzc(string2, zzio2.zzj().zzd(zzhf2.zza), zzio2.zzj().zzb(bundle));
                zzqf.zzaz(bundle, 5);
            }
            bundle.remove(string);
            bl = true;
        }
    }

    final void zzR(zzqe zzqe2, String string, int n, String string2, String string3, int n2) {
        zzqf zzqf2 = new Bundle();
        zzqf.zzaz((Bundle)zzqf2, n);
        if (!TextUtils.isEmpty((CharSequence)string2) && !TextUtils.isEmpty((CharSequence)string3)) {
            zzqf2.putString(string2, string3);
        }
        if (n == 6 || n == 7 || n == 2) {
            long l = n2;
            zzqf2.putLong("_el", l);
        }
        zzqe2.zza(string, "_err", (Bundle)zzqf2);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @WorkerThread
    protected final void zzaZ() {
        long l;
        this.zzg();
        SecureRandom secureRandom = new SecureRandom();
        long l2 = secureRandom.nextLong();
        if (l2 == 0L) {
            long l3 = secureRandom.nextLong();
            if (l3 == 0L) {
                this.zzu.zzaW().zzk().zza("Utils falling back to Random for random id");
                l = l3;
            } else {
                l = l3;
            }
        } else {
            l = l2;
        }
        this.zze.set(l);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    final void zzS(Bundle object, String string, Object object2) {
        void var1_3;
        void var2_5;
        void var3_6;
        block10: {
            block9: {
                if (object == null) break block9;
                if (var3_6 instanceof Long) {
                    object.putLong((String)var2_5, ((Long)var3_6).longValue());
                    return;
                }
                if (var3_6 instanceof String) {
                    object.putString((String)var2_5, String.valueOf(var3_6));
                    return;
                }
                if (var3_6 instanceof Double) {
                    object.putDouble((String)var2_5, ((Double)var3_6).doubleValue());
                    return;
                }
                if (var3_6 instanceof Bundle[]) {
                    object.putParcelableArray((String)var2_5, (Parcelable[])((Bundle[])var3_6));
                    return;
                }
                if (var2_5 != null) break block10;
            }
            return;
        }
        if (var3_6 != null) {
            String string2 = var3_6.getClass().getSimpleName();
        } else {
            Object var1_4 = null;
        }
        Object object3 = ((zzjq)object3).zzu;
        zzhc zzhc2 = ((zzio)object3).zzaW().zzl();
        object3 = ((zzio)object3).zzj().zze((String)var2_5);
        zzhc2.zzc("Not putting event parameter. Invalid value type. name, type", object3, var1_3);
    }

    public final void zzT(zzcy zzcy2, boolean bl) {
        Bundle bundle = new Bundle();
        bundle.putBoolean("r", bl);
        try {
            zzcy2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzaW().zzk().zzb("Error returning boolean value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzU(zzcy zzcy2, ArrayList arrayList) {
        Bundle bundle = new Bundle();
        bundle.putParcelableArrayList("r", arrayList);
        try {
            zzcy2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzaW().zzk().zzb("Error returning bundle list to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzV(zzcy zzcy2, Bundle bundle) {
        try {
            zzcy2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzaW().zzk().zzb("Error returning bundle value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzW(zzcy zzcy2, byte[] byArray) {
        Bundle bundle = new Bundle();
        bundle.putByteArray("r", byArray);
        try {
            zzcy2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzaW().zzk().zzb("Error returning byte array to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzX(zzcy zzcy2, int n) {
        Bundle bundle = new Bundle();
        bundle.putInt("r", n);
        try {
            zzcy2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzaW().zzk().zzb("Error returning int value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzY(zzcy zzcy2, long l) {
        Bundle bundle = new Bundle();
        bundle.putLong("r", l);
        try {
            zzcy2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzaW().zzk().zzb("Error returning long value to wrapper", (Object)remoteException);
            return;
        }
    }

    public final void zzZ(zzcy zzcy2, String string) {
        Bundle bundle = new Bundle();
        bundle.putString("r", string);
        try {
            zzcy2.zze(bundle);
            return;
        }
        catch (RemoteException remoteException) {
            this.zzu.zzaW().zzk().zzb("Error returning string value to wrapper", (Object)remoteException);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    final void zzaa(String string, String string2, String string3, Bundle bundle, List list, boolean bl) {
        if (bundle != null) {
            zzio zzio2 = this.zzu;
            int n = true != zzio2.zzf().zzu.zzw().zzao(231100000, true) ? 0 : 35;
            Iterator iterator = new TreeSet(bundle.keySet()).iterator();
            int n2 = 0;
            boolean bl2 = false;
            while (iterator.hasNext()) {
                String string4;
                int n3;
                String string5 = (String)iterator.next();
                if (list == null || !list.contains(string5)) {
                    n3 = !bl ? this.zzi(string5) : 0;
                    if (n3 == 0) {
                        n3 = this.zzh(string5);
                    }
                } else {
                    n3 = 0;
                }
                if (n3 != 0) {
                    string4 = n3 == 3 ? string5 : null;
                    this.zzM(bundle, n3, string5, string4);
                    bundle.remove(string5);
                    continue;
                }
                if (this.zzal(bundle.get(string5))) {
                    zzio2.zzaW().zzl().zzd("Nested Bundle parameters are not allowed; discarded. event name, param name, child param name", string2, string3, string5);
                    n3 = 22;
                } else {
                    String string6 = string5;
                    n3 = this.zza(string, string2, string6, bundle.get(string6), bundle, list, bl, false);
                }
                if (n3 != 0 && !"_ev".equals(string5)) {
                    Bundle bundle2 = bundle;
                    String string7 = string5;
                    this.zzM(bundle2, n3, string7, bundle2.get(string7));
                    bundle.remove(string5);
                    continue;
                }
                if (!zzqf.zzaq(string5) || zzqf.zzaC(string5, zzjz.zzd)) continue;
                ++n2;
                if (!this.zzao(231100000, true)) {
                    String string8 = zzio2.zzj().zzd(string2);
                    string4 = zzio2.zzj().zzb(bundle);
                    zzio2.zzaW().zzf().zzc("Item array not supported on client's version of Google Play Services (Android Only)", string8, string4);
                    zzqf.zzaz(bundle, 23);
                    bundle.remove(string5);
                    continue;
                }
                if (n2 <= n) continue;
                if (!zzio2.zzf().zzx(null, zzgi.zzbr) || !bl2) {
                    zzhc zzhc2 = zzio2.zzaW().zzf();
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("Item can't contain more than ");
                    stringBuilder.append(n);
                    stringBuilder.append(" item-scoped custom params");
                    zzhc2.zzc(stringBuilder.toString(), zzio2.zzj().zzd(string2), zzio2.zzj().zzb(bundle));
                }
                zzqf.zzaz(bundle, 28);
                bundle.remove(string5);
                bl2 = true;
            }
        }
    }

    final boolean zzab(String string) {
        String string2 = (String)zzgi.zzaq.zza(null);
        return string2.equals("*") || Arrays.asList(string2.split(",")).contains(string);
    }

    private static boolean zzaC(String string, String[] stringArray) {
        Preconditions.checkNotNull((Object)stringArray);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!Objects.equals(string, stringArray[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    final boolean zzac(String string, String string2) {
        Object object;
        zzio zzio2 = ((zzjq)object).zzu;
        if (zzio2.zzf().zzx(null, zzgi.zzbp)) {
            if (!TextUtils.isEmpty((CharSequence)string)) {
                if (((zzqf)object).zzax(string)) return true;
                if (!((zzqf)object).zzu.zzL()) {
                    return false;
                }
                object = zzhe.zzn(string);
                zzio2.zzaW().zzf().zzb("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", object);
                return false;
            }
            if (!((zzqf)object).zzu.zzL()) {
                return false;
            }
            zzio2.zzaW().zzf().zza("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            if (((zzqf)object).zzax(string)) return true;
            if (!((zzqf)object).zzu.zzL()) return false;
            object = zzhe.zzn(string);
            zzio2.zzaW().zzf().zzb("Invalid google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI. provided id", object);
            return false;
        }
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            if (((zzqf)object).zzax(string2)) return true;
            object = zzhe.zzn(string2);
            zzio2.zzaW().zzf().zzb("Invalid admob_app_id. Analytics disabled.", object);
            return false;
        }
        if (!((zzqf)object).zzu.zzL()) return false;
        zzio2.zzaW().zzf().zza("Missing google_app_id. Firebase Analytics disabled. See https://goo.gl/NAOOOI");
        return false;
    }

    final boolean zzad(String string, int n, String string2) {
        if (string2 == null) {
            ((zzjq)((Object)n2)).zzu.zzaW().zzf().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        String string3 = string2;
        if (string3.codePointCount(0, string3.length()) > n) {
            Integer n2 = n;
            ((zzjq)((Object)n2)).zzu.zzaW().zzf().zzd("Name is too long. Type, maximum supported length, name", string, n2, string2);
            return false;
        }
        return true;
    }

    final boolean zzae(String string, String[] stringArray, String[] stringArray2, String string2) {
        if (string2 == null) {
            this.zzu.zzaW().zzf().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        Preconditions.checkNotNull((Object)string2);
        String[] stringArray3 = zzb;
        for (int i = 0; i < 3; ++i) {
            if (!string2.startsWith(stringArray3[i])) continue;
            this.zzu.zzaW().zzf().zzc("Name starts with reserved prefix. Type, name", string, string2);
            return false;
        }
        if (stringArray != null && zzqf.zzaC(string2, stringArray) && (stringArray2 == null || !zzqf.zzaC(string2, stringArray2))) {
            this.zzu.zzaW().zzf().zzc("Name is reserved. Type, name", string, string2);
            return false;
        }
        return true;
    }

    final boolean zzaf(String string, String string2, int n, Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof Long || object instanceof Float || object instanceof Integer || object instanceof Byte || object instanceof Short || object instanceof Boolean || object instanceof Double) {
            return true;
        }
        if (object instanceof String || object instanceof Character || object instanceof CharSequence) {
            Object object2 = object = object.toString();
            if (((String)object2).codePointCount(0, ((String)object2).length()) > n) {
                Integer n2 = ((String)object).length();
                ((zzjq)((Object)n2)).zzu.zzaW().zzl().zzd("Value is too long; discarded. Value kind, name, value length", string, string2, n2);
                return false;
            }
            return true;
        }
        return false;
    }

    final boolean zzag(String string, String string2) {
        block8: {
            int n;
            int n2;
            block7: {
                if (string2 == null) {
                    this.zzu.zzaW().zzf().zzb("Name is required and can't be null. Type", string);
                    return false;
                }
                if (string2.length() == 0) {
                    this.zzu.zzaW().zzf().zzb("Name is required and can't be empty. Type", string);
                    return false;
                }
                n2 = string2.codePointAt(0);
                if (Character.isLetter(n2)) break block7;
                if (n2 != 95) break block8;
                n2 = 95;
            }
            int n3 = string2.length();
            for (n2 = Character.charCount(n2); n2 < n3; n2 += Character.charCount(n)) {
                n = string2.codePointAt(n2);
                if (n == 95 || Character.isLetterOrDigit(n)) {
                    continue;
                }
                this.zzu.zzaW().zzf().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
                return false;
            }
            return true;
        }
        this.zzu.zzaW().zzf().zzc("Name must start with a letter or _ (underscore). Type, name", string, string2);
        return false;
    }

    final boolean zzah(String string, String string2) {
        int n;
        if (string2 == null) {
            this.zzu.zzaW().zzf().zzb("Name is required and can't be null. Type", string);
            return false;
        }
        if (string2.length() == 0) {
            this.zzu.zzaW().zzf().zzb("Name is required and can't be empty. Type", string);
            return false;
        }
        int n2 = string2.codePointAt(0);
        if (!Character.isLetter(n2)) {
            this.zzu.zzaW().zzf().zzc("Name must start with a letter. Type, name", string, string2);
            return false;
        }
        int n3 = string2.length();
        for (n2 = Character.charCount(n2); n2 < n3; n2 += Character.charCount(n)) {
            n = string2.codePointAt(n2);
            if (n == 95 || Character.isLetterOrDigit(n)) {
                continue;
            }
            this.zzu.zzaW().zzf().zzc("Name must consist of letters, digits or _ (underscores). Type, name", string, string2);
            return false;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @WorkerThread
    @TargetApi(value=30)
    final boolean zzai() {
        block9: {
            block10: {
                if (this.zzh != null) ** GOTO lbl19
                var1_1 = this.zzB();
                if (var1_1 == null) {
                    return false;
                }
                var1_1 = var1_1.getMeasurementApiStatusAsync();
                var2_6 = (Integer)var1_1.get(10000L, TimeUnit.MILLISECONDS);
                if (var2_6 == null) break block9;
                try {
                    var1_2 = var2_6.intValue();
                    if (!var1_2) break block10;
                    var1_2 = true;
                }
                catch (InterruptedException | CancellationException | ExecutionException | TimeoutException var1_5) {
                    ** continue;
                }
lbl13:
                // 3 sources

                while (true) {
                    this.zzh = var1_2;
                    var1_3 = var2_6;
lbl17:
                    // 2 sources

                    while (true) {
                        this.zzu.zzaW().zzj().zzb("Measurement manager api status result", var1_3);
lbl19:
                        // 2 sources

                        return this.zzh;
                    }
                    break;
                }
            }
            var1_2 = false;
            ** GOTO lbl13
        }
        var1_2 = false;
        ** while (true)
        catch (InterruptedException | CancellationException | ExecutionException | TimeoutException var1_4) {
            var2_6 = null;
lbl28:
            // 2 sources

            while (true) {
                this.zzu.zzaW().zzk().zzb("Measurement manager api exception", var1_3);
                this.zzh = false;
                var1_3 = var2_6;
                ** continue;
                break;
            }
        }
    }

    @WorkerThread
    final boolean zzaj(String string) {
        ((zzjq)zzjs2).zzg();
        zzjs zzjs2 = ((zzjq)zzjs2).zzu;
        if (Wrappers.packageManager((Context)((zzio)zzjs2).zzaT()).checkCallingOrSelfPermission(string) == 0) {
            return true;
        }
        ((zzio)zzjs2).zzaW().zzd().zzb("Permission not granted", string);
        return false;
    }

    final boolean zzak(String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            return true;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            return false;
        }
        zzjs zzjs2 = ((zzjq)zzjs2).zzu;
        String string3 = ((zzio)zzjs2).zzf().zzo();
        ((zzio)zzjs2).zzaV();
        return string3.equals(string);
    }

    final boolean zzal(Object object) {
        return object instanceof Parcelable[] || object instanceof ArrayList || object instanceof Bundle;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final boolean zzam(Context context, String signatureArray) {
        X500Principal x500Principal = new X500Principal("CN=Android Debug,O=Android,C=US");
        context = Wrappers.packageManager((Context)context).getPackageInfo((String)signatureArray, 64);
        if (context == null) return true;
        signatureArray = context.signatures;
        if (signatureArray == null) return true;
        int n = context.signatures.length;
        if (n <= 0) return true;
        try {
            context = context.signatures[0];
            return ((X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(new ByteArrayInputStream(context.toByteArray()))).getSubjectX500Principal().equals(x500Principal);
        }
        catch (CertificateException certificateException) {
            this.zzu.zzaW().zze().zzb("Error obtaining certificate", certificateException);
            return true;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            this.zzu.zzaW().zze().zzb("Package name not found", (Object)nameNotFoundException);
            return true;
        }
    }

    @WorkerThread
    final boolean zzan() {
        this.zzg();
        return this.zzq() == 1L;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean zzao(int n, boolean bl) {
        Boolean bl2 = this.zzu.zzu().zzl();
        if (this.zzm() >= n / 1000) return true;
        if (bl2 == null) return false;
        if (bl2 != false) return false;
        return true;
    }

    static boolean zzap(String string) {
        return !TextUtils.isEmpty((CharSequence)string) && string.startsWith("_");
    }

    static boolean zzaq(String string) {
        Preconditions.checkNotEmpty((String)string);
        return string.charAt(0) != '_' || string.equals("_ep");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean zzar(Context context) {
        block6: {
            PackageManager packageManager;
            block5: {
                Preconditions.checkNotNull((Object)context);
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            context = packageManager.getReceiverInfo(new ComponentName(context, "com.google.android.gms.measurement.AppMeasurementReceiver"), 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static boolean zzas(Context context, String string) {
        block6: {
            PackageManager packageManager;
            block5: {
                try {
                    packageManager = context.getPackageManager();
                    if (packageManager != null) break block5;
                    return false;
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    return false;
                }
            }
            context = packageManager.getServiceInfo(new ComponentName(context, string), 0);
            if (context == null) break block6;
            boolean bl = context.enabled;
            if (!bl) break block6;
            return true;
        }
        return false;
    }

    static boolean zzat(Context context, boolean bl) {
        Preconditions.checkNotNull((Object)context);
        if (Build.VERSION.SDK_INT >= 24) {
            return zzqf.zzas(context, "com.google.android.gms.measurement.AppMeasurementJobService");
        }
        return zzqf.zzas(context, "com.google.android.gms.measurement.AppMeasurementService");
    }

    @Override
    protected final boolean zzc() {
        return true;
    }

    public static boolean zzau(String string) {
        return !zzc[0].equals(string);
    }

    final boolean zzav(String string, String string2) {
        boolean bl = TextUtils.isEmpty((CharSequence)string2);
        if (!TextUtils.isEmpty((CharSequence)string) && !bl) {
            Preconditions.checkNotNull((Object)string);
            return !string.equals(string2);
        }
        return false;
    }

    final boolean zzaw(String string, String string2, String string3, String string4) {
        if (this.zzu.zzf().zzx(null, zzgi.zzbp)) {
            return this.zzav(string, string2);
        }
        boolean bl = TextUtils.isEmpty((CharSequence)string);
        boolean bl2 = TextUtils.isEmpty((CharSequence)string2);
        if (!bl && !bl2) {
            Preconditions.checkNotNull((Object)string);
            return !string.equals(string2);
        }
        if (bl && bl2) {
            if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string4)) {
                return !string3.equals(string4);
            }
            return !TextUtils.isEmpty((CharSequence)string4);
        }
        if (!bl) {
            if (TextUtils.isEmpty((CharSequence)string4)) {
                return false;
            }
            return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
        }
        return TextUtils.isEmpty((CharSequence)string3) || !string3.equals(string4);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @VisibleForTesting
    final boolean zzax(String string) {
        Object object;
        Preconditions.checkNotNull((Object)string);
        if (!((zzjq)object).zzu.zzf().zzx(null, zzgi.zzbp)) {
            object = "^(1:\\d+:android:[a-f0-9]+|ca-app-pub-.*)$";
            return string.matches((String)object);
        }
        object = "^1:\\d+:android:[a-f0-9]+$";
        return string.matches((String)object);
    }

    final byte[] zzay(Parcelable object) {
        if (object == null) {
            return null;
        }
        zzqf zzqf2 = Parcel.obtain();
        try {
            object.writeToParcel((Parcel)zzqf2, 0);
            object = zzqf2.marshall();
        }
        catch (Throwable throwable) {
            zzqf2.recycle();
            throw throwable;
        }
        zzqf2.recycle();
        return object;
    }

    /*
     * Enabled aggressive block sorting
     */
    static final boolean zzaz(Bundle bundle, int n) {
        if (bundle == null || bundle.getLong("_err") != 0L) {
            return false;
        }
        long l = n;
        bundle.putLong("_err", l);
        return true;
    }
}

