/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.os.Bundle;
import androidx.annotation.WorkerThread;
import androidx.collection.ArrayMap;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zza;
import com.google.android.gms.measurement.internal.zzb;
import com.google.android.gms.measurement.internal.zzf;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzlt;
import com.google.android.gms.measurement.internal.zzpo;
import java.util.Iterator;
import java.util.Map;

public final class zzd
extends zzf {
    private final Map zza;
    private final Map zzb = new ArrayMap();
    private long zzc;

    public zzd(zzib zzib2) {
        super(zzib2);
        this.zza = new ArrayMap();
    }

    public final void zza(String string, long l) {
        if (string == null || string.length() == 0) {
            this.zzu.zzaV().zzb().zza("Ad unit id must be a non-empty string");
            return;
        }
        this.zzu.zzaW().zzj(new zza(this, string, l));
    }

    public final void zzb(String string, long l) {
        if (string == null || string.length() == 0) {
            this.zzu.zzaV().zzb().zza("Ad unit id must be a non-empty string");
            return;
        }
        this.zzu.zzaW().zzj(new zzb(this, string, l));
    }

    @WorkerThread
    private final void zzh(long l, zzlt zzlt2) {
        if (zzlt2 == null) {
            this.zzu.zzaV().zzk().zza("Not logging ad exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzu.zzaV().zzk().zzb("Not logging ad exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putLong("_xt", l);
        zzpo.zzav(zzlt2, bundle, true);
        this.zzu.zzj().zzF("am", "_xa", bundle);
    }

    @WorkerThread
    private final void zzi(String string, long l, zzlt zzlt2) {
        if (zzlt2 == null) {
            this.zzu.zzaV().zzk().zza("Not logging ad unit exposure. No active activity");
            return;
        }
        if (l < 1000L) {
            this.zzu.zzaV().zzk().zzb("Not logging ad unit exposure. Less than 1000 ms. exposure", l);
            return;
        }
        Bundle bundle = new Bundle();
        bundle.putString("_ai", string);
        bundle.putLong("_xt", l);
        zzpo.zzav(zzlt2, bundle, true);
        this.zzu.zzj().zzF("am", "_xu", bundle);
    }

    @WorkerThread
    public final void zzc(long l) {
        zzlt zzlt2 = this.zzu.zzs().zzh(false);
        Map map = this.zza;
        for (String string : map.keySet()) {
            this.zzi(string, l - (Long)map.get(string), zzlt2);
        }
        if (!map.isEmpty()) {
            this.zzh(l - this.zzc, zzlt2);
        }
        this.zzj(l);
    }

    @WorkerThread
    private final void zzj(long l) {
        Map map = this.zza;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            map.put((String)iterator.next(), l);
        }
        if (!map.isEmpty()) {
            this.zzc = l;
            return;
        }
    }

    final /* synthetic */ void zzd(String string, long l) {
        Integer n;
        ((zzjd)this).zzg();
        Preconditions.checkNotEmpty((String)string);
        Map map = this.zzb;
        if (map.isEmpty()) {
            this.zzc = l;
        }
        if ((n = (Integer)map.get(string)) != null) {
            map.put(string, n + 1);
            return;
        }
        if (map.size() >= 100) {
            this.zzu.zzaV().zze().zza("Too many ads visible");
            return;
        }
        map.put(string, 1);
        this.zza.put(string, l);
    }

    /*
     * Enabled aggressive block sorting
     */
    final /* synthetic */ void zze(String string, long l) {
        ((zzjd)this).zzg();
        Preconditions.checkNotEmpty((String)string);
        Map map = this.zzb;
        Integer n = (Integer)map.get(string);
        if (n == null) {
            this.zzu.zzaV().zzb().zzb("Call to endAdUnitExposure for unknown ad unit id", string);
            return;
        }
        zzlt zzlt2 = this.zzu.zzs().zzh(false);
        int n2 = n + -1;
        if (n2 != 0) {
            map.put(string, n2);
            return;
        }
        map.remove(string);
        Map map2 = this.zza;
        Long l2 = (Long)map2.get(string);
        if (l2 == null) {
            this.zzu.zzaV().zzb().zza("First ad unit exposure time was never set");
        } else {
            long l3 = l - l2;
            map2.remove(string);
            this.zzi(string, l3, zzlt2);
        }
        if (!map.isEmpty()) {
            return;
        }
        long l4 = this.zzc;
        if (l4 == 0L) {
            this.zzu.zzaV().zzb().zza("First ad exposure time was never set");
            return;
        }
        this.zzh(l - l4, zzlt2);
        this.zzc = 0L;
    }

    final /* synthetic */ void zzf(long l) {
        this.zzj(l);
    }
}

