/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzgr;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzhv;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzje;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzhy
extends zzje {
    @Nullable
    private zzhx zza;
    @Nullable
    private zzhx zzb;
    private final PriorityBlockingQueue zzc;
    private final BlockingQueue zzd;
    private final Thread.UncaughtExceptionHandler zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Object zzg = new Object();
    private final Semaphore zzh = new Semaphore(2);
    private volatile boolean zzi;
    private static final AtomicLong zzj = new AtomicLong(Long.MIN_VALUE);

    zzhy(zzib object) {
        super((zzib)object);
        this.zzc = new PriorityBlockingQueue();
        this.zzd = new LinkedBlockingQueue();
        object = "Thread death: Uncaught exception on worker thread";
        this.zze = new zzhv(this, (String)object);
        object = "Thread death: Uncaught exception on network thread";
        this.zzf = new zzhv(this, (String)object);
    }

    @Override
    protected final boolean zza() {
        return false;
    }

    @Override
    public final void zzg() {
        if (Thread.currentThread() != this.zza) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzaX() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final void zzd() {
        if (Thread.currentThread() == this.zza) {
            throw new IllegalStateException("Call not expected from worker thread");
        }
    }

    public final boolean zze() {
        return Thread.currentThread() == this.zza;
    }

    public final boolean zzf() {
        return Thread.currentThread() == this.zzb;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Future zzh(Callable callable) throws IllegalStateException {
        this.zzw();
        Preconditions.checkNotNull((Object)callable);
        String string = "Task exception on worker thread";
        zzhw zzhw2 = new zzhw(this, callable, false, string);
        if (Thread.currentThread() == this.zza) {
            if (!this.zzc.isEmpty()) {
                this.zzu.zzaV().zze().zza("Callable skipped the worker queue.");
            }
            zzhw2.run();
            return zzhw2;
        }
        this.zzz(zzhw2);
        return zzhw2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Future zzi(Callable callable) throws IllegalStateException {
        this.zzw();
        Preconditions.checkNotNull((Object)callable);
        String string = "Task exception on worker thread";
        zzhw zzhw2 = new zzhw(this, callable, true, string);
        if (Thread.currentThread() == this.zza) {
            zzhw2.run();
            return zzhw2;
        }
        this.zzz(zzhw2);
        return zzhw2;
    }

    public final void zzj(Runnable runnable) throws IllegalStateException {
        this.zzw();
        Preconditions.checkNotNull((Object)runnable);
        String string = "Task exception on worker thread";
        zzhy zzhy2 = this;
        zzhy2.zzz(new zzhw(zzhy2, runnable, false, string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    final Object zzk(AtomicReference atomicReference, long l, String string, Runnable runnable) {
        String string2 = "Interrupted waiting for ";
        synchronized (atomicReference) {
            zzhy zzhy2 = ((zzjd)object).zzu.zzaW();
            zzhy2.zzj(runnable);
            try {
                atomicReference.wait(l);
                // MONITOREXIT @DISABLED, blocks:[1, 4] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1 /* !! */ 
                atomicReference = atomicReference.get();
                if (atomicReference == null) {
                    ((zzjd)object).zzu.zzaV().zze().zza("Timed out waiting for ".concat(string));
                }
                return atomicReference;
            }
            catch (InterruptedException interruptedException) {
                Object object = ((zzjd)object).zzu.zzaV();
                object = ((zzgt)object).zze();
                int n = string.length() + 24;
                StringBuilder stringBuilder = new StringBuilder(n);
                stringBuilder.append(string2);
                stringBuilder.append(string);
                ((zzgr)object).zza(stringBuilder.toString());
                return null;
            }
        }
    }

    public final void zzl(Runnable runnable) throws IllegalStateException {
        this.zzw();
        Preconditions.checkNotNull((Object)runnable);
        String string = "Task exception on worker thread";
        zzhy zzhy2 = this;
        zzhy2.zzz(new zzhw(zzhy2, runnable, true, string));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzz(zzhw runnable) {
        Object object = this.zzg;
        synchronized (object) {
            PriorityBlockingQueue priorityBlockingQueue = this.zzc;
            priorityBlockingQueue.add(runnable);
            runnable = this.zza;
            if (runnable == null) {
                String string = "Measurement Worker";
                runnable = new zzhx(this, string, priorityBlockingQueue);
                this.zza = runnable;
                this.zza.setUncaughtExceptionHandler(this.zze);
                this.zza.start();
            } else {
                ((zzhx)runnable).zza();
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzm(Runnable object) throws IllegalStateException {
        this.zzw();
        Preconditions.checkNotNull((Object)object);
        Object object2 = "Task exception on network thread";
        Runnable runnable = new zzhw(this, (Runnable)object, false, (String)object2);
        object = this.zzg;
        synchronized (object) {
            object2 = this.zzd;
            object2.add(runnable);
            runnable = this.zzb;
            if (runnable == null) {
                String string = "Measurement Network";
                runnable = new zzhx(this, string, (BlockingQueue)object2);
                this.zzb = runnable;
                this.zzb.setUncaughtExceptionHandler(this.zzf);
                this.zzb.start();
            } else {
                ((zzhx)runnable).zza();
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    final /* synthetic */ zzhx zzn() {
        return this.zza;
    }

    final /* synthetic */ void zzo(zzhx zzhx2) {
        this.zza = null;
    }

    final /* synthetic */ zzhx zzp() {
        return this.zzb;
    }

    final /* synthetic */ void zzq(zzhx zzhx2) {
        this.zzb = null;
    }

    final /* synthetic */ Object zzr() {
        return this.zzg;
    }

    final /* synthetic */ Semaphore zzs() {
        return this.zzh;
    }

    final /* synthetic */ boolean zzt() {
        return false;
    }

    static /* synthetic */ AtomicLong zzu() {
        return zzj;
    }
}

