/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.stats.ConnectionTracker;
import com.google.android.gms.measurement.internal.zzfy;
import com.google.android.gms.measurement.internal.zzga;
import com.google.android.gms.measurement.internal.zzgn;
import com.google.android.gms.measurement.internal.zzgt;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzib;
import com.google.android.gms.measurement.internal.zzjd;
import com.google.android.gms.measurement.internal.zzmx;
import com.google.android.gms.measurement.internal.zzmy;
import com.google.android.gms.measurement.internal.zzmz;
import com.google.android.gms.measurement.internal.zzna;
import com.google.android.gms.measurement.internal.zznd;
import com.google.android.gms.measurement.internal.zznk;
import java.util.Objects;

public final class zzne
implements ServiceConnection,
BaseGmsClient.BaseConnectionCallbacks,
BaseGmsClient.BaseOnConnectionFailedListener {
    private volatile boolean zzb;
    private volatile zzgn zzc;
    final /* synthetic */ zznk zza;

    protected zzne(zznk zznk2) {
        Objects.requireNonNull(zznk2);
        this.zza = zznk2;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zza(Intent object) {
        zznk zznk2 = this.zza;
        ((zzjd)zznk2).zzg();
        Context context = zznk2.zzu.zzaY();
        ConnectionTracker connectionTracker = ConnectionTracker.getInstance();
        synchronized (this) {
            boolean bl = this.zzb;
            if (bl) {
                object = this.zza;
                object = ((zzjd)object).zzu.zzaV();
                ((zzgt)object).zzk().zza("Connection attempt already in progress");
                return;
            }
            zznk zznk3 = this.zza;
            zzgt zzgt2 = zznk3.zzu.zzaV();
            zzgt2.zzk().zza("Using local app measurement service");
            this.zzb = true;
            connectionTracker.bindService(context, (Intent)object, (ServiceConnection)zznk3.zzY(), 129);
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    @WorkerThread
    public final void zzb() {
        if (this.zzc != null && (this.zzc.isConnected() || this.zzc.isConnecting())) {
            this.zzc.disconnect();
        }
        this.zzc = null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onServiceConnected(ComponentName object, IBinder object2) {
        block13: {
            this.zza.zzu.zzaW().zzd();
            // MONITORENTER : this
            if (object2 == null) {
                this.zzb = false;
                object = this.zza;
                object = ((zzjd)object).zzu.zzaV();
                ((zzgt)object).zzb().zza("Service connected with null binder");
                // MONITOREXIT : this
                return;
            }
            try {
                object = object2.getInterfaceDescriptor();
                boolean bl = "com.google.android.gms.measurement.internal.IMeasurementService".equals(object);
                if (bl) {
                    object = object2.queryLocalInterface("com.google.android.gms.measurement.internal.IMeasurementService");
                    bl = object instanceof zzga;
                    object = bl ? (zzga)object : new zzfy((IBinder)object2);
                    object2 = this.zza;
                    object2 = ((zzjd)object2).zzu.zzaV();
                    ((zzgt)object2).zzk().zza("Bound to IMeasurementService interface");
                    break block13;
                }
                object2 = this.zza;
                object2 = ((zzjd)object2).zzu.zzaV();
                ((zzgt)object2).zzb().zzb("Got binder with a wrong descriptor", object);
                object = null;
            }
            catch (RemoteException remoteException) {
                block14: {
                    object = null;
                    break block14;
                    catch (RemoteException remoteException2) {}
                }
                object2 = this.zza;
                object2 = ((zzjd)object2).zzu.zzaV();
                ((zzgt)object2).zzb().zza("Service connect failed to get IMeasurementService");
            }
        }
        if (object != null) {
            object2 = this.zza;
            object2 = ((zzjd)object2).zzu.zzaW();
            ((zzhy)object2).zzj(new zzmx(this, (zzga)object));
            return;
        }
        this.zzb = false;
        try {
            object = ConnectionTracker.getInstance();
            object2 = this.zza;
            Context context = ((zzjd)object2).zzu.zzaY();
            object.unbindService(context, (ServiceConnection)((zznk)object2).zzY());
            // MONITOREXIT : this
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    @MainThread
    public final void onServiceDisconnected(ComponentName componentName) {
        zzib zzib2 = this.zza.zzu;
        zzib2.zzaW().zzd();
        zzib2.zzaV().zzj().zza("Service disconnected");
        zzib2.zzaW().zzj(new zzmy(this, componentName));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @WorkerThread
    public final void zzc() {
        zznk zznk2 = this.zza;
        ((zzjd)zznk2).zzg();
        Object object = zznk2.zzu.zzaY();
        synchronized (this) {
            boolean bl;
            boolean bl2 = this.zzb;
            if (bl2) {
                object = this.zza;
                object = ((zzjd)object).zzu.zzaV();
                ((zzgt)object).zzk().zza("Connection attempt already in progress");
                return;
            }
            zzgn zzgn2 = this.zzc;
            if (zzgn2 != null && ((bl = this.zzc.isConnecting()) || (bl = this.zzc.isConnected()))) {
                object = this.zza;
                object = ((zzjd)object).zzu.zzaV();
                ((zzgt)object).zzk().zza("Already awaiting connection attempt");
                return;
            }
            zzne zzne2 = this;
            this.zzc = new zzgn((Context)object, Looper.getMainLooper(), zzne2, zzne2);
            object = this.zza;
            object = ((zzjd)object).zzu.zzaV();
            ((zzgt)object).zzk().zza("Connecting to remote service");
            this.zzb = true;
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            this.zzc.checkAvailabilityAndConnect();
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @MainThread
    public final void onConnected(Bundle object) {
        this.zza.zzu.zzaW().zzd();
        // MONITORENTER : this
        try {
            Preconditions.checkNotNull((Object)((Object)this.zzc));
            object = (zzga)this.zzc.getService();
            zzjd zzjd2 = this.zza;
            zzjd2 = zzjd2.zzu.zzaW();
            ((zzhy)zzjd2).zzj(new zzmz(this, (zzga)object));
            // MONITOREXIT : this
            return;
        }
        catch (DeadObjectException | IllegalStateException throwable) {
            this.zzc = null;
            this.zzb = false;
            return;
            {
                catch (Throwable throwable2) {}
                {
                    // MONITOREXIT : this
                    throw throwable2;
                }
            }
        }
    }

    @MainThread
    public final void onConnectionSuspended(int n) {
        zzib zzib2 = this.zza.zzu;
        zzib2.zzaW().zzd();
        zzib2.zzaV().zzj().zza("Service connection suspended");
        zzib2.zzaW().zzj(new zzna(this));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @MainThread
    public final void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        zznk zznk2 = this.zza;
        zznk2.zzu.zzaW().zzd();
        zzgt zzgt2 = zznk2.zzu.zzf();
        if (zzgt2 != null) {
            zzgt2.zzk().zzb("Service connection failed", connectionResult);
        }
        synchronized (this) {
            this.zzb = false;
            this.zzc = null;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
        this.zza.zzu.zzaW().zzj(new zznd(this, connectionResult));
    }

    final /* synthetic */ void zzd(boolean bl) {
        this.zzb = false;
    }
}

