/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.Build;
import android.os.RemoteException;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import com.google.android.gms.internal.measurement.zzjo;
import com.google.android.gms.internal.measurement.zzjp;
import com.google.android.gms.internal.measurement.zzjq;
import com.google.android.gms.internal.measurement.zzjs;
import com.google.android.gms.internal.measurement.zzjv;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class zzjr
implements zzjv {
    private static final ConcurrentMap zzb = new ConcurrentHashMap();
    private final ContentResolver zzc;
    private final Uri zzd;
    private final Runnable zze;
    @GuardedBy(value="this")
    private ContentObserver zzf = null;
    private volatile boolean zzg = true;
    private final Object zzh = new Object();
    private volatile Map zzi;
    @GuardedBy(value="this")
    private final List zzj = new ArrayList();
    public static final String[] zza;

    private zzjr(ContentResolver contentResolver, Uri uri, Runnable runnable) {
        Preconditions.checkNotNull((Object)contentResolver);
        Preconditions.checkNotNull((Object)uri);
        this.zzc = contentResolver;
        this.zzd = uri;
        this.zze = runnable;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static zzjr zza(ContentResolver object, Uri uri, Runnable runnable) {
        boolean bl;
        if (Build.VERSION.SDK_INT >= 24) {
            object = (zzjr)zzb.computeIfAbsent(uri, new zzjq((ContentResolver)object, uri, runnable));
        } else {
            ConcurrentMap concurrentMap = zzb;
            zzjr zzjr2 = (zzjr)concurrentMap.get(uri);
            if (zzjr2 == null) {
                zzjr2 = new zzjr((ContentResolver)object, uri, runnable);
                if ((object = concurrentMap.putIfAbsent(uri, zzjr2)) == null) {
                    object = zzjr2;
                }
            } else {
                object = zzjr2;
            }
        }
        try {
            bl = object.zzg;
            if (!bl) return object;
            // MONITORENTER : object
        }
        catch (SecurityException securityException) {
            return null;
        }
        bl = object.zzg;
        if (bl) {
            zzjo zzjo2 = new zzjo((zzjr)object, null);
            object.zzc.registerContentObserver(object.zzd, false, (ContentObserver)zzjo2);
            object.zzf = zzjo2;
            object.zzg = false;
        }
        // MONITOREXIT : object
        return object;
        {
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final Map zzb() {
        var1_2 = this.zzi;
        if (var1_2 != null) ** GOTO lbl24
        var2_3 = this.zzh;
        synchronized (var2_3) {
            block12: {
                var1_2 = this.zzi;
                if (var1_2 != null) ** GOTO lbl23
                var1_2 = StrictMode.allowThreadDiskReads();
                try {
                    var3_4 = (Map)zzjv.zzh(new zzjp(this));
                    ** GOTO lbl19
                }
                catch (SQLiteException | IllegalStateException | SecurityException var3_5) {
                    block11: {
                        try {
                            Log.w((String)"ConfigurationContentLdr", (String)"Unable to query ContentProvider, using default values", (Throwable)var3_5);
                            var3_6 = Collections.emptyMap();
                            break block11;
                        }
                        catch (Throwable var0_1) {
                            break block12;
                        }
lbl19:
                        // 1 sources

                        StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)var1_2);
                        var1_2 = var3_4;
lbl21:
                        // 2 sources

                        while (true) {
                            this.zzi = var1_2;
lbl23:
                            // 2 sources

                            // MONITOREXIT @DISABLED, blocks:[6, 7, 9] lbl23 : MonitorExitStatement: MONITOREXIT : var2_3
lbl24:
                            // 2 sources

                            if (var1_2 != null) {
                                return var1_2;
                            }
                            return Collections.emptyMap();
                        }
                    }
                    StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)var1_2);
                    var1_2 = var3_6;
                    ** continue;
                }
            }
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)var1_2);
            throw var0_1;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzc() {
        Iterator iterator = this.zzh;
        synchronized (iterator) {
            this.zzi = null;
            this.zze.run();
        }
        synchronized (this) {
            boolean bl;
            iterator = this.zzj.iterator();
            while (bl = iterator.hasNext()) {
                ((zzjs)iterator.next()).zza();
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    static void zzd() {
        Iterator iterator = zzb.values().iterator();
        while (iterator.hasNext()) {
            zzjr zzjr2 = (zzjr)iterator.next();
            // MONITORENTER : zzjr2
            boolean bl = zzjr2.zzg;
            if (bl) {
                zzjr2.zzg = false;
                // MONITOREXIT : zzjr2
            } else {
                ContentObserver contentObserver = zzjr2.zzf;
                if (contentObserver != null) {
                    ContentResolver contentResolver = zzjr2.zzc;
                    contentResolver.unregisterContentObserver(contentObserver);
                    zzjr2.zzf = null;
                }
            }
            iterator.remove();
        }
        return;
        {
            catch (Throwable throwable) {}
            {
                // MONITOREXIT : zzjr2
                throw throwable;
            }
        }
    }

    static {
        String string = "key";
        zza = new String[]{string, "value"};
    }

    static /* synthetic */ zzjr zzf(ContentResolver contentResolver, Uri uri, Runnable runnable, Uri uri2) {
        return new zzjr(contentResolver, uri, runnable);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final /* synthetic */ Map zzg() {
        block20: {
            block21: {
                block19: {
                    block18: {
                        this = this.zzd;
                        var1_4 = this.zzc.acquireUnstableContentProviderClient((Uri)this);
                        if (var1_4 == null) {
                            Log.w((String)"ConfigurationContentLdr", (String)"Unable to acquire ContentProviderClient, using default values");
                            return Collections.emptyMap();
                        }
                        var2_5 = var1_4.query((Uri)this, zzjr.zza, null, null, null);
                        if (var2_5 != null) break block18;
                        Log.w((String)"ConfigurationContentLdr", (String)"ContentProvider query returned null cursor, using default values");
                        this = Collections.emptyMap();
                        var1_4.release();
                        return this;
                    }
                    var0_1 = var2_5.getCount();
                    if (var0_1 != 0) break block19;
                    this = Collections.emptyMap();
                    var2_5.close();
                    var1_4.release();
                    return this;
                }
                if (var0_1 > 256) ** GOTO lbl33
                this = new ArrayMap(var0_1);
                break block21;
lbl33:
                // 2 sources

                this = new HashMap<K, V>(var0_1, 1.0f);
            }
            while (var3_7 = var2_5.moveToNext()) {
                this.put(var2_5.getString(0), var2_5.getString(1));
            }
            var3_7 = var2_5.isAfterLast();
            if (var3_7) break block20;
            Log.w((String)"ConfigurationContentLdr", (String)"Cursor read incomplete (ContentProvider dead?), using default values");
            this = Collections.emptyMap();
            var2_5.close();
            var1_4.release();
            return this;
        }
        var2_5.close();
        var1_4.release();
        return this;
        catch (Throwable var0_3) {
            if (var2_5 != null) {
                var2_5.close();
            }
            try {
                throw var0_3;
            }
            catch (RemoteException var0_2) {
                try {
                    Log.w((String)"ConfigurationContentLdr", (String)"ContentProvider query failed, using default values", (Throwable)var0_2);
                    this = Collections.emptyMap();
                }
                catch (Throwable v0) {
                    var1_4.release();
                    throw v0;
                }
                var1_4.release();
                return this;
            }
            catch (Throwable var2_6) {
                var0_3.addSuppressed(var2_6);
                throw var0_3;
            }
        }
    }
}

