/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.internal;

import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.measurement.internal.zzgs;
import com.google.android.gms.measurement.internal.zzgu;
import com.google.android.gms.measurement.internal.zzhw;
import com.google.android.gms.measurement.internal.zzhx;
import com.google.android.gms.measurement.internal.zzhy;
import com.google.android.gms.measurement.internal.zzic;
import com.google.android.gms.measurement.internal.zzje;
import com.google.android.gms.measurement.internal.zzjf;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public final class zzhz
extends zzjf {
    @Nullable
    private zzhy zza;
    @Nullable
    private zzhy zzb;
    private final PriorityBlockingQueue zzc;
    private final BlockingQueue zzd;
    private final Thread.UncaughtExceptionHandler zze;
    private final Thread.UncaughtExceptionHandler zzf;
    private final Object zzg = new Object();
    private final Semaphore zzh = new Semaphore(2);
    private volatile boolean zzi;
    private static final AtomicLong zzj = new AtomicLong(Long.MIN_VALUE);

    zzhz(zzic object) {
        super((zzic)object);
        this.zzc = new PriorityBlockingQueue();
        this.zzd = new LinkedBlockingQueue();
        object = "Thread death: Uncaught exception on worker thread";
        this.zze = new zzhw(this, (String)object);
        object = "Thread death: Uncaught exception on network thread";
        this.zzf = new zzhw(this, (String)object);
    }

    @Override
    protected final boolean zza() {
        return false;
    }

    @Override
    public final void zzg() {
        if (Thread.currentThread() != this.zza) {
            throw new IllegalStateException("Call expected from worker thread");
        }
    }

    @Override
    public final void zzaX() {
        if (Thread.currentThread() != this.zzb) {
            throw new IllegalStateException("Call expected from network thread");
        }
    }

    public final void zzd() {
        if (Thread.currentThread() == this.zza) {
            throw new IllegalStateException("Call not expected from worker thread");
        }
    }

    public final boolean zze() {
        return Thread.currentThread() == this.zza;
    }

    public final boolean zzf() {
        return Thread.currentThread() == this.zzb;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Future zzh(Callable callable) throws IllegalStateException {
        this.zzw();
        Preconditions.checkNotNull((Object)callable);
        String string = "Task exception on worker thread";
        zzhx zzhx2 = new zzhx(this, callable, false, string);
        if (Thread.currentThread() == this.zza) {
            if (!this.zzc.isEmpty()) {
                this.zzu.zzaV().zze().zza("Callable skipped the worker queue.");
            }
            zzhx2.run();
            return zzhx2;
        }
        this.zzz(zzhx2);
        return zzhx2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Future zzi(Callable callable) throws IllegalStateException {
        this.zzw();
        Preconditions.checkNotNull((Object)callable);
        String string = "Task exception on worker thread";
        zzhx zzhx2 = new zzhx(this, callable, true, string);
        if (Thread.currentThread() == this.zza) {
            zzhx2.run();
            return zzhx2;
        }
        this.zzz(zzhx2);
        return zzhx2;
    }

    public final void zzj(Runnable runnable) throws IllegalStateException {
        this.zzw();
        Preconditions.checkNotNull((Object)runnable);
        String string = "Task exception on worker thread";
        zzhz zzhz2 = this;
        zzhz2.zzz(new zzhx(zzhz2, runnable, false, string));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    final Object zzk(AtomicReference atomicReference, long l, String string, Runnable runnable) {
        String string2 = "Interrupted waiting for ";
        synchronized (atomicReference) {
            zzhz zzhz2 = ((zzje)object).zzu.zzaW();
            zzhz2.zzj(runnable);
            try {
                atomicReference.wait(l);
                // MONITOREXIT @DISABLED, blocks:[1, 4] lbl7 : MonitorExitStatement: MONITOREXIT : var1_1 /* !! */ 
                atomicReference = atomicReference.get();
                if (atomicReference == null) {
                    ((zzje)object).zzu.zzaV().zze().zza("Timed out waiting for ".concat(string));
                }
                return atomicReference;
            }
            catch (InterruptedException interruptedException) {
                Object object = ((zzje)object).zzu.zzaV();
                object = ((zzgu)object).zze();
                int n = string.length() + 24;
                StringBuilder stringBuilder = new StringBuilder(n);
                stringBuilder.append(string2);
                stringBuilder.append(string);
                ((zzgs)object).zza(stringBuilder.toString());
                return null;
            }
        }
    }

    public final void zzl(Runnable runnable) throws IllegalStateException {
        this.zzw();
        Preconditions.checkNotNull((Object)runnable);
        String string = "Task exception on worker thread";
        zzhz zzhz2 = this;
        zzhz2.zzz(new zzhx(zzhz2, runnable, true, string));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzz(zzhx runnable) {
        Object object = this.zzg;
        synchronized (object) {
            PriorityBlockingQueue priorityBlockingQueue = this.zzc;
            priorityBlockingQueue.add(runnable);
            runnable = this.zza;
            if (runnable == null) {
                String string = "Measurement Worker";
                runnable = new zzhy(this, string, priorityBlockingQueue);
                this.zza = runnable;
                this.zza.setUncaughtExceptionHandler(this.zze);
                this.zza.start();
            } else {
                ((zzhy)runnable).zza();
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void zzm(Runnable object) throws IllegalStateException {
        this.zzw();
        Preconditions.checkNotNull((Object)object);
        Object object2 = "Task exception on network thread";
        Runnable runnable = new zzhx(this, (Runnable)object, false, (String)object2);
        object = this.zzg;
        synchronized (object) {
            object2 = this.zzd;
            object2.add(runnable);
            runnable = this.zzb;
            if (runnable == null) {
                String string = "Measurement Network";
                runnable = new zzhy(this, string, (BlockingQueue)object2);
                this.zzb = runnable;
                this.zzb.setUncaughtExceptionHandler(this.zzf);
                this.zzb.start();
            } else {
                ((zzhy)runnable).zza();
            }
            return;
            {
                catch (Throwable throwable) {}
                {
                    throw throwable;
                }
            }
        }
    }

    final /* synthetic */ zzhy zzn() {
        return this.zza;
    }

    final /* synthetic */ void zzo(zzhy zzhy2) {
        this.zza = null;
    }

    final /* synthetic */ zzhy zzp() {
        return this.zzb;
    }

    final /* synthetic */ void zzq(zzhy zzhy2) {
        this.zzb = null;
    }

    final /* synthetic */ Object zzr() {
        return this.zzg;
    }

    final /* synthetic */ Semaphore zzs() {
        return this.zzh;
    }

    final /* synthetic */ boolean zzt() {
        return false;
    }

    static /* synthetic */ AtomicLong zzu() {
        return zzj;
    }
}

