/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.internal.GoogleServices;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzea;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzen;
import com.google.android.gms.internal.measurement.zzeo;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzet;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzev;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfa;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzfc;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.internal.measurement.zzfe;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.internal.measurement.zzfg;
import com.google.android.gms.internal.measurement.zzfh;
import com.google.android.gms.internal.measurement.zzfi;
import com.google.android.gms.internal.measurement.zzfj;
import com.google.android.gms.internal.measurement.zzfk;
import com.google.android.gms.internal.measurement.zzfl;
import com.google.android.gms.internal.measurement.zzfm;
import com.google.android.gms.internal.measurement.zzfn;
import com.google.android.gms.internal.measurement.zzfo;
import com.google.android.gms.internal.measurement.zzfp;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class zzem {
    private static volatile zzem zzadz;
    private final String zzadw;
    protected final Clock zzrz;
    private final ExecutorService zzaea;
    private final AppMeasurementSdk zzaeb;
    private Map<AppMeasurementSdk.OnEventListener, zzd> zzaec;
    private int zzaed;
    private boolean zzaee;
    private String zzaef;
    private zzdz zzaeg;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzem zza(Context context, String string, String string2, String string3, Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzadz != null) return zzadz;
        Class<zzem> clazz = zzem.class;
        synchronized (zzem.class) {
            if (zzadz != null) return zzadz;
            zzadz = new zzem(context, string, string2, string3, bundle);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return zzadz;
        }
    }

    public final AppMeasurementSdk zzfv() {
        return this.zzaeb;
    }

    private zzem(Context context, String string, String string2, String string3, Bundle bundle) {
        this.zzadw = string == null || !zzem.zze(string2, string3) ? "FA" : string;
        this.zzrz = DefaultClock.getInstance();
        this.zzaea = new ThreadPoolExecutor(0, 1, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
        Application application = (Application)context.getApplicationContext();
        zzem zzem2 = this;
        if (application == null) {
            Log.w((String)zzem2.zzadw, (String)"Unable to register lifecycle notifications. Application null.");
        } else {
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzem2.new zze());
        }
        this.zzaeb = new AppMeasurementSdk(this);
        application = context;
        if (!(!zzem.zzf((Context)application) || zzem.zzfw())) {
            this.zzaef = null;
            this.zzaee = true;
            Log.w((String)this.zzadw, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
            return;
        }
        if (!zzem.zze(string2, string3)) {
            this.zzaef = "fa";
            if (string2 != null && string3 != null) {
                Log.v((String)this.zzadw, (String)"Deferring to Google Analytics for Firebase for event data collection. https://goo.gl/J1sWQy");
                this.zzaee = true;
                return;
            }
            if (string2 == null ^ string3 == null) {
                Log.w((String)this.zzadw, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
            }
        } else {
            this.zzaef = string2;
        }
        this.zza(new zzen(this, context, string2, string3, bundle));
    }

    private static boolean zzf(Context context) {
        try {
            GoogleServices.initialize((Context)context);
            return GoogleServices.getGoogleAppId() != null;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    private static boolean zze(String string, String string2) {
        return string2 != null && string != null && !zzem.zzfw();
    }

    private final void zza(zzb zzb2) {
        this.zzaea.execute(zzb2);
    }

    protected final zzdz zzg(Context context) {
        try {
            return zzea.asInterface(DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_REMOTE, (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService"));
        }
        catch (DynamiteModule.LoadingException loadingException) {
            this.zza((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    private static int zzh(Context context) {
        return DynamiteModule.getRemoteVersion((Context)context, (String)"com.google.android.gms.measurement.dynamite");
    }

    private static int zzi(Context context) {
        return DynamiteModule.getLocalVersion((Context)context, (String)"com.google.android.gms.measurement.dynamite");
    }

    private final void zza(Exception exception, boolean bl, boolean bl2) {
        this.zzaee |= bl;
        if (bl) {
            Log.w((String)this.zzadw, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zzc(5, string, exception, null, null);
        }
        Log.w((String)this.zzadw, (String)string, (Throwable)exception);
    }

    private static boolean zzfw() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public final void setEventInterceptor(AppMeasurementSdk.EventInterceptor eventInterceptor) {
        this.zza(new zzeu(this, eventInterceptor));
    }

    public final void registerOnMeasurementEventListener(AppMeasurementSdk.OnEventListener onEventListener) {
        this.zza(new zzfe(this, onEventListener));
    }

    public final void unregisterOnMeasurementEventListener(AppMeasurementSdk.OnEventListener onEventListener) {
        this.zza(new zzff(this, onEventListener));
    }

    public final void logEventInternal(String string, String string2, Bundle bundle) {
        this.zza(string, string2, bundle, true, true, null);
    }

    public final void logEventInternalNoInterceptor(String string, String string2, Bundle bundle, long l) {
        this.zza(string, string2, bundle, true, false, l);
    }

    private final void zza(String string, String string2, Bundle bundle, boolean bl, boolean bl2, Long l) {
        this.zza(new zzfg(this, l, string, string2, bundle, true, bl2));
    }

    public final void zza(String string, String string2, Object object, boolean bl) {
        this.zza(new zzfh(this, string, string2, object, true));
    }

    public final void setConditionalUserProperty(Bundle bundle) {
        this.zza(new zzfi(this, bundle));
    }

    public final void clearConditionalUserProperty(String string, String string2, Bundle bundle) {
        this.zza(new zzeo(this, string, string2, bundle));
    }

    public final List<Bundle> getConditionalUserProperties(String string, String string2) {
        zza zza2 = new zza();
        this.zza(new zzep(this, string, string2, zza2));
        List<Bundle> list = zza2.zzl(5000L);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final void setCurrentScreen(Activity activity, String string, String string2) {
        this.zza(new zzeq(this, activity, string, string2));
    }

    public final void setMeasurementEnabled(boolean bl) {
        this.zza(new zzer(this, bl));
    }

    public final void beginAdUnitExposure(String string) {
        this.zza(new zzes(this, string));
    }

    public final void endAdUnitExposure(String string) {
        this.zza(new zzet(this, string));
    }

    public final String getGmpAppId() {
        zza zza2 = new zza();
        this.zza(new zzev(this, zza2));
        return zza2.zzk(500L);
    }

    public final String zzfx() {
        zza zza2 = new zza();
        this.zza(new zzew(this, zza2));
        return zza2.zzk(50L);
    }

    public final long generateEventId() {
        zza zza2 = new zza();
        this.zza(new zzex(this, zza2));
        Long l = zza2.zzm(500L);
        if (l == null) {
            zzem zzem2 = this;
            return new Random(System.nanoTime() ^ zzem2.zzrz.currentTimeMillis()).nextLong() + (long)(++zzem2.zzaed);
        }
        return l;
    }

    public final String getCurrentScreenName() {
        zza zza2 = new zza();
        this.zza(new zzey(this, zza2));
        return zza2.zzk(500L);
    }

    public final String getCurrentScreenClass() {
        zza zza2 = new zza();
        this.zza(new zzez(this, zza2));
        return zza2.zzk(500L);
    }

    public final Map<String, Object> getUserProperties(String string, String string2, boolean bl) {
        zza zza2 = new zza();
        this.zza(new zzfa(this, string, string2, bl, zza2));
        Bundle bundle = zza2.zzo(5000L);
        if (bundle == null || bundle.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(bundle.size());
        for (String string3 : bundle.keySet()) {
            Object object = bundle.get(string3);
            if (!(object instanceof Double) && !(object instanceof Long) && !(object instanceof String)) continue;
            hashMap.put(string3, object);
        }
        return hashMap;
    }

    public final void zzc(int n, String string, Object object, Object object2, Object object3) {
        this.zza(new zzfb(this, false, 5, string, object, object2, object3));
    }

    public final Bundle zza(Bundle bundle, boolean bl) {
        zza zza2 = new zza();
        this.zza(new zzfc(this, bundle, zza2));
        if (bl) {
            return zza2.zzo(5000L);
        }
        return null;
    }

    public final int getMaxUserProperties(String string) {
        zza zza2 = new zza();
        this.zza(new zzfd(this, string, zza2));
        Integer n = zza2.zzn(10000L);
        if (n == null) {
            return 25;
        }
        return n;
    }

    public final String getAppIdOrigin() {
        return this.zzaef;
    }

    static /* synthetic */ Map zza(zzem zzem2, Map map) {
        zzem2.zzaec = map;
        return zzem2.zzaec;
    }

    static /* synthetic */ zzdz zza(zzem zzem2, zzdz zzdz2) {
        zzem2.zzaeg = zzdz2;
        return zzem2.zzaeg;
    }

    static /* synthetic */ zzdz zzb(zzem zzem2) {
        return zzem2.zzaeg;
    }

    static /* synthetic */ boolean zza(zzem zzem2, String string, String string2) {
        return zzem.zze(string, string2);
    }

    static /* synthetic */ int zzj(Context context) {
        return zzem.zzi(context);
    }

    static /* synthetic */ int zzk(Context context) {
        return zzem.zzh(context);
    }

    static /* synthetic */ Map zzd(zzem zzem2) {
        return zzem2.zzaec;
    }

    final class zze
    implements Application.ActivityLifecycleCallbacks {
        zze() {
        }

        public final void onActivityCreated(Activity activity, Bundle bundle) {
            zzem.this.zza(new zzfj(this, activity, bundle));
        }

        public final void onActivityStarted(Activity activity) {
            zzem.this.zza(new zzfk(this, activity));
        }

        public final void onActivityResumed(Activity activity) {
            zzem.this.zza(new zzfl(this, activity));
        }

        public final void onActivityPaused(Activity activity) {
            zzem.this.zza(new zzfm(this, activity));
        }

        public final void onActivityStopped(Activity activity) {
            zzem.this.zza(new zzfn(this, activity));
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            zza zza2 = new zza();
            zzem.this.zza(new zzfo(this, activity, zza2));
            Bundle bundle2 = zza2.zzo(50L);
            if (bundle2 != null) {
                bundle.putAll(bundle2);
            }
        }

        public final void onActivityDestroyed(Activity activity) {
            zzem.this.zza(new zzfp(this, activity));
        }
    }

    static final class zzc
    extends zzeg {
        private final AppMeasurementSdk.EventInterceptor zzafm;

        zzc(AppMeasurementSdk.EventInterceptor eventInterceptor) {
            this.zzafm = eventInterceptor;
        }

        @Override
        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            this.zzafm.interceptEvent(string, string2, bundle, l);
        }
    }

    static final class zzd
    extends zzeg {
        private final AppMeasurementSdk.OnEventListener zzafn;

        zzd(AppMeasurementSdk.OnEventListener onEventListener) {
            this.zzafn = onEventListener;
        }

        @Override
        public final void onEvent(String string, String string2, Bundle bundle, long l) {
            this.zzafn.onEvent(string, string2, bundle, l);
        }
    }

    final class zza
    extends zzed {
        private final AtomicReference<Bundle> zzafi = new AtomicReference();
        private boolean zzafj;

        zza() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void zzb(Bundle bundle) {
            AtomicReference<Bundle> atomicReference = this.zzafi;
            synchronized (atomicReference) {
                try {
                    this.zzafi.set(bundle);
                    this.zzafj = true;
                }
                finally {
                    this.zzafi.notify();
                }
                return;
            }
        }

        final String zzk(long l) {
            return this.zza(this.zzp(l), String.class);
        }

        final <T extends Parcelable> List<T> zzl(long l) {
            return this.zza(this.zzp(5000L), List.class);
        }

        final Long zzm(long l) {
            return this.zza(this.zzp(500L), Long.class);
        }

        final Integer zzn(long l) {
            return this.zza(this.zzp(10000L), Integer.class);
        }

        final Bundle zzo(long l) {
            return this.zzp(l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Bundle zzp(long l) {
            AtomicReference<Bundle> atomicReference = this.zzafi;
            synchronized (atomicReference) {
                if (!this.zzafj) {
                    try {
                        this.zzafi.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        return null;
                    }
                }
                return this.zzafi.get();
            }
        }

        private final <T> T zza(Bundle bundle, Class<T> clazz) {
            if (bundle != null) {
                Object object = bundle.get("r");
                try {
                    if (object != null) {
                        return clazz.cast(object);
                    }
                    return null;
                }
                catch (ClassCastException classCastException) {
                    String string = "Unexpected object type. Expected, Received";
                    String string2 = clazz.getCanonicalName();
                    String string3 = object.getClass().getCanonicalName();
                    zzem.this.zzc(5, string, string2, string3, classCastException);
                    Log.w((String)zzem.this.zzadw, (String)String.format(String.valueOf(string).concat(": %s, %s"), string2, string3), (Throwable)classCastException);
                    throw classCastException;
                }
            }
            return null;
        }
    }

    abstract class zzb
    implements Runnable {
        final long timestamp;
        final long zzafk;
        private final boolean zzafl;

        zzb() {
            this(true);
        }

        zzb(boolean bl) {
            this.timestamp = zzem.this.zzrz.currentTimeMillis();
            this.zzafk = zzem.this.zzrz.elapsedRealtime();
            this.zzafl = bl;
        }

        @Override
        public void run() {
            if (zzem.this.zzaee) {
                this.zzfz();
                return;
            }
            try {
                this.zzfy();
                return;
            }
            catch (Exception exception) {
                zzem.this.zza(exception, false, this.zzafl);
                this.zzfz();
                return;
            }
        }

        protected void zzfz() {
        }

        abstract void zzfy() throws RemoteException;
    }
}

