/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.api;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.internal.measurement.zzem;
import java.util.List;
import java.util.Map;

@KeepForSdk
public class AppMeasurementSdk {
    private final zzem zzads;

    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    public static AppMeasurementSdk getInstance(@NonNull Context context) {
        return zzem.zza(context, null, null, null, null).zzfv();
    }

    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    public static AppMeasurementSdk getInstance(@NonNull Context context, @NonNull String string, @NonNull String string2, @NonNull String string3, Bundle bundle) {
        return zzem.zza(context, string, string2, string3, bundle).zzfv();
    }

    public AppMeasurementSdk(zzem zzem2) {
        this.zzads = zzem2;
    }

    @KeepForSdk
    public void setMeasurementEnabled(boolean bl) {
        this.zzads.setMeasurementEnabled(bl);
    }

    @KeepForSdk
    public void logEvent(String string, String string2, Bundle bundle) {
        this.zzads.logEventInternal(string, string2, bundle);
    }

    @KeepForSdk
    public void logEventNoInterceptor(String string, String string2, Bundle bundle, long l) {
        this.zzads.logEventInternalNoInterceptor(string, string2, bundle, l);
    }

    @KeepForSdk
    public void setUserProperty(String string, String string2, Object object) {
        Object object2 = object;
        String string3 = string2;
        String string4 = string;
        this.zzads.zza(string4, string3, object2, true);
    }

    @KeepForSdk
    public Map<String, Object> getUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=24L) String string2, boolean bl) {
        return this.zzads.getUserProperties(string, string2, bl);
    }

    @KeepForSdk
    public void setConditionalUserProperty(@NonNull Bundle bundle) {
        this.zzads.setConditionalUserProperty(bundle);
    }

    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        this.zzads.clearConditionalUserProperty(string, string2, bundle);
    }

    @KeepForSdk
    public List<Bundle> getConditionalUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=23L) String string2) {
        return this.zzads.getConditionalUserProperties(string, string2);
    }

    @Nullable
    @KeepForSdk
    public String getCurrentScreenName() {
        return this.zzads.getCurrentScreenName();
    }

    @Nullable
    @KeepForSdk
    public String getCurrentScreenClass() {
        return this.zzads.getCurrentScreenClass();
    }

    @Nullable
    @KeepForSdk
    public String getAppInstanceId() {
        return this.zzads.zzfx();
    }

    @Nullable
    @KeepForSdk
    public String getGmpAppId() {
        return this.zzads.getGmpAppId();
    }

    @KeepForSdk
    public long generateEventId() {
        return this.zzads.generateEventId();
    }

    @KeepForSdk
    public void beginAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zzads.beginAdUnitExposure(string);
    }

    @KeepForSdk
    public void endAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zzads.endAdUnitExposure(string);
    }

    @WorkerThread
    @KeepForSdk
    public void setEventInterceptor(EventInterceptor eventInterceptor) {
        this.zzads.setEventInterceptor(eventInterceptor);
    }

    @KeepForSdk
    public void registerOnMeasurementEventListener(OnEventListener onEventListener) {
        this.zzads.registerOnMeasurementEventListener(onEventListener);
    }

    @KeepForSdk
    public void unregisterOnMeasurementEventListener(OnEventListener onEventListener) {
        this.zzads.unregisterOnMeasurementEventListener(onEventListener);
    }

    @KeepForSdk
    public Bundle performActionWithResponse(Bundle bundle) {
        return this.zzads.zza(bundle, true);
    }

    @KeepForSdk
    public void performAction(Bundle bundle) {
        this.zzads.zza(bundle, false);
    }

    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        return this.zzads.getMaxUserProperties(string);
    }

    @KeepForSdk
    public void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        this.zzads.setCurrentScreen(activity, string, string2);
    }

    @KeepForSdk
    public String getAppIdOrigin() {
        return this.zzads.getAppIdOrigin();
    }

    @KeepForSdk
    public static interface OnEventListener {
        @WorkerThread
        @KeepForSdk
        public void onEvent(String var1, String var2, Bundle var3, long var4);
    }

    @KeepForSdk
    public static interface EventInterceptor {
        @WorkerThread
        @KeepForSdk
        public void interceptEvent(String var1, String var2, Bundle var3, long var4);
    }

    @KeepForSdk
    public static final class ConditionalUserProperty {
        @KeepForSdk
        public static final String ORIGIN = "origin";
        @KeepForSdk
        public static final String NAME = "name";
        @KeepForSdk
        public static final String VALUE = "value";
        @KeepForSdk
        public static final String TRIGGER_EVENT_NAME = "trigger_event_name";
        @KeepForSdk
        public static final String TRIGGER_TIMEOUT = "trigger_timeout";
        @KeepForSdk
        public static final String TIMED_OUT_EVENT_NAME = "timed_out_event_name";
        @KeepForSdk
        public static final String TIMED_OUT_EVENT_PARAMS = "timed_out_event_params";
        @KeepForSdk
        public static final String TRIGGERED_EVENT_NAME = "triggered_event_name";
        @KeepForSdk
        public static final String TRIGGERED_EVENT_PARAMS = "triggered_event_params";
        @KeepForSdk
        public static final String TIME_TO_LIVE = "time_to_live";
        @KeepForSdk
        public static final String EXPIRED_EVENT_NAME = "expired_event_name";
        @KeepForSdk
        public static final String EXPIRED_EVENT_PARAMS = "expired_event_params";
        @KeepForSdk
        public static final String CREATION_TIMESTAMP = "creation_timestamp";
        @KeepForSdk
        public static final String ACTIVE = "active";
        @KeepForSdk
        public static final String TRIGGERED_TIMESTAMP = "triggered_timestamp";

        private ConditionalUserProperty() {
        }
    }
}

