/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.api;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.annotation.Size;
import android.support.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.internal.measurement.zzea;
import com.google.android.gms.measurement.internal.zzcx;
import com.google.android.gms.measurement.internal.zzcy;
import java.util.List;
import java.util.Map;

@KeepForSdk
public class AppMeasurementSdk {
    private final zzea zzadd;

    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    public static AppMeasurementSdk getInstance(@NonNull Context context) {
        return zzea.zza(context, null, null, null, null).zzga();
    }

    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    public static AppMeasurementSdk getInstance(@NonNull Context context, @NonNull String string, @NonNull String string2, @NonNull String string3, Bundle bundle) {
        return zzea.zza(context, string, string2, string3, bundle).zzga();
    }

    public AppMeasurementSdk(zzea zzea2) {
        this.zzadd = zzea2;
    }

    @KeepForSdk
    public void setMeasurementEnabled(boolean bl) {
        this.zzadd.setMeasurementEnabled(bl);
    }

    @KeepForSdk
    public void logEvent(String string, String string2, Bundle bundle) {
        this.zzadd.logEventInternal(string, string2, bundle);
    }

    @KeepForSdk
    public void logEventNoInterceptor(String string, String string2, Bundle bundle, long l) {
        this.zzadd.logEventInternalNoInterceptor(string, string2, bundle, l);
    }

    @KeepForSdk
    public void setUserProperty(String string, String string2, Object object) {
        Object object2 = object;
        String string3 = string2;
        String string4 = string;
        this.zzadd.zza(string4, string3, object2, true);
    }

    @KeepForSdk
    @WorkerThread
    public Map<String, Object> getUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=24L) String string2, boolean bl) {
        return this.zzadd.getUserProperties(string, string2, bl);
    }

    @KeepForSdk
    public void setConditionalUserProperty(@NonNull Bundle bundle) {
        this.zzadd.setConditionalUserProperty(bundle);
    }

    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        this.zzadd.clearConditionalUserProperty(string, string2, bundle);
    }

    @KeepForSdk
    @WorkerThread
    public List<Bundle> getConditionalUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=23L) String string2) {
        return this.zzadd.getConditionalUserProperties(string, string2);
    }

    @Nullable
    @KeepForSdk
    public String getCurrentScreenName() {
        return this.zzadd.getCurrentScreenName();
    }

    @Nullable
    @KeepForSdk
    public String getCurrentScreenClass() {
        return this.zzadd.getCurrentScreenClass();
    }

    @Nullable
    @KeepForSdk
    public String getAppInstanceId() {
        return this.zzadd.zzgc();
    }

    @Nullable
    @KeepForSdk
    public String getGmpAppId() {
        return this.zzadd.getGmpAppId();
    }

    @KeepForSdk
    public long generateEventId() {
        return this.zzadd.generateEventId();
    }

    @KeepForSdk
    public void beginAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zzadd.beginAdUnitExposure(string);
    }

    @KeepForSdk
    public void endAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zzadd.endAdUnitExposure(string);
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public void setEventInterceptor(EventInterceptor eventInterceptor) {
        this.zzadd.zza(eventInterceptor);
    }

    @ShowFirstParty
    @KeepForSdk
    public void registerOnMeasurementEventListener(OnEventListener onEventListener) {
        this.zzadd.zza(onEventListener);
    }

    @ShowFirstParty
    @KeepForSdk
    public void unregisterOnMeasurementEventListener(OnEventListener onEventListener) {
        this.zzadd.zzb(onEventListener);
    }

    @KeepForSdk
    public Bundle performActionWithResponse(Bundle bundle) {
        return this.zzadd.zza(bundle, true);
    }

    @KeepForSdk
    public void performAction(Bundle bundle) {
        this.zzadd.zza(bundle, false);
    }

    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        return this.zzadd.getMaxUserProperties(string);
    }

    @KeepForSdk
    public void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        this.zzadd.setCurrentScreen(activity, string, string2);
    }

    @KeepForSdk
    public String getAppIdOrigin() {
        return this.zzadd.getAppIdOrigin();
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface OnEventListener
    extends zzcy {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void onEvent(String var1, String var2, Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface EventInterceptor
    extends zzcx {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void interceptEvent(String var1, String var2, Bundle var3, long var4);
    }

    @KeepForSdk
    public static final class ConditionalUserProperty {
        @KeepForSdk
        public static final String ORIGIN = "origin";
        @KeepForSdk
        public static final String NAME = "name";
        @KeepForSdk
        public static final String VALUE = "value";
        @KeepForSdk
        public static final String TRIGGER_EVENT_NAME = "trigger_event_name";
        @KeepForSdk
        public static final String TRIGGER_TIMEOUT = "trigger_timeout";
        @KeepForSdk
        public static final String TIMED_OUT_EVENT_NAME = "timed_out_event_name";
        @KeepForSdk
        public static final String TIMED_OUT_EVENT_PARAMS = "timed_out_event_params";
        @KeepForSdk
        public static final String TRIGGERED_EVENT_NAME = "triggered_event_name";
        @KeepForSdk
        public static final String TRIGGERED_EVENT_PARAMS = "triggered_event_params";
        @KeepForSdk
        public static final String TIME_TO_LIVE = "time_to_live";
        @KeepForSdk
        public static final String EXPIRED_EVENT_NAME = "expired_event_name";
        @KeepForSdk
        public static final String EXPIRED_EVENT_PARAMS = "expired_event_params";
        @KeepForSdk
        public static final String CREATION_TIMESTAMP = "creation_timestamp";
        @KeepForSdk
        public static final String ACTIVE = "active";
        @KeepForSdk
        public static final String TRIGGERED_TIMESTAMP = "triggered_timestamp";

        private ConditionalUserProperty() {
        }
    }
}

