/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.api;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.internal.measurement.zzx;
import com.google.android.gms.measurement.internal.zzhn;
import com.google.android.gms.measurement.internal.zzho;
import java.util.List;
import java.util.Map;

@KeepForSdk
public class AppMeasurementSdk {
    private final zzx zza;

    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    public static AppMeasurementSdk getInstance(@NonNull Context context) {
        return zzx.zza(context).zza();
    }

    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    public static AppMeasurementSdk getInstance(@NonNull Context context, @NonNull String string, @NonNull String string2, @NonNull String string3, Bundle bundle) {
        return zzx.zza(context, string, string2, string3, bundle).zza();
    }

    public AppMeasurementSdk(zzx zzx2) {
        this.zza = zzx2;
    }

    @KeepForSdk
    public void setMeasurementEnabled(boolean bl) {
        this.zza.zza(bl);
    }

    @KeepForSdk
    public void logEvent(String string, String string2, Bundle bundle) {
        this.zza.zza(string, string2, bundle);
    }

    @KeepForSdk
    public void logEventNoInterceptor(String string, String string2, Bundle bundle, long l) {
        this.zza.zza(string, string2, bundle, l);
    }

    @KeepForSdk
    public void setUserProperty(String string, String string2, Object object) {
        this.zza.zza(string, string2, object);
    }

    @KeepForSdk
    @WorkerThread
    public Map<String, Object> getUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=24L) String string2, boolean bl) {
        return this.zza.zza(string, string2, bl);
    }

    @KeepForSdk
    public void setConditionalUserProperty(@NonNull Bundle bundle) {
        this.zza.zza(bundle);
    }

    @KeepForSdk
    public void clearConditionalUserProperty(@NonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        this.zza.zzb(string, string2, bundle);
    }

    @KeepForSdk
    @WorkerThread
    public List<Bundle> getConditionalUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=23L) String string2) {
        return this.zza.zzb(string, string2);
    }

    @Nullable
    @KeepForSdk
    public String getCurrentScreenName() {
        return this.zza.zzf();
    }

    @Nullable
    @KeepForSdk
    public String getCurrentScreenClass() {
        return this.zza.zzg();
    }

    @Nullable
    @KeepForSdk
    public String getAppInstanceId() {
        return this.zza.zzd();
    }

    @Nullable
    @KeepForSdk
    public String getGmpAppId() {
        return this.zza.zzc();
    }

    @KeepForSdk
    public long generateEventId() {
        return this.zza.zze();
    }

    @KeepForSdk
    public void beginAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zza.zzb(string);
    }

    @KeepForSdk
    public void endAdUnitExposure(@NonNull @Size(min=1L) String string) {
        this.zza.zzc(string);
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public void setEventInterceptor(EventInterceptor eventInterceptor) {
        this.zza.zza(eventInterceptor);
    }

    @ShowFirstParty
    @KeepForSdk
    public void registerOnMeasurementEventListener(OnEventListener onEventListener) {
        this.zza.zza(onEventListener);
    }

    @ShowFirstParty
    @KeepForSdk
    public void unregisterOnMeasurementEventListener(OnEventListener onEventListener) {
        this.zza.zzb(onEventListener);
    }

    @KeepForSdk
    public Bundle performActionWithResponse(Bundle bundle) {
        return this.zza.zza(bundle, true);
    }

    @KeepForSdk
    public void performAction(Bundle bundle) {
        this.zza.zza(bundle, false);
    }

    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@NonNull @Size(min=1L) String string) {
        return this.zza.zzd(string);
    }

    @KeepForSdk
    public void setCurrentScreen(@NonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        this.zza.zza(activity, string, string2);
    }

    @KeepForSdk
    public String getAppIdOrigin() {
        return this.zza.zzi();
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface OnEventListener
    extends zzhn {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void onEvent(String var1, String var2, Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface EventInterceptor
    extends zzho {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void interceptEvent(String var1, String var2, Bundle var3, long var4);
    }

    @KeepForSdk
    public static final class ConditionalUserProperty {
        @KeepForSdk
        public static final String ORIGIN = "origin";
        @KeepForSdk
        public static final String NAME = "name";
        @KeepForSdk
        public static final String VALUE = "value";
        @KeepForSdk
        public static final String TRIGGER_EVENT_NAME = "trigger_event_name";
        @KeepForSdk
        public static final String TRIGGER_TIMEOUT = "trigger_timeout";
        @KeepForSdk
        public static final String TIMED_OUT_EVENT_NAME = "timed_out_event_name";
        @KeepForSdk
        public static final String TIMED_OUT_EVENT_PARAMS = "timed_out_event_params";
        @KeepForSdk
        public static final String TRIGGERED_EVENT_NAME = "triggered_event_name";
        @KeepForSdk
        public static final String TRIGGERED_EVENT_PARAMS = "triggered_event_params";
        @KeepForSdk
        public static final String TIME_TO_LIVE = "time_to_live";
        @KeepForSdk
        public static final String EXPIRED_EVENT_NAME = "expired_event_name";
        @KeepForSdk
        public static final String EXPIRED_EVENT_PARAMS = "expired_event_params";
        @KeepForSdk
        public static final String CREATION_TIMESTAMP = "creation_timestamp";
        @KeepForSdk
        public static final String ACTIVE = "active";
        @KeepForSdk
        public static final String TRIGGERED_TIMESTAMP = "triggered_timestamp";

        private ConditionalUserProperty() {
        }
    }
}

