/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.measurement.api;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.annotation.RequiresPermission;
import androidx.annotation.Size;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.internal.ShowFirstParty;
import com.google.android.gms.internal.measurement.zzbr;
import com.google.android.gms.measurement.internal.zzgw;
import com.google.android.gms.measurement.internal.zzgx;
import java.util.List;
import java.util.Map;

@KeepForSdk
@ShowFirstParty
public class AppMeasurementSdk {
    private final zzbr zza;

    @ShowFirstParty
    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @RecentlyNonNull
    public static AppMeasurementSdk getInstance(@RecentlyNonNull Context context) {
        return zzbr.zza(context, null, null, null, null).zzb();
    }

    @KeepForSdk
    @RequiresPermission(allOf={"android.permission.INTERNET", "android.permission.ACCESS_NETWORK_STATE", "android.permission.WAKE_LOCK"})
    @RecentlyNonNull
    public static AppMeasurementSdk getInstance(@RecentlyNonNull Context context, @RecentlyNonNull String string, @RecentlyNonNull String string2, @Nullable String string3, @RecentlyNonNull Bundle bundle) {
        return zzbr.zza(context, string, string2, string3, bundle).zzb();
    }

    @KeepForSdk
    public void setMeasurementEnabled(boolean bl) {
        this.zza.zzp(bl);
    }

    @KeepForSdk
    public void setMeasurementEnabled(@Nullable Boolean bl) {
        this.zza.zzp(bl);
    }

    @KeepForSdk
    public void setConsent(@RecentlyNonNull Bundle bundle) {
        this.zza.zzq(bundle);
    }

    @KeepForSdk
    public void logEvent(@RecentlyNonNull String string, @RecentlyNonNull String string2, @RecentlyNonNull Bundle bundle) {
        this.zza.zzh(string, string2, bundle);
    }

    @KeepForSdk
    public void logEventNoInterceptor(@RecentlyNonNull String string, @RecentlyNonNull String string2, @RecentlyNonNull Bundle bundle, long l) {
        this.zza.zzi(string, string2, bundle, l);
    }

    @KeepForSdk
    public void setUserProperty(@RecentlyNonNull String string, @RecentlyNonNull String string2, @RecentlyNonNull Object object) {
        this.zza.zzj(string, string2, object, true);
    }

    @KeepForSdk
    @WorkerThread
    @RecentlyNonNull
    public Map<String, Object> getUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=24L) String string2, boolean bl) {
        return this.zza.zzB(string, string2, bl);
    }

    @KeepForSdk
    public void setConditionalUserProperty(@RecentlyNonNull Bundle bundle) {
        this.zza.zzk(bundle);
    }

    @KeepForSdk
    public void clearConditionalUserProperty(@RecentlyNonNull @Size(min=1L, max=24L) String string, @Nullable String string2, @Nullable Bundle bundle) {
        this.zza.zzl(string, string2, bundle);
    }

    @KeepForSdk
    @WorkerThread
    @RecentlyNonNull
    public List<Bundle> getConditionalUserProperties(@Nullable String string, @Nullable @Size(min=1L, max=23L) String string2) {
        return this.zza.zzm(string, string2);
    }

    @RecentlyNullable
    @KeepForSdk
    public String getCurrentScreenName() {
        return this.zza.zzz();
    }

    @RecentlyNullable
    @KeepForSdk
    public String getCurrentScreenClass() {
        return this.zza.zzA();
    }

    @RecentlyNullable
    @KeepForSdk
    public String getAppInstanceId() {
        return this.zza.zzx();
    }

    @RecentlyNullable
    @KeepForSdk
    public String getGmpAppId() {
        return this.zza.zzw();
    }

    @KeepForSdk
    public long generateEventId() {
        return this.zza.zzy();
    }

    @KeepForSdk
    public void beginAdUnitExposure(@RecentlyNonNull @Size(min=1L) String string) {
        this.zza.zzu(string);
    }

    @KeepForSdk
    public void endAdUnitExposure(@RecentlyNonNull @Size(min=1L) String string) {
        this.zza.zzv(string);
    }

    @WorkerThread
    @ShowFirstParty
    @KeepForSdk
    public void setEventInterceptor(@RecentlyNonNull EventInterceptor eventInterceptor) {
        this.zza.zzd(eventInterceptor);
    }

    @ShowFirstParty
    @KeepForSdk
    public void registerOnMeasurementEventListener(@RecentlyNonNull OnEventListener onEventListener) {
        this.zza.zze(onEventListener);
    }

    @ShowFirstParty
    @KeepForSdk
    public void unregisterOnMeasurementEventListener(@RecentlyNonNull OnEventListener onEventListener) {
        this.zza.zzf(onEventListener);
    }

    @KeepForSdk
    @RecentlyNonNull
    public Bundle performActionWithResponse(@RecentlyNonNull Bundle bundle) {
        return this.zza.zzD(bundle, true);
    }

    @KeepForSdk
    public void performAction(@RecentlyNonNull Bundle bundle) {
        this.zza.zzD(bundle, false);
    }

    @WorkerThread
    @KeepForSdk
    public int getMaxUserProperties(@RecentlyNonNull @Size(min=1L) String string) {
        return this.zza.zzE(string);
    }

    @KeepForSdk
    public void setCurrentScreen(@RecentlyNonNull Activity activity, @Size(min=1L, max=36L) @Nullable String string, @Size(min=1L, max=36L) @Nullable String string2) {
        this.zza.zzo(activity, string, string2);
    }

    @KeepForSdk
    @RecentlyNonNull
    public String getAppIdOrigin() {
        return this.zza.zzG();
    }

    public AppMeasurementSdk(zzbr zzbr2) {
        this.zza = zzbr2;
    }

    public final void zza(boolean bl) {
        this.zza.zzI(bl);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface OnEventListener
    extends zzgx {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void onEvent(@RecentlyNonNull String var1, @RecentlyNonNull String var2, @RecentlyNonNull Bundle var3, long var4);
    }

    @ShowFirstParty
    @KeepForSdk
    public static interface EventInterceptor
    extends zzgw {
        @WorkerThread
        @ShowFirstParty
        @KeepForSdk
        public void interceptEvent(@RecentlyNonNull String var1, @RecentlyNonNull String var2, @RecentlyNonNull Bundle var3, long var4);
    }

    @KeepForSdk
    public static final class ConditionalUserProperty {
        @KeepForSdk
        @RecentlyNonNull
        public static final String ORIGIN = "origin";
        @KeepForSdk
        @RecentlyNonNull
        public static final String NAME = "name";
        @KeepForSdk
        @RecentlyNonNull
        public static final String VALUE = "value";
        @KeepForSdk
        @RecentlyNonNull
        public static final String TRIGGER_EVENT_NAME = "trigger_event_name";
        @KeepForSdk
        @RecentlyNonNull
        public static final String TRIGGER_TIMEOUT = "trigger_timeout";
        @KeepForSdk
        @RecentlyNonNull
        public static final String TIMED_OUT_EVENT_NAME = "timed_out_event_name";
        @KeepForSdk
        @RecentlyNonNull
        public static final String TIMED_OUT_EVENT_PARAMS = "timed_out_event_params";
        @KeepForSdk
        @RecentlyNonNull
        public static final String TRIGGERED_EVENT_NAME = "triggered_event_name";
        @KeepForSdk
        @RecentlyNonNull
        public static final String TRIGGERED_EVENT_PARAMS = "triggered_event_params";
        @KeepForSdk
        @RecentlyNonNull
        public static final String TIME_TO_LIVE = "time_to_live";
        @KeepForSdk
        @RecentlyNonNull
        public static final String EXPIRED_EVENT_NAME = "expired_event_name";
        @KeepForSdk
        @RecentlyNonNull
        public static final String EXPIRED_EVENT_PARAMS = "expired_event_params";
        @KeepForSdk
        @RecentlyNonNull
        public static final String CREATION_TIMESTAMP = "creation_timestamp";
        @KeepForSdk
        @RecentlyNonNull
        public static final String ACTIVE = "active";
        @KeepForSdk
        @RecentlyNonNull
        public static final String TRIGGERED_TIMESTAMP = "triggered_timestamp";

        private ConditionalUserProperty() {
        }
    }
}

