/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.NetworkOnMainThreadException;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzcu;
import com.google.android.gms.internal.measurement.zzcz;
import com.google.android.gms.internal.measurement.zzdd;
import com.google.android.gms.internal.measurement.zzde;
import com.google.android.gms.internal.measurement.zzdg;
import com.google.android.gms.internal.measurement.zzdj;
import com.google.android.gms.internal.measurement.zzdm;
import com.google.android.gms.internal.measurement.zzdr;
import com.google.android.gms.internal.measurement.zzdt;
import com.google.android.gms.internal.measurement.zzdu;
import com.google.android.gms.internal.measurement.zzdv;
import com.google.android.gms.internal.measurement.zzdw;
import com.google.android.gms.internal.measurement.zzdx;
import com.google.android.gms.internal.measurement.zzdy;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzea;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzek;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzen;
import com.google.android.gms.internal.measurement.zzeo;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzet;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzev;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfa;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzfc;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.internal.measurement.zzfe;
import com.google.android.gms.internal.measurement.zzff;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzhi;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zzix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.checkerframework.checker.nullness.qual.Nullable;

public class zzds {
    private static volatile zzds zzb;
    private final String zzc;
    protected final Clock zza;
    private final ExecutorService zzd;
    private final AppMeasurementSdk zze;
    @GuardedBy(value="listenerList")
    private final List<Pair<zzix, zzd>> zzf;
    private int zzg;
    private boolean zzh;
    private @Nullable String zzi;
    private volatile @Nullable zzdd zzj;

    public final int zza(String string) {
        zzde zzde2 = new zzde();
        this.zza(new zzep(this, string, zzde2));
        Integer n = (Integer)zzde.zza((Bundle)zzde2.zza(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    public final long zza() {
        zzde zzde2 = new zzde();
        this.zza(new zzek(this, zzde2));
        Long l = zzde2.zzb(500L);
        if (l == null) {
            zzds zzds2 = this;
            return new Random(System.nanoTime() ^ zzds2.zza.currentTimeMillis()).nextLong() + (long)(++zzds2.zzg);
        }
        return l;
    }

    public final @Nullable Bundle zza(Bundle bundle, boolean bl) {
        zzde zzde2 = new zzde();
        this.zza(new zzeq(this, bundle, zzde2));
        if (bl) {
            return zzde2.zza(5000L);
        }
        return null;
    }

    public final AppMeasurementSdk zzb() {
        return this.zze;
    }

    static /* bridge */ /* synthetic */ zzdd zza(zzds zzds2) {
        return zzds2.zzj;
    }

    protected final @Nullable zzdd zza(Context context, boolean bl) {
        try {
            return zzdg.asInterface((IBinder)DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION, (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService"));
        }
        catch (DynamiteModule.LoadingException loadingException) {
            this.zza((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    public static zzds zza(@NonNull Context context) {
        return zzds.zza(context, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzds zza(Context context, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzb != null) return zzb;
        Class<zzds> clazz = zzds.class;
        synchronized (zzds.class) {
            if (zzb != null) return zzb;
            zzb = new zzds(context, string, string2, string3, bundle);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return zzb;
        }
    }

    @WorkerThread
    public final @Nullable Long zzc() {
        zzde zzde2 = new zzde();
        this.zza(new zzer(this, zzde2));
        return zzde2.zzb(120000L);
    }

    public final @Nullable Object zza(int n) {
        zzde zzde2 = new zzde();
        this.zza(new zzeu(this, zzde2, n));
        return zzde.zza((Bundle)zzde2.zza(15000L), Object.class);
    }

    static /* bridge */ /* synthetic */ String zzb(zzds zzds2) {
        return zzds2.zzc;
    }

    public final @Nullable String zzd() {
        return this.zzi;
    }

    @WorkerThread
    public final @Nullable String zze() {
        zzde zzde2 = new zzde();
        this.zza(new zzes(this, zzde2));
        return zzde2.zzc(120000L);
    }

    public final @Nullable String zzf() {
        zzde zzde2 = new zzde();
        this.zza(new zzeh(this, zzde2));
        return zzde2.zzc(50L);
    }

    public final @Nullable String zzg() {
        zzde zzde2 = new zzde();
        this.zza(new zzem(this, zzde2));
        return zzde2.zzc(500L);
    }

    public final @Nullable String zzh() {
        zzde zzde2 = new zzde();
        this.zza(new zzej(this, zzde2));
        return zzde2.zzc(500L);
    }

    public final @Nullable String zzi() {
        zzde zzde2 = new zzde();
        this.zza(new zzei(this, zzde2));
        return zzde2.zzc(500L);
    }

    public final List<Bundle> zza(@Nullable String string, @Nullable String string2) {
        zzde zzde2 = new zzde();
        this.zza(new zzdv(this, string, string2, zzde2));
        List list = (List)zzde.zza((Bundle)zzde2.zza(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final Map<String, Object> zza(@Nullable String string, @Nullable String string2, boolean bl) {
        zzde zzde2 = new zzde();
        this.zza(new zzel(this, string, string2, bl, zzde2));
        Bundle bundle = zzde2.zza(5000L);
        if (bundle == null || bundle.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(bundle.size());
        for (String string3 : bundle.keySet()) {
            Object object = bundle.get(string3);
            if (!(object instanceof Double) && !(object instanceof Long) && !(object instanceof String)) continue;
            hashMap.put(string3, object);
        }
        return hashMap;
    }

    static /* bridge */ /* synthetic */ void zza(zzds zzds2, zzdd zzdd2) {
        zzds2.zzj = zzdd2;
    }

    private zzds(Context context, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Bundle bundle) {
        this.zzc = string == null || !this.zzc(string2, string3) ? "FA" : string;
        this.zza = DefaultClock.getInstance();
        zzds zzds2 = this;
        this.zzd = zzcu.zza().zza(new zzee(zzds2), zzcz.zza);
        this.zze = new AppMeasurementSdk(this);
        this.zzf = new ArrayList<Pair<zzix, zzd>>();
        Context context2 = context;
        zzds2 = this;
        if (!(!zzds.zzb(context2) || zzds2.zzk())) {
            this.zzi = null;
            this.zzh = true;
            Log.w((String)this.zzc, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
            return;
        }
        if (!this.zzc(string2, string3)) {
            this.zzi = "fa";
            if (string2 != null && string3 != null) {
                Log.v((String)this.zzc, (String)"Deferring to Google Analytics for Firebase for event data collection. https://firebase.google.com/docs/analytics");
            } else if (string2 == null ^ string3 == null) {
                Log.w((String)this.zzc, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
            }
        } else {
            this.zzi = string2;
        }
        this.zza(new zzdr(this, string2, string3, context, bundle));
        context2 = (Application)context.getApplicationContext();
        zzds2 = this;
        if (context2 == null) {
            Log.w((String)zzds2.zzc, (String)"Unable to register lifecycle notifications. Application null.");
            return;
        }
        context2.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzds2.new zzc());
    }

    private final void zza(Exception exception, boolean bl, boolean bl2) {
        this.zzh |= bl;
        if (bl) {
            Log.w((String)this.zzc, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zza(5, string, exception, null, null);
        }
        Log.w((String)this.zzc, (String)string, (Throwable)exception);
    }

    public final void zzb(String string) {
        this.zza(new zzeg(this, string));
    }

    public final void zza(String string, @Nullable String string2, @Nullable Bundle bundle) {
        this.zza(new zzdw(this, string, string2, bundle));
    }

    public final void zzc(String string) {
        this.zza(new zzef(this, string));
    }

    public final void zza(@NonNull String string, @Nullable Bundle bundle) {
        this.zza(null, string, bundle, false, true, null);
    }

    public final void zzb(String string, String string2, @Nullable Bundle bundle) {
        this.zza(string, string2, bundle, true, true, null);
    }

    public final void zza(String string, String string2, @Nullable Bundle bundle, long l) {
        this.zza(string, string2, bundle, true, false, l);
    }

    private final void zza(@Nullable String string, String string2, @Nullable Bundle bundle, boolean bl, boolean bl2, @Nullable Long l) {
        this.zza(new zzex(this, l, string, string2, bundle, bl, bl2));
    }

    public final void zza(int n, String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        this.zza(new zzeo(this, false, 5, string, object, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zzix zzix2) {
        zzd zzd2;
        Preconditions.checkNotNull((Object)zzix2);
        List<Pair<zzix, zzd>> list = this.zzf;
        synchronized (list) {
            for (int i = 0; i < this.zzf.size(); ++i) {
                if (!zzix2.equals(this.zzf.get((int)i).first)) continue;
                Log.w((String)this.zzc, (String)"OnEventListener already registered.");
                return;
            }
            zzd2 = new zzd(zzix2);
            this.zzf.add((Pair<zzix, zzd>)new Pair((Object)zzix2, (Object)zzd2));
        }
        if (this.zzj != null) {
            try {
                this.zzj.registerOnMeasurementEventListener((zzdj)zzd2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to register event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzev(this, zzd2));
    }

    public final void zzj() {
        this.zza(new zzeb(this));
    }

    private final void zza(zzb zzb2) {
        this.zzd.execute(zzb2);
    }

    public final void zza(Bundle bundle) {
        this.zza(new zzdt(this, bundle));
    }

    public final void zzb(Bundle bundle) {
        this.zza(new zzdz(this, bundle));
    }

    public final void zzc(Bundle bundle) {
        this.zza(new zzec(this, bundle));
    }

    public final void zza(Activity activity, @Nullable String string, @Nullable String string2) {
        this.zza(new zzdx(this, activity, string, string2));
    }

    public final void zza(boolean bl) {
        this.zza(new zzet(this, bl));
    }

    public final void zzd(@Nullable Bundle bundle) {
        this.zza(new zzew(this, bundle));
    }

    public final void zza(zziu zziu2) {
        zza zza2 = new zza(zziu2);
        if (this.zzj != null) {
            try {
                this.zzj.setEventInterceptor((zzdj)zza2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to set event interceptor on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzen(this, zza2));
    }

    public final void zza(@Nullable Boolean bl) {
        this.zza(new zzea(this, bl));
    }

    public final void zza(long l) {
        this.zza(new zzed(this, l));
    }

    public final void zzd(@Nullable String string) {
        this.zza(new zzdy(this, string));
    }

    public final void zzb(String string, @Nullable String string2) {
        this.zza(null, string, string2, false);
    }

    public final void zza(@Nullable String string, String string2, @Nullable Object object, boolean bl) {
        this.zza(new zzdu(this, string, string2, object, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zzix zzix2) {
        zzd zzd2;
        Preconditions.checkNotNull((Object)zzix2);
        List<Pair<zzix, zzd>> list = this.zzf;
        synchronized (list) {
            Pair<zzix, zzd> pair = null;
            for (int i = 0; i < this.zzf.size(); ++i) {
                if (!zzix2.equals(this.zzf.get((int)i).first)) continue;
                pair = this.zzf.get(i);
                break;
            }
            if (pair == null) {
                Log.w((String)this.zzc, (String)"OnEventListener had not been registered.");
                return;
            }
            this.zzf.remove(pair);
            zzd2 = (zzd)((Object)pair.second);
        }
        if (this.zzj != null) {
            try {
                this.zzj.unregisterOnMeasurementEventListener((zzdj)zzd2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to unregister event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzey(this, zzd2));
    }

    static /* synthetic */ boolean zza(zzds zzds2, String string, String string2) {
        return zzds2.zzc(string, string2);
    }

    private final boolean zzc(@Nullable String string, @Nullable String string2) {
        return string2 != null && string != null && !this.zzk();
    }

    private final boolean zzk() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics", false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static boolean zzb(Context context) {
        try {
            String string;
            String string2 = string = zzhi.zza((Context)context);
            String string3 = "google_app_id";
            Context context2 = context;
            return new zzhi(context2, string2).zza(string3) != null;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    abstract class zzb
    implements Runnable {
        final long zza;
        final long zzb;
        private final boolean zzc;

        zzb() {
            this(true);
        }

        zzb(boolean bl) {
            this.zza = zzds.this.zza.currentTimeMillis();
            this.zzb = zzds.this.zza.elapsedRealtime();
            this.zzc = bl;
        }

        protected void zzb() {
        }

        @Override
        public void run() {
            if (zzds.this.zzh) {
                this.zzb();
                return;
            }
            try {
                this.zza();
                return;
            }
            catch (Exception exception) {
                zzds.this.zza(exception, false, this.zzc);
                this.zzb();
                return;
            }
        }

        abstract void zza() throws RemoteException;
    }

    static final class zza
    extends zzdm {
        private final zziu zza;

        public final int zza() {
            return System.identityHashCode(this.zza);
        }

        zza(zziu zziu2) {
            this.zza = zziu2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.interceptEvent(string, string2, bundle, l);
        }
    }

    static final class zzd
    extends zzdm {
        private final zzix zza;

        public final int zza() {
            return System.identityHashCode(this.zza);
        }

        zzd(zzix zzix2) {
            this.zza = zzix2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.onEvent(string, string2, bundle, l);
        }
    }

    final class zzc
    implements Application.ActivityLifecycleCallbacks {
        zzc() {
        }

        public final void onActivityCreated(Activity activity, @Nullable Bundle bundle) {
            zzds.this.zza(new zzfa(this, bundle, activity));
        }

        public final void onActivityDestroyed(Activity activity) {
            zzds.this.zza(new zzff(this, activity));
        }

        public final void onActivityPaused(Activity activity) {
            zzds.this.zza(new zzfb(this, activity));
        }

        public final void onActivityResumed(Activity activity) {
            zzds.this.zza(new zzfc(this, activity));
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            zzde zzde2 = new zzde();
            zzds.this.zza(new zzfd(this, activity, zzde2));
            Bundle bundle2 = zzde2.zza(50L);
            if (bundle2 != null) {
                bundle.putAll(bundle2);
            }
        }

        public final void onActivityStarted(Activity activity) {
            zzds.this.zza(new zzez(this, activity));
        }

        public final void onActivityStopped(Activity activity) {
            zzds.this.zza(new zzfe(this, activity));
        }
    }
}

