/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.measurement;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.IBinder;
import android.os.NetworkOnMainThreadException;
import android.os.RemoteException;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Clock;
import com.google.android.gms.common.util.DefaultClock;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.measurement.zzcr;
import com.google.android.gms.internal.measurement.zzda;
import com.google.android.gms.internal.measurement.zzdb;
import com.google.android.gms.internal.measurement.zzdc;
import com.google.android.gms.internal.measurement.zzdh;
import com.google.android.gms.internal.measurement.zzdi;
import com.google.android.gms.internal.measurement.zzdp;
import com.google.android.gms.internal.measurement.zzdq;
import com.google.android.gms.internal.measurement.zzdr;
import com.google.android.gms.internal.measurement.zzds;
import com.google.android.gms.internal.measurement.zzdt;
import com.google.android.gms.internal.measurement.zzdu;
import com.google.android.gms.internal.measurement.zzdv;
import com.google.android.gms.internal.measurement.zzdw;
import com.google.android.gms.internal.measurement.zzdx;
import com.google.android.gms.internal.measurement.zzdy;
import com.google.android.gms.internal.measurement.zzdz;
import com.google.android.gms.internal.measurement.zzea;
import com.google.android.gms.internal.measurement.zzeb;
import com.google.android.gms.internal.measurement.zzec;
import com.google.android.gms.internal.measurement.zzed;
import com.google.android.gms.internal.measurement.zzee;
import com.google.android.gms.internal.measurement.zzef;
import com.google.android.gms.internal.measurement.zzeg;
import com.google.android.gms.internal.measurement.zzeh;
import com.google.android.gms.internal.measurement.zzei;
import com.google.android.gms.internal.measurement.zzej;
import com.google.android.gms.internal.measurement.zzek;
import com.google.android.gms.internal.measurement.zzel;
import com.google.android.gms.internal.measurement.zzem;
import com.google.android.gms.internal.measurement.zzen;
import com.google.android.gms.internal.measurement.zzeo;
import com.google.android.gms.internal.measurement.zzep;
import com.google.android.gms.internal.measurement.zzeq;
import com.google.android.gms.internal.measurement.zzer;
import com.google.android.gms.internal.measurement.zzes;
import com.google.android.gms.internal.measurement.zzet;
import com.google.android.gms.internal.measurement.zzeu;
import com.google.android.gms.internal.measurement.zzev;
import com.google.android.gms.internal.measurement.zzew;
import com.google.android.gms.internal.measurement.zzex;
import com.google.android.gms.internal.measurement.zzey;
import com.google.android.gms.internal.measurement.zzez;
import com.google.android.gms.internal.measurement.zzfa;
import com.google.android.gms.internal.measurement.zzfb;
import com.google.android.gms.internal.measurement.zzfc;
import com.google.android.gms.internal.measurement.zzfd;
import com.google.android.gms.measurement.api.AppMeasurementSdk;
import com.google.android.gms.measurement.internal.zzhd;
import com.google.android.gms.measurement.internal.zziu;
import com.google.android.gms.measurement.internal.zziv;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.checkerframework.checker.nullness.qual.Nullable;

public class zzdn {
    private static volatile zzdn zzb;
    private final String zzc;
    protected final Clock zza;
    private final ExecutorService zzd;
    private final AppMeasurementSdk zze;
    @GuardedBy(value="listenerList")
    private final List<Pair<zziu, zzd>> zzf;
    private int zzg;
    private boolean zzh;
    private @Nullable String zzi;
    private volatile @Nullable zzdc zzj;

    public final int zza(String string) {
        zzda zzda2 = new zzda();
        this.zza(new zzeo(this, string, zzda2));
        Integer n = (Integer)zzda.zza((Bundle)zzda2.zza(10000L), Integer.class);
        if (n == null) {
            return 25;
        }
        return n;
    }

    public final long zza() {
        zzda zzda2 = new zzda();
        this.zza(new zzef(this, zzda2));
        Long l = zzda2.zzb(500L);
        if (l == null) {
            zzdn zzdn2 = this;
            return new Random(System.nanoTime() ^ zzdn2.zza.currentTimeMillis()).nextLong() + (long)(++zzdn2.zzg);
        }
        return l;
    }

    public final @Nullable Bundle zza(Bundle bundle, boolean bl) {
        zzda zzda2 = new zzda();
        this.zza(new zzel(this, bundle, zzda2));
        if (bl) {
            return zzda2.zza(5000L);
        }
        return null;
    }

    public final AppMeasurementSdk zzb() {
        return this.zze;
    }

    static /* bridge */ /* synthetic */ zzdc zza(zzdn zzdn2) {
        return zzdn2.zzj;
    }

    protected final @Nullable zzdc zza(Context context, boolean bl) {
        try {
            return zzdb.asInterface((IBinder)DynamiteModule.load((Context)context, (DynamiteModule.VersionPolicy)DynamiteModule.PREFER_HIGHEST_OR_LOCAL_VERSION, (String)"com.google.android.gms.measurement.dynamite").instantiate("com.google.android.gms.measurement.internal.AppMeasurementDynamiteService"));
        }
        catch (DynamiteModule.LoadingException loadingException) {
            this.zza((Exception)((Object)loadingException), true, false);
            return null;
        }
    }

    public static zzdn zza(@NonNull Context context) {
        return zzdn.zza(context, null, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static zzdn zza(Context context, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Bundle bundle) {
        Preconditions.checkNotNull((Object)context);
        if (zzb != null) return zzb;
        Class<zzdn> clazz = zzdn.class;
        synchronized (zzdn.class) {
            if (zzb != null) return zzb;
            zzb = new zzdn(context, string, string2, string3, bundle);
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return zzb;
        }
    }

    @WorkerThread
    public final @Nullable Long zzc() {
        zzda zzda2 = new zzda();
        this.zza(new zzeq(this, zzda2));
        return zzda2.zzb(120000L);
    }

    public final @Nullable Object zza(int n) {
        zzda zzda2 = new zzda();
        this.zza(new zzep(this, zzda2, n));
        return zzda.zza((Bundle)zzda2.zza(15000L), Object.class);
    }

    static /* bridge */ /* synthetic */ String zzb(zzdn zzdn2) {
        return zzdn2.zzc;
    }

    public final @Nullable String zzd() {
        return this.zzi;
    }

    @WorkerThread
    public final @Nullable String zze() {
        zzda zzda2 = new zzda();
        this.zza(new zzen(this, zzda2));
        return zzda2.zzc(120000L);
    }

    public final @Nullable String zzf() {
        zzda zzda2 = new zzda();
        this.zza(new zzeg(this, zzda2));
        return zzda2.zzc(50L);
    }

    public final @Nullable String zzg() {
        zzda zzda2 = new zzda();
        this.zza(new zzeh(this, zzda2));
        return zzda2.zzc(500L);
    }

    public final @Nullable String zzh() {
        zzda zzda2 = new zzda();
        this.zza(new zzei(this, zzda2));
        return zzda2.zzc(500L);
    }

    public final @Nullable String zzi() {
        zzda zzda2 = new zzda();
        this.zza(new zzed(this, zzda2));
        return zzda2.zzc(500L);
    }

    public final List<Bundle> zza(@Nullable String string, @Nullable String string2) {
        zzda zzda2 = new zzda();
        this.zza(new zzdu(this, string, string2, zzda2));
        List list = (List)zzda.zza((Bundle)zzda2.zza(5000L), List.class);
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    public final Map<String, Object> zza(@Nullable String string, @Nullable String string2, boolean bl) {
        zzda zzda2 = new zzda();
        this.zza(new zzek(this, string, string2, bl, zzda2));
        Bundle bundle = zzda2.zza(5000L);
        if (bundle == null || bundle.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(bundle.size());
        for (String string3 : bundle.keySet()) {
            Object object = bundle.get(string3);
            if (!(object instanceof Double) && !(object instanceof Long) && !(object instanceof String)) continue;
            hashMap.put(string3, object);
        }
        return hashMap;
    }

    static /* bridge */ /* synthetic */ void zza(zzdn zzdn2, zzdc zzdc2) {
        zzdn2.zzj = zzdc2;
    }

    private zzdn(Context context, @Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable Bundle bundle) {
        this.zzc = string == null || !this.zzc(string2, string3) ? "FA" : string;
        this.zza = DefaultClock.getInstance();
        zzdn zzdn2 = this;
        this.zzd = zzcr.zza().zza(new zzdz(zzdn2), 1);
        this.zze = new AppMeasurementSdk(this);
        this.zzf = new ArrayList<Pair<zziu, zzd>>();
        Context context2 = context;
        zzdn2 = this;
        if (!(!zzdn.zzb(context2) || zzdn2.zzk())) {
            this.zzi = null;
            this.zzh = true;
            Log.w((String)this.zzc, (String)"Disabling data collection. Found google_app_id in strings.xml but Google Analytics for Firebase is missing. Remove this value or add Google Analytics for Firebase to resume data collection.");
            return;
        }
        if (!this.zzc(string2, string3)) {
            this.zzi = "fa";
            if (string2 != null && string3 != null) {
                Log.v((String)this.zzc, (String)"Deferring to Google Analytics for Firebase for event data collection. https://firebase.google.com/docs/analytics");
            } else if (string2 == null ^ string3 == null) {
                Log.w((String)this.zzc, (String)"Specified origin or custom app id is null. Both parameters will be ignored.");
            }
        } else {
            this.zzi = string2;
        }
        this.zza(new zzdq(this, string2, string3, context, bundle));
        context2 = (Application)context.getApplicationContext();
        zzdn2 = this;
        if (context2 == null) {
            Log.w((String)zzdn2.zzc, (String)"Unable to register lifecycle notifications. Application null.");
            return;
        }
        context2.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)zzdn2.new zzc());
    }

    private final void zza(Exception exception, boolean bl, boolean bl2) {
        this.zzh |= bl;
        if (bl) {
            Log.w((String)this.zzc, (String)"Data collection startup failed. No data will be collected.", (Throwable)exception);
            return;
        }
        String string = "Error with data collection. Data lost.";
        if (bl2) {
            this.zza(5, string, exception, null, null);
        }
        Log.w((String)this.zzc, (String)string, (Throwable)exception);
    }

    public final void zzb(String string) {
        this.zza(new zzeb(this, string));
    }

    public final void zza(String string, @Nullable String string2, @Nullable Bundle bundle) {
        this.zza(new zzdr(this, string, string2, bundle));
    }

    public final void zzc(String string) {
        this.zza(new zzee(this, string));
    }

    public final void zza(@NonNull String string, @Nullable Bundle bundle) {
        this.zza(null, string, bundle, false, true, null);
    }

    public final void zzb(String string, String string2, @Nullable Bundle bundle) {
        this.zza(string, string2, bundle, true, true, null);
    }

    public final void zza(String string, String string2, @Nullable Bundle bundle, long l) {
        this.zza(string, string2, bundle, true, false, l);
    }

    private final void zza(@Nullable String string, String string2, @Nullable Bundle bundle, boolean bl, boolean bl2, @Nullable Long l) {
        this.zza(new zzev(this, l, string, string2, bundle, bl, bl2));
    }

    public final void zza(int n, String string, @Nullable Object object, @Nullable Object object2, @Nullable Object object3) {
        this.zza(new zzej(this, false, 5, string, object, null, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zza(zziu zziu2) {
        zzd zzd2;
        Preconditions.checkNotNull((Object)zziu2);
        List<Pair<zziu, zzd>> list = this.zzf;
        synchronized (list) {
            for (int i = 0; i < this.zzf.size(); ++i) {
                if (!zziu2.equals(this.zzf.get((int)i).first)) continue;
                Log.w((String)this.zzc, (String)"OnEventListener already registered.");
                return;
            }
            zzd2 = new zzd(zziu2);
            this.zzf.add((Pair<zziu, zzd>)new Pair((Object)zziu2, (Object)zzd2));
        }
        if (this.zzj != null) {
            try {
                this.zzj.registerOnMeasurementEventListener((zzdi)zzd2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to register event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzet(this, zzd2));
    }

    public final void zzj() {
        this.zza(new zzea(this));
    }

    private final void zza(zzb zzb2) {
        this.zzd.execute(zzb2);
    }

    public final void zza(Bundle bundle) {
        this.zza(new zzds(this, bundle));
    }

    public final void zzb(Bundle bundle) {
        this.zza(new zzdy(this, bundle));
    }

    public final void zzc(Bundle bundle) {
        this.zza(new zzdx(this, bundle));
    }

    public final void zza(Activity activity, @Nullable String string, @Nullable String string2) {
        this.zza(new zzdw(this, activity, string, string2));
    }

    public final void zza(boolean bl) {
        this.zza(new zzes(this, bl));
    }

    public final void zzd(@Nullable Bundle bundle) {
        this.zza(new zzer(this, bundle));
    }

    public final void zza(zziv zziv2) {
        zza zza2 = new zza(zziv2);
        if (this.zzj != null) {
            try {
                this.zzj.setEventInterceptor((zzdi)zza2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to set event interceptor on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzem(this, zza2));
    }

    public final void zza(@Nullable Boolean bl) {
        this.zza(new zzdv(this, bl));
    }

    public final void zza(long l) {
        this.zza(new zzec(this, l));
    }

    public final void zza(Intent intent) {
        this.zza(new zzeu(this, intent));
    }

    public final void zzd(@Nullable String string) {
        this.zza(new zzdt(this, string));
    }

    public final void zzb(String string, @Nullable String string2) {
        this.zza(null, string, string2, false);
    }

    public final void zza(@Nullable String string, String string2, @Nullable Object object, boolean bl) {
        this.zza(new zzdp(this, string, string2, object, bl));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzb(zziu zziu2) {
        zzd zzd2;
        Preconditions.checkNotNull((Object)zziu2);
        List<Pair<zziu, zzd>> list = this.zzf;
        synchronized (list) {
            Pair<zziu, zzd> pair = null;
            for (int i = 0; i < this.zzf.size(); ++i) {
                if (!zziu2.equals(this.zzf.get((int)i).first)) continue;
                pair = this.zzf.get(i);
                break;
            }
            if (pair == null) {
                Log.w((String)this.zzc, (String)"OnEventListener had not been registered.");
                return;
            }
            this.zzf.remove(pair);
            zzd2 = (zzd)((Object)pair.second);
        }
        if (this.zzj != null) {
            try {
                this.zzj.unregisterOnMeasurementEventListener((zzdi)zzd2);
                return;
            }
            catch (BadParcelableException | NetworkOnMainThreadException | RemoteException | IllegalArgumentException | IllegalStateException | NullPointerException | SecurityException | UnsupportedOperationException throwable) {
                Log.w((String)this.zzc, (String)"Failed to unregister event listener on calling thread. Trying again on the dynamite thread.");
            }
        }
        this.zza(new zzew(this, zzd2));
    }

    static /* synthetic */ boolean zza(zzdn zzdn2, String string, String string2) {
        return zzdn2.zzc(string, string2);
    }

    private final boolean zzc(@Nullable String string, @Nullable String string2) {
        return string2 != null && string != null && !this.zzk();
    }

    private final boolean zzk() {
        try {
            Class.forName("com.google.firebase.analytics.FirebaseAnalytics", false, this.getClass().getClassLoader());
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static boolean zzb(Context context) {
        try {
            String string;
            String string2 = string = zzhd.zza((Context)context);
            String string3 = "google_app_id";
            Context context2 = context;
            return new zzhd(context2, string2).zza(string3) != null;
        }
        catch (IllegalStateException illegalStateException) {
            return false;
        }
    }

    abstract class zzb
    implements Runnable {
        final long zza;
        final long zzb;
        private final boolean zzc;

        zzb() {
            this(true);
        }

        zzb(boolean bl) {
            this.zza = zzdn.this.zza.currentTimeMillis();
            this.zzb = zzdn.this.zza.elapsedRealtime();
            this.zzc = bl;
        }

        protected void zzb() {
        }

        @Override
        public void run() {
            if (zzdn.this.zzh) {
                this.zzb();
                return;
            }
            try {
                this.zza();
                return;
            }
            catch (Exception exception) {
                zzdn.this.zza(exception, false, this.zzc);
                this.zzb();
                return;
            }
        }

        abstract void zza() throws RemoteException;
    }

    static final class zza
    extends zzdh {
        private final zziv zza;

        public final int zza() {
            return System.identityHashCode(this.zza);
        }

        zza(zziv zziv2) {
            this.zza = zziv2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.interceptEvent(string, string2, bundle, l);
        }
    }

    static final class zzd
    extends zzdh {
        private final zziu zza;

        public final int zza() {
            return System.identityHashCode(this.zza);
        }

        zzd(zziu zziu2) {
            this.zza = zziu2;
        }

        public final void zza(String string, String string2, Bundle bundle, long l) {
            this.zza.onEvent(string, string2, bundle, l);
        }
    }

    final class zzc
    implements Application.ActivityLifecycleCallbacks {
        zzc() {
        }

        public final void onActivityCreated(Activity activity, @Nullable Bundle bundle) {
            zzdn.this.zza(new zzey(this, bundle, activity));
        }

        public final void onActivityDestroyed(Activity activity) {
            zzdn.this.zza(new zzfd(this, activity));
        }

        public final void onActivityPaused(Activity activity) {
            zzdn.this.zza(new zzez(this, activity));
        }

        public final void onActivityResumed(Activity activity) {
            zzdn.this.zza(new zzfa(this, activity));
        }

        public final void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
            zzda zzda2 = new zzda();
            zzdn.this.zza(new zzfb(this, activity, zzda2));
            Bundle bundle2 = zzda2.zza(50L);
            if (bundle2 != null) {
                bundle.putAll(bundle2);
            }
        }

        public final void onActivityStarted(Activity activity) {
            zzdn.this.zza(new zzex(this, activity));
        }

        public final void onActivityStopped(Activity activity) {
            zzdn.this.zza(new zzfc(this, activity));
        }
    }
}

